/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.mnet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseLoader;
import org.colomoto.biolqm.io.antlr.Assignment;
import org.colomoto.biolqm.io.antlr.ErrorListener;
import org.colomoto.biolqm.io.antlr.ExpressionStack;
import org.colomoto.biolqm.io.antlr.MNetLexer;
import org.colomoto.biolqm.io.antlr.MNetParser;
import org.colomoto.biolqm.io.mnet.MNetParserListener;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDManagerFactory;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.MDDVariableFactory;
import org.colomoto.mddlib.logicalfunction.FunctionNode;
import org.colomoto.mddlib.logicalfunction.OperandFactory;
import org.colomoto.mddlib.logicalfunction.SimpleOperandFactory;

public class MNetImport
extends BaseLoader {
    @Override
    public LogicalModel performTask() throws IOException {
        ANTLRInputStream input = new ANTLRInputStream(this.streams.reader());
        ErrorListener errors = new ErrorListener();
        MNetParser parser = this.getParser((CharStream)input, errors);
        MNetParser.ModelContext mctx = parser.model();
        if (errors.hasErrors()) {
            System.err.println("Found some errors:");
            for (String s : errors.getErrors()) {
                System.err.println("  " + s);
            }
            return null;
        }
        HashMap<Object, NodeInfo> id2var = new HashMap<Object, NodeInfo>();
        ArrayList<NodeInfo> variables = new ArrayList<NodeInfo>();
        for (MNetParser.AssignContext actx : mctx.assign()) {
            NodeInfo ni;
            String id = actx.var().ID().getText();
            TerminalNode tnode = actx.var().VALUE();
            byte max = 1;
            if (tnode != null && (max = Byte.parseByte(tnode.getText())) < 1) {
                max = 1;
            }
            if (id2var.containsKey(id)) {
                ni = (NodeInfo)id2var.get(id);
                if (max <= ni.getMax()) continue;
                ni.setMax(max);
                continue;
            }
            ni = new NodeInfo(id, max);
            id2var.put(id, ni);
            variables.add(ni);
        }
        MDDVariableFactory mvf = new MDDVariableFactory();
        for (NodeInfo ni : variables) {
            mvf.add((Object)ni, (byte)(ni.getMax() + 1));
        }
        MDDManager ddmanager = MDDManagerFactory.getManager((MDDVariableFactory)mvf, (int)10);
        MDDVariable[] ddvariables = ddmanager.getAllVariables();
        int[] functions = new int[variables.size()];
        SimpleOperandFactory operandFactory = new SimpleOperandFactory(variables);
        MNetParserListener listener = new MNetParserListener((OperandFactory)operandFactory);
        HashMap<NodeInfo, List<Assignment>> var2assign = new HashMap<NodeInfo, List<Assignment>>();
        for (MNetParser.AssignContext actx : mctx.assign()) {
            MNetParser.VarContext vc = actx.var();
            String id = vc.ID().getText();
            int th = 1;
            TerminalNode nth = vc.VALUE();
            if (nth != null) {
                th = Integer.parseInt(nth.getText());
            }
            NodeInfo ni = (NodeInfo)id2var.get(id);
            FunctionNode node = listener.loadExpr((ParseTree)actx.expr());
            ArrayList<Assignment> asgs = (ArrayList<Assignment>)var2assign.get(ni);
            if (asgs == null) {
                asgs = new ArrayList<Assignment>();
                var2assign.put(ni, asgs);
            }
            asgs.add(new Assignment(th, node));
        }
        return ExpressionStack.constructMVModel((OperandFactory)operandFactory, variables, var2assign);
    }

    private MNetParser getParser(CharStream input, ErrorListener errors) {
        MNetLexer lexer = new MNetLexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        MNetParser parser = new MNetParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errors);
        return parser;
    }
}

