/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.petrinet;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Vector;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseExporter;
import org.colomoto.biolqm.io.petrinet.TransitionData;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public abstract class AbstractPNEncoder
extends BaseExporter {
    public final List<NodeInfo> nodeOrder;
    public final MDDManager ddmanager;
    public final int[] functions;
    public final int len;
    private int[][] t_priorities = null;
    private byte[] initialstate = null;

    public AbstractPNEncoder(LogicalModel model) {
        super(model);
        this.nodeOrder = model.getComponents();
        this.ddmanager = model.getMDDManager();
        this.functions = model.getLogicalFunctions();
        this.len = this.nodeOrder.size();
    }

    private void browse(List v_result, MDDManager ddmanager, int f, int[][] t_priorities, int nodeIndex, List<NodeInfo> v_node, int len) {
        if (ddmanager.isleaf(f)) {
            TransitionData td = new TransitionData();
            td.value = f;
            td.maxValue = v_node.get(nodeIndex).getMax();
            td.nodeIndex = nodeIndex;
            td.t_cst = null;
            if (t_priorities != null) {
                td.increasePriority = t_priorities[nodeIndex][0];
                td.decreasePriority = t_priorities[nodeIndex][1];
            }
            v_result.add(td);
        } else {
            int[][] t_cst = new int[len][3];
            for (int i = 0; i < t_cst.length; ++i) {
                t_cst[i][0] = -1;
            }
            this.browse(v_result, t_cst, 0, ddmanager, f, t_priorities, nodeIndex, v_node);
        }
    }

    private void browse(List v_result, int[][] t_cst, int level, MDDManager ddmanager, int f, int[][] t_priorities, int nodeIndex, List<NodeInfo> v_node) {
        if (ddmanager.isleaf(f)) {
            int index;
            TransitionData td = new TransitionData();
            td.value = f;
            td.maxValue = v_node.get(nodeIndex).getMax();
            td.nodeIndex = nodeIndex;
            if (t_priorities != null) {
                td.increasePriority = t_priorities[nodeIndex][0];
                td.decreasePriority = t_priorities[nodeIndex][1];
            }
            td.t_cst = new int[t_cst.length][3];
            int ti = 0;
            for (int i = 0; i < t_cst.length && (index = t_cst[i][0]) != -1; ++i) {
                if (index == nodeIndex) {
                    td.minValue = t_cst[i][1];
                    td.maxValue = t_cst[i][2];
                    continue;
                }
                td.t_cst[ti][0] = index;
                td.t_cst[ti][1] = t_cst[i][1];
                td.t_cst[ti][2] = v_node.get(index).getMax() - t_cst[i][2];
                if (td.t_cst[ti][1] <= 0 && td.t_cst[ti][2] <= 0) continue;
                ++ti;
            }
            if (ti == 0) {
                td.t_cst = null;
            } else {
                td.t_cst[ti][0] = -1;
            }
            v_result.add(td);
            return;
        }
        MDDVariable var = ddmanager.getNodeVariable(f);
        t_cst[level][0] = ddmanager.getVariableIndex(var);
        for (int i = 0; i < var.nbval; ++i) {
            int j;
            int next = ddmanager.getChild(f, i);
            for (j = i + 1; j < var.nbval && ddmanager.getChild(f, j) == next; ++j) {
            }
            t_cst[level][1] = i;
            t_cst[level][2] = --j;
            this.browse(v_result, t_cst, level + 1, ddmanager, next, t_priorities, nodeIndex, v_node);
            i = j;
        }
        t_cst[level][0] = -1;
    }

    private byte[][] prepareExport(List[] t_transition) {
        if (this.initialstate == null) {
            this.initialstate = new byte[this.len];
        }
        int[][] t_priorities = null;
        byte[][] t_markup = new byte[this.len][2];
        for (int i = 0; i < this.len; ++i) {
            Vector v_transition;
            int f = this.functions[i];
            NodeInfo vertex = this.nodeOrder.get(i);
            t_markup[i][0] = this.initialstate[i];
            t_markup[i][1] = (byte)(vertex.getMax() - this.initialstate[i]);
            t_transition[i] = v_transition = new Vector();
            this.browse(v_transition, this.ddmanager, f, t_priorities, i, this.nodeOrder, this.len);
        }
        return t_markup;
    }

    protected abstract void doExport(String var1, List<NodeInfo> var2, List[] var3, byte[][] var4, OutputStreamWriter var5) throws IOException;

    @Override
    public void export() throws IOException {
        List[] t_transition = new List[this.len];
        byte[][] t_markup = this.prepareExport(t_transition);
        OutputStreamWriter writer = this.streams.writer();
        this.doExport("defaultName", this.nodeOrder, t_transition, t_markup, writer);
        writer.close();
    }

    public void setInitialState(byte[] init) {
        this.initialstate = init;
    }

    public byte[] getInitialstate() {
        return this.initialstate;
    }
}

