/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.petrinet;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.petrinet.AbstractPNEncoder;
import org.colomoto.biolqm.io.petrinet.TransitionData;

public class PNEncoderINA
extends AbstractPNEncoder {
    public PNEncoderINA(LogicalModel model) {
        super(model);
    }

    @Override
    protected void doExport(String netName, List<NodeInfo> nodes, List[] t_transition, byte[][] t_markup, OutputStreamWriter out) throws IOException {
        int i;
        int len = t_transition.length;
        ArrayList[][] t_prepost = new ArrayList[2 * len][2];
        ArrayList<String> v_transition = new ArrayList<String>();
        for (i = 0; i < t_prepost.length; ++i) {
            t_prepost[i][0] = new ArrayList();
            t_prepost[i][1] = new ArrayList();
        }
        for (i = 0; i < len; ++i) {
            String vertex = nodes.get(i).toString();
            if (t_transition[i] == null) continue;
            byte maxvalue = nodes.get(i).getMax();
            List v_trst = t_transition[i];
            for (int j = 0; j < v_trst.size(); ++j) {
                TransitionData td = (TransitionData)v_trst.get(j);
                int a = -1;
                int b = -1;
                int selfMinInf = td.minValue;
                int selfMaxInf = -1;
                int selfMinSup = -1;
                int selfMaxSup = td.maxValue;
                if (selfMinInf != 0 || selfMaxSup != maxvalue) {
                    if (td.value > 0 && td.minValue < td.value) {
                        v_transition.add("t_" + vertex + "_" + j + "+ \t " + td.increasePriority + " 0\n");
                        a = v_transition.size();
                        selfMaxInf = maxvalue - Math.min(td.value - 1, selfMaxSup);
                    }
                    if (td.value < maxvalue && td.maxValue > td.value) {
                        v_transition.add("t_" + vertex + "_" + j + "- \t " + td.decreasePriority + " 0\n");
                        b = v_transition.size();
                        selfMinSup = Math.max(td.value + 1, selfMinInf);
                        selfMaxSup = td.value - selfMaxSup;
                    }
                } else {
                    if (td.value > 0) {
                        v_transition.add("t_" + vertex + "_" + j + "+ \t " + td.increasePriority + " 0\n");
                        a = v_transition.size();
                        selfMaxInf = maxvalue - (td.value - 1);
                    }
                    if (td.value < maxvalue) {
                        v_transition.add("t_" + vertex + "_" + j + "- \t " + td.decreasePriority + " 0\n");
                        b = v_transition.size();
                        selfMinSup = td.value + 1;
                        selfMaxSup = 0;
                    }
                }
                if (td.t_cst != null) {
                    int index;
                    for (int c = 0; c < td.t_cst.length && (index = td.t_cst[c][0]) != -1; ++c) {
                        int min = td.t_cst[c][1];
                        int max = td.t_cst[c][2];
                        index *= 2;
                        if (min > 1) {
                            if (a != -1) {
                                t_prepost[index][0].add(a + ":" + min);
                                t_prepost[index][1].add(a + ":" + min);
                            }
                            if (b != -1) {
                                t_prepost[index][0].add(b + ":" + min);
                                t_prepost[index][1].add(b + ":" + min);
                            }
                        } else if (min == 1) {
                            if (a != -1) {
                                t_prepost[index][0].add("" + a);
                                t_prepost[index][1].add("" + a);
                            }
                            if (b != -1) {
                                t_prepost[index][0].add("" + b);
                                t_prepost[index][1].add("" + b);
                            }
                        }
                        if (max > 1) {
                            if (a != -1) {
                                t_prepost[index + 1][0].add(a + ":" + max);
                                t_prepost[index + 1][1].add(a + ":" + max);
                            }
                            if (b == -1) continue;
                            t_prepost[index + 1][0].add(b + ":" + max);
                            t_prepost[index + 1][1].add(b + ":" + max);
                            continue;
                        }
                        if (max != 1) continue;
                        if (a != -1) {
                            t_prepost[index + 1][0].add("" + a);
                            t_prepost[index + 1][1].add("" + a);
                        }
                        if (b == -1) continue;
                        t_prepost[index + 1][0].add("" + b);
                        t_prepost[index + 1][1].add("" + b);
                    }
                }
                if (a != -1) {
                    if (selfMinInf > 1) {
                        t_prepost[2 * i][1].add(a + ":" + selfMinInf);
                        t_prepost[2 * i][0].add(a + ":" + (selfMinInf + 1));
                    } else if (selfMinInf == 1) {
                        t_prepost[2 * i][1].add("" + a);
                        t_prepost[2 * i][0].add(a + ":2");
                    } else {
                        t_prepost[2 * i][0].add(a + "");
                    }
                    if (selfMaxInf > 2) {
                        t_prepost[2 * i + 1][0].add(a + ":" + (selfMaxInf - 1));
                        t_prepost[2 * i + 1][1].add(a + ":" + selfMaxInf);
                    } else if (selfMaxInf == 2) {
                        t_prepost[2 * i + 1][0].add("" + a);
                        t_prepost[2 * i + 1][1].add(a + ":" + selfMaxInf);
                    } else {
                        t_prepost[2 * i + 1][1].add("" + a);
                    }
                }
                if (b == -1) continue;
                if (selfMinSup > 2) {
                    t_prepost[2 * i][0].add(b + ":" + (selfMinSup - 1));
                    t_prepost[2 * i][1].add(b + ":" + selfMinSup);
                } else if (selfMinSup == 2) {
                    t_prepost[2 * i][0].add(b + "");
                    t_prepost[2 * i][1].add(b + ":2");
                } else {
                    t_prepost[2 * i][1].add(b + "");
                }
                if (selfMaxSup > 1) {
                    t_prepost[2 * i + 1][1].add(b + ":" + selfMaxSup);
                    t_prepost[2 * i + 1][0].add(b + ":" + (selfMaxSup + 1));
                    continue;
                }
                if (selfMaxSup == 1) {
                    t_prepost[2 * i + 1][1].add("" + b);
                    t_prepost[2 * i + 1][0].add(b + ":2");
                    continue;
                }
                t_prepost[2 * i + 1][0].add("" + b);
            }
        }
        out.write("P   M   PRE,POST  NETZ 0:" + netName + "\n");
        for (i = 0; i < len; ++i) {
            int j;
            String s_pp = "";
            ArrayList v = t_prepost[2 * i][0];
            for (j = 0; j < v.size(); ++j) {
                s_pp = s_pp + " " + v.get(j);
            }
            v = t_prepost[2 * i][1];
            if (v.size() > 0) {
                s_pp = s_pp + " ,";
                for (j = 0; j < v.size(); ++j) {
                    s_pp = s_pp + " " + v.get(j);
                }
            }
            out.write(2 * i + 1 + " " + t_markup[i][0] + " \t " + s_pp + "\n");
            s_pp = "";
            v = t_prepost[2 * i + 1][0];
            for (j = 0; j < v.size(); ++j) {
                s_pp = s_pp + " " + v.get(j);
            }
            v = t_prepost[2 * i + 1][1];
            if (v.size() > 0) {
                s_pp = s_pp + " ,";
                for (j = 0; j < v.size(); ++j) {
                    s_pp = s_pp + " " + v.get(j);
                }
            }
            out.write(2 * i + 2 + " " + t_markup[i][1] + " \t " + s_pp + "\n");
        }
        out.write("@\nplace nr.  name \t capacity time\n");
        for (i = 0; i < len; ++i) {
            NodeInfo ni = nodes.get(i);
            String s = ni + " \t " + ni.getMax() + " 0\n";
            out.write(2 * i + 1 + ":  " + s);
            out.write(2 * i + 2 + ": -" + s);
        }
        out.write("@\ntrans nr. \t name priority time\n");
        for (i = 0; i < v_transition.size(); ++i) {
            out.write(i + 1 + ": " + v_transition.get(i));
        }
        out.write("@\n");
        out.close();
    }
}

