/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.petrinet;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.petrinet.AbstractPNEncoder;
import org.colomoto.biolqm.io.petrinet.TransitionData;
import org.colomoto.common.xml.XMLWriter;

public class PNEncoderPNML
extends AbstractPNEncoder {
    public PNEncoderPNML(LogicalModel model) {
        super(model);
    }

    @Override
    protected void doExport(String netName, List<NodeInfo> v_no, List[] t_transition, byte[][] t_markup, OutputStreamWriter fout) throws IOException {
        byte max;
        String s_node;
        List v_transition;
        int i;
        XMLWriter out = new XMLWriter(fout, null);
        int len = t_transition.length;
        out.openTag("pnml");
        out.openTag("net", new String[]{"id", netName, "type", "P/T net"});
        for (i = 0; i < len; ++i) {
            this.addPlace(out, "" + v_no.get(i), t_markup[i][0], 50, 10 + 80 * i);
            this.addPlace(out, "-" + v_no.get(i), t_markup[i][1], 100, 10 + 80 * i);
        }
        for (i = 0; i < t_transition.length; ++i) {
            v_transition = t_transition[i];
            s_node = v_no.get(i).toString();
            max = v_no.get(i).getMax();
            int c = 0;
            if (v_transition == null) continue;
            for (int j = 0; j < v_transition.size(); ++j) {
                TransitionData td = (TransitionData)v_transition.get(j);
                if (td.value > 0 && td.minValue < td.value) {
                    this.addTransition(out, "t_" + s_node + "_" + j + "+", 200 + 80 * c, 10 + 80 * i);
                    ++c;
                }
                if (td.value >= max || td.maxValue <= td.value) continue;
                this.addTransition(out, "t_" + s_node + "_" + j + "-", 200 + 80 * c, 10 + 80 * i);
                ++c;
            }
        }
        for (i = 0; i < t_transition.length; ++i) {
            v_transition = t_transition[i];
            s_node = v_no.get(i).toString();
            max = v_no.get(i).getMax();
            if (v_transition == null) continue;
            for (int j = 0; j < v_transition.size(); ++j) {
                int lmax;
                int lmin;
                int index;
                int ti;
                int a;
                String s_src;
                String s_transition;
                TransitionData td = (TransitionData)v_transition.get(j);
                if (td.value > 0 && td.minValue < td.value) {
                    s_transition = "t_" + s_node + "_" + j + "+";
                    s_src = v_no.get(td.nodeIndex).toString();
                    if (td.minValue == 0) {
                        this.addArc(out, s_transition, s_src, 1);
                    } else {
                        this.addArc(out, s_src, s_transition, td.minValue);
                        this.addArc(out, s_transition, s_src, td.minValue + 1);
                    }
                    a = td.value <= td.maxValue ? max - td.value + 1 : max - td.maxValue;
                    this.addArc(out, "-" + s_src, s_transition, a);
                    if (a > 1) {
                        this.addArc(out, s_transition, "-" + s_src, a - 1);
                    }
                    if (td.t_cst != null) {
                        for (ti = 0; ti < td.t_cst.length && (index = td.t_cst[ti][0]) != -1; ++ti) {
                            lmin = td.t_cst[ti][1];
                            lmax = td.t_cst[ti][2];
                            s_src = v_no.get(index).toString();
                            if (lmin != 0) {
                                this.addArc(out, s_src, s_transition, lmin);
                                this.addArc(out, s_transition, s_src, lmin);
                            }
                            if (lmax == 0) continue;
                            this.addArc(out, "-" + s_src, s_transition, lmax);
                            this.addArc(out, s_transition, "-" + s_src, lmax);
                        }
                    }
                }
                if (td.value >= max || td.maxValue <= td.value) continue;
                s_transition = "t_" + s_node + "_" + j + "-";
                s_src = v_no.get(td.nodeIndex).toString();
                if (td.maxValue == max) {
                    this.addArc(out, s_transition, "-" + s_src, 1);
                } else {
                    this.addArc(out, "-" + s_src, s_transition, td.maxValue);
                    this.addArc(out, s_transition, "-" + s_src, td.maxValue + 1);
                }
                a = td.value >= td.minValue ? td.value + 1 : td.minValue;
                this.addArc(out, s_src, s_transition, a);
                if (a > 1) {
                    this.addArc(out, s_transition, s_src, a - 1);
                }
                if (td.t_cst == null) continue;
                for (ti = 0; ti < td.t_cst.length && (index = td.t_cst[ti][0]) != -1; ++ti) {
                    lmin = td.t_cst[ti][1];
                    lmax = td.t_cst[ti][2];
                    s_src = v_no.get(index).toString();
                    if (lmin != 0) {
                        this.addArc(out, s_src, s_transition, lmin);
                        this.addArc(out, s_transition, s_src, lmin);
                    }
                    if (lmax == 0) continue;
                    this.addArc(out, "-" + s_src, s_transition, lmax);
                    this.addArc(out, s_transition, "-" + s_src, lmax);
                }
            }
        }
        out.closeTag();
        out.closeTag();
        fout.close();
    }

    private void addPlace(XMLWriter out, String id, int markup, int x, int y) throws IOException {
        out.openTag("place", new String[]{"id", id});
        out.openTag("graphics");
        out.addTag("position", new String[]{"x", "" + x, "y", "" + y});
        out.closeTag();
        out.openTag("name");
        out.addTag("value", id);
        out.closeTag();
        out.openTag("initialMarking");
        out.addTag("value", "" + markup);
        out.closeTag();
        out.closeTag();
    }

    private void addTransition(XMLWriter out, String id, int x, int y) throws IOException {
        out.openTag("transition", new String[]{"id", id});
        out.openTag("graphics");
        out.addTag("position", new String[]{"x", "" + x, "y", "" + y});
        out.closeTag();
        out.openTag("name");
        out.addTag("value", id);
        out.closeTag();
        out.openTag("orientation");
        out.addTag("value", "0");
        out.closeTag();
        out.openTag("rate");
        out.addTag("value", "1.0");
        out.closeTag();
        out.openTag("timed");
        out.addTag("value", "false");
        out.closeTag();
        out.closeTag();
    }

    private void addArc(XMLWriter out, String src, String target, int value) throws IOException {
        out.openTag("arc");
        out.addAttr("id", "a_" + src + "_-" + target);
        out.addAttr("source", src);
        out.addAttr("target", target);
        out.openTag("inscription");
        out.addTag("value", "" + value);
        out.closeTag();
        out.closeTag();
    }
}

