/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.pint;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseExporter;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.PathSearcher;

public class PintExport
extends BaseExporter {
    public PintExport(LogicalModel model) {
        super(model);
    }

    @Override
    public void export() throws IOException {
        int i;
        List<NodeInfo> nodes = this.model.getComponents();
        OutputStreamWriter writer = this.streams.writer();
        writer.write("(* This model has been automatically generated using colomoto/logicalmodels\n");
        writer.write(" * You may want to optimize this model for pint using the following command:\n");
        writer.write("       pint-export --simplify -i model.an -o model.an\n");
        writer.write(" * where model.an is this file.\n *)\n\n");
        for (NodeInfo ni : nodes) {
            writer.write('\"' + ni.getNodeID() + "\" [0");
            for (i = 1; i <= ni.getMax(); ++i) {
                writer.write(", " + i);
            }
            writer.write("]\n");
        }
        writer.write("\n");
        MDDManager ddmanager = this.model.getMDDManager();
        PathSearcher searcher = new PathSearcher(ddmanager);
        int[] functions = this.model.getLogicalFunctions();
        for (int idx = 0; idx < functions.length; ++idx) {
            NodeInfo ni = nodes.get(idx);
            int[] path = searcher.setNode(functions[idx]);
            Iterator iterator = searcher.iterator();
            while (iterator.hasNext()) {
                int leaf = (Integer)iterator.next();
                int selfcond = -1;
                boolean first = true;
                String cond = "";
                for (i = 0; i < path.length; ++i) {
                    int cst = path[i];
                    if (cst < 0) continue;
                    if (i == idx) {
                        selfcond = cst;
                        continue;
                    }
                    if (!first) {
                        cond = cond + " and ";
                    }
                    first = false;
                    cond = cond + '\"' + nodes.get(i).toString() + "\"=" + cst;
                }
                int omin = 0;
                int omax = ni.getMax();
                if (selfcond >= 0) {
                    omin = omax = selfcond;
                }
                for (i = omin; i <= omax; ++i) {
                    if (leaf == i) continue;
                    int j = i < leaf ? i + 1 : i - 1;
                    writer.write('\"' + ni.toString() + "\" " + i + " -> " + j);
                    if (!first) {
                        writer.write(" when " + cond);
                    }
                    writer.write("\n");
                }
            }
            writer.write("\n");
        }
        ((Writer)writer).close();
    }
}

