/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.sbml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.colomoto.biolqm.io.sbml.SBMLQualBundle;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.layout.LayoutModelPlugin;
import org.sbml.jsbml.ext.qual.QualModelPlugin;
import org.sbml.jsbml.xml.stax.SBMLReader;

public class SBMLqualHelper {
    public static SBMLQualBundle loadFile(File f) throws IOException, XMLStreamException {
        return SBMLqualHelper.getQualitativeModel(SBMLqualHelper.parseFile(f));
    }

    public static SBMLQualBundle parseInputStream(InputStream in) throws XMLStreamException {
        return SBMLqualHelper.getQualitativeModel(new SBMLReader().readSBMLFromStream(in));
    }

    public static SBMLDocument parseFile(File f) throws IOException, XMLStreamException {
        return new SBMLReader().readSBML(f);
    }

    public static SBMLQualBundle newBundle() {
        return SBMLqualHelper.newBundle(false);
    }

    public static SBMLQualBundle newBundle(boolean addLayout) {
        SBMLDocument sdoc = new SBMLDocument(3, 1);
        sdoc.addNamespace("qual", "xmlns", "http://www.sbml.org/sbml/level3/version1/qual/version1");
        if (addLayout) {
            sdoc.addNamespace("layout", "xmlns", "http://www.sbml.org/sbml/level3/version1/layout/version1");
        }
        Model smodel = sdoc.createModel("model_id");
        QualModelPlugin qmodel = new QualModelPlugin(smodel);
        smodel.addExtension("http://www.sbml.org/sbml/level3/version1/qual/version1", (SBasePlugin)qmodel);
        sdoc.getSBMLDocumentAttributes().put("qual:required", "true");
        LayoutModelPlugin lmodel = null;
        if (addLayout) {
            lmodel = new LayoutModelPlugin(smodel);
            smodel.addExtension("http://www.sbml.org/sbml/level3/version1/layout/version1", (SBasePlugin)lmodel);
            sdoc.getSBMLDocumentAttributes().put("layout:required", "false");
        }
        return new SBMLQualBundle(sdoc, smodel, qmodel, lmodel);
    }

    private static SBMLQualBundle getQualitativeModel(SBMLDocument sdoc) {
        Model smodel = sdoc.getModel();
        QualModelPlugin qmodel = null;
        SBasePlugin plugin = smodel.getExtension("http://www.sbml.org/sbml/level3/version1/qual/version1");
        if (plugin instanceof QualModelPlugin) {
            qmodel = (QualModelPlugin)plugin;
        } else {
            System.out.println("Failed creating the qual model plugin");
        }
        LayoutModelPlugin lmodel = null;
        plugin = smodel.getExtension("http://www.sbml.org/sbml/level3/version1/layout/version1");
        if (plugin instanceof LayoutModelPlugin) {
            lmodel = (LayoutModelPlugin)plugin;
        }
        return new SBMLQualBundle(sdoc, smodel, qmodel, lmodel);
    }
}

