/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.io.truthtable;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.io.BaseExporter;

public class TruthTableExport
extends BaseExporter {
    public TruthTableExport(LogicalModel model) {
        super(model);
    }

    @Override
    public void export() throws IOException {
        OutputStreamWriter writer = this.streams.writer();
        List<NodeInfo> nodeOrder = this.model.getComponents();
        String stmp = "";
        for (NodeInfo node : nodeOrder) {
            stmp = stmp + node.getNodeID() + " ";
        }
        writer.write(stmp.trim() + "\n");
        byte[] state = new byte[nodeOrder.size()];
        TruthTableExport.exportStatesFromDim(writer, this.model, state, 0, 0);
        ((Writer)writer).close();
    }

    private static void exportStatesFromDim(Writer writer, LogicalModel m, byte[] state, int i, int j) throws IOException {
        if (j == state.length) {
            writer.append(TruthTableExport.state2String(state) + " ");
            writer.append(TruthTableExport.state2String(TruthTableExport.getStateImage(m, state)) + "\n");
        } else {
            NodeInfo node = m.getComponents().get(j);
            for (byte b = 0; b <= node.getMax(); b = (byte)(b + 1)) {
                state[j] = b;
                TruthTableExport.exportStatesFromDim(writer, m, state, i, j + 1);
            }
            for (int k = j; k < state.length - 1; ++k) {
                state[k] = 0;
            }
        }
    }

    private static String state2String(byte[] state) {
        String tmp = "";
        for (int i = 0; i < state.length; ++i) {
            tmp = tmp + state[i];
        }
        return tmp;
    }

    private static byte[] getStateImage(LogicalModel m, byte[] state) {
        byte[] nextState = new byte[state.length];
        for (int i = 0; i < state.length; ++i) {
            nextState[i] = m.getTargetValue(i, state);
        }
        return nextState;
    }
}

