/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.buffer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.colomoto.biolqm.ConnectivityMatrix;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.BaseModifier;
import org.colomoto.biolqm.modifier.buffer.BufferingRule;
import org.colomoto.mddlib.IndexMapper;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDMapper;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.internal.MDDStoreImpl;

public class BufferingModifier
extends BaseModifier
implements IndexMapper {
    private final LogicalModel model;
    private MDDManager ddm;
    private MDDManager newDDM;
    private List<NodeInfo> core;
    private List<NodeInfo> extra;
    private List<NodeInfo> newCore;
    private List<NodeInfo> newExtra;
    private int[] coreFunctions;
    private int[] extraFunctions;
    private int[] newCoreFunctions;
    private int[] newExtraFunctions;
    private Map<Integer, BufferingRule> rules = new HashMap<Integer, BufferingRule>();
    private MDDMapper mapper = null;
    private int curTarget = 0;
    private int nbBuffers = 0;

    public BufferingModifier(LogicalModel model) {
        this.model = model;
    }

    @Override
    public void setParameter(String param) {
        if (param.equalsIgnoreCase("buffer")) {
            this.addAllSingleBuffers();
            return;
        }
        if (param.equalsIgnoreCase("delay")) {
            this.addDelayBuffers();
            return;
        }
        String[] cfg = param.split(":");
        if (cfg.length != 2) {
            System.err.println("Unrecognized parameter for the buffer modifier: " + param);
            return;
        }
        int src = this.model.getComponentIndex(cfg[0]);
        int tgt = this.model.getComponentIndex(cfg[1]);
        if (src < 0 || tgt < 0) {
            System.err.println("Unrecognized component(s) for the buffer modifier: " + param);
            return;
        }
        this.addSingleBuffer(src, tgt);
    }

    @Override
    public LogicalModel performTask() {
        int size;
        this.ddm = this.model.getMDDManager();
        this.core = this.model.getComponents();
        this.extra = this.model.getExtraComponents();
        this.coreFunctions = this.model.getLogicalFunctions();
        this.extraFunctions = this.model.getExtraLogicalFunctions();
        int curPosition = size = this.core.size();
        for (int i = 0; i < size; ++i) {
            BufferingRule rule = this.rules.get(i);
            if (rule == null) continue;
            rule.lock(curPosition);
            curPosition += rule.count();
        }
        if (curPosition == size) {
            return this.model;
        }
        this.nbBuffers = curPosition - size;
        this.newCore = this.getComponents(this.core, true);
        this.newExtra = this.getComponents(this.extra, false);
        this.newDDM = new MDDStoreImpl(this.newCore, this.ddm.getLeafCount());
        this.mapper = new MDDMapper(this.ddm, this.newDDM, (IndexMapper)this);
        this.newCoreFunctions = this.transferFunctions(this.coreFunctions, 0);
        this.newExtraFunctions = this.transferFunctions(this.extraFunctions, this.coreFunctions.length);
        return new LogicalModelImpl(this.newDDM, this.newCore, this.newCoreFunctions, this.newExtra, this.newExtraFunctions);
    }

    private BufferingRule ensureRule(int source) {
        BufferingRule rule = this.rules.get(source);
        if (rule == null) {
            rule = new BufferingRule(source);
            this.rules.put(source, rule);
        }
        return rule;
    }

    private List<NodeInfo> getComponents(List<NodeInfo> components, boolean isCore) {
        int size;
        int newSize = size = components.size();
        if (isCore) {
            newSize += this.nbBuffers;
        }
        ArrayList<NodeInfo> result = new ArrayList<NodeInfo>(newSize);
        for (NodeInfo ni : components) {
            result.add(ni.clone());
        }
        if (isCore) {
            int i = 0;
            for (NodeInfo ni : components) {
                int c = this.countBuffersFrom(i);
                for (int j = 0; j < this.countBuffersFrom(i); ++j) {
                    result.add(new NodeInfo("_bf_" + ni.getNodeID() + "_" + j, ni.getMax()));
                }
                ++i;
            }
        }
        return result;
    }

    private int[] transferFunctions(int[] functions, int shift) {
        int size;
        int newSize = size = functions.length;
        if (shift == 0) {
            newSize += this.nbBuffers;
        }
        int[] newFunctions = new int[newSize];
        this.curTarget = shift;
        for (int i = 0; i < functions.length; ++i) {
            newFunctions[i] = this.mapper.mapMDD(functions[i]);
            ++this.curTarget;
        }
        if (shift == 0) {
            int idx = size;
            for (int i = 0; i < functions.length; ++i) {
                int c = this.countBuffersFrom(i);
                if (c <= 0) continue;
                int node = 0;
                MDDVariable var = this.newDDM.getVariableForKey((Object)this.core.get(i));
                if (var.nbval == 2) {
                    node = var.getNode(0, 1);
                } else {
                    int[] children = new int[var.nbval];
                    for (int k = 0; k < children.length; ++k) {
                        children[k] = k;
                    }
                    node = var.getNode(children);
                }
                for (int j = 0; j < this.countBuffersFrom(i); ++j) {
                    newFunctions[idx++] = node;
                }
            }
        }
        return newFunctions;
    }

    private int get(int source, int target) {
        Integer result;
        BufferingRule rules = this.rules.get(source);
        if (rules != null && (result = Integer.valueOf(rules.get(target))) != null) {
            return result;
        }
        return source;
    }

    private int countBuffersFrom(int source) {
        BufferingRule rules = this.rules.get(source);
        if (rules != null) {
            return rules.count();
        }
        return 0;
    }

    public int get(int i) {
        return this.get(i, this.curTarget);
    }

    public void addAllSingleBuffers() {
        ConnectivityMatrix matrix = new ConnectivityMatrix(this.model);
        int ncore = this.model.getComponents().size();
        for (int src = 0; src < ncore; ++src) {
            int[] targets;
            for (int tgt : targets = matrix.getCoreTargets(src, false)) {
                this.addSingleBuffer(src, tgt);
            }
            for (int tgt : targets = matrix.getCoreTargets(src, true)) {
                this.addSingleBuffer(src, tgt + ncore);
            }
        }
    }

    public void addDelayBuffers() {
        ConnectivityMatrix matrix = new ConnectivityMatrix(this.model);
        int ncore = this.model.getComponents().size();
        for (int src = 0; src < ncore; ++src) {
            int[] coreTargets = matrix.getCoreTargets(src, false);
            int[] extraTargets = matrix.getCoreTargets(src, true);
            ArrayList<Integer> allTargets = new ArrayList<Integer>(coreTargets.length + extraTargets.length);
            for (int tgt : coreTargets) {
                allTargets.add(tgt);
            }
            for (int tgt : extraTargets) {
                allTargets.add(tgt + ncore);
            }
            if (allTargets.size() <= 0) continue;
            this.addMultipleBuffer(src, allTargets);
        }
    }

    public void addSingleBuffer(int source, int target) {
        this.ensureRule(source).add(target);
    }

    public void addMultipleBuffer(int source, List<Integer> targets) {
        this.ensureRule(source).add(targets);
    }
}

