/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.perturbation;

import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.perturbation.LogicalModelPerturbation;

public class FixedValuePerturbation
implements LogicalModelPerturbation {
    public final int value;
    public final NodeInfo component;

    public FixedValuePerturbation(NodeInfo target) {
        this(target, 0);
    }

    public FixedValuePerturbation(NodeInfo target, int value) {
        if (value < 0 || value > target.getMax()) {
            throw new RuntimeException("Invalid perturbation settings for " + target + ": " + value);
        }
        this.component = target;
        this.value = value;
    }

    @Override
    public void restrictValues(byte[] state, List<NodeInfo> nodeOrder) {
        int index = nodeOrder.indexOf(this.component);
        state[index] = (byte)this.value;
    }

    @Override
    public void update(LogicalModel model) {
        int idx = -1;
        int[] functions = null;
        idx = model.getComponents().indexOf(this.component);
        if (idx >= 0) {
            functions = model.getLogicalFunctions();
        } else {
            idx = model.getExtraComponents().indexOf(this.component);
            if (idx >= 0) {
                functions = model.getExtraLogicalFunctions();
            }
        }
        if (idx < 0) {
            throw new RuntimeException("Perturbation.update(): Could not find the target component");
        }
        int oldValue = functions[idx];
        functions[idx] = this.value;
        model.getMDDManager().free(oldValue);
    }

    @Override
    public boolean affectsNode(NodeInfo node) {
        return this.component.equals(node);
    }

    public String toString() {
        if (this.value == 0) {
            return this.component.getNodeID() + " KO";
        }
        return this.component.getNodeID() + " E" + this.value;
    }

    @Override
    public String getStringRepresentation() {
        return this.component.getNodeID() + "%" + this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof FixedValuePerturbation) {
            FixedValuePerturbation p = (FixedValuePerturbation)o;
            return p.value == this.value && p.component.equals(this.component);
        }
        return false;
    }
}

