/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.perturbation;

import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.perturbation.LogicalModelPerturbation;
import org.colomoto.biolqm.modifier.perturbation.RegulatorRemovalOperation;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public class InteractionPerturbation
implements LogicalModelPerturbation {
    public final int regValue;
    public final NodeInfo target;
    public final NodeInfo regulator;

    public InteractionPerturbation(NodeInfo regulator, NodeInfo target, int regValue) {
        this.regValue = regValue;
        this.target = target;
        this.regulator = regulator;
    }

    @Override
    public void restrictValues(byte[] state, List<NodeInfo> nodeOrder) {
    }

    @Override
    public void update(LogicalModel model) {
        int idx = -1;
        int[] functions = null;
        idx = model.getComponents().indexOf(this.target);
        if (idx >= 0) {
            functions = model.getLogicalFunctions();
        } else {
            idx = model.getExtraComponents().indexOf(this.target);
            if (idx >= 0) {
                functions = model.getExtraLogicalFunctions();
            }
        }
        if (idx < 0) {
            throw new RuntimeException("Perturbation.update(): Could not find the target component");
        }
        int oldValue = functions[idx];
        MDDManager manager = model.getMDDManager();
        MDDVariable var = manager.getVariableForKey((Object)this.regulator);
        RegulatorRemovalOperation op = new RegulatorRemovalOperation(model.getMDDManager(), var, this.regValue);
        functions[idx] = op.restrict(oldValue);
        model.getMDDManager().free(oldValue);
    }

    public String toString() {
        return this.target.getNodeID() + " [" + this.regulator.getNodeID() + "@" + this.regValue + "]";
    }

    @Override
    public String getStringRepresentation() {
        return this.regulator.getNodeID() + ":" + this.target.getNodeID() + "%" + this.regValue;
    }

    public boolean equals(Object o) {
        if (o instanceof InteractionPerturbation) {
            InteractionPerturbation p = (InteractionPerturbation)o;
            return p.regulator.equals(this.regulator) && p.target.equals(this.target) && p.regValue == this.regValue;
        }
        return false;
    }

    @Override
    public boolean affectsNode(NodeInfo node) {
        return this.target.equals(node);
    }
}

