/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.perturbation;

import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public class RangeRestrictionOperation {
    private final MDDManager manager;
    private final int min;
    private final int max;

    public RangeRestrictionOperation(MDDManager manager, int min, int max) {
        this.manager = manager;
        this.min = min;
        this.max = max;
    }

    public int restrict(int node) {
        if (this.manager.isleaf(node)) {
            if (node <= this.min) {
                return this.min;
            }
            if (node > this.max) {
                return this.max;
            }
            return node;
        }
        MDDVariable var = this.manager.getNodeVariable(node);
        if (var.nbval == 2) {
            int f = this.restrict(this.manager.getChild(node, 0));
            int t = this.restrict(this.manager.getChild(node, 1));
            return var.getNode(f, t);
        }
        int[] children = new int[var.nbval];
        for (int i = 0; i < var.nbval; ++i) {
            children[i] = this.restrict(this.manager.getChild(node, i));
        }
        return var.getNode(children);
    }
}

