/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.reduction;

import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.helper.state.Range;
import org.colomoto.biolqm.helper.state.StatePattern;
import org.colomoto.biolqm.modifier.BaseModifier;
import org.colomoto.mddlib.MDDManager;

public class PatternReduction
extends BaseModifier {
    private final LogicalModel model;
    private final StatePattern pattern;

    public PatternReduction(LogicalModel model, StatePattern pattern) {
        this.model = model;
        this.pattern = pattern;
    }

    @Override
    public LogicalModel performTask() {
        LogicalModel modified = this.model.clone();
        MDDManager ddmanager = modified.getMDDManager();
        int[] functions = modified.getLogicalFunctions();
        int i = -1;
        for (NodeInfo ni : modified.getComponents()) {
            int f;
            int v;
            Range range = (Range)this.pattern.get(ni);
            if (range == null || range.min != range.max || (v = range.min) < 0 || v != range.max || v > ni.getMax() || ddmanager.isleaf(f = functions[++i])) continue;
            functions[i] = v;
        }
        return modified;
    }
}

