/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.reverse;

import java.util.ArrayList;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.BaseModifier;
import org.colomoto.biolqm.modifier.booleanize.BooleanizeModifier;
import org.colomoto.biolqm.modifier.reverse.ReverseOperation;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public class ReverseModifier
extends BaseModifier {
    private final LogicalModel model;

    public ReverseModifier(LogicalModel model) {
        this.model = model;
    }

    @Override
    public LogicalModel performTask() throws Exception {
        int i;
        MDDManager ddmanager = this.model.getMDDManager();
        ReverseOperation revOp = new ReverseOperation(ddmanager);
        MDDVariable[] variables = ddmanager.getAllVariables();
        ArrayList<NodeInfo> allNodes = new ArrayList<NodeInfo>(this.model.getComponents());
        allNodes.addAll(this.model.getExtraComponents());
        int[] functions = this.model.getLogicalFunctions();
        int[] extrafunctions = this.model.getExtraLogicalFunctions();
        int[] allFunctions = new int[functions.length + extrafunctions.length];
        for (i = 0; i < functions.length; ++i) {
            allFunctions[i] = functions[i];
        }
        for (i = functions.length; i < functions.length + extrafunctions.length - 1; ++i) {
            allFunctions[i] = extrafunctions[i - functions.length];
        }
        LogicalModel model = (LogicalModel)new BooleanizeModifier(this.model).call();
        for (int varIdx = 0; varIdx < variables.length; ++varIdx) {
            MDDVariable var = variables[varIdx];
            int f = allFunctions[varIdx];
            int newFunction = revOp.reverse(var, f);
            ddmanager.free(f);
            allFunctions[varIdx] = newFunction;
        }
        BooleanizeModifier.preventForbiddenStates(ddmanager, allNodes, allFunctions);
        return new LogicalModelImpl(allNodes, ddmanager, allFunctions);
    }
}

