/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.fixpoints;

import java.util.Iterator;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.tool.fixpoints.StableOperation;
import org.colomoto.biolqm.tool.fixpoints.StructuralNodeOrderer;
import org.colomoto.common.task.AbstractTask;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;

public class FixpointSearcher
extends AbstractTask<Integer> {
    private final LogicalModel model;

    public FixpointSearcher(LogicalModel model) {
        this.model = model;
    }

    @Override
    protected Integer performTask() {
        int prev;
        StructuralNodeOrderer ordering = new StructuralNodeOrderer(this.model);
        StableOperation sop = new StableOperation();
        int[] mdds = this.model.getLogicalFunctions();
        int result = prev = 1;
        List<NodeInfo> nodes = this.model.getComponents();
        MDDManager ddmanager = this.model.getMDDManager();
        Iterator iterator = ordering.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            NodeInfo node = nodes.get(i);
            prev = result;
            MDDVariable var = ddmanager.getVariableForKey((Object)node);
            int f = mdds[i];
            result = sop.getStable(ddmanager, prev, f, var);
            ddmanager.free(prev);
            if (!this.canceled) continue;
            ddmanager.free(result);
            return null;
        }
        return result;
    }

    public MDDManager getMDDManager() {
        return this.model.getMDDManager();
    }

    public PathSearcher getPaths() {
        int result = (Integer)this.getResult();
        PathSearcher ps = new PathSearcher(this.model.getMDDManager(), 1);
        ps.setNode(result);
        return ps;
    }
}

