/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.fixpoints;

import java.util.Iterator;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.helper.state.PatternStateIterator;
import org.colomoto.biolqm.helper.state.StateList;
import org.colomoto.biolqm.tool.AbstractToolTask;
import org.colomoto.biolqm.tool.fixpoints.FixpointList;
import org.colomoto.biolqm.tool.fixpoints.FixpointMethod;
import org.colomoto.biolqm.tool.fixpoints.FixpointSearcher;
import org.colomoto.biolqm.tool.fixpoints.StableASP;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.PathSearcher;

public class FixpointTask
extends AbstractToolTask<FixpointList> {
    public FixpointMethod method = FixpointMethod.MDD;
    public boolean pattern = false;
    public boolean extra = false;

    public FixpointTask(LogicalModel model) {
        super(model);
    }

    @Override
    public void setParameters(String[] parameters) {
        if (parameters == null) {
            return;
        }
        for (String p : parameters) {
            if ("asp".equalsIgnoreCase(p = p.trim())) {
                this.method = FixpointMethod.ASP;
            }
            if ("pattern".equalsIgnoreCase(p)) {
                this.pattern = true;
            }
            if (!"extra".equalsIgnoreCase(p)) continue;
            this.extra = true;
        }
    }

    @Override
    protected FixpointList performTask() throws Exception {
        FixpointList result = null;
        switch (this.method) {
            case ASP: {
                result = this.getASP(this.model);
                break;
            }
            default: {
                result = this.getMDD(this.model, this.pattern);
            }
        }
        result.setExtra(this.extra);
        return result;
    }

    public void useASP() {
        this.method = FixpointMethod.ASP;
    }

    public void useMDD() {
        this.method = FixpointMethod.MDD;
    }

    public FixpointList getMDD(LogicalModel model) {
        return this.getMDD(model, false);
    }

    private byte[] cloneState(int[] path) {
        byte[] result = new byte[path.length];
        for (int idx = 0; idx < path.length; ++idx) {
            result[idx] = (byte)path[idx];
        }
        return result;
    }

    public FixpointList getMDD(LogicalModel model, boolean pattern) {
        FixpointSearcher ssearcher = new FixpointSearcher(model);
        FixpointList result = new FixpointList(model);
        try {
            int stable = (Integer)ssearcher.call();
            MDDManager ddm = ssearcher.getMDDManager();
            PatternStateIterator expander = null;
            if (!pattern) {
                List<NodeInfo> components = model.getComponents();
                byte[] max = new byte[components.size()];
                for (int i = 0; i < max.length; ++i) {
                    max[i] = components.get(i).getMax();
                }
                expander = new PatternStateIterator(max, max);
            }
            PathSearcher psearcher = new PathSearcher(ddm, 1);
            int[] path = psearcher.setNode(stable);
            Iterator iterator = psearcher.iterator();
            while (iterator.hasNext()) {
                int v = (Integer)iterator.next();
                if (pattern) {
                    result.add(this.cloneState(path));
                    continue;
                }
                expander.reset(path);
                while (expander.hasNext()) {
                    result.add(expander.next().clone());
                }
            }
            ddm.free(stable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private FixpointList getASP(LogicalModel model) {
        StableASP asp = new StableASP(model);
        return asp.get();
    }

    @Override
    public void cli() {
        NodeInfo[] components;
        StateList result = null;
        try {
            result = (StateList)this.call();
        }
        catch (Exception e) {
            System.out.println("Error while constructing the result");
            e.printStackTrace();
            return;
        }
        if (result == null || result.size() < 1) {
            System.out.println("NO RESULTS");
            return;
        }
        for (NodeInfo ni : components = result.getComponents()) {
            System.out.print(ni + " ");
        }
        System.out.println();
        int nrows = result.size();
        for (int row = 0; row < nrows; ++row) {
            for (int col = 0; col < components.length; ++col) {
                byte i = result.get(row, col);
                if (i == -5) {
                    System.out.print("?");
                    continue;
                }
                if (i < 0) {
                    System.out.print("-");
                    continue;
                }
                System.out.print(i);
            }
            System.out.println();
        }
    }
}

