/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.fixpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.tool.fixpoints.FixpointList;
import org.colomoto.biolqm.tool.fixpoints.StructuralNodeOrderer;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;

public class JBDDModel {
    private final LogicalModel _ori;
    private final int nvar;
    private final BDDFactory jbdd;
    private final BDD[] functions;

    public JBDDModel(LogicalModel lm) {
        this._ori = lm;
        MDDManager ddmanager = lm.getMDDManager();
        MDDVariable[] variables = ddmanager.getAllVariables();
        this.nvar = variables.length;
        this.functions = new BDD[this.nvar];
        this.jbdd = BDDFactory.init((String)"java", (int)100000, (int)1000);
        this.jbdd.setVarNum(this.nvar);
        PathSearcher searcher = new PathSearcher(ddmanager);
        int[] lf = lm.getLogicalFunctions();
        for (int idx = 0; idx < lf.length; ++idx) {
            BDD func = this.jbdd.zero();
            int[] path = searcher.setNode(lf[idx]);
            Iterator iterator = searcher.iterator();
            while (iterator.hasNext()) {
                int leaf = (Integer)iterator.next();
                if (leaf == 0) continue;
                BDD cur = this.jbdd.one();
                for (int i = 0; i < path.length; ++i) {
                    int cst = path[i];
                    if (cst < 0) continue;
                    BDD ith = cst == 0 ? this.jbdd.nithVar(i) : this.jbdd.ithVar(i);
                    cur.andWith(ith);
                }
                func.orWith(cur);
            }
            this.functions[idx] = func;
        }
    }

    public static FixpointList getBDD(LogicalModel model) {
        JBDDModel jm = new JBDDModel(model);
        List<NodeInfo> components = model.getComponents();
        BDD stable = jm.stable();
        FixpointList result = new FixpointList(model);
        List l = stable.allsat();
        for (byte[] b : l) {
            for (int idx = 0; idx < components.size(); ++idx) {
                if (b[idx] < 0) {
                    System.out.print("-");
                    continue;
                }
                System.out.print(b[idx]);
            }
            System.out.println();
        }
        return result;
    }

    public void print() {
        for (int idx = 0; idx < this.functions.length; ++idx) {
            BDD func = this.functions[idx];
            if (func.isZero()) {
                System.out.println(idx + " = 0");
                continue;
            }
            System.out.println(idx + " = " + func);
        }
    }

    public BDD[] biimps() {
        BDD[] biimps = new BDD[this.nvar];
        for (int idx = 0; idx < this.nvar; ++idx) {
            BDD ith = this.jbdd.ithVar(idx);
            BDD ithNext = this.jbdd.nithVar(this.nvar + idx);
            biimps[idx] = ith.biimpWith(ithNext);
        }
        return biimps;
    }

    public BDD[] globalFunctions() {
        BDD[] globals = new BDD[this.nvar];
        this.jbdd.setVarNum(this.nvar * 2);
        for (int idx = 0; idx < this.nvar; ++idx) {
            BDD ith = this.jbdd.ithVar(this.nvar + idx);
            BDD nith = this.jbdd.nithVar(this.nvar + idx);
            globals[idx] = this.functions[idx].ite(ith, nith);
        }
        return globals;
    }

    public BDD[] globalAsyncFunctions() {
        BDD[] biimps = this.biimps();
        BDD[] globals = new BDD[this.nvar];
        this.jbdd.setVarNum(this.nvar * 2);
        for (int idx = 0; idx < this.nvar; ++idx) {
            BDD ith = this.jbdd.ithVar(this.nvar + idx);
            BDD cur = ith.biimp(this.functions[idx]);
            for (int j = 0; j < this.nvar; ++j) {
                if (j == idx) continue;
                cur.and(biimps[j]);
            }
            globals[idx] = cur;
        }
        return globals;
    }

    public BDD globalSynchronousFunction() {
        BDD[] globals = this.globalFunctions();
        BDD result = this.jbdd.one();
        StructuralNodeOrderer ordering = new StructuralNodeOrderer(this._ori);
        Iterator iterator = ordering.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            result.and(globals[i]);
        }
        return result;
    }

    public BDD globalAsynchronousFunction() {
        BDD[] globals = this.globalAsyncFunctions();
        BDD result = this.jbdd.zero();
        StructuralNodeOrderer ordering = new StructuralNodeOrderer(this._ori);
        Iterator iterator = ordering.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            result.or(globals[i]);
        }
        return result;
    }

    public BDD globalStable() {
        BDD gfunc = this.globalFunctions()[0];
        for (int idx = 0; idx < this.nvar; ++idx) {
            BDD ith = this.jbdd.ithVar(idx);
            BDD ithNext = this.jbdd.ithVar(this.nvar + idx);
            BDD nith = this.jbdd.nithVar(idx);
            BDD nithNext = this.jbdd.nithVar(this.nvar + idx);
            BDD cur = ith.andWith(ithNext).orWith(nith.andWith(nithNext));
            gfunc.andWith(cur);
        }
        return gfunc;
    }

    public BDD stable() {
        BDD result = this.jbdd.one();
        StructuralNodeOrderer ordering = new StructuralNodeOrderer(this._ori);
        Iterator iterator = ordering.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            BDD ith = this.jbdd.ithVar(i);
            BDD nith = this.jbdd.nithVar(i);
            BDD cur = this.functions[i];
            BDD curstable = cur.ite(ith, nith);
            result.andWith(curstable);
        }
        return result;
    }

    public List<int[]> bddPaths(BDD node) {
        BDDFactory f = node.getFactory();
        int[] set = new int[f.varNum()];
        for (int i = 0; i < set.length; ++i) {
            set[i] = -1;
        }
        ArrayList<int[]> paths = new ArrayList<int[]>();
        JBDDModel.bdd_printset_rec(f, paths, node, set);
        return paths;
    }

    private static void bdd_printset_rec(BDDFactory f, List<int[]> paths, BDD r, int[] set) {
        if (r.isZero()) {
            return;
        }
        if (r.isOne()) {
            paths.add((int[])set.clone());
            return;
        }
        set[f.var2Level((int)r.var())] = 0;
        BDD rl = r.low();
        JBDDModel.bdd_printset_rec(f, paths, rl, set);
        rl.free();
        set[f.var2Level((int)r.var())] = 1;
        BDD rh = r.high();
        JBDDModel.bdd_printset_rec(f, paths, rh, set);
        rh.free();
        set[f.var2Level((int)r.var())] = -1;
    }
}

