/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.fixpoints;

import org.colomoto.biolqm.tool.fixpoints.IsStableOperation;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.NodeRelation;
import org.colomoto.mddlib.operators.AbstractFlexibleOperator;

public class StableOperation
extends AbstractFlexibleOperator {
    MDDVariable ref;
    byte nbVal;

    public StableOperation() {
        super(AbstractFlexibleOperator.MergeAction.ASKME);
        for (NodeRelation rel : NodeRelation.values()) {
            this.setAction(rel, AbstractFlexibleOperator.MergeAction.ASKME);
        }
    }

    public int getStable(MDDManager factory, int known, int f, MDDVariable var) {
        this.ref = var;
        this.nbVal = var.nbval;
        int ret = this.combine(factory, known, f);
        return ret;
    }

    public AbstractFlexibleOperator.MergeAction ask(MDDManager factory, NodeRelation type, int first, int other) {
        switch (type) {
            case LL: {
                if (first == 0) {
                    return AbstractFlexibleOperator.MergeAction.THIS;
                }
                return AbstractFlexibleOperator.MergeAction.CUSTOM;
            }
            case NL: 
            case NN: 
            case NNn: {
                if (this.ref.after(factory.getNodeVariable(first))) {
                    return AbstractFlexibleOperator.MergeAction.RECURSIVE;
                }
                return AbstractFlexibleOperator.MergeAction.CUSTOM;
            }
            case LN: {
                if (first == 0) {
                    return AbstractFlexibleOperator.MergeAction.THIS;
                }
            }
            case NNf: {
                if (this.ref.after(factory.getNodeVariable(other))) {
                    return AbstractFlexibleOperator.MergeAction.RECURSIVE;
                }
                return AbstractFlexibleOperator.MergeAction.CUSTOM;
            }
        }
        System.err.println("DEBUG: Stable ask should not come here!");
        return AbstractFlexibleOperator.MergeAction.ASKME;
    }

    public int custom(MDDManager factory, NodeRelation type, int first, int other) {
        int[] children = new int[this.nbVal];
        MDDVariable firstVar = factory.getNodeVariable(first);
        switch (type) {
            case LL: 
            case NL: {
                if (this.ref.equals((Object)firstVar)) {
                    for (int i = 0; i < this.nbVal; ++i) {
                        children[i] = i == other ? factory.getChild(first, i) : 0;
                    }
                } else {
                    for (int i = 0; i < this.nbVal; ++i) {
                        children[i] = i == other ? first : 0;
                    }
                }
                return this.ref.getNode(children);
            }
            case NN: 
            case NNn: 
            case LN: 
            case NNf: {
                if (type == NodeRelation.NNn && this.ref.equals((Object)firstVar)) {
                    for (int i = 0; i < this.nbVal; ++i) {
                        children[i] = IsStableOperation.getOp(i).combine(factory, factory.getChild(first, i), other);
                    }
                } else if (type == NodeRelation.NN && this.ref.equals((Object)firstVar)) {
                    for (int i = 0; i < this.nbVal; ++i) {
                        children[i] = IsStableOperation.getOp(i).combine(factory, factory.getChild(first, i), factory.getChild(other, i));
                    }
                } else if (type != NodeRelation.NNn && this.ref.equals((Object)factory.getNodeVariable(other))) {
                    for (int i = 0; i < this.nbVal; ++i) {
                        children[i] = IsStableOperation.getOp(i).combine(factory, first, factory.getChild(other, i));
                    }
                } else {
                    for (int i = 0; i < this.nbVal; ++i) {
                        children[i] = IsStableOperation.getOp(i).combine(factory, first, other);
                    }
                }
                return this.ref.getNodeFree(children);
            }
        }
        System.err.println("DEBUG: Stable custom should not come here!");
        return -1;
    }
}

