/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation;

import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.tool.simulation.LogicalModelUpdater;

public abstract class BaseUpdater
implements LogicalModelUpdater {
    protected final LogicalModel model;
    protected final int size;

    public BaseUpdater(LogicalModel model) {
        this.model = model;
        this.size = model.getComponents().size();
    }

    protected int nodeChange(byte[] state, int index) {
        byte curState = state[index];
        byte nextState = this.model.getTargetValue(index, state);
        if (nextState > curState) {
            return 1;
        }
        if (nextState < curState) {
            return -1;
        }
        return 0;
    }

    @Override
    public LogicalModel getModel() {
        return this.model;
    }

    protected byte[] update(byte[] state, int idx, int change, byte[] next) {
        if (change == 0) {
            return next;
        }
        if (next == null) {
            next = (byte[])state.clone();
        }
        int n = idx;
        next[n] = (byte)(next[n] + change);
        return next;
    }
}

