/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.deterministic;

import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.tool.simulation.BaseUpdater;
import org.colomoto.biolqm.tool.simulation.deterministic.DeterministicUpdater;
import org.colomoto.biolqm.tool.simulation.grouping.ModelGrouping;

public class BlockSequentialUpdater
extends BaseUpdater
implements DeterministicUpdater {
    private final int[][] blocks;
    private final byte[] tmp_state;

    public BlockSequentialUpdater(ModelGrouping grouping) {
        this(grouping.getModel(), grouping.getDeterministicBlocks());
    }

    public BlockSequentialUpdater(LogicalModel model, int[][] blocks) {
        super(model);
        this.blocks = blocks;
        this.tmp_state = new byte[model.getComponents().size()];
    }

    public BlockSequentialUpdater(LogicalModel model, String config) {
        this(new ModelGrouping(model, config));
    }

    @Override
    public byte[] getSuccessor(byte[] state) {
        byte[] nextstate = (byte[])state.clone();
        boolean changed = false;
        for (int[] block : this.blocks) {
            System.arraycopy(nextstate, 0, this.tmp_state, 0, nextstate.length);
            for (int i = 0; i < block.length; i += 2) {
                int k_aux = block[i];
                int cst = block[i + 1];
                int change = this.nodeChange(this.tmp_state, k_aux);
                if (change == 0 || cst != 0 && cst != change) continue;
                int n = k_aux;
                nextstate[n] = (byte)(nextstate[n] + change);
                changed = true;
            }
        }
        if (changed) {
            return nextstate;
        }
        return null;
    }
}

