/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.deterministic;

import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.tool.simulation.BaseUpdater;
import org.colomoto.biolqm.tool.simulation.deterministic.DeterministicUpdater;

public class SequentialUpdater
extends BaseUpdater
implements DeterministicUpdater {
    private final int[] order;

    public SequentialUpdater(LogicalModel model) {
        super(model);
        this.order = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.order[i] = i;
        }
    }

    public SequentialUpdater(LogicalModel model, String s_order) {
        this(model);
        String[] nodes = s_order.split(",");
        int idx = 0;
        List<NodeInfo> components = model.getComponents();
        boolean[] ordered = new boolean[components.size()];
        for (String node : nodes) {
            int k;
            NodeInfo ni = model.getComponent(node.trim());
            if (ni == null || ordered[k = components.indexOf(ni)]) continue;
            ordered[k] = true;
            this.order[idx++] = k;
        }
        for (int k = 0; k < this.size; ++k) {
            if (ordered[k]) continue;
            this.order[idx++] = k;
        }
    }

    public SequentialUpdater(LogicalModel model, int[] order) {
        super(model);
        this.order = order;
    }

    @Override
    public byte[] getSuccessor(byte[] state) {
        byte[] refstate = state;
        byte[] nextstate = null;
        for (int idx : this.order) {
            int change = this.nodeChange(refstate, idx);
            if (change == 0) continue;
            nextstate = this.update(refstate, idx, change, nextstate);
            refstate = nextstate;
        }
        return nextstate;
    }
}

