/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.deterministic;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.colomoto.biolqm.tool.simulation.deterministic.DeterministicUpdater;

class StateIterator
implements Iterator<byte[]> {
    private byte[] state;
    private final byte[][] buffer;
    private int buffer_pos;
    private final DeterministicUpdater updater;
    private int steps;

    public StateIterator(byte[] state, DeterministicUpdater updater, int length, int max_steps) {
        this.state = state;
        this.updater = updater;
        this.steps = max_steps;
        this.buffer = new byte[length][];
        this.buffer_pos = 0;
    }

    @Override
    public boolean hasNext() {
        return this.state != null;
    }

    @Override
    public byte[] next() {
        if (this.state == null) {
            throw new NoSuchElementException();
        }
        for (byte[] prev : this.buffer) {
            if (prev == null) break;
            if (!Arrays.equals(this.state, prev)) continue;
            byte[] ret = this.state;
            this.state = null;
            return ret;
        }
        this.buffer[this.buffer_pos++] = this.state;
        if (this.buffer_pos >= this.buffer.length) {
            this.buffer_pos = 0;
        }
        byte[] ret = this.state;
        this.state = (byte[])(this.steps < 1 ? null : this.updater.getSuccessor(this.state));
        --this.steps;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

