/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.grouping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.tool.simulation.grouping.SplittingType;

public class ModelGrouping {
    public static final String SEPVAR = ",";
    public static final String SEPGROUP = "/";
    public static final String SEPCLASS = ":";
    protected LogicalModel model;
    private List<RankedClass> pcList;

    public ModelGrouping(LogicalModel m) {
        this.model = m;
        this.pcList = new ArrayList<RankedClass>();
        int coreVars = 0;
        for (int n = 0; n < this.model.getComponents().size(); ++n) {
            if (this.model.getComponents().get(n).isInput()) continue;
            ++coreVars;
        }
        int[] vars = new int[coreVars * 2];
        int i = 0;
        for (int n = 0; n < this.model.getComponents().size(); ++n) {
            if (this.model.getComponents().get(n).isInput()) continue;
            vars[i] = n;
            vars[i + 1] = 0;
            i += 2;
        }
        this.pcList.add(new RankedClass(new RankedClassGroup(vars)));
    }

    public ModelGrouping(LogicalModel m, String textFormat) {
        String[] saPCs;
        this.model = m;
        this.pcList = new ArrayList<RankedClass>();
        for (String sPC : saPCs = textFormat.split(SEPCLASS)) {
            this.pcList.add(new RankedClass(m, sPC));
        }
    }

    private ModelGrouping(LogicalModel m, List<RankedClass> pcList) {
        this.model = m;
        this.pcList = pcList;
    }

    public LogicalModel getModel() {
        return this.model;
    }

    public int[][] getDeterministicBlocks() {
        int n = this.pcList.size();
        int[][] blocks = new int[n][];
        int idx = 0;
        for (RankedClass cl : this.pcList) {
            int l = 0;
            for (RankedClassGroup grp : cl.groups) {
                l += grp.vars.length;
            }
            int[] cur = new int[l];
            int pos = 0;
            for (RankedClassGroup grp : cl.groups) {
                System.arraycopy(grp.vars, 0, cur, pos, grp.vars.length);
                pos += grp.vars.length;
            }
            blocks[idx] = cur;
            ++idx;
        }
        return blocks;
    }

    public ModelGrouping clone() {
        ArrayList<RankedClass> pcNew = new ArrayList<RankedClass>();
        for (RankedClass pc : this.pcList) {
            pcNew.add(pc.clone());
        }
        return new ModelGrouping(this.model, pcNew);
    }

    public ModelGrouping cloneWithModel(LogicalModel modifiedModel) {
        ArrayList<RankedClass> pcNew = new ArrayList<RankedClass>();
        for (RankedClass pc : this.pcList) {
            pcNew.add(pc.clone());
        }
        return new ModelGrouping(modifiedModel, pcNew);
    }

    public void switchClasses(int i, int j) {
        RankedClass pc = this.getClass(i);
        this.pcList.remove(i);
        this.pcList.add(j, pc);
    }

    private boolean isValid(int idxPC) {
        return idxPC >= 0 && this.pcList.size() > idxPC;
    }

    public RankedClass getClass(int idxPC) {
        if (!this.isValid(idxPC)) {
            return null;
        }
        return this.pcList.get(idxPC);
    }

    public List<List<String>> getClassVars(int idxPC) {
        ArrayList<List<String>> tmp;
        if (this.isValid(idxPC)) {
            tmp = this.pcList.get(idxPC).getVars(this.model);
        } else {
            tmp = new ArrayList();
            tmp.add(new ArrayList());
        }
        return tmp;
    }

    public void decPriorities(int idxPC, int idxGrp, List<String> vars) {
        if (!this.isValid(idxPC) || !this.pcList.get(idxPC).isValid(idxGrp)) {
            return;
        }
        for (String varMm : vars) {
            int splitFlag = 0;
            String var = varMm;
            if (varMm.endsWith(SplittingType.POSITIVE.toString())) {
                splitFlag = 1;
                var = varMm.substring(0, varMm.length() - SplittingType.POSITIVE.toString().length());
            } else if (varMm.endsWith(SplittingType.NEGATIVE.toString())) {
                splitFlag = -1;
                var = varMm.substring(0, varMm.length() - SplittingType.NEGATIVE.toString().length());
            }
            for (int idx = 0; idx < this.model.getComponents().size(); ++idx) {
                if (!this.model.getComponents().get(idx).getNodeID().equals(var)) continue;
                if (this.pcList.get(idxPC).contains(idxGrp, idx, splitFlag)) {
                    this.pcList.get(idxPC).remove(idxGrp, idx, splitFlag);
                }
                if (idxPC + 1 == this.pcList.size()) {
                    int[] newvars = new int[]{idx, splitFlag};
                    this.pcList.add(new RankedClass(new RankedClassGroup(newvars)));
                    continue;
                }
                this.pcList.get(idxPC + 1).add(0, idx, splitFlag);
            }
            if (!this.pcList.get(idxPC).isEmpty()) continue;
            this.pcList.remove(idxPC);
        }
    }

    public void decGroup(int idxPC, int idxGrp, List<String> vars) {
        if (!this.isValid(idxPC) || !this.pcList.get(idxPC).isValid(idxGrp)) {
            return;
        }
        for (String varMm : vars) {
            int splitFlag = 0;
            String var = varMm;
            if (varMm.endsWith(SplittingType.POSITIVE.toString())) {
                splitFlag = 1;
                var = varMm.substring(0, varMm.length() - SplittingType.POSITIVE.toString().length());
            } else if (varMm.endsWith(SplittingType.NEGATIVE.toString())) {
                splitFlag = -1;
                var = varMm.substring(0, varMm.length() - SplittingType.NEGATIVE.toString().length());
            }
            for (int idx = 0; idx < this.model.getComponents().size(); ++idx) {
                if (!this.model.getComponents().get(idx).getNodeID().equals(var) || !this.pcList.get(idxPC).contains(idxGrp, idx, splitFlag)) continue;
                this.pcList.get(idxPC).remove(idxGrp, idx, splitFlag);
                if (idxGrp + 1 == this.pcList.get(idxPC).size()) {
                    int[] newVars = new int[]{idx, splitFlag};
                    this.pcList.get(idxPC).addGrp(idxGrp + 1, new RankedClassGroup(newVars));
                    continue;
                }
                this.pcList.get(idxPC).add(idxGrp + 1, idx, splitFlag);
            }
        }
        if (((RankedClassGroup)this.pcList.get(idxPC).groups.get(idxGrp)).isEmpty()) {
            this.pcList.get(idxPC).groups.remove(idxGrp);
        }
    }

    public void incGroup(int idxPC, int idxGrp, List<String> vars) {
        if (!this.isValid(idxPC) || !this.pcList.get(idxPC).isValid(idxGrp)) {
            return;
        }
        for (String varMm : vars) {
            int splitFlag = 0;
            String var = varMm;
            if (varMm.endsWith(SplittingType.POSITIVE.toString())) {
                splitFlag = 1;
                var = varMm.substring(0, varMm.length() - SplittingType.POSITIVE.toString().length());
            } else if (varMm.endsWith(SplittingType.NEGATIVE.toString())) {
                splitFlag = -1;
                var = varMm.substring(0, varMm.length() - SplittingType.NEGATIVE.toString().length());
            }
            for (int idx = 0; idx < this.model.getComponents().size(); ++idx) {
                if (!this.model.getComponents().get(idx).getNodeID().equals(var) || !this.pcList.get(idxPC).contains(idxGrp, idx, splitFlag)) continue;
                this.pcList.get(idxPC).remove(idxGrp, idx, splitFlag);
                if (idxGrp == 0) {
                    int[] newVars = new int[]{idx, splitFlag};
                    this.pcList.get(idxPC).addGrp(0, new RankedClassGroup(newVars));
                    ++idxGrp;
                    continue;
                }
                this.pcList.get(idxPC).add(idxGrp - 1, idx, splitFlag);
            }
        }
        if (((RankedClassGroup)this.pcList.get(idxPC).groups.get(idxGrp)).isEmpty()) {
            this.pcList.get(idxPC).groups.remove(idxGrp);
        }
    }

    public void incPriorities(int idxPC, int idxGrp, List<String> vars) {
        if (!this.isValid(idxPC) || !this.pcList.get(idxPC).isValid(idxGrp)) {
            return;
        }
        ArrayList<int[]> lVars = new ArrayList<int[]>();
        for (String varMm : vars) {
            int splitFlag = 0;
            String var = varMm;
            if (varMm.endsWith(SplittingType.POSITIVE.toString())) {
                splitFlag = 1;
                var = varMm.substring(0, varMm.length() - SplittingType.POSITIVE.toString().length());
            } else if (varMm.endsWith(SplittingType.NEGATIVE.toString())) {
                splitFlag = -1;
                var = varMm.substring(0, varMm.length() - SplittingType.NEGATIVE.toString().length());
            }
            for (int idx = 0; idx < this.model.getComponents().size(); ++idx) {
                if (!this.model.getComponents().get(idx).getNodeID().equals(var) || !this.pcList.get(idxPC).contains(idxGrp, idx, splitFlag)) continue;
                int[] newvars = new int[]{idx, splitFlag};
                lVars.add(newvars);
            }
        }
        if (lVars.isEmpty()) {
            return;
        }
        for (int[] newvars : lVars) {
            this.pcList.get(idxPC).remove(idxGrp, newvars[0], newvars[1]);
            if (idxPC == 0) {
                this.pcList.add(0, new RankedClass(new RankedClassGroup(newvars)));
                ++idxPC;
                continue;
            }
            this.pcList.get(idxPC - 1).add(0, newvars[0], newvars[1]);
        }
        if (((RankedClassGroup)this.pcList.get(idxPC).groups.get(idxGrp)).isEmpty()) {
            this.pcList.get(idxPC).groups.remove(idxGrp);
        }
        if (this.pcList.get(idxPC).isEmpty()) {
            this.pcList.remove(idxPC);
        }
    }

    public void groupExpand(int idxPC) {
        this.pcList.get(idxPC).expand();
    }

    public void groupCollapse(int idxPC) {
        this.pcList.get(idxPC).collapse();
    }

    public void collapseAll() {
        RankedClass pc0 = this.pcList.get(0);
        for (int c = this.size() - 1; c > 0; --c) {
            while (this.pcList.get(c).size() > 0) {
                RankedClassGroup pcg = this.pcList.get(c).removeGrp(0);
                pc0.addGrp(0, pcg);
            }
            this.pcList.remove(c);
        }
        pc0.collapse();
        for (int idxVar = 0; idxVar < this.model.getComponents().size(); ++idxVar) {
            pc0.unsplit(0, idxVar, 1);
            this.remove(idxVar, -1);
        }
    }

    public int size() {
        return this.pcList.size();
    }

    public void split(int idxPC, int idxGrp, String var) {
        if (!this.isValid(idxPC) || !this.pcList.get(idxPC).isValid(idxGrp)) {
            return;
        }
        for (int idx = 0; idx < this.model.getComponents().size(); ++idx) {
            if (!this.model.getComponents().get(idx).getNodeID().equals(var)) continue;
            this.pcList.get(idxPC).split(idxGrp, idx);
            return;
        }
    }

    public void unsplit(int idxPC, int idxGrp, String varMm) {
        if (!this.isValid(idxPC) || !this.pcList.get(idxPC).isValid(idxGrp) || !varMm.endsWith(SplittingType.POSITIVE.toString()) && !varMm.endsWith(SplittingType.NEGATIVE.toString())) {
            return;
        }
        String var = varMm.substring(0, varMm.length() - SplittingType.POSITIVE.toString().length());
        int splitFlag = varMm.endsWith(SplittingType.POSITIVE.toString()) ? 1 : -1;
        for (int idx = 0; idx < this.model.getComponents().size(); ++idx) {
            if (!this.model.getComponents().get(idx).getNodeID().equals(var)) continue;
            this.pcList.get(idxPC).unsplit(idxGrp, idx, splitFlag);
            this.remove(idx, -1 * splitFlag);
            break;
        }
    }

    private void remove(int idxVar, int splitFlag) {
        for (int i = 0; i < this.size() && !this.pcList.get(i).remove(idxVar, splitFlag); ++i) {
        }
    }

    public boolean equals(Object a) {
        ModelGrouping outMPC = (ModelGrouping)a;
        if (outMPC.getModel() != this.getModel() || outMPC.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (outMPC.pcList.get(i).equals(this.pcList.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String sTmp = "";
        for (RankedClass pc : this.pcList) {
            if (!sTmp.isEmpty()) {
                sTmp = sTmp + SEPCLASS;
            }
            sTmp = sTmp + pc;
        }
        return sTmp;
    }

    public class RankedClassGroup {
        private int[] vars;

        public RankedClassGroup(int[] vars) {
            this.vars = vars;
        }

        public RankedClassGroup(LogicalModel m, String textFormat) {
            int i;
            String[] saVars = textFormat.split(ModelGrouping.SEPVAR);
            ArrayList<int[]> lVars = new ArrayList<int[]>();
            block0: for (i = 0; i < saVars.length; ++i) {
                String var = saVars[i];
                int split = 0;
                if (saVars[i].endsWith(SplittingType.NEGATIVE.toString())) {
                    split = -1;
                    var = saVars[i].substring(0, var.length() - SplittingType.NEGATIVE.toString().length());
                } else if (saVars[i].endsWith(SplittingType.POSITIVE.toString())) {
                    split = 1;
                    var = saVars[i].substring(0, var.length() - SplittingType.POSITIVE.toString().length());
                }
                for (int idx = 0; idx < m.getComponents().size(); ++idx) {
                    NodeInfo node = m.getComponents().get(idx);
                    if (!node.getNodeID().equals(var)) continue;
                    if (node.isInput()) continue block0;
                    int[] newVar = new int[]{idx, split};
                    lVars.add(newVar);
                    continue block0;
                }
            }
            this.vars = new int[lVars.size() * 2];
            for (i = 0; i < lVars.size(); ++i) {
                this.vars[i * 2] = ((int[])lVars.get(i))[0];
                this.vars[i * 2 + 1] = ((int[])lVars.get(i))[1];
            }
        }

        public int[] array() {
            return this.vars;
        }

        public boolean isEmpty() {
            return this.vars == null || this.vars.length < 1;
        }

        public int size() {
            return this.vars.length / 2;
        }

        private boolean contains(int idx, int splitFlag) {
            for (int i = 0; i < this.vars.length; i += 2) {
                if (this.vars[i] != idx || this.vars[i + 1] != splitFlag) continue;
                return true;
            }
            return false;
        }

        public List<String> getVars(LogicalModel m) {
            ArrayList<String> lVars = new ArrayList<String>();
            for (int i = 0; i < this.vars.length; i += 2) {
                String var = m.getComponents().get(this.vars[i]).getNodeID();
                if (this.vars[i + 1] == 1) {
                    var = var + SplittingType.POSITIVE.toString();
                } else if (this.vars[i + 1] == -1) {
                    var = var + SplittingType.NEGATIVE.toString();
                }
                lVars.add(var);
            }
            return lVars;
        }

        public boolean split(int idx) {
            if (!this.contains(idx, 0)) {
                return false;
            }
            int[] newVars = new int[this.vars.length + 2];
            int i = 0;
            int j = 0;
            while (i < this.vars.length) {
                newVars[j] = this.vars[i];
                if (this.vars[i] != idx) {
                    newVars[j + 1] = this.vars[i + 1];
                } else {
                    newVars[j + 1] = -1;
                    newVars[j + 2] = this.vars[i];
                    newVars[j + 3] = 1;
                    j += 2;
                }
                i += 2;
                j += 2;
            }
            this.vars = newVars;
            return true;
        }

        public boolean unsplit(int idx, int splitFlag) {
            if (!this.contains(idx, splitFlag)) {
                return false;
            }
            for (int i = 0; i < this.vars.length; i += 2) {
                if (this.vars[i] != idx || this.vars[i + 1] != splitFlag) continue;
                this.vars[i + 1] = 0;
                break;
            }
            return true;
        }

        public boolean remove(int idx, int splitFlag) {
            if (!this.contains(idx, splitFlag)) {
                return false;
            }
            int[] newVars = new int[this.vars.length - 2];
            int j = 0;
            for (int i = 0; i < this.vars.length; i += 2) {
                if (this.vars[i] == idx && this.vars[i + 1] == splitFlag) continue;
                newVars[j] = this.vars[i];
                newVars[j + 1] = this.vars[i + 1];
                j += 2;
            }
            this.vars = newVars;
            return true;
        }

        public boolean add(int idx, int splitFlag) {
            if (this.contains(idx, splitFlag)) {
                return false;
            }
            int[] newVars = new int[this.vars.length + 2];
            System.arraycopy(this.vars, 0, newVars, 0, this.vars.length);
            newVars[this.vars.length] = idx;
            newVars[this.vars.length + 1] = splitFlag;
            this.vars = newVars;
            return true;
        }

        public RankedClassGroup clone() {
            return new RankedClassGroup((int[])this.vars.clone());
        }

        public boolean equals(Object o) {
            RankedClassGroup outPC = (RankedClassGroup)o;
            return Arrays.equals(this.vars, outPC.vars);
        }
    }

    public class RankedClass {
        private List<RankedClassGroup> groups = new ArrayList<RankedClassGroup>();

        public RankedClass(RankedClassGroup pcg) {
            this.groups.add(pcg);
        }

        public RankedClass(LogicalModel m, String textFormat) {
            String[] saPCGs;
            for (String sPCG : saPCGs = textFormat.split(ModelGrouping.SEPGROUP)) {
                this.groups.add(new RankedClassGroup(m, sPCG));
            }
        }

        public boolean isValid(int idxGrp) {
            return idxGrp >= 0 && this.groups.size() > idxGrp;
        }

        public int size() {
            return this.groups.size();
        }

        public boolean isEmpty() {
            return this.size() == 0 || this.size() == 1 && this.groups.get(0).isEmpty();
        }

        private boolean contains(int idxGrp, int idxVar, int splitFlag) {
            return this.groups.get(idxGrp).contains(idxVar, splitFlag);
        }

        public RankedClassGroup removeGrp(int idxGrp) {
            if (!this.isValid(idxGrp)) {
                return null;
            }
            RankedClassGroup pcg = this.groups.get(idxGrp);
            this.groups.remove(idxGrp);
            return pcg;
        }

        public void addGrp(int pos, RankedClassGroup pcg) {
            this.groups.add(pos, pcg);
        }

        public int[] getGroupValues(int idxGrp) {
            if (idxGrp >= 0 && idxGrp < this.size()) {
                return this.groups.get(idxGrp).array();
            }
            return null;
        }

        public List<List<String>> getVars(LogicalModel m) {
            ArrayList<List<String>> lVars = new ArrayList<List<String>>();
            for (RankedClassGroup pcg : this.groups) {
                lVars.add(pcg.getVars(m));
            }
            return lVars;
        }

        public void collapse() {
            for (int g = this.size() - 1; g > 0; --g) {
                int[] vars = this.getGroupValues(g);
                for (int i = 0; i < vars.length; i += 2) {
                    this.groups.get(0).add(vars[i], vars[i + 1]);
                }
                this.groups.remove(g);
            }
        }

        public void expand() {
            ArrayList<RankedClassGroup> lPCGs = new ArrayList<RankedClassGroup>();
            for (RankedClassGroup pcg : this.groups) {
                int[] vars = pcg.array();
                for (int i = 0; i < vars.length; i += 2) {
                    int[] newVars = new int[]{vars[i], vars[i + 1]};
                    RankedClassGroup pcgNew = new RankedClassGroup(newVars);
                    lPCGs.add(pcgNew);
                }
            }
            this.groups = lPCGs;
        }

        public boolean split(int idxGrp, int idxVar) {
            return this.groups.get(idxGrp).split(idxVar);
        }

        public boolean unsplit(int idxGrp, int idxVar, int splitFlag) {
            return this.groups.get(idxGrp).unsplit(idxVar, splitFlag);
        }

        public boolean remove(int idxGrp, int idxVar, int splitFlag) {
            return this.groups.get(idxGrp).remove(idxVar, splitFlag);
        }

        public boolean remove(int idxVar, int splitFlag) {
            for (int g = 0; g < this.groups.size(); ++g) {
                if (!this.remove(g, idxVar, splitFlag)) continue;
                return true;
            }
            return false;
        }

        public boolean add(int idxGrp, int idxVar, int splitFlag) {
            return this.groups.get(idxGrp).add(idxVar, splitFlag);
        }

        public RankedClass clone() {
            RankedClass pc = new RankedClass(this.groups.get(0).clone());
            for (int g = 1; g < this.groups.size(); ++g) {
                pc.addGrp(g, this.groups.get(g).clone());
            }
            return pc;
        }

        public boolean equals(Object o) {
            RankedClass outPC = (RankedClass)o;
            if (outPC.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (outPC.groups.get(i).equals(this.groups.get(i))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            String sPC = "";
            for (RankedClassGroup pcg : this.groups) {
                if (!sPC.isEmpty()) {
                    sPC = sPC + ModelGrouping.SEPGROUP;
                }
                String sG = "";
                for (int i = 0; i < pcg.vars.length; i += 2) {
                    if (!sG.isEmpty()) {
                        sG = sG + ModelGrouping.SEPVAR;
                    }
                    sG = sG + ModelGrouping.this.model.getComponents().get(pcg.vars[i]).getNodeID();
                    if (pcg.vars[i + 1] == 1) {
                        sG = sG + SplittingType.POSITIVE.toString();
                        continue;
                    }
                    if (pcg.vars[i + 1] != -1) continue;
                    sG = sG + SplittingType.NEGATIVE.toString();
                }
                sPC = sPC + sG;
            }
            return sPC;
        }
    }
}

