/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.multiplesuccessor;

import java.util.ArrayList;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.tool.simulation.BaseUpdater;
import org.colomoto.biolqm.tool.simulation.multiplesuccessor.EmptySuccessorList;
import org.colomoto.biolqm.tool.simulation.multiplesuccessor.MultipleSuccessorsUpdater;
import org.colomoto.biolqm.tool.simulation.multiplesuccessor.SingleStateList;
import org.colomoto.biolqm.tool.simulation.multiplesuccessor.StateList;

public abstract class AbstractMultipleSuccessorUpdater
extends BaseUpdater
implements MultipleSuccessorsUpdater {
    private static final List<byte[]> EMPTYSUCCESSOR = new EmptySuccessorList();
    protected byte[] state = null;
    protected byte[] nextState = null;

    public AbstractMultipleSuccessorUpdater(LogicalModel model) {
        super(model);
    }

    public List<byte[]> addSuccessor(List<byte[]> successors, byte[] state) {
        if (state == null) {
            return successors;
        }
        if (successors == null) {
            successors = new ArrayList<byte[]>();
        }
        successors.add(state);
        return successors;
    }

    public static List<byte[]> getEmptySuccessors() {
        return EMPTYSUCCESSOR;
    }

    public static List<byte[]> getSingleSuccessors(byte[] next) {
        if (next == null) {
            return EMPTYSUCCESSOR;
        }
        return new SingleStateList(next);
    }

    public static List<byte[]> getSuccessors(List<byte[]> nexts) {
        if (nexts == null || nexts.size() == 0) {
            return EMPTYSUCCESSOR;
        }
        if (nexts.size() == 1) {
            return new SingleStateList(nexts.get(0));
        }
        return new StateList(nexts);
    }
}

