/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.random;

import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.tool.simulation.random.AbstractRandomUpdater;

public class RandomUpdaterWithRates
extends AbstractRandomUpdater {
    private final double[] rates;

    public RandomUpdaterWithRates(LogicalModel model) {
        this(model, null);
    }

    public RandomUpdaterWithRates(LogicalModel model, double[] rates) {
        super(model);
        if (rates == null) {
            this.rates = new double[this.size];
            for (int i = 0; i < this.rates.length; ++i) {
                this.rates[i] = 1.0;
            }
        } else {
            this.rates = rates;
        }
    }

    @Override
    public byte[] pickSuccessor(byte[] state) {
        int nb_changes = 0;
        double totalrate = 0.0;
        double[] step_rates = new double[this.size];
        int[][] step_changes = new int[this.size][2];
        for (int idx = 0; idx < this.size; ++idx) {
            int change = this.nodeChange(state, idx);
            if (change == 0) continue;
            double r = this.rates[idx];
            step_rates[nb_changes] = totalrate += r;
            step_changes[nb_changes][0] = idx;
            step_changes[nb_changes][1] = change;
            ++nb_changes;
        }
        if (nb_changes == 0) {
            return null;
        }
        byte[] nextstate = (byte[])state.clone();
        int selected = this.select(step_rates, nb_changes, totalrate);
        int idx = step_changes[selected][0];
        int change = step_changes[selected][1];
        int n = idx;
        nextstate[n] = (byte)(nextstate[n] + change);
        return nextstate;
    }

    private int select(double[] step_rates, int nb_changes, double totalrate) {
        int idx;
        if (nb_changes == 1) {
            return 0;
        }
        int s = 0;
        double r = totalrate * this.random.nextDouble();
        for (idx = 0; idx < nb_changes && !((double)(s = (int)((double)s + step_rates[idx])) > r); ++idx) {
        }
        return idx;
    }
}

