/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.trapspaces;

public class TrapSpace {
    public final int length;
    public final int nfree;
    public final int npercolated;
    public final byte[] pattern;
    public final boolean[] percolated;

    protected TrapSpace(byte[] pattern) {
        this(pattern, null);
    }

    protected TrapSpace(byte[] pattern, boolean[] percolated) {
        this.length = pattern.length;
        this.pattern = pattern;
        if (percolated == null) {
            percolated = new boolean[this.length];
        }
        this.percolated = percolated;
        int nfree = 0;
        int npercolated = 0;
        for (int i = 0; i < this.length; ++i) {
            if (pattern[i] < 0) {
                ++nfree;
                continue;
            }
            if (!percolated[i]) continue;
            ++npercolated;
        }
        this.nfree = nfree;
        this.npercolated = npercolated;
    }

    public String toString() {
        String s = "";
        block5: for (int i = 0; i < this.length; ++i) {
            byte v = this.pattern[i];
            switch (v) {
                case -2: {
                    s = s + "- ";
                    continue block5;
                }
                case -1: {
                    s = s + "* ";
                    continue block5;
                }
                case -5: {
                    s = s + "? ";
                    continue block5;
                }
                default: {
                    s = s + v;
                    s = this.percolated[i] ? s + "'" : s + " ";
                }
            }
        }
        return s;
    }

    public String shortString() {
        String s = "";
        for (int i = 0; i < this.length; ++i) {
            byte v = this.pattern[i];
            s = v < 0 ? s + "-" : s + v;
        }
        return s;
    }

    public boolean contains(TrapSpace t) {
        if (t.nfree >= this.nfree) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            byte v1 = this.pattern[i];
            byte v2 = t.pattern[i];
            if (v1 < 0 || v1 == v2 || this.percolated[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof TrapSpace) {
            return this.pattern.equals(((TrapSpace)other).pattern);
        }
        return false;
    }
}

