/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.trapspaces;

import java.util.ArrayList;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.helper.state.StateList;
import org.colomoto.biolqm.tool.fixpoints.FixpointList;
import org.colomoto.biolqm.tool.trapspaces.TrapSpace;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceTask;

public class TrapSpaceList
extends ArrayList<TrapSpace>
implements StateList {
    public final boolean terminal;
    public final NodeInfo[] nodes;

    public TrapSpaceList(TrapSpaceTask settings, LogicalModel model) {
        this.terminal = settings.terminal;
        this.nodes = FixpointList.extractIDs(model.getComponents());
    }

    public boolean addPattern(byte[] pattern, boolean[] variant) {
        if (this.terminal) {
            if (variant != null) {
                int nvariant = 0;
                for (int i = 0; i < variant.length; ++i) {
                    if (pattern[i] >= 0 || !variant[i]) continue;
                    ++nvariant;
                }
                if (nvariant > 0) {
                    return this.unfoldTerminal(pattern, variant, nvariant);
                }
            }
            return this.add(new TrapSpace(pattern));
        }
        if (variant != null) {
            int nvariants = 0;
            for (boolean b : variant) {
                if (!b) continue;
                ++nvariants;
            }
            if (nvariants > 0) {
                return this.unfold(pattern, variant, nvariants);
            }
        }
        return this.add(new TrapSpace(pattern));
    }

    private boolean unfoldTerminal(byte[] pattern, boolean[] variant, int nvariants) {
        byte[] cur = (byte[])pattern.clone();
        int[] jokers = new int[nvariants];
        int k = 0;
        for (int i = 0; i < variant.length; ++i) {
            if (pattern[i] >= 0 || !variant[i]) continue;
            jokers[k++] = i;
            cur[i] = 0;
        }
        this.add(new TrapSpace((byte[])cur.clone()));
        int curj = 0;
        while (curj < nvariants) {
            int pos = jokers[curj];
            byte curv = cur[pos];
            boolean changed = false;
            if (curv != 1) {
                cur[pos] = 1;
                changed = true;
            }
            if (changed) {
                for (int j = 0; j < curj; ++j) {
                    cur[jokers[j]] = 0;
                }
                this.add(new TrapSpace((byte[])cur.clone()));
                curj = 0;
                continue;
            }
            ++curj;
        }
        return true;
    }

    private boolean unfold(byte[] pattern, boolean[] variant, int nvariants) {
        byte[] cur = (byte[])pattern.clone();
        int[] jokers = new int[nvariants];
        int k = 0;
        for (int i = 0; i < variant.length; ++i) {
            if (!variant[i]) continue;
            jokers[k++] = i;
            cur[i] = -1;
        }
        this.add(new TrapSpace((byte[])cur.clone()));
        int curj = 0;
        while (curj < nvariants) {
            int pos = jokers[curj];
            byte curv = cur[pos];
            byte target = pattern[pos];
            boolean changed = false;
            if (target < 0) {
                if (curv == -1) {
                    cur[pos] = 0;
                    changed = true;
                } else if (curv == 0) {
                    cur[pos] = 1;
                    changed = true;
                }
            } else if (curv != target) {
                cur[pos] = target;
                changed = true;
            }
            if (changed) {
                for (int j = 0; j < curj; ++j) {
                    cur[jokers[j]] = -1;
                }
                this.add(new TrapSpace((byte[])cur.clone()));
                curj = 0;
                continue;
            }
            ++curj;
        }
        return true;
    }

    @Override
    public boolean add(TrapSpace t) {
        if (this.terminal) {
            int n;
            int s = n = this.size();
            for (int i = 0; i < n; ++i) {
                TrapSpace o = (TrapSpace)this.get(i);
                if (t.contains(o)) {
                    return true;
                }
                if (!o.contains(t)) continue;
                TrapSpace last = (TrapSpace)this.get(n - 1);
                this.set(i, last);
                --n;
                --i;
            }
            if (n < s) {
                this.set(n, t);
                if (++n < s) {
                    this.removeRange(n, s);
                }
                return true;
            }
            return super.add(t);
        }
        return super.add(t);
    }

    public List<Integer>[] getInclusionDiagram() {
        int n = this.size();
        ArrayList<Integer> roots = new ArrayList<Integer>();
        List[] inclusions = new List[n];
        for (int i = 0; i < n; ++i) {
            TrapSpace t = (TrapSpace)this.get(i);
            this.place(t, i, roots, inclusions);
        }
        return inclusions;
    }

    private void lookup(TrapSpace t, int idx, List<Integer> roots, List<Integer>[] inclusions) {
        List<Integer> children = inclusions[idx];
        for (Integer i : roots) {
            TrapSpace o = (TrapSpace)this.get(i);
            if (t.contains(o)) {
                if (children == null) {
                    inclusions[idx] = children = new ArrayList<Integer>();
                }
                if (children.contains(i)) continue;
                children.add(i);
                continue;
            }
            List<Integer> nexts = inclusions[i];
            if (nexts == null) continue;
            this.lookup(t, idx, nexts, inclusions);
        }
    }

    private void place(TrapSpace t, int idx, List<Integer> roots, List<Integer>[] inclusions) {
        int n;
        if (roots.contains(idx)) {
            return;
        }
        boolean included = false;
        for (Integer i : roots) {
            TrapSpace o = (TrapSpace)this.get(i);
            List<Integer> nexts = inclusions[i];
            if (o.contains(t)) {
                included = true;
                if (nexts == null) {
                    inclusions[i.intValue()] = nexts = new ArrayList<Integer>();
                }
                this.place(t, idx, nexts, inclusions);
                continue;
            }
            if (nexts == null) continue;
            this.lookup(t, idx, nexts, inclusions);
        }
        if (included) {
            return;
        }
        int s = n = roots.size();
        for (int ii = 0; ii < n; ++ii) {
            Integer i = roots.get(ii);
            TrapSpace o = (TrapSpace)this.get(i);
            List<Integer> nexts = inclusions[idx];
            if (t.contains(o)) {
                if (nexts == null) {
                    inclusions[idx] = nexts = new ArrayList<Integer>();
                }
                this.place(o, i, nexts, inclusions);
                roots.set(ii, roots.get(--n));
                --ii;
                continue;
            }
            if (nexts == null) continue;
            this.lookup(t, idx, nexts, inclusions);
        }
        if (s < n) {
            roots.set(n, idx);
            if (++n < s) {
                this.removeRange(n, s);
            }
            return;
        }
        if (!roots.contains(idx)) {
            roots.add(idx);
        }
    }

    public boolean[][] inclusion() {
        int n = this.size();
        boolean[][] incl = new boolean[n][n];
        for (int i = 0; i < n; ++i) {
            TrapSpace t = (TrapSpace)this.get(i);
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                incl[i][j] = t.contains((TrapSpace)this.get(j));
            }
        }
        boolean[][] fincl = (boolean[][])incl.clone();
        for (int i = 0; i < n; ++i) {
            for (int p = 0; p < n; ++p) {
                if (!incl[p][i]) continue;
                for (int j = 0; j < n; ++j) {
                    if (j == i || j == p || !incl[i][j]) continue;
                    incl[p][j] = false;
                }
            }
        }
        return fincl;
    }

    public int getNVars() {
        if (this.size() == 0) {
            return 0;
        }
        return ((TrapSpace)this.get((int)0)).length;
    }

    @Override
    public NodeInfo[] getComponents() {
        return this.nodes;
    }

    @Override
    public byte get(int row, int col) {
        return ((TrapSpace)this.get((int)row)).pattern[col];
    }

    @Override
    public boolean setExtra(boolean extra) {
        return false;
    }

    @Override
    public byte[] fillState(byte[] state, int index) {
        int l = this.getComponents().length;
        if (state == null || state.length != l) {
            state = new byte[l];
        }
        byte[] innerstate = ((TrapSpace)this.get((int)index)).pattern;
        int ofset = innerstate.length;
        System.arraycopy(innerstate, 0, state, 0, ofset);
        return state;
    }
}

