/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.trapspaces;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.helper.clingo.ClingoLauncher;
import org.colomoto.biolqm.helper.clingo.ClingoResult;
import org.colomoto.biolqm.helper.clingo.ClingoResultHandler;
import org.colomoto.biolqm.helper.implicants.Formula;
import org.colomoto.biolqm.tool.trapspaces.TrapSpace;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceList;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceSolver;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceTask;

public class TrapSpaceSolverASP
implements TrapSpaceSolver,
ClingoResultHandler {
    private final LogicalModel model;
    private final List<NodeInfo> components;
    private int curprime = 0;
    private TrapSpaceList solutions;
    TrapSpaceTask settings;
    private final StringBuffer program = new StringBuffer();

    public TrapSpaceSolverASP(LogicalModel model, TrapSpaceTask settings) {
        this.model = model;
        this.settings = settings;
        this.components = model.getComponents();
        this.program.append("% encoding of prime implicants as hyper-arcs that consist of a unique \"target\" and (possibly) several \"sources\".\n");
        this.program.append("% \"target\" and \"source\" are triplets that consist of a variable name, an activity and a unique arc-identifier.\n");
    }

    @Override
    public void add_variable(int idx, Formula formula, Formula not_formula) {
        String s_target = this.components.get(idx).getNodeID();
        this.add_prime(s_target, 1, formula);
        this.add_prime(s_target, 0, not_formula);
    }

    @Override
    public void add_fixed(int idx, int value) {
        String s_target = this.components.get(idx).getNodeID();
        this.program.append("target(\"" + s_target + "\", " + value + ", a" + this.curprime + ").\n");
        ++this.curprime;
    }

    private void add_prime(String target, int value, Formula formula) {
        for (int[] t : formula.toArray()) {
            this.program.append("target(\"" + target + "\", " + value + ", a" + this.curprime + ").");
            for (int i = 0; i < t.length; ++i) {
                int v = t[i];
                if (v < 0) continue;
                String cur = this.components.get(formula.regulators[i]).getNodeID();
                this.program.append(" source(\"" + cur + "\", " + v + ", a" + this.curprime + ").");
            }
            this.program.append("\n");
            ++this.curprime;
        }
    }

    @Override
    public String show() {
        boolean focusMode = false;
        if (this.settings.focusComponents != null && this.settings.focusComponents.length > 0) {
            focusMode = true;
            this.program.append("% Keep only conditions to fix selected components\n");
            for (String nodeid : this.settings.focusComponents) {
                this.program.append("focus(\"" + nodeid + "\").\n");
            }
            this.program.append("focus(V2) :- in_set(ID), target(V1,S1,ID), source(V2,S2,ID), focus(V1).\n:- in_set(ID), target(V,S,ID), not focus(V), not percolated(V).\n\n");
        }
        this.program.append("\n\n% generator: \"in_set(ID)\" specifies which arcs are chosen for a trap set (ID is unique for target(_,_,_)).\n{in_set(ID) : target(V,S,ID)}.\n\n");
        this.program.append("\n\n% consistency constraint: a node can not be fixed to different values\n:- in_set(ID1), in_set(ID2), target(V,1,ID1), target(V,0,ID2).\n\n% stability constraint: a fixed node must be target in a selected prime\n:- in_set(ID1), source(V,S,ID1), not in_set(ID2) : target(V,S,ID2).\n\n% \"hit\" captures the stable variables and their activities.\nhit(V,S) :- in_set(ID), target(V,S,ID).\n\n");
        if (this.settings.percolate) {
            this.program.append("% Enforce propagation\n");
            if (!focusMode) {
                this.program.append("in_set(ID) :- target(V,S,ID); hit(V1,S1) : source(V1,S1,ID).\n\n% Detect percolated: nodes which are not part of a selected circuit\nupstream(V1,V2) :- in_set(ID), target(V1,S1,ID), source(V2,S2,ID).\nupstream(V1,V2) :- upstream(V1,V3), upstream(V3,V2).\npercolated(V1) :- hit(V1,S), not upstream(V1,V1).\n\n");
            }
        } else {
            this.program.append("% bijection constraint (bijection between solutions and trap spaces), avoids duplicate results\nin_set(ID) :- target(V,S,ID), hit(V,S), hit(V1,S1) : source(V1,S1,ID).\n\n");
        }
        this.program.append("% show all (default)\n#show hit/2.\n");
        if (this.settings.percolate) {
            this.program.append("#show percolated/1.\n");
        }
        return this.program.toString();
    }

    @Override
    public void solve(TrapSpaceList solutions) {
        String asp = this.show();
        this.solutions = solutions;
        ClingoLauncher launcher = new ClingoLauncher(this, asp);
        launcher.setMinsolutions(this.settings.terminal);
        try {
            launcher.run();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handle(ClingoResult r) {
        if (r == null) {
            return;
        }
        HashSet<String> percolated = new HashSet<String>();
        HashMap<String, Integer> hit = new HashMap<String, Integer>();
        List<String[]> lmatches = r.get("percolated");
        if (lmatches != null) {
            for (String[] t : lmatches) {
                percolated.add(t[0]);
            }
        }
        if ((lmatches = r.get("hit")) != null) {
            for (String[] t : lmatches) {
                hit.put(t[0], Integer.parseInt(t[1]));
            }
        }
        byte[] pattern = new byte[this.components.size()];
        boolean[] isPercolated = new boolean[pattern.length];
        for (int idx = 0; idx < pattern.length; ++idx) {
            String uid = this.components.get(idx).getNodeID();
            if (hit.containsKey(uid)) {
                pattern[idx] = ((Integer)hit.get(uid)).byteValue();
                if (percolated != null && percolated.contains(uid)) {
                    isPercolated[idx] = true;
                    continue;
                }
                isPercolated[idx] = false;
                continue;
            }
            pattern[idx] = -2;
            isPercolated[idx] = false;
        }
        this.solutions.add(new TrapSpace(pattern, isPercolated));
    }

    @Override
    public void add_focus(int idx) {
    }
}

