/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.trapspaces;

import java.util.List;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.helper.implicants.Formula;
import org.colomoto.biolqm.tool.fixpoints.StructuralNodeOrderer;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceList;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceSolver;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceTask;

public class TrapSpaceSolverBDD
implements TrapSpaceSolver {
    private final int nvar;
    private final BDDFactory jbdd;
    private final BDD[] constraints;
    private StructuralNodeOrderer order;
    private List<NodeInfo> components;
    private boolean percolate;
    private BDD focus;

    public TrapSpaceSolverBDD(LogicalModel model, TrapSpaceTask settings) {
        this.percolate = settings.percolate;
        this.nvar = model.getComponents().size();
        this.jbdd = BDDFactory.init((String)"java", (int)50000, (int)500);
        this.jbdd.setVarNum(this.nvar * 2);
        this.focus = this.jbdd.one();
        this.constraints = new BDD[this.nvar];
        this.order = new StructuralNodeOrderer(model);
        this.components = model.getComponents();
    }

    @Override
    public void add_focus(int idx) {
        int vidx = 2 * idx;
        BDD active = this.jbdd.ithVar(vidx).andWith(this.jbdd.nithVar(vidx + 1));
        BDD inactive = this.jbdd.nithVar(vidx).andWith(this.jbdd.ithVar(vidx + 1));
        this.focus.andWith(active);
    }

    @Override
    public void add_variable(int idx, Formula formula, Formula not_formula) {
        int[] regulators = formula.regulators;
        BDD f_active = this.formula2BDD(regulators, formula.toArray());
        BDD f_inactive = this.formula2BDD(regulators, not_formula.toArray());
        this.addConstraint(idx, f_active, f_inactive);
    }

    @Override
    public void add_fixed(int idx, int value) {
        BDD f_inactive;
        BDD f_active;
        if (value == 0) {
            f_active = this.jbdd.zero();
            f_inactive = this.jbdd.one();
        } else {
            f_active = this.jbdd.one();
            f_inactive = this.jbdd.zero();
        }
        this.addConstraint(idx, f_active, f_inactive);
    }

    private void addConstraint(int idx, BDD f_active, BDD f_inactive) {
        int vidx = 2 * idx;
        BDD free = this.jbdd.nithVar(vidx).andWith(this.jbdd.nithVar(vidx + 1));
        BDD active = this.jbdd.ithVar(vidx).andWith(this.jbdd.nithVar(vidx + 1));
        BDD inactive = this.jbdd.nithVar(vidx).andWith(this.jbdd.ithVar(vidx + 1));
        if (this.percolate) {
            free.andWith(f_inactive.not()).andWith(f_active.not());
        }
        active.andWith(f_active);
        inactive.andWith(f_inactive);
        this.constraints[idx] = free.orWith(active).orWith(inactive);
    }

    private BDD formula2BDD(int[] regulators, int[][] terms) {
        BDD cst = this.jbdd.zero();
        for (int[] term : terms) {
            BDD curcst = this.jbdd.one();
            for (int i = 0; i < term.length; ++i) {
                int curidx = 2 * regulators[i];
                if (term[i] == 0) {
                    curcst.andWith(this.jbdd.ithVar(curidx + 1));
                    continue;
                }
                if (term[i] != 1) continue;
                curcst.andWith(this.jbdd.ithVar(curidx));
            }
            cst.orWith(curcst);
        }
        return cst;
    }

    @Override
    public void solve(TrapSpaceList solutions) {
        BDD result = this.focus;
        for (int idx : this.order) {
            BDD next = this.constraints[idx];
            result.andWith(next);
        }
        List l = result.allsat();
        for (byte[] b : l) {
            byte[] s = new byte[this.nvar];
            boolean[] variants = new boolean[this.nvar];
            for (int idx = 0; idx < this.nvar; ++idx) {
                int vidx = 2 * idx;
                if (b[vidx] > 0) {
                    s[idx] = 1;
                    continue;
                }
                if (b[vidx + 1] > 0) {
                    s[idx] = 0;
                    continue;
                }
                if (b[vidx] < 0) {
                    if (b[vidx + 1] < 0) {
                        s[idx] = -2;
                        variants[idx] = true;
                        continue;
                    }
                    s[idx] = 1;
                    variants[idx] = true;
                    continue;
                }
                if (b[vidx + 1] < 0) {
                    s[idx] = 0;
                    variants[idx] = true;
                    continue;
                }
                s[idx] = -2;
            }
            solutions.addPattern(s, variants);
        }
    }
}

