/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.trapspaces;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.helper.clingo.ClingoLauncher;
import org.colomoto.biolqm.helper.clingo.ClingoResult;
import org.colomoto.biolqm.helper.clingo.ClingoResultHandler;
import org.colomoto.biolqm.helper.implicants.Formula;
import org.colomoto.biolqm.tool.trapspaces.TrapSpace;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceList;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceSolver;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceTask;

public class TrapSpaceSolverFunctionASP
implements TrapSpaceSolver,
ClingoResultHandler {
    private final LogicalModel model;
    private final List<NodeInfo> components;
    private TrapSpaceList solutions;
    TrapSpaceTask settings;
    private static final int[] SWAP = new int[]{1, 0};
    private final StringBuffer program = new StringBuffer();

    public TrapSpaceSolverFunctionASP(LogicalModel model, TrapSpaceTask settings) {
        this.model = model;
        this.settings = settings;
        this.components = model.getComponents();
        this.program.append("% Define one Boolean variable per possible component value.\n{\n");
        String prefix = "\n  v";
        for (NodeInfo ni : this.components) {
            String uid = ni.getNodeID();
            this.program.append(prefix);
            this.program.append(uid + "0; v" + uid + "1");
            prefix = ";\n  v";
        }
        this.program.append("\n}.\n");
    }

    @Override
    public void add_variable(int idx, Formula formula, Formula not_formula) {
        String uid = this.components.get(idx).getNodeID();
        this.program.append(":- v" + uid + "0, v" + uid + "1.\n");
        this.add_prime(uid, 1, formula);
        this.add_prime(uid, 0, not_formula);
        this.program.append("\n");
    }

    @Override
    public void add_fixed(int idx, int value) {
        if (value < 0 || value > 1) {
            throw new RuntimeException("Invalid value: " + value);
        }
        String uid = this.components.get(idx).getNodeID();
        this.program.append("v" + uid + value + ".\n");
        this.program.append(":- v" + uid + SWAP[value] + ".\n");
    }

    private void add_prime(String target, int value, Formula formula) {
        for (int[] t : formula.toArray()) {
            this.program.append(":- v" + target + SWAP[value]);
            for (int i = 0; i < t.length; ++i) {
                int v = t[i];
                if (v < 0) continue;
                String cur = this.components.get(formula.regulators[i]).getNodeID();
                this.program.append(", not v" + cur + SWAP[v]);
            }
            this.program.append(".\n");
            if (!this.settings.percolate) continue;
            this.program.append("v" + target + value + " :- ");
            String prefix = "";
            for (int i = 0; i < t.length; ++i) {
                int v = t[i];
                if (v < 0) continue;
                String cur = this.components.get(formula.regulators[i]).getNodeID();
                this.program.append(prefix + "v" + cur + v);
                prefix = ", ";
            }
            this.program.append(".\n");
        }
    }

    @Override
    public String show() {
        boolean focusMode = false;
        if (this.settings.focusComponents != null && this.settings.focusComponents.length > 0) {
            focusMode = true;
            this.program.append("% TODO: Keep only conditions to fix selected components\n");
        }
        return this.program.toString();
    }

    @Override
    public void solve(TrapSpaceList solutions) {
        String asp = this.show();
        this.solutions = solutions;
        ClingoLauncher launcher = new ClingoLauncher(this, asp);
        launcher.setMinsolutions(this.settings.terminal);
        try {
            launcher.run();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handle(ClingoResult r) {
        if (r == null) {
            return;
        }
        HashMap<String, Integer> hit = new HashMap<String, Integer>();
        List<String[]> lmatches = r.get("");
        if (lmatches != null) {
            for (String[] t : lmatches) {
                String match;
                if (t.length != 1 || !(match = t[0]).startsWith("v")) continue;
                int l = match.length() - 1;
                hit.put(match.substring(1, l), Integer.parseInt(match.substring(l)));
            }
        }
        byte[] pattern = new byte[this.components.size()];
        for (int idx = 0; idx < pattern.length; ++idx) {
            String uid = this.components.get(idx).getNodeID();
            pattern[idx] = hit.containsKey(uid) ? ((Integer)hit.get(uid)).byteValue() : (byte)-2;
        }
        this.solutions.add(new TrapSpace(pattern));
    }

    @Override
    public void add_focus(int idx) {
    }
}

