/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.trapspaces;

import java.util.ArrayList;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.helper.implicants.Formula;
import org.colomoto.biolqm.helper.implicants.MDD2PrimeImplicants;
import org.colomoto.biolqm.modifier.booleanize.BooleanizeService;
import org.colomoto.biolqm.modifier.reduction.ReductionModifier;
import org.colomoto.biolqm.modifier.reduction.ReductionService;
import org.colomoto.biolqm.service.LQMServiceManager;
import org.colomoto.biolqm.tool.AbstractToolTask;
import org.colomoto.biolqm.tool.trapspaces.TrapSpace;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceList;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceSolver;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceSolverASP;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceSolverBDD;
import org.colomoto.biolqm.tool.trapspaces.TrapSpaceSolverFunctionASP;
import org.colomoto.mddlib.MDDManager;

public class TrapSpaceTask
extends AbstractToolTask<TrapSpaceList> {
    private static final BooleanizeService boolService = LQMServiceManager.get(BooleanizeService.class);
    private static final ReductionService reduceService = LQMServiceManager.get(ReductionService.class);
    private MDDManager ddmanager;
    private MDD2PrimeImplicants primer;
    private TrapSpaceSolver solver;
    private LogicalModel workModel;
    public boolean reduce = false;
    public boolean percolate = true;
    public boolean bdd = false;
    public boolean altasp = false;
    public boolean showasp = false;
    public boolean terminal = true;
    public boolean diag = false;
    public String[] focusComponents = null;
    private static boolean SMART_DIAG = false;

    public TrapSpaceTask(LogicalModel model) {
        super(model);
        this.workModel = model;
    }

    @Override
    public void setParameters(String[] parameters) {
        if (parameters == null) {
            return;
        }
        boolean focus = false;
        for (String s : parameters) {
            if (focus) {
                this.focusComponents = s.split(",");
                focus = false;
                continue;
            }
            if ("terminal".equalsIgnoreCase(s)) {
                this.terminal = true;
                this.diag = false;
                continue;
            }
            if ("raw".equalsIgnoreCase(s)) {
                this.terminal = false;
                this.diag = false;
                continue;
            }
            if ("diag".equalsIgnoreCase(s) || "tree".equalsIgnoreCase(s)) {
                this.terminal = false;
                this.diag = true;
                continue;
            }
            if ("percolate".equalsIgnoreCase(s)) {
                this.percolate = true;
                continue;
            }
            if ("all".equalsIgnoreCase(s)) {
                this.percolate = false;
                continue;
            }
            if ("reduce".equalsIgnoreCase(s)) {
                this.reduce = true;
                continue;
            }
            if ("bdd".equalsIgnoreCase(s)) {
                this.bdd = true;
                continue;
            }
            if ("asp".equalsIgnoreCase(s)) {
                this.bdd = false;
                continue;
            }
            if ("altasp".equalsIgnoreCase(s)) {
                this.bdd = false;
                this.altasp = true;
                continue;
            }
            if ("showASP".equalsIgnoreCase(s)) {
                this.bdd = false;
                this.showasp = true;
                continue;
            }
            if ("focus".equalsIgnoreCase(s)) {
                focus = true;
                continue;
            }
            System.out.println("Unknown parameter: " + s);
        }
    }

    public void loadSettings() throws Exception {
        if (!this.workModel.isBoolean()) {
            this.workModel = boolService.modify(this.workModel);
        }
        if (this.reduce) {
            ReductionModifier reducer = reduceService.getModifier(this.workModel);
            reducer.handleFixed = true;
            reducer.purgeFixed = true;
            reducer.handleOutputs = false;
            this.workModel = (LogicalModel)reducer.call();
        }
        this.ddmanager = this.workModel.getMDDManager();
        this.primer = new MDD2PrimeImplicants(this.ddmanager);
        this.solver = this.bdd ? new TrapSpaceSolverBDD(this.workModel, this) : (this.altasp ? new TrapSpaceSolverFunctionASP(this.workModel, this) : new TrapSpaceSolverASP(this.workModel, this));
    }

    public void loadModel() {
        int[] functions = this.workModel.getLogicalFunctions();
        for (int i = 0; i < functions.length; ++i) {
            int f = functions[i];
            if (f < this.ddmanager.getLeafCount()) {
                this.solver.add_fixed(i, f);
                continue;
            }
            Formula formula = this.primer.getPrimes(f, 1);
            Formula not_formula = formula.negatePrimes();
            this.solver.add_variable(i, formula, not_formula);
        }
        if (this.focusComponents != null) {
            block1: for (String sid : this.focusComponents) {
                int idx = 0;
                for (NodeInfo ni : this.workModel.getComponents()) {
                    if (ni.getNodeID().equals(sid)) {
                        this.solver.add_focus(idx);
                        continue block1;
                    }
                    ++idx;
                }
            }
        }
    }

    public static List<TrapSpace> selectAttractors(List<TrapSpace> solutions) {
        ArrayList<TrapSpace> selected = new ArrayList<TrapSpace>();
        int n = solutions.size();
        for (int i = 0; i < n; ++i) {
            boolean keep = true;
            TrapSpace s1 = solutions.get(i);
            for (int j = 0; j < n; ++j) {
                if (i == j || !s1.contains(solutions.get(j))) continue;
                keep = false;
                break;
            }
            if (!keep) continue;
            selected.add(s1);
        }
        return selected;
    }

    @Override
    public void cli() {
        if (this.showasp) {
            try {
                this.loadSettings();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.loadModel();
            System.out.println(this.solver.show());
            return;
        }
        TrapSpaceList solutions = null;
        try {
            solutions = this.performTask();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (this.diag) {
            TrapSpace s;
            int i;
            Object diagram;
            int n = solutions.size();
            int k = (int)Math.log10(n) + 1;
            if (SMART_DIAG) {
                diagram = solutions.getInclusionDiagram();
                for (i = 0; i < n; ++i) {
                    s = (TrapSpace)solutions.get(i);
                    List<Integer> children = diagram[i];
                    String incl = " ";
                    if (children == null) {
                        incl = "@";
                    } else {
                        for (int c : children) {
                            incl = incl + " " + c;
                        }
                    }
                    System.out.format("%" + k + "d:  %s   | %s\n", i, s, incl);
                }
                System.out.println();
                System.out.println();
            }
            diagram = solutions.inclusion();
            for (i = 0; i < n; ++i) {
                s = (TrapSpace)solutions.get(i);
                String incl = " ";
                for (int j = 0; j < n; ++j) {
                    if (diagram[i][j] == false) continue;
                    incl = incl + " " + j;
                }
                if (incl.length() < 2) {
                    incl = "@";
                }
                System.out.format("%" + k + "d:  %s   | %s\n", i, s, incl);
            }
            return;
        }
        for (NodeInfo ni : solutions.nodes) {
            System.out.print(ni + " ");
        }
        System.out.println();
        for (TrapSpace s : solutions) {
            System.out.println(s);
        }
    }

    @Override
    protected TrapSpaceList performTask() throws Exception {
        this.loadSettings();
        this.loadModel();
        TrapSpaceList solutions = new TrapSpaceList(this, this.workModel);
        this.solver.solve(solutions);
        return solutions;
    }
}

