/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.common.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class XMLWriter {
    private OutputStreamWriter out = null;
    private List<String> v_stack = new ArrayList<String>();
    private boolean inTag;
    private boolean inContent;
    private boolean indent;
    private StringBuffer buf = null;
    private static final Pattern P_SID = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");

    public static boolean isValidId(String id) {
        return P_SID.matcher(id).find();
    }

    public XMLWriter(String filename, String dtdFile) throws IOException {
        this(new FileOutputStream(filename), dtdFile);
    }

    public XMLWriter(OutputStreamWriter out, String dtdFile) throws IOException {
        this(out, dtdFile, true);
    }

    public XMLWriter(OutputStream out, String dtdFile) throws IOException {
        this(new OutputStreamWriter(out, "UTF-8"), dtdFile, true);
    }

    private XMLWriter(OutputStreamWriter out, String dtdFile, boolean indent) throws IOException {
        this.indent = indent;
        this.out = out;
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (dtdFile != null) {
            this.write("<!DOCTYPE gxl SYSTEM \"" + dtdFile + "\">\n");
        }
    }

    public void toBuffer() throws IOException {
        if (this.inTag) {
            this.write(">");
            if (this.indent) {
                this.write("\n");
            }
            this.inTag = false;
        }
        this.buf = new StringBuffer();
    }

    public String getBuffer() {
        if (this.buf == null) {
            return null;
        }
        String s = this.buf.toString();
        this.buf = null;
        return s;
    }

    public void writeEsc(String s, boolean isAttVal) throws IOException {
        StringCharacterIterator iterator = new StringCharacterIterator(s);
        char cur = iterator.current();
        while (cur != '\uffff') {
            switch (cur) {
                case '&': {
                    this.write("&amp;");
                    break;
                }
                case '<': {
                    this.write("&lt;");
                    break;
                }
                case '>': {
                    this.write("&gt;");
                    break;
                }
                case '\"': {
                    if (isAttVal) {
                        this.write("&quot;");
                        break;
                    }
                    this.write('\"');
                    break;
                }
                default: {
                    this.write(cur);
                }
            }
            cur = iterator.next();
        }
    }

    public void write(String s) throws IOException {
        if (this.buf != null) {
            this.buf.append(s);
            return;
        }
        this.out.write(s);
    }

    public void write(char c) throws IOException {
        if (this.buf != null) {
            this.buf.append(c);
            return;
        }
        this.out.write(c);
    }

    public void openTag(String name) throws IOException {
        if (this.inTag) {
            this.write(">");
            if (this.indent) {
                this.write("\n");
            }
        }
        this.inTag = true;
        if (this.indent) {
            for (int i = 0; i < this.v_stack.size(); ++i) {
                this.write("  ");
            }
        }
        this.write("<" + name);
        this.v_stack.add(name);
        this.inContent = false;
    }

    public void addTag(String name) throws IOException {
        this.openTag(name);
        this.closeTag();
    }

    public void addTag(String name, String[] attributes, String content) throws IOException {
        this.openTag(name, attributes);
        this.addContent(content);
        this.closeTag();
    }

    public void openTag(String name, String[] attributes) throws IOException {
        this.openTag(name);
        for (int i = 0; i < attributes.length; i += 2) {
            this.addAttr(attributes[i], attributes[i + 1]);
        }
    }

    public void addTag(String name, String[] attributes) throws IOException {
        this.openTag(name, attributes);
        this.closeTag();
    }

    public void addTag(String tag, String content) throws IOException {
        this.openTag(tag);
        this.addContent(content);
        this.closeTag();
    }

    public void closeTag() throws IOException {
        int l = this.v_stack.size() - 1;
        if (this.inTag) {
            this.write("/>");
        } else {
            if (!this.inContent && this.indent) {
                for (int i = 0; i < l; ++i) {
                    this.write("  ");
                }
            }
            this.write("</" + this.v_stack.get(l) + ">");
        }
        if (this.indent) {
            this.write("\n");
        }
        this.v_stack.remove(l);
        this.inTag = false;
        this.inContent = false;
    }

    public void addAttr(String name, String value) throws IOException {
        if (!this.inTag) {
            return;
        }
        this.write(" " + name + "=\"");
        if (value == null) {
            this.writeEsc("", true);
        } else {
            this.writeEsc(value, true);
        }
        this.write("\"");
    }

    public void addContent(String s) throws IOException {
        if (this.inTag) {
            this.write(">");
            this.inTag = false;
        }
        this.writeEsc(s, false);
        this.inContent = true;
    }

    public void addFormatedContent(String s, boolean b) throws IOException {
        this.addLongContent(s, b, false);
    }

    public void addComplexContent(String s, boolean b) throws IOException {
        this.addLongContent(s, b, true);
    }

    private void addLongContent(String s, boolean b, boolean cdata) throws IOException {
        if (this.inTag) {
            this.write(">");
            this.inTag = false;
            if (b && this.indent) {
                this.write("\n");
            }
        }
        if (cdata) {
            this.write("<![CDATA[");
        }
        this.write(s);
        if (cdata) {
            this.write("]]>");
        }
    }

    public void close() throws IOException {
        while (this.v_stack.size() > 0) {
            this.closeTag();
        }
        this.out.close();
    }
}

