/*
	Copyright (c) 2004-2008, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

	http://dojotoolkit.org/license

*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(!dojo._hasResource["dojox.storage.Provider"]){dojo._hasResource["dojox.storage.Provider"]=true;dojo.provide("dojox.storage.Provider");dojo.declare("dojox.storage.Provider",null,{constructor:function(){},SUCCESS:"success",FAILED:"failed",PENDING:"pending",SIZE_NOT_AVAILABLE:"Size not available",SIZE_NO_LIMIT:"No size limit",DEFAULT_NAMESPACE:"default",onHideSettingsUI:null,initialize:function(){console.warn("dojox.storage.initialize not implemented");},isAvailable:function(){console.warn("dojox.storage.isAvailable not implemented");},put:function(_1,_2,_3,_4){console.warn("dojox.storage.put not implemented");},get:function(_5,_6){console.warn("dojox.storage.get not implemented");},hasKey:function(_7,_8){return !!this.get(_7,_8);},getKeys:function(_9){console.warn("dojox.storage.getKeys not implemented");},clear:function(_a){console.warn("dojox.storage.clear not implemented");},remove:function(_b,_c){console.warn("dojox.storage.remove not implemented");},getNamespaces:function(){console.warn("dojox.storage.getNamespaces not implemented");},isPermanent:function(){console.warn("dojox.storage.isPermanent not implemented");},getMaximumSize:function(){console.warn("dojox.storage.getMaximumSize not implemented");},putMultiple:function(_d,_e,_f,_10){console.warn("dojox.storage.putMultiple not implemented");},getMultiple:function(_11,_12){console.warn("dojox.storage.getMultiple not implemented");},removeMultiple:function(_13,_14){console.warn("dojox.storage.remove not implemented");},isValidKeyArray:function(_15){if(_15===null||_15===undefined||!dojo.isArray(_15)){return false;}return !dojo.some(_15,function(key){return !this.isValidKey(key);});},hasSettingsUI:function(){return false;},showSettingsUI:function(){console.warn("dojox.storage.showSettingsUI not implemented");},hideSettingsUI:function(){console.warn("dojox.storage.hideSettingsUI not implemented");},isValidKey:function(_17){if(_17===null||_17===undefined){return false;}return /^[0-9A-Za-z_]*$/.test(_17);},getResourceList:function(){return [];}});}if(!dojo._hasResource["dojox.storage.manager"]){dojo._hasResource["dojox.storage.manager"]=true;dojo.provide("dojox.storage.manager");dojox.storage.manager=new function(){this.currentProvider=null;this.available=false;this.providers=[];this._initialized=false;this._onLoadListeners=[];this.initialize=function(){this.autodetect();};this.register=function(_18,_19){this.providers.push(_19);this.providers[_18]=_19;};this.setProvider=function(_1a){};this.autodetect=function(){if(this._initialized){return;}var _1b=dojo.config["forceStorageProvider"]||false;var _1c;for(var i=0;i<this.providers.length;i++){_1c=this.providers[i];if(_1b&&_1b==_1c.declaredClass){_1c.isAvailable();break;}else{if(!_1b&&_1c.isAvailable()){break;}}}if(!_1c){this._initialized=true;this.available=false;this.currentProvider=null;console.warn("No storage provider found for this platform");this.loaded();return;}this.currentProvider=_1c;dojo.mixin(dojox.storage,this.currentProvider);dojox.storage.initialize();this._initialized=true;this.available=true;};this.isAvailable=function(){return this.available;};this.addOnLoad=function(_1e){this._onLoadListeners.push(_1e);if(this.isInitialized()){this._fireLoaded();}};this.removeOnLoad=function(_1f){for(var i=0;i<this._onLoadListeners.length;i++){if(_1f==this._onLoadListeners[i]){this._onLoadListeners=this._onLoadListeners.splice(i,1);break;}}};this.isInitialized=function(){if(this.currentProvider!=null&&this.currentProvider.declaredClass=="dojox.storage.FlashStorageProvider"&&dojox.flash.ready==false){return false;}else{return this._initialized;}};this.supportsProvider=function(_21){try{var _22=eval("new "+_21+"()");var _23=_22.isAvailable();if(!_23){return false;}return _23;}catch(e){return false;}};this.getProvider=function(){return this.currentProvider;};this.loaded=function(){this._fireLoaded();};this._fireLoaded=function(){dojo.forEach(this._onLoadListeners,function(i){try{i();}catch(e){console.debug(e);}});};this.getResourceList=function(){var _25=[];dojo.forEach(dojox.storage.manager.providers,function(_26){_25=_25.concat(_26.getResourceList());});return _25;};};}if(!dojo._hasResource["dojo.gears"]){dojo._hasResource["dojo.gears"]=true;dojo.provide("dojo.gears");dojo.gears._gearsObject=function(){var _27;var _28;var _29=dojo.getObject("google.gears");if(_29){return _29;}if(typeof GearsFactory!="undefined"){_27=new GearsFactory();}else{if(dojo.isIE){try{_27=new ActiveXObject("Gears.Factory");}catch(e){}}else{if(navigator.mimeTypes["application/x-googlegears"]){_27=document.createElement("object");_27.setAttribute("type","application/x-googlegears");_27.setAttribute("width",0);_27.setAttribute("height",0);_27.style.display="none";document.documentElement.appendChild(_27);}}}if(!_27){return null;}dojo.setObject("google.gears.factory",_27);return dojo.getObject("google.gears");};dojo.gears.available=(!!dojo.gears._gearsObject())||0;}if(!dojo._hasResource["dojox._sql._crypto"]){dojo._hasResource["dojox._sql._crypto"]=true;dojo.provide("dojox._sql._crypto");dojo.mixin(dojox._sql._crypto,{_POOL_SIZE:100,encrypt:function(_2a,_2b,_2c){this._initWorkerPool();var msg={plaintext:_2a,password:_2b};msg=dojo.toJson(msg);msg="encr:"+String(msg);this._assignWork(msg,_2c);},decrypt:function(_2e,_2f,_30){this._initWorkerPool();var msg={ciphertext:_2e,password:_2f};msg=dojo.toJson(msg);msg="decr:"+String(msg);this._assignWork(msg,_30);},_initWorkerPool:function(){if(!this._manager){try{this._manager=google.gears.factory.create("beta.workerpool","1.0");this._unemployed=[];this._employed={};this._handleMessage=[];var _32=this;this._manager.onmessage=function(msg,_34){var _35=_32._employed["_"+_34];_32._employed["_"+_34]=undefined;_32._unemployed.push("_"+_34);if(_32._handleMessage.length){var _36=_32._handleMessage.shift();_32._assignWork(_36.msg,_36.callback);}_35(msg);};var _37="function _workerInit(){"+"gearsWorkerPool.onmessage = "+String(this._workerHandler)+";"+"}";var _38=_37+" _workerInit();";for(var i=0;i<this._POOL_SIZE;i++){this._unemployed.push("_"+this._manager.createWorker(_38));}}catch(exp){throw exp.message||exp;}}},_assignWork:function(msg,_3b){if(!this._handleMessage.length&&this._unemployed.length){var _3c=this._unemployed.shift().substring(1);this._employed["_"+_3c]=_3b;this._manager.sendMessage(msg,parseInt(_3c,10));}else{this._handleMessage={msg:msg,callback:_3b};}},_workerHandler:function(msg,_3e){var _3f=[99,124,119,123,242,107,111,197,48,1,103,43,254,215,171,118,202,130,201,125,250,89,71,240,173,212,162,175,156,164,114,192,183,253,147,38,54,63,247,204,52,165,229,241,113,216,49,21,4,199,35,195,24,150,5,154,7,18,128,226,235,39,178,117,9,131,44,26,27,110,90,160,82,59,214,179,41,227,47,132,83,209,0,237,32,252,177,91,106,203,190,57,74,76,88,207,208,239,170,251,67,77,51,133,69,249,2,127,80,60,159,168,81,163,64,143,146,157,56,245,188,182,218,33,16,255,243,210,205,12,19,236,95,151,68,23,196,167,126,61,100,93,25,115,96,129,79,220,34,42,144,136,70,238,184,20,222,94,11,219,224,50,58,10,73,6,36,92,194,211,172,98,145,149,228,121,231,200,55,109,141,213,78,169,108,86,244,234,101,122,174,8,186,120,37,46,28,166,180,198,232,221,116,31,75,189,139,138,112,62,181,102,72,3,246,14,97,53,87,185,134,193,29,158,225,248,152,17,105,217,142,148,155,30,135,233,206,85,40,223,140,161,137,13,191,230,66,104,65,153,45,15,176,84,187,22];var _40=[[0,0,0,0],[1,0,0,0],[2,0,0,0],[4,0,0,0],[8,0,0,0],[16,0,0,0],[32,0,0,0],[64,0,0,0],[128,0,0,0],[27,0,0,0],[54,0,0,0]];function Cipher(_41,w){var Nb=4;var Nr=w.length/Nb-1;var _45=[[],[],[],[]];for(var i=0;i<4*Nb;i++){_45[i%4][Math.floor(i/4)]=_41[i];}_45=AddRoundKey(_45,w,0,Nb);for(var _47=1;_47<Nr;_47++){_45=SubBytes(_45,Nb);_45=ShiftRows(_45,Nb);_45=MixColumns(_45,Nb);_45=AddRoundKey(_45,w,_47,Nb);}_45=SubBytes(_45,Nb);_45=ShiftRows(_45,Nb);_45=AddRoundKey(_45,w,Nr,Nb);var _48=new Array(4*Nb);for(var i=0;i<4*Nb;i++){_48[i]=_45[i%4][Math.floor(i/4)];}return _48;};function SubBytes(s,Nb){for(var r=0;r<4;r++){for(var c=0;c<Nb;c++){s[r][c]=_3f[s[r][c]];}}return s;};function ShiftRows(s,Nb){var t=new Array(4);for(var r=1;r<4;r++){for(var c=0;c<4;c++){t[c]=s[r][(c+r)%Nb];}for(var c=0;c<4;c++){s[r][c]=t[c];}}return s;};function MixColumns(s,Nb){for(var c=0;c<4;c++){var a=new Array(4);var b=new Array(4);for(var i=0;i<4;i++){a[i]=s[i][c];b[i]=s[i][c]&128?s[i][c]<<1^283:s[i][c]<<1;}s[0][c]=b[0]^a[1]^b[1]^a[2]^a[3];s[1][c]=a[0]^b[1]^a[2]^b[2]^a[3];s[2][c]=a[0]^a[1]^b[2]^a[3]^b[3];s[3][c]=a[0]^b[0]^a[1]^a[2]^b[3];}return s;};function AddRoundKey(_58,w,rnd,Nb){for(var r=0;r<4;r++){for(var c=0;c<Nb;c++){_58[r][c]^=w[rnd*4+c][r];}}return _58;};function KeyExpansion(key){var Nb=4;var Nk=key.length/4;var Nr=Nk+6;var w=new Array(Nb*(Nr+1));var _63=new Array(4);for(var i=0;i<Nk;i++){var r=[key[4*i],key[4*i+1],key[4*i+2],key[4*i+3]];w[i]=r;}for(var i=Nk;i<(Nb*(Nr+1));i++){w[i]=new Array(4);for(var t=0;t<4;t++){_63[t]=w[i-1][t];}if(i%Nk==0){_63=SubWord(RotWord(_63));for(var t=0;t<4;t++){_63[t]^=_40[i/Nk][t];}}else{if(Nk>6&&i%Nk==4){_63=SubWord(_63);}}for(var t=0;t<4;t++){w[i][t]=w[i-Nk][t]^_63[t];}}return w;};function SubWord(w){for(var i=0;i<4;i++){w[i]=_3f[w[i]];}return w;};function RotWord(w){w[4]=w[0];for(var i=0;i<4;i++){w[i]=w[i+1];}return w;};function AESEncryptCtr(_6b,_6c,_6d){if(!(_6d==128||_6d==192||_6d==256)){return "";}var _6e=_6d/8;var _6f=new Array(_6e);for(var i=0;i<_6e;i++){_6f[i]=_6c.charCodeAt(i)&255;}var key=Cipher(_6f,KeyExpansion(_6f));key=key.concat(key.slice(0,_6e-16));var _72=16;var _73=new Array(_72);var _74=(new Date()).getTime();for(var i=0;i<4;i++){_73[i]=(_74>>>i*8)&255;}for(var i=0;i<4;i++){_73[i+4]=(_74/4294967296>>>i*8)&255;}var _75=KeyExpansion(key);var _76=Math.ceil(_6b.length/_72);var _77=new Array(_76);for(var b=0;b<_76;b++){for(var c=0;c<4;c++){_73[15-c]=(b>>>c*8)&255;}for(var c=0;c<4;c++){_73[15-c-4]=(b/4294967296>>>c*8);}var _7a=Cipher(_73,_75);var _7b=b<_76-1?_72:(_6b.length-1)%_72+1;var ct="";for(var i=0;i<_7b;i++){var _7d=_6b.charCodeAt(b*_72+i);var _7e=_7d^_7a[i];ct+=String.fromCharCode(_7e);}_77[b]=escCtrlChars(ct);}var _7f="";for(var i=0;i<8;i++){_7f+=String.fromCharCode(_73[i]);}_7f=escCtrlChars(_7f);return _7f+"-"+_77.join("-");};function AESDecryptCtr(_80,_81,_82){if(!(_82==128||_82==192||_82==256)){return "";}var _83=_82/8;var _84=new Array(_83);for(var i=0;i<_83;i++){_84[i]=_81.charCodeAt(i)&255;}var _86=KeyExpansion(_84);var key=Cipher(_84,_86);key=key.concat(key.slice(0,_83-16));var _88=KeyExpansion(key);_80=_80.split("-");var _89=16;var _8a=new Array(_89);var _8b=unescCtrlChars(_80[0]);for(var i=0;i<8;i++){_8a[i]=_8b.charCodeAt(i);}var _8c=new Array(_80.length-1);for(var b=1;b<_80.length;b++){for(var c=0;c<4;c++){_8a[15-c]=((b-1)>>>c*8)&255;}for(var c=0;c<4;c++){_8a[15-c-4]=((b/4294967296-1)>>>c*8)&255;}var _8f=Cipher(_8a,_88);_80[b]=unescCtrlChars(_80[b]);var pt="";for(var i=0;i<_80[b].length;i++){var _91=_80[b].charCodeAt(i);var _92=_91^_8f[i];pt+=String.fromCharCode(_92);}_8c[b-1]=pt;}return _8c.join("");};function escCtrlChars(str){return str.replace(/[\0\t\n\v\f\r\xa0!-]/g,function(c){return "!"+c.charCodeAt(0)+"!";});};function unescCtrlChars(str){return str.replace(/!\d\d?\d?!/g,function(c){return String.fromCharCode(c.slice(1,-1));});};function encrypt(_97,_98){return AESEncryptCtr(_97,_98,256);};function decrypt(_99,_9a){return AESDecryptCtr(_99,_9a,256);};var cmd=msg.substr(0,4);var arg=msg.substr(5);if(cmd=="encr"){arg=eval("("+arg+")");var _9d=arg.plaintext;var _9e=arg.password;var _9f=encrypt(_9d,_9e);gearsWorkerPool.sendMessage(String(_9f),_3e);}else{if(cmd=="decr"){arg=eval("("+arg+")");var _a0=arg.ciphertext;var _9e=arg.password;var _9f=decrypt(_a0,_9e);gearsWorkerPool.sendMessage(String(_9f),_3e);}}}});}if(!dojo._hasResource["dojox._sql.common"]){dojo._hasResource["dojox._sql.common"]=true;dojo.provide("dojox._sql.common");dojox.sql=new Function("return dojox.sql._exec(arguments);");dojo.mixin(dojox.sql,{dbName:null,debug:(dojo.exists("dojox.sql.debug")?dojox.sql.debug:false),open:function(_a1){if(this._dbOpen&&(!_a1||_a1==this.dbName)){return;}if(!this.dbName){this.dbName="dot_store_"+window.location.href.replace(/[^0-9A-Za-z_]/g,"_");if(this.dbName.length>63){this.dbName=this.dbName.substring(0,63);}}if(!_a1){_a1=this.dbName;}try{this._initDb();this.db.open(_a1);this._dbOpen=true;}catch(exp){throw exp.message||exp;}},close:function(_a2){if(dojo.isIE){return;}if(!this._dbOpen&&(!_a2||_a2==this.dbName)){return;}if(!_a2){_a2=this.dbName;}try{this.db.close(_a2);this._dbOpen=false;}catch(exp){throw exp.message||exp;}},_exec:function(_a3){try{this._initDb();if(!this._dbOpen){this.open();this._autoClose=true;}var sql=null;var _a5=null;var _a6=null;var _a7=dojo._toArray(_a3);sql=_a7.splice(0,1)[0];if(this._needsEncrypt(sql)||this._needsDecrypt(sql)){_a5=_a7.splice(_a7.length-1,1)[0];_a6=_a7.splice(_a7.length-1,1)[0];}if(this.debug){this._printDebugSQL(sql,_a7);}if(this._needsEncrypt(sql)){var _a8=new dojox.sql._SQLCrypto("encrypt",sql,_a6,_a7,_a5);return;}else{if(this._needsDecrypt(sql)){var _a8=new dojox.sql._SQLCrypto("decrypt",sql,_a6,_a7,_a5);return;}}var rs=this.db.execute(sql,_a7);rs=this._normalizeResults(rs);if(this._autoClose){this.close();}return rs;}catch(exp){exp=exp.message||exp;console.debug("SQL Exception: "+exp);if(this._autoClose){try{this.close();}catch(e){console.debug("Error closing database: "+e.message||e);}}throw exp;}},_initDb:function(){if(!this.db){try{this.db=google.gears.factory.create("beta.database","1.0");}catch(exp){dojo.setObject("google.gears.denied",true);dojox.off.onFrameworkEvent("coreOperationFailed");throw "Google Gears must be allowed to run";}}},_printDebugSQL:function(sql,_ab){var msg="dojox.sql(\""+sql+"\"";for(var i=0;i<_ab.length;i++){if(typeof _ab[i]=="string"){msg+=", \""+_ab[i]+"\"";}else{msg+=", "+_ab[i];}}msg+=")";console.debug(msg);},_normalizeResults:function(rs){var _af=[];if(!rs){return [];}while(rs.isValidRow()){var row={};for(var i=0;i<rs.fieldCount();i++){var _b2=rs.fieldName(i);var _b3=rs.field(i);row[_b2]=_b3;}_af.push(row);rs.next();}rs.close();return _af;},_needsEncrypt:function(sql){return /encrypt\([^\)]*\)/i.test(sql);},_needsDecrypt:function(sql){return /decrypt\([^\)]*\)/i.test(sql);}});dojo.declare("dojox.sql._SQLCrypto",null,{constructor:function(_b6,sql,_b8,_b9,_ba){if(_b6=="encrypt"){this._execEncryptSQL(sql,_b8,_b9,_ba);}else{this._execDecryptSQL(sql,_b8,_b9,_ba);}},_execEncryptSQL:function(sql,_bc,_bd,_be){var _bf=this._stripCryptoSQL(sql);var _c0=this._flagEncryptedArgs(sql,_bd);var _c1=this;this._encrypt(_bf,_bc,_bd,_c0,function(_c2){var _c3=false;var _c4=[];var exp=null;try{_c4=dojox.sql.db.execute(_bf,_c2);}catch(execError){_c3=true;exp=execError.message||execError;}if(exp!=null){if(dojox.sql._autoClose){try{dojox.sql.close();}catch(e){}}_be(null,true,exp.toString());return;}_c4=dojox.sql._normalizeResults(_c4);if(dojox.sql._autoClose){dojox.sql.close();}if(dojox.sql._needsDecrypt(sql)){var _c6=_c1._determineDecryptedColumns(sql);_c1._decrypt(_c4,_c6,_bc,function(_c7){_be(_c7,false,null);});}else{_be(_c4,false,null);}});},_execDecryptSQL:function(sql,_c9,_ca,_cb){var _cc=this._stripCryptoSQL(sql);var _cd=this._determineDecryptedColumns(sql);var _ce=false;var _cf=[];var exp=null;try{_cf=dojox.sql.db.execute(_cc,_ca);}catch(execError){_ce=true;exp=execError.message||execError;}if(exp!=null){if(dojox.sql._autoClose){try{dojox.sql.close();}catch(e){}}_cb(_cf,true,exp.toString());return;}_cf=dojox.sql._normalizeResults(_cf);if(dojox.sql._autoClose){dojox.sql.close();}this._decrypt(_cf,_cd,_c9,function(_d1){_cb(_d1,false,null);});},_encrypt:function(sql,_d3,_d4,_d5,_d6){this._totalCrypto=0;this._finishedCrypto=0;this._finishedSpawningCrypto=false;this._finalArgs=_d4;for(var i=0;i<_d4.length;i++){if(_d5[i]){var _d8=_d4[i];var _d9=i;this._totalCrypto++;dojox._sql._crypto.encrypt(_d8,_d3,dojo.hitch(this,function(_da){this._finalArgs[_d9]=_da;this._finishedCrypto++;if(this._finishedCrypto>=this._totalCrypto&&this._finishedSpawningCrypto){_d6(this._finalArgs);}}));}}this._finishedSpawningCrypto=true;},_decrypt:function(_db,_dc,_dd,_de){this._totalCrypto=0;this._finishedCrypto=0;this._finishedSpawningCrypto=false;this._finalResultSet=_db;for(var i=0;i<_db.length;i++){var row=_db[i];for(var _e1 in row){if(_dc=="*"||_dc[_e1]){this._totalCrypto++;var _e2=row[_e1];this._decryptSingleColumn(_e1,_e2,_dd,i,function(_e3){_de(_e3);});}}}this._finishedSpawningCrypto=true;},_stripCryptoSQL:function(sql){sql=sql.replace(/DECRYPT\(\*\)/ig,"*");var _e5=sql.match(/ENCRYPT\([^\)]*\)/ig);if(_e5!=null){for(var i=0;i<_e5.length;i++){var _e7=_e5[i];var _e8=_e7.match(/ENCRYPT\(([^\)]*)\)/i)[1];sql=sql.replace(_e7,_e8);}}_e5=sql.match(/DECRYPT\([^\)]*\)/ig);if(_e5!=null){for(var i=0;i<_e5.length;i++){var _e9=_e5[i];var _ea=_e9.match(/DECRYPT\(([^\)]*)\)/i)[1];sql=sql.replace(_e9,_ea);}}return sql;},_flagEncryptedArgs:function(sql,_ec){var _ed=new RegExp(/([\"][^\"]*\?[^\"]*[\"])|([\'][^\']*\?[^\']*[\'])|(\?)/ig);var _ee;var _ef=0;var _f0=[];while((_ee=_ed.exec(sql))!=null){var _f1=RegExp.lastMatch+"";if(/^[\"\']/.test(_f1)){continue;}var _f2=false;if(/ENCRYPT\([^\)]*$/i.test(RegExp.leftContext)){_f2=true;}_f0[_ef]=_f2;_ef++;}return _f0;},_determineDecryptedColumns:function(sql){var _f4={};if(/DECRYPT\(\*\)/i.test(sql)){_f4="*";}else{var _f5=/DECRYPT\((?:\s*\w*\s*\,?)*\)/ig;var _f6;while(_f6=_f5.exec(sql)){var _f7=new String(RegExp.lastMatch);var _f8=_f7.replace(/DECRYPT\(/i,"");_f8=_f8.replace(/\)/,"");_f8=_f8.split(/\s*,\s*/);dojo.forEach(_f8,function(_f9){if(/\s*\w* AS (\w*)/i.test(_f9)){_f9=_f9.match(/\s*\w* AS (\w*)/i)[1];}_f4[_f9]=true;});}}return _f4;},_decryptSingleColumn:function(_fa,_fb,_fc,_fd,_fe){dojox._sql._crypto.decrypt(_fb,_fc,dojo.hitch(this,function(_ff){this._finalResultSet[_fd][_fa]=_ff;this._finishedCrypto++;if(this._finishedCrypto>=this._totalCrypto&&this._finishedSpawningCrypto){_fe(this._finalResultSet);}}));}});}if(!dojo._hasResource["dojox.sql"]){dojo._hasResource["dojox.sql"]=true;dojo.provide("dojox.sql");}if(!dojo._hasResource["dojox.storage.GearsStorageProvider"]){dojo._hasResource["dojox.storage.GearsStorageProvider"]=true;dojo.provide("dojox.storage.GearsStorageProvider");if(dojo.gears.available){(function(){dojo.declare("dojox.storage.GearsStorageProvider",dojox.storage.Provider,{constructor:function(){},TABLE_NAME:"__DOJO_STORAGE",initialized:false,_available:null,initialize:function(){if(dojo.config["disableGearsStorage"]==true){return;}this.TABLE_NAME="__DOJO_STORAGE";try{dojox.sql("CREATE TABLE IF NOT EXISTS "+this.TABLE_NAME+"( "+" namespace TEXT, "+" key TEXT, "+" value TEXT "+")");dojox.sql("CREATE UNIQUE INDEX IF NOT EXISTS namespace_key_index"+" ON "+this.TABLE_NAME+" (namespace, key)");}catch(e){console.debug("dojox.storage.GearsStorageProvider.initialize:",e);this.initialized=false;dojox.storage.manager.loaded();return;}this.initialized=true;dojox.storage.manager.loaded();},isAvailable:function(){return this._available=dojo.gears.available;},put:function(key,_101,_102,_103){if(this.isValidKey(key)==false){throw new Error("Invalid key given: "+key);}_103=_103||this.DEFAULT_NAMESPACE;if(dojo.isString(_101)){_101="string:"+_101;}else{_101=dojo.toJson(_101);}try{dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND key = ?",_103,key);dojox.sql("INSERT INTO "+this.TABLE_NAME+" VALUES (?, ?, ?)",_103,key,_101);}catch(e){console.debug("dojox.storage.GearsStorageProvider.put:",e);_102(this.FAILED,key,e.toString());return;}if(_102){_102(dojox.storage.SUCCESS,key,null);}},get:function(key,_105){if(this.isValidKey(key)==false){throw new Error("Invalid key given: "+key);}_105=_105||this.DEFAULT_NAMESPACE;var _106=dojox.sql("SELECT * FROM "+this.TABLE_NAME+" WHERE namespace = ? AND "+" key = ?",_105,key);if(!_106.length){return null;}else{_106=_106[0].value;}if(dojo.isString(_106)&&(/^string:/.test(_106))){_106=_106.substring("string:".length);}else{_106=dojo.fromJson(_106);}return _106;},getNamespaces:function(){var _107=[dojox.storage.DEFAULT_NAMESPACE];var rs=dojox.sql("SELECT namespace FROM "+this.TABLE_NAME+" DESC GROUP BY namespace");for(var i=0;i<rs.length;i++){if(rs[i].namespace!=dojox.storage.DEFAULT_NAMESPACE){_107.push(rs[i].namespace);}}return _107;},getKeys:function(_10a){_10a=_10a||this.DEFAULT_NAMESPACE;if(this.isValidKey(_10a)==false){throw new Error("Invalid namespace given: "+_10a);}var rs=dojox.sql("SELECT key FROM "+this.TABLE_NAME+" WHERE namespace = ?",_10a);var _10c=[];for(var i=0;i<rs.length;i++){_10c.push(rs[i].key);}return _10c;},clear:function(_10e){if(this.isValidKey(_10e)==false){throw new Error("Invalid namespace given: "+_10e);}_10e=_10e||this.DEFAULT_NAMESPACE;dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ?",_10e);},remove:function(key,_110){_110=_110||this.DEFAULT_NAMESPACE;dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND"+" key = ?",_110,key);},putMultiple:function(keys,_112,_113,_114){if(this.isValidKeyArray(keys)===false||!_112 instanceof Array||keys.length!=_112.length){throw new Error("Invalid arguments: keys = ["+keys+"], values = ["+_112+"]");}if(_114==null||typeof _114=="undefined"){_114=dojox.storage.DEFAULT_NAMESPACE;}if(this.isValidKey(_114)==false){throw new Error("Invalid namespace given: "+_114);}this._statusHandler=_113;try{dojox.sql.open();dojox.sql.db.execute("BEGIN TRANSACTION");var _115="REPLACE INTO "+this.TABLE_NAME+" VALUES (?, ?, ?)";for(var i=0;i<keys.length;i++){var _117=_112[i];if(dojo.isString(_117)){_117="string:"+_117;}else{_117=dojo.toJson(_117);}dojox.sql.db.execute(_115,[_114,keys[i],_117]);}dojox.sql.db.execute("COMMIT TRANSACTION");dojox.sql.close();}catch(e){console.debug("dojox.storage.GearsStorageProvider.putMultiple:",e);if(_113){_113(this.FAILED,keys,e.toString());}return;}if(_113){_113(dojox.storage.SUCCESS,keys,null);}},getMultiple:function(keys,_119){if(this.isValidKeyArray(keys)===false){throw new ("Invalid key array given: "+keys);}if(_119==null||typeof _119=="undefined"){_119=dojox.storage.DEFAULT_NAMESPACE;}if(this.isValidKey(_119)==false){throw new Error("Invalid namespace given: "+_119);}var _11a="SELECT * FROM "+this.TABLE_NAME+" WHERE namespace = ? AND "+" key = ?";var _11b=[];for(var i=0;i<keys.length;i++){var _11d=dojox.sql(_11a,_119,keys[i]);if(!_11d.length){_11b[i]=null;}else{_11d=_11d[0].value;if(dojo.isString(_11d)&&(/^string:/.test(_11d))){_11b[i]=_11d.substring("string:".length);}else{_11b[i]=dojo.fromJson(_11d);}}}return _11b;},removeMultiple:function(keys,_11f){_11f=_11f||this.DEFAULT_NAMESPACE;dojox.sql.open();dojox.sql.db.execute("BEGIN TRANSACTION");var _120="DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND key = ?";for(var i=0;i<keys.length;i++){dojox.sql.db.execute(_120,[_11f,keys[i]]);}dojox.sql.db.execute("COMMIT TRANSACTION");dojox.sql.close();},isPermanent:function(){return true;},getMaximumSize:function(){return this.SIZE_NO_LIMIT;},hasSettingsUI:function(){return false;},showSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},hideSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");}});dojox.storage.manager.register("dojox.storage.GearsStorageProvider",new dojox.storage.GearsStorageProvider());})();}}if(!dojo._hasResource["dojox.storage.WhatWGStorageProvider"]){dojo._hasResource["dojox.storage.WhatWGStorageProvider"]=true;dojo.provide("dojox.storage.WhatWGStorageProvider");dojo.declare("dojox.storage.WhatWGStorageProvider",[dojox.storage.Provider],{initialized:false,_domain:null,_available:null,_statusHandler:null,_allNamespaces:null,_storageEventListener:null,initialize:function(){if(dojo.config["disableWhatWGStorage"]==true){return;}this._domain=this._getDomain();this.initialized=true;dojox.storage.manager.loaded();},isAvailable:function(){try{var _122=globalStorage[this._getDomain()];}catch(e){this._available=false;return this._available;}this._available=true;return this._available;},put:function(key,_124,_125,_126){if(this.isValidKey(key)==false){throw new Error("Invalid key given: "+key);}_126=_126||this.DEFAULT_NAMESPACE;key=this.getFullKey(key,_126);this._statusHandler=_125;if(dojo.isString(_124)){_124="string:"+_124;}else{_124=dojo.toJson(_124);}var _127=dojo.hitch(this,function(evt){window.removeEventListener("storage",_127,false);if(_125){_125.call(null,this.SUCCESS,key);}});window.addEventListener("storage",_127,false);try{var _129=globalStorage[this._domain];_129.setItem(key,_124);}catch(e){this._statusHandler.call(null,this.FAILED,key,e.toString());}},get:function(key,_12b){if(this.isValidKey(key)==false){throw new Error("Invalid key given: "+key);}_12b=_12b||this.DEFAULT_NAMESPACE;key=this.getFullKey(key,_12b);var _12c=globalStorage[this._domain];var _12d=_12c.getItem(key);if(_12d==null||_12d==""){return null;}_12d=_12d.value;if(dojo.isString(_12d)&&(/^string:/.test(_12d))){_12d=_12d.substring("string:".length);}else{_12d=dojo.fromJson(_12d);}return _12d;},getNamespaces:function(){var _12e=[this.DEFAULT_NAMESPACE];var _12f={};var _130=globalStorage[this._domain];var _131=/^__([^_]*)_/;for(var i=0;i<_130.length;i++){var _133=_130.key(i);if(_131.test(_133)==true){var _134=_133.match(_131)[1];if(typeof _12f[_134]=="undefined"){_12f[_134]=true;_12e.push(_134);}}}return _12e;},getKeys:function(_135){_135=_135||this.DEFAULT_NAMESPACE;if(this.isValidKey(_135)==false){throw new Error("Invalid namespace given: "+_135);}var _136;if(_135==this.DEFAULT_NAMESPACE){_136=new RegExp("^([^_]{2}.*)$");}else{_136=new RegExp("^__"+_135+"_(.*)$");}var _137=globalStorage[this._domain];var _138=[];for(var i=0;i<_137.length;i++){var _13a=_137.key(i);if(_136.test(_13a)==true){_13a=_13a.match(_136)[1];_138.push(_13a);}}return _138;},clear:function(_13b){_13b=_13b||this.DEFAULT_NAMESPACE;if(this.isValidKey(_13b)==false){throw new Error("Invalid namespace given: "+_13b);}var _13c;if(_13b==this.DEFAULT_NAMESPACE){_13c=new RegExp("^[^_]{2}");}else{_13c=new RegExp("^__"+_13b+"_");}var _13d=globalStorage[this._domain];var keys=[];for(var i=0;i<_13d.length;i++){if(_13c.test(_13d.key(i))==true){keys[keys.length]=_13d.key(i);}}dojo.forEach(keys,dojo.hitch(_13d,"removeItem"));},remove:function(key,_141){key=this.getFullKey(key,_141);var _142=globalStorage[this._domain];_142.removeItem(key);},isPermanent:function(){return true;},getMaximumSize:function(){return this.SIZE_NO_LIMIT;},hasSettingsUI:function(){return false;},showSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},hideSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},getFullKey:function(key,_144){_144=_144||this.DEFAULT_NAMESPACE;if(this.isValidKey(_144)==false){throw new Error("Invalid namespace given: "+_144);}if(_144==this.DEFAULT_NAMESPACE){return key;}else{return "__"+_144+"_"+key;}},_getDomain:function(){return ((location.hostname=="localhost"&&dojo.isFF&&dojo.isFF<3)?"localhost.localdomain":location.hostname);}});dojox.storage.manager.register("dojox.storage.WhatWGStorageProvider",new dojox.storage.WhatWGStorageProvider());}if(!dojo._hasResource["dojo.AdapterRegistry"]){dojo._hasResource["dojo.AdapterRegistry"]=true;dojo.provide("dojo.AdapterRegistry");dojo.AdapterRegistry=function(_145){this.pairs=[];this.returnWrappers=_145||false;};dojo.extend(dojo.AdapterRegistry,{register:function(name,_147,wrap,_149,_14a){this.pairs[((_14a)?"unshift":"push")]([name,_147,wrap,_149]);},match:function(){for(var i=0;i<this.pairs.length;i++){var pair=this.pairs[i];if(pair[1].apply(this,arguments)){if((pair[3])||(this.returnWrappers)){return pair[2];}else{return pair[2].apply(this,arguments);}}}throw new Error("No match found");},unregister:function(name){for(var i=0;i<this.pairs.length;i++){var pair=this.pairs[i];if(pair[0]==name){this.pairs.splice(i,1);return true;}}return false;}});}if(!dojo._hasResource["dijit._base.place"]){dojo._hasResource["dijit._base.place"]=true;dojo.provide("dijit._base.place");dijit.getViewport=function(){var _150=dojo.global;var _151=dojo.doc;var w=0,h=0;var de=_151.documentElement;var dew=de.clientWidth,deh=de.clientHeight;if(dojo.isMozilla){var minw,minh,maxw,maxh;var dbw=_151.body.clientWidth;if(dbw>dew){minw=dew;maxw=dbw;}else{maxw=dew;minw=dbw;}var dbh=_151.body.clientHeight;if(dbh>deh){minh=deh;maxh=dbh;}else{maxh=deh;minh=dbh;}w=(maxw>_150.innerWidth)?minw:maxw;h=(maxh>_150.innerHeight)?minh:maxh;}else{if(!dojo.isOpera&&_150.innerWidth){w=_150.innerWidth;h=_150.innerHeight;}else{if(dojo.isIE&&de&&deh){w=dew;h=deh;}else{if(dojo.body().clientWidth){w=dojo.body().clientWidth;h=dojo.body().clientHeight;}}}}var _15d=dojo._docScroll();return {w:w,h:h,l:_15d.x,t:_15d.y};};dijit.placeOnScreen=function(node,pos,_160,_161){var _162=dojo.map(_160,function(_163){return {corner:_163,pos:pos};});return dijit._place(node,_162);};dijit._place=function(node,_165,_166){var view=dijit.getViewport();if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){dojo.body().appendChild(node);}var best=null;dojo.some(_165,function(_169){var _16a=_169.corner;var pos=_169.pos;if(_166){_166(node,_169.aroundCorner,_16a);}var _16c=node.style;var _16d=_16c.display;var _16e=_16c.visibility;_16c.visibility="hidden";_16c.display="";var mb=dojo.marginBox(node);_16c.display=_16d;_16c.visibility=_16e;var _170=(_16a.charAt(1)=="L"?pos.x:Math.max(view.l,pos.x-mb.w)),_171=(_16a.charAt(0)=="T"?pos.y:Math.max(view.t,pos.y-mb.h)),endX=(_16a.charAt(1)=="L"?Math.min(view.l+view.w,_170+mb.w):pos.x),endY=(_16a.charAt(0)=="T"?Math.min(view.t+view.h,_171+mb.h):pos.y),_174=endX-_170,_175=endY-_171,_176=(mb.w-_174)+(mb.h-_175);if(best==null||_176<best.overflow){best={corner:_16a,aroundCorner:_169.aroundCorner,x:_170,y:_171,w:_174,h:_175,overflow:_176};}return !_176;});node.style.left=best.x+"px";node.style.top=best.y+"px";if(best.overflow&&_166){_166(node,best.aroundCorner,best.corner);}return best;};dijit.placeOnScreenAroundNode=function(node,_178,_179,_17a){_178=dojo.byId(_178);var _17b=_178.style.display;_178.style.display="";var _17c=_178.offsetWidth;var _17d=_178.offsetHeight;var _17e=dojo.coords(_178,true);_178.style.display=_17b;return dijit._placeOnScreenAroundRect(node,_17e.x,_17e.y,_17c,_17d,_179,_17a);};dijit.placeOnScreenAroundRectangle=function(node,_180,_181,_182){return dijit._placeOnScreenAroundRect(node,_180.x,_180.y,_180.width,_180.height,_181,_182);};dijit._placeOnScreenAroundRect=function(node,x,y,_186,_187,_188,_189){var _18a=[];for(var _18b in _188){_18a.push({aroundCorner:_18b,corner:_188[_18b],pos:{x:x+(_18b.charAt(1)=="L"?0:_186),y:y+(_18b.charAt(0)=="T"?0:_187)}});}return dijit._place(node,_18a,_189);};dijit.placementRegistry=new dojo.AdapterRegistry();dijit.placementRegistry.register("node",function(n,x){return typeof x=="object"&&typeof x.offsetWidth!="undefined"&&typeof x.offsetHeight!="undefined";},dijit.placeOnScreenAroundNode);dijit.placementRegistry.register("rect",function(n,x){return typeof x=="object"&&"x" in x&&"y" in x&&"width" in x&&"height" in x;},dijit.placeOnScreenAroundRectangle);dijit.placeOnScreenAroundElement=function(node,_191,_192,_193){return dijit.placementRegistry.match.apply(dijit.placementRegistry,arguments);};}if(!dojo._hasResource["dojox.flash._base"]){dojo._hasResource["dojox.flash._base"]=true;dojo.provide("dojox.flash._base");dojox.flash=function(){};dojox.flash={ready:false,url:null,_visible:true,_loadedListeners:[],_installingListeners:[],setSwf:function(url,_195){this.url=url;this._visible=true;if(_195!==null&&typeof _195!=="undefined"){this._visible=_195;}this._initialize();},addLoadedListener:function(_196){this._loadedListeners.push(_196);},addInstallingListener:function(_197){this._installingListeners.push(_197);},loaded:function(){dojox.flash.ready=true;if(dojox.flash._loadedListeners.length>0){for(var i=0;i<dojox.flash._loadedListeners.length;i++){dojox.flash._loadedListeners[i].call(null);}}},installing:function(){if(dojox.flash._installingListeners.length>0){for(var i=0;i<dojox.flash._installingListeners.length;i++){dojox.flash._installingListeners[i].call(null);}}},_initialize:function(){var _19a=new dojox.flash.Install();dojox.flash.installer=_19a;if(_19a.needed()){_19a.install();}else{dojox.flash.obj=new dojox.flash.Embed(this._visible);dojox.flash.obj.write();dojox.flash.comm=new dojox.flash.Communicator();}}};dojox.flash.Info=function(){this._detectVersion();};dojox.flash.Info.prototype={version:-1,versionMajor:-1,versionMinor:-1,versionRevision:-1,capable:false,installing:false,isVersionOrAbove:function(_19b,_19c,_19d){_19d=parseFloat("."+_19d);if(this.versionMajor>=_19b&&this.versionMinor>=_19c&&this.versionRevision>=_19d){return true;}else{return false;}},_detectVersion:function(){var _19e;for(var _19f=25;_19f>0;_19f--){if(dojo.isIE){var axo;try{if(_19f>6){axo=new ActiveXObject("ShockwaveFlash.ShockwaveFlash."+_19f);}else{axo=new ActiveXObject("ShockwaveFlash.ShockwaveFlash");}if(typeof axo=="object"){if(_19f==6){axo.AllowScriptAccess="always";}_19e=axo.GetVariable("$version");}}catch(e){continue;}}else{_19e=this._JSFlashInfo(_19f);}if(_19e==-1){this.capable=false;return;}else{if(_19e!=0){var _1a1;if(dojo.isIE){var _1a2=_19e.split(" ");var _1a3=_1a2[1];_1a1=_1a3.split(",");}else{_1a1=_19e.split(".");}this.versionMajor=_1a1[0];this.versionMinor=_1a1[1];this.versionRevision=_1a1[2];var _1a4=this.versionMajor+"."+this.versionRevision;this.version=parseFloat(_1a4);this.capable=true;break;}}}},_JSFlashInfo:function(_1a5){if(navigator.plugins!=null&&navigator.plugins.length>0){if(navigator.plugins["Shockwave Flash 2.0"]||navigator.plugins["Shockwave Flash"]){var _1a6=navigator.plugins["Shockwave Flash 2.0"]?" 2.0":"";var _1a7=navigator.plugins["Shockwave Flash"+_1a6].description;var _1a8=_1a7.split(" ");var _1a9=_1a8[2].split(".");var _1aa=_1a9[0];var _1ab=_1a9[1];var _1ac=(_1a8[3]||_1a8[4]).split("r");var _1ad=_1ac[1]>0?_1ac[1]:0;var _1ae=_1aa+"."+_1ab+"."+_1ad;return _1ae;}}return -1;}};dojox.flash.Embed=function(_1af){this._visible=_1af;};dojox.flash.Embed.prototype={width:215,height:138,id:"flashObject",_visible:true,protocol:function(){switch(window.location.protocol){case "https:":return "https";break;default:return "http";break;}},write:function(_1b0){var _1b1;var _1b2=dojox.flash.url;var _1b3=_1b2;var _1b4=_1b2;var _1b5=dojo.baseUrl;var _1b6=document.location.protocol+"//"+document.location.host;if(_1b0){var _1b7=escape(window.location);document.title=document.title.slice(0,47)+" - Flash Player Installation";var _1b8=escape(document.title);_1b3+="?MMredirectURL="+_1b7+"&MMplayerType=ActiveX"+"&MMdoctitle="+_1b8+"&baseUrl="+escape(_1b5)+"&xdomain="+escape(_1b6);_1b4+="?MMredirectURL="+_1b7+"&MMplayerType=PlugIn"+"&baseUrl="+escape(_1b5)+"&xdomain="+escape(_1b6);}else{_1b3+="?cachebust="+new Date().getTime();_1b3+="&xdomain="+escape(_1b6);}if(_1b4.indexOf("?")==-1){_1b4+="?baseUrl="+escape(_1b5);}else{_1b4+="&baseUrl="+escape(_1b5);}_1b4+="&xdomain="+escape(_1b6);_1b1="<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" "+"codebase=\""+this.protocol()+"://fpdownload.macromedia.com/pub/shockwave/cabs/flash/"+"swflash.cab#version=8,0,0,0\"\n "+"width=\""+this.width+"\"\n "+"height=\""+this.height+"\"\n "+"id=\""+this.id+"\"\n "+"name=\""+this.id+"\"\n "+"align=\"middle\">\n "+"<param name=\"allowScriptAccess\" value=\"always\"></param>\n "+"<param name=\"movie\" value=\""+_1b3+"\"></param>\n "+"<param name=\"quality\" value=\"high\"></param>\n "+"<param name=\"bgcolor\" value=\"#ffffff\"></param>\n "+"<embed src=\""+_1b4+"\" "+"quality=\"high\" "+"bgcolor=\"#ffffff\" "+"width=\""+this.width+"\" "+"height=\""+this.height+"\" "+"id=\""+this.id+"Embed"+"\" "+"name=\""+this.id+"\" "+"swLiveConnect=\"true\" "+"align=\"middle\" "+"allowScriptAccess=\"always\" "+"type=\"application/x-shockwave-flash\" "+"pluginspage=\""+this.protocol()+"://www.macromedia.com/go/getflashplayer\" "+"></embed>\n"+"</object>\n";dojo.connect(dojo,"loaded",dojo.hitch(this,function(){var _1b9=this.id+"Container";if(dojo.byId(_1b9)){return;}var div=document.createElement("div");div.id=this.id+"Container";div.style.width=this.width+"px";div.style.height=this.height+"px";if(!this._visible){div.style.position="absolute";div.style.zIndex="10000";div.style.top="-1000px";div.style.left="-1000px";}div.innerHTML=_1b1;var body=document.getElementsByTagName("body");if(!body||!body.length){throw new Error("No body tag for this page");}body=body[0];body.appendChild(div);}));},get:function(){if(dojo.isIE||dojo.isSafari){return dojo.byId(this.id);}else{return document[this.id+"Embed"];}},setVisible:function(_1bc){var _1bd=dojo.byId(this.id+"Container");if(_1bc==true){_1bd.style.position="absolute";_1bd.style.visibility="visible";}else{_1bd.style.position="absolute";_1bd.style.x="-1000px";_1bd.style.y="-1000px";_1bd.style.visibility="hidden";}},center:function(){var _1be=this.width;var _1bf=this.height;var _1c0=dijit.getViewport();var x=_1c0.l+(_1c0.w-_1be)/2;var y=_1c0.t+(_1c0.h-_1bf)/2;var _1c3=dojo.byId(this.id+"Container");_1c3.style.top=y+"px";_1c3.style.left=x+"px";}};dojox.flash.Communicator=function(){};dojox.flash.Communicator.prototype={_addExternalInterfaceCallback:function(_1c4){var _1c5=dojo.hitch(this,function(){var _1c6=new Array(arguments.length);for(var i=0;i<arguments.length;i++){_1c6[i]=this._encodeData(arguments[i]);}var _1c8=this._execFlash(_1c4,_1c6);_1c8=this._decodeData(_1c8);return _1c8;});this[_1c4]=_1c5;},_encodeData:function(data){if(!data||typeof data!="string"){return data;}var _1ca=/\&([^;]*)\;/g;data=data.replace(_1ca,"&amp;$1;");data=data.replace(/</g,"&lt;");data=data.replace(/>/g,"&gt;");data=data.replace("\\","&custom_backslash;");data=data.replace(/\0/g,"\\0");data=data.replace(/\"/g,"&quot;");return data;},_decodeData:function(data){if(data&&data.length&&typeof data!="string"){data=data[0];}if(!data||typeof data!="string"){return data;}data=data.replace(/\&custom_lt\;/g,"<");data=data.replace(/\&custom_gt\;/g,">");data=data.replace(/\&custom_backslash\;/g,"\\");data=data.replace(/\\0/g," ");return data;},_execFlash:function(_1cc,_1cd){var _1ce=dojox.flash.obj.get();_1cd=(_1cd)?_1cd:[];for(var i=0;i<_1cd;i++){if(typeof _1cd[i]=="string"){_1cd[i]=this._encodeData(_1cd[i]);}}var _1d0=function(){return eval(_1ce.CallFunction("<invoke name=\""+_1cc+"\" returntype=\"javascript\">"+__flash__argumentsToXML(_1cd,0)+"</invoke>"));};var _1d1=_1d0.call(_1cd);if(typeof _1d1=="string"){_1d1=this._decodeData(_1d1);}return _1d1;}};dojox.flash.Install=function(){};dojox.flash.Install.prototype={needed:function(){if(dojox.flash.info.capable==false){return true;}if(!dojox.flash.info.isVersionOrAbove(8,0,0)){return true;}return false;},install:function(){var _1d2;dojox.flash.info.installing=true;dojox.flash.installing();if(dojox.flash.info.capable==false){_1d2=new dojox.flash.Embed(false);_1d2.write();}else{if(dojox.flash.info.isVersionOrAbove(6,0,65)){_1d2=new dojox.flash.Embed(false);_1d2.write(true);_1d2.setVisible(true);_1d2.center();}else{alert("This content requires a more recent version of the Macromedia "+" Flash Player.");window.location.href=+dojox.flash.Embed.protocol()+"://www.macromedia.com/go/getflashplayer";}}},_onInstallStatus:function(msg){if(msg=="Download.Complete"){dojox.flash._initialize();}else{if(msg=="Download.Cancelled"){alert("This content requires a more recent version of the Macromedia "+" Flash Player.");window.location.href=dojox.flash.Embed.protocol()+"://www.macromedia.com/go/getflashplayer";}else{if(msg=="Download.Failed"){alert("There was an error downloading the Flash Player update. "+"Please try again later, or visit macromedia.com to download "+"the latest version of the Flash plugin.");}}}}};dojox.flash.info=new dojox.flash.Info();}if(!dojo._hasResource["dojox.flash"]){dojo._hasResource["dojox.flash"]=true;dojo.provide("dojox.flash");}if(!dojo._hasResource["dojox.storage.FlashStorageProvider"]){dojo._hasResource["dojox.storage.FlashStorageProvider"]=true;dojo.provide("dojox.storage.FlashStorageProvider");dojo.declare("dojox.storage.FlashStorageProvider",dojox.storage.Provider,{initialized:false,_available:null,_statusHandler:null,_flashReady:false,_pageReady:false,initialize:function(){if(dojo.config["disableFlashStorage"]==true){return;}dojox.flash.addLoadedListener(dojo.hitch(this,function(){this._flashReady=true;if(this._flashReady&&this._pageReady){this._loaded();}}));var _1d4=dojo.moduleUrl("dojox","storage/Storage.swf").toString();dojox.flash.setSwf(_1d4,false);dojo.connect(dojo,"loaded",this,function(){this._pageReady=true;if(this._flashReady&&this._pageReady){this._loaded();}});},setFlushDelay:function(_1d5){if(_1d5===null||typeof _1d5==="undefined"||isNaN(_1d5)){throw new Error("Invalid argunment: "+_1d5);}dojox.flash.comm.setFlushDelay(String(_1d5));},getFlushDelay:function(){return Number(dojox.flash.comm.getFlushDelay());},flush:function(_1d6){if(_1d6==null||typeof _1d6=="undefined"){_1d6=dojox.storage.DEFAULT_NAMESPACE;}dojox.flash.comm.flush(_1d6);},isAvailable:function(){return (this._available=!dojo.config["disableFlashStorage"]);},put:function(key,_1d8,_1d9,_1da){if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}if(!_1da){_1da=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1da)){throw new Error("Invalid namespace given: "+_1da);}this._statusHandler=_1d9;if(dojo.isString(_1d8)){_1d8="string:"+_1d8;}else{_1d8=dojo.toJson(_1d8);}dojox.flash.comm.put(key,_1d8,_1da);},putMultiple:function(keys,_1dc,_1dd,_1de){if(!this.isValidKeyArray(keys)||!_1dc instanceof Array||keys.length!=_1dc.length){throw new Error("Invalid arguments: keys = ["+keys+"], values = ["+_1dc+"]");}if(!_1de){_1de=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1de)){throw new Error("Invalid namespace given: "+_1de);}this._statusHandler=_1dd;var _1df=keys.join(",");var _1e0=[];for(var i=0;i<_1dc.length;i++){if(dojo.isString(_1dc[i])){_1dc[i]="string:"+_1dc[i];}else{_1dc[i]=dojo.toJson(_1dc[i]);}_1e0[i]=_1dc[i].length;}var _1e2=_1dc.join("");var _1e3=_1e0.join(",");dojox.flash.comm.putMultiple(_1df,_1e2,_1e3,this.namespace);},get:function(key,_1e5){if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}if(!_1e5){_1e5=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1e5)){throw new Error("Invalid namespace given: "+_1e5);}var _1e6=dojox.flash.comm.get(key,_1e5);if(_1e6==""){return null;}return this._destringify(_1e6);},getMultiple:function(keys,_1e8){if(!this.isValidKeyArray(keys)){throw new ("Invalid key array given: "+keys);}if(!_1e8){_1e8=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1e8)){throw new Error("Invalid namespace given: "+_1e8);}var _1e9=keys.join(",");var _1ea=dojox.flash.comm.getMultiple(_1e9,this.namespace);var _1eb=eval("("+_1ea+")");for(var i=0;i<_1eb.length;i++){_1eb[i]=(_1eb[i]=="")?null:this._destringify(_1eb[i]);}return _1eb;},_destringify:function(_1ed){if(dojo.isString(_1ed)&&(/^string:/.test(_1ed))){_1ed=_1ed.substring("string:".length);}else{_1ed=dojo.fromJson(_1ed);}return _1ed;},getKeys:function(_1ee){if(!_1ee){_1ee=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1ee)){throw new Error("Invalid namespace given: "+_1ee);}var _1ef=dojox.flash.comm.getKeys(_1ee);if(_1ef==null||_1ef=="null"){_1ef="";}_1ef=_1ef.split(",");_1ef.sort();return _1ef;},getNamespaces:function(){var _1f0=dojox.flash.comm.getNamespaces();if(_1f0==null||_1f0=="null"){_1f0=dojox.storage.DEFAULT_NAMESPACE;}_1f0=_1f0.split(",");_1f0.sort();return _1f0;},clear:function(_1f1){if(!_1f1){_1f1=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1f1)){throw new Error("Invalid namespace given: "+_1f1);}dojox.flash.comm.clear(_1f1);},remove:function(key,_1f3){if(!_1f3){_1f3=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1f3)){throw new Error("Invalid namespace given: "+_1f3);}dojox.flash.comm.remove(key,_1f3);},removeMultiple:function(keys,_1f5){if(!this.isValidKeyArray(keys)){dojo.raise("Invalid key array given: "+keys);}if(!_1f5){_1f5=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1f5)){throw new Error("Invalid namespace given: "+_1f5);}var _1f6=keys.join(",");dojox.flash.comm.removeMultiple(_1f6,this.namespace);},isPermanent:function(){return true;},getMaximumSize:function(){return dojox.storage.SIZE_NO_LIMIT;},hasSettingsUI:function(){return true;},showSettingsUI:function(){dojox.flash.comm.showSettings();dojox.flash.obj.setVisible(true);dojox.flash.obj.center();},hideSettingsUI:function(){dojox.flash.obj.setVisible(false);if(dojo.isFunction(dojox.storage.onHideSettingsUI)){dojox.storage.onHideSettingsUI.call(null);}},getResourceList:function(){return [];},_loaded:function(){this._allNamespaces=this.getNamespaces();this.initialized=true;dojox.storage.manager.loaded();},_onStatus:function(_1f7,key,_1f9){var ds=dojox.storage;var dfo=dojox.flash.obj;if(_1f7==ds.PENDING){dfo.center();dfo.setVisible(true);}else{dfo.setVisible(false);}if(ds._statusHandler){ds._statusHandler.call(null,_1f7,key,_1f9);}}});dojox.storage.manager.register("dojox.storage.FlashStorageProvider",new dojox.storage.FlashStorageProvider());}if(!dojo._hasResource["dojox.storage._common"]){dojo._hasResource["dojox.storage._common"]=true;dojo.provide("dojox.storage._common");dojox.storage.manager.initialize();}if(!dojo._hasResource["dojox.storage"]){dojo._hasResource["dojox.storage"]=true;dojo.provide("dojox.storage");}if(!dojo._hasResource["dojox.off.files"]){dojo._hasResource["dojox.off.files"]=true;dojo.provide("dojox.off.files");dojox.off.files={versionURL:"version.js",listOfURLs:[],refreshing:false,_cancelID:null,_error:false,_errorMessages:[],_currentFileIndex:0,_store:null,_doSlurp:false,slurp:function(){this._doSlurp=true;},cache:function(_1fc){if(dojo.isString(_1fc)){var url=this._trimAnchor(_1fc+"");if(!this.isAvailable(url)){this.listOfURLs.push(url);}}else{if(_1fc instanceof dojo._Url){var url=this._trimAnchor(_1fc.uri);if(!this.isAvailable(url)){this.listOfURLs.push(url);}}else{dojo.forEach(_1fc,function(url){url=this._trimAnchor(url);if(!this.isAvailable(url)){this.listOfURLs.push(url);}},this);}}},printURLs:function(){console.debug("The following URLs are cached for offline use:");dojo.forEach(this.listOfURLs,function(i){console.debug(i);});},remove:function(url){for(var i=0;i<this.listOfURLs.length;i++){if(this.listOfURLs[i]==url){this.listOfURLs=this.listOfURLs.splice(i,1);break;}}},isAvailable:function(url){for(var i=0;i<this.listOfURLs.length;i++){if(this.listOfURLs[i]==url){return true;}}return false;},refresh:function(_204){try{if(dojo.config.isDebug){this.printURLs();}this.refreshing=true;if(this.versionURL){this._getVersionInfo(function(_205,_206,_207){if(dojo.config.isDebug||!_206||_207||!_205||_205!=_206){console.warn("Refreshing offline file list");this._doRefresh(_204,_206);}else{console.warn("No need to refresh offline file list");_204(false,[]);}});}else{console.warn("Refreshing offline file list");this._doRefresh(_204);}}catch(e){this.refreshing=false;dojox.off.coreOpFailed=true;dojox.off.enabled=false;dojox.off.onFrameworkEvent("coreOperationFailed");}},abortRefresh:function(){if(!this.refreshing){return;}this._store.abortCapture(this._cancelID);this.refreshing=false;},_slurp:function(){if(!this._doSlurp){return;}var _208=dojo.hitch(this,function(url){if(this._sameLocation(url)){this.cache(url);}});_208(window.location.href);dojo.query("script").forEach(function(i){try{_208(i.getAttribute("src"));}catch(exp){}});dojo.query("link").forEach(function(i){try{if(!i.getAttribute("rel")||i.getAttribute("rel").toLowerCase()!="stylesheet"){return;}_208(i.getAttribute("href"));}catch(exp){}});dojo.query("img").forEach(function(i){try{_208(i.getAttribute("src"));}catch(exp){}});dojo.query("a").forEach(function(i){try{_208(i.getAttribute("href"));}catch(exp){}});dojo.forEach(document.styleSheets,function(_20e){try{if(_20e.cssRules){dojo.forEach(_20e.cssRules,function(rule){var text=rule.cssText;if(text){var _211=text.match(/url\(\s*([^\) ]*)\s*\)/i);if(!_211){return;}for(var i=1;i<_211.length;i++){_208(_211[i]);}}});}else{if(_20e.cssText){var _213;var text=_20e.cssText.toString();var _215=text.split(/\f|\r|\n/);for(var i=0;i<_215.length;i++){_213=_215[i].match(/url\(\s*([^\) ]*)\s*\)/i);if(_213&&_213.length){_208(_213[1]);}}}}}catch(exp){}});},_sameLocation:function(url){if(!url){return false;}if(url.length&&url.charAt(0)=="#"){return false;}url=new dojo._Url(url);if(!url.scheme&&!url.port&&!url.host){return true;}if(!url.scheme&&url.host&&url.port&&window.location.hostname==url.host&&window.location.port==url.port){return true;}if(!url.scheme&&url.host&&!url.port&&window.location.hostname==url.host&&window.location.port==80){return true;}return window.location.protocol==(url.scheme+":")&&window.location.hostname==url.host&&(window.location.port==url.port||!window.location.port&&!url.port);},_trimAnchor:function(url){return url.replace(/\#.*$/,"");},_doRefresh:function(_219,_21a){var _21b;try{_21b=google.gears.factory.create("beta.localserver","1.0");}catch(exp){dojo.setObject("google.gears.denied",true);dojox.off.onFrameworkEvent("coreOperationFailed");throw "Google Gears must be allowed to run";}var _21c="dot_store_"+window.location.href.replace(/[^0-9A-Za-z_]/g,"_");if(_21c.length>=64){_21c=_21c.substring(0,63);}_21b.removeStore(_21c);_21b.openStore(_21c);var _21d=_21b.createStore(_21c);this._store=_21d;var self=this;this._currentFileIndex=0;this._cancelID=_21d.capture(this.listOfURLs,function(url,_220,_221){if(!_220&&self.refreshing){self._cancelID=null;self.refreshing=false;var _222=[];_222.push("Unable to capture: "+url);_219(true,_222);return;}else{if(_220){self._currentFileIndex++;}}if(_220&&self._currentFileIndex>=self.listOfURLs.length){self._cancelID=null;self.refreshing=false;if(_21a){dojox.storage.put("oldVersion",_21a,null,dojox.off.STORAGE_NAMESPACE);}dojox.storage.put("justDebugged",dojo.config.isDebug,null,dojox.off.STORAGE_NAMESPACE);_219(false,[]);}});},_getVersionInfo:function(_223){var _224=dojox.storage.get("justDebugged",dojox.off.STORAGE_NAMESPACE);var _225=dojox.storage.get("oldVersion",dojox.off.STORAGE_NAMESPACE);var _226=null;_223=dojo.hitch(this,_223);dojo.xhrGet({url:this.versionURL+"?browserbust="+new Date().getTime(),timeout:5*1000,handleAs:"javascript",error:function(err){dojox.storage.remove("oldVersion",dojox.off.STORAGE_NAMESPACE);dojox.storage.remove("justDebugged",dojox.off.STORAGE_NAMESPACE);_223(_225,_226,_224);},load:function(data){if(data){_226=data;}_223(_225,_226,_224);}});}};}if(!dojo._hasResource["dojox.off.sync"]){dojo._hasResource["dojox.off.sync"]=true;dojo.provide("dojox.off.sync");dojo.mixin(dojox.off.sync,{isSyncing:false,cancelled:false,successful:true,details:[],error:false,actions:null,autoSync:true,onSync:function(type){},synchronize:function(){if(this.isSyncing||dojox.off.goingOnline||(!dojox.off.isOnline)){return;}this.isSyncing=true;this.successful=false;this.details=[];this.cancelled=false;this.start();},cancel:function(){if(!this.isSyncing){return;}this.cancelled=true;if(dojox.off.files.refreshing){dojox.off.files.abortRefresh();}this.onSync("cancel");},finishedDownloading:function(_22a,_22b){if(typeof _22a=="undefined"){_22a=true;}if(!_22a){this.successful=false;this.details.push(_22b);this.error=true;}this.finished();},start:function(){if(this.cancelled){this.finished();return;}this.onSync("start");this.refreshFiles();},refreshFiles:function(){if(this.cancelled){this.finished();return;}this.onSync("refreshFiles");dojox.off.files.refresh(dojo.hitch(this,function(_22c,_22d){if(_22c){this.error=true;this.successful=false;for(var i=0;i<_22d.length;i++){this.details.push(_22d[i]);}}this.upload();}));},upload:function(){if(this.cancelled){this.finished();return;}this.onSync("upload");dojo.connect(this.actions,"onReplayFinished",this,this.download);this.actions.replay();},download:function(){if(this.cancelled){this.finished();return;}this.onSync("download");},finished:function(){this.isSyncing=false;this.successful=(!this.cancelled&&!this.error);this.onSync("finished");},_save:function(_22f){this.actions._save(function(){_22f();});},_load:function(_230){this.actions._load(function(){_230();});}});dojo.declare("dojox.off.sync.ActionLog",null,{entries:[],reasonHalted:null,isReplaying:false,autoSave:true,add:function(_231){if(this.isReplaying){throw "Programming error: you can not call "+"dojox.off.sync.actions.add() while "+"we are replaying an action log";}this.entries.push(_231);if(this.autoSave){this._save();}},onReplay:function(_232,_233){},length:function(){return this.entries.length;},haltReplay:function(_234){if(!this.isReplaying){return;}if(_234){this.reasonHalted=_234.toString();}if(this.autoSave){var self=this;this._save(function(){self.isReplaying=false;self.onReplayFinished();});}else{this.isReplaying=false;this.onReplayFinished();}},continueReplay:function(){if(!this.isReplaying){return;}this.entries.shift();if(!this.entries.length){if(this.autoSave){var self=this;this._save(function(){self.isReplaying=false;self.onReplayFinished();});return;}else{this.isReplaying=false;this.onReplayFinished();return;}}var _237=this.entries[0];this.onReplay(_237,this);},clear:function(){if(this.isReplaying){return;}this.entries=[];if(this.autoSave){this._save();}},replay:function(){if(this.isReplaying){return;}this.reasonHalted=null;if(!this.entries.length){this.onReplayFinished();return;}this.isReplaying=true;var _238=this.entries[0];this.onReplay(_238,this);},onReplayFinished:function(){},toString:function(){var _239="";_239+="[";for(var i=0;i<this.entries.length;i++){_239+="{";for(var j in this.entries[i]){_239+=j+": \""+this.entries[i][j]+"\"";_239+=", ";}_239+="}, ";}_239+="]";return _239;},_save:function(_23c){if(!_23c){_23c=function(){};}try{var self=this;var _23e=function(_23f,key,_241){if(_23f==dojox.storage.FAILED){dojox.off.onFrameworkEvent("save",{status:dojox.storage.FAILED,isCoreSave:true,key:key,value:_241,namespace:dojox.off.STORAGE_NAMESPACE});_23c();}else{if(_23f==dojox.storage.SUCCESS){_23c();}}};dojox.storage.put("actionlog",this.entries,_23e,dojox.off.STORAGE_NAMESPACE);}catch(exp){console.debug("dojox.off.sync._save: "+exp.message||exp);dojox.off.onFrameworkEvent("save",{status:dojox.storage.FAILED,isCoreSave:true,key:"actionlog",value:this.entries,namespace:dojox.off.STORAGE_NAMESPACE});_23c();}},_load:function(_242){var _243=dojox.storage.get("actionlog",dojox.off.STORAGE_NAMESPACE);if(!_243){_243=[];}this.entries=_243;_242();}});dojox.off.sync.actions=new dojox.off.sync.ActionLog();}if(!dojo._hasResource["dojox.off._common"]){dojo._hasResource["dojox.off._common"]=true;dojo.provide("dojox.off._common");dojo.mixin(dojox.off,{isOnline:false,NET_CHECK:5,STORAGE_NAMESPACE:"_dot",enabled:true,availabilityURL:dojo.moduleUrl("dojox","off/network_check.txt"),goingOnline:false,coreOpFailed:false,doNetChecking:true,hasOfflineCache:null,browserRestart:false,_STORAGE_APP_NAME:window.location.href.replace(/[^0-9A-Za-z_]/g,"_"),_initializeCalled:false,_storageLoaded:false,_pageLoaded:false,onLoad:function(){},onNetwork:function(type){},initialize:function(){this._initializeCalled=true;if(this._storageLoaded&&this._pageLoaded){this._onLoad();}},goOffline:function(){if((dojox.off.sync.isSyncing)||(this.goingOnline)){return;}this.goingOnline=false;this.isOnline=false;},goOnline:function(_245){if(dojox.off.sync.isSyncing||dojox.off.goingOnline){return;}this.goingOnline=true;this.isOnline=false;this._isSiteAvailable(_245);},onFrameworkEvent:function(type,_247){if(type=="save"){if(_247.isCoreSave&&(_247.status==dojox.storage.FAILED)){dojox.off.coreOpFailed=true;dojox.off.enabled=false;dojox.off.onFrameworkEvent("coreOperationFailed");}}else{if(type=="coreOperationFailed"){dojox.off.coreOpFailed=true;dojox.off.enabled=false;}}},_checkOfflineCacheAvailable:function(_248){this.hasOfflineCache=dojo.gears.available;_248();},_onLoad:function(){dojox.off.files.cache(dojo.moduleUrl("dojo","dojo.js"));this._cacheDojoResources();dojox.off.files.cache(dojox.storage.manager.getResourceList());dojox.off.files._slurp();this._checkOfflineCacheAvailable(dojo.hitch(this,"_onOfflineCacheChecked"));},_onOfflineCacheChecked:function(){if(this.hasOfflineCache&&this.enabled){this._load(dojo.hitch(this,"_finishStartingUp"));}else{if(this.hasOfflineCache&&!this.enabled){this._finishStartingUp();}else{this._keepCheckingUntilInstalled();}}},_keepCheckingUntilInstalled:function(){this._finishStartingUp();},_finishStartingUp:function(){if(!this.hasOfflineCache){this.onLoad();}else{if(this.enabled){this._startNetworkThread();this.goOnline(dojo.hitch(this,function(){dojox.off.onLoad();}));}else{if(this.coreOpFailed){this.onFrameworkEvent("coreOperationFailed");}else{this.onLoad();}}}},_onPageLoad:function(){this._pageLoaded=true;if(this._storageLoaded&&this._initializeCalled){this._onLoad();}},_onStorageLoad:function(){this._storageLoaded=true;if(!dojox.storage.manager.isAvailable()&&dojox.storage.manager.isInitialized()){this.coreOpFailed=true;this.enabled=false;}if(this._pageLoaded&&this._initializeCalled){this._onLoad();}},_isSiteAvailable:function(_249){dojo.xhrGet({url:this._getAvailabilityURL(),handleAs:"text",timeout:this.NET_CHECK*1000,error:dojo.hitch(this,function(err){this.goingOnline=false;this.isOnline=false;if(_249){_249(false);}}),load:dojo.hitch(this,function(data){this.goingOnline=false;this.isOnline=true;if(_249){_249(true);}else{this.onNetwork("online");}})});},_startNetworkThread:function(){if(!this.doNetChecking){return;}window.setInterval(dojo.hitch(this,function(){var d=dojo.xhrGet({url:this._getAvailabilityURL(),handleAs:"text",timeout:this.NET_CHECK*1000,error:dojo.hitch(this,function(err){if(this.isOnline){this.isOnline=false;try{if(typeof d.ioArgs.xhr.abort=="function"){d.ioArgs.xhr.abort();}}catch(e){}dojox.off.sync.isSyncing=false;this.onNetwork("offline");}}),load:dojo.hitch(this,function(data){if(!this.isOnline){this.isOnline=true;this.onNetwork("online");}})});}),this.NET_CHECK*1000);},_getAvailabilityURL:function(){var url=this.availabilityURL.toString();if(url.indexOf("?")==-1){url+="?";}else{url+="&";}url+="browserbust="+new Date().getTime();return url;},_onOfflineCacheInstalled:function(){this.onFrameworkEvent("offlineCacheInstalled");},_cacheDojoResources:function(){var _250=true;dojo.forEach(dojo.query("script"),function(i){var src=i.getAttribute("src");if(!src){return;}if(src.indexOf("_base/_loader/bootstrap.js")!=-1){_250=false;}});if(!_250){dojox.off.files.cache(dojo.moduleUrl("dojo","_base.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/loader.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/bootstrap.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/hostenv_browser.js").uri);}for(var i=0;i<dojo._loadedUrls.length;i++){dojox.off.files.cache(dojo._loadedUrls[i]);}},_save:function(){},_load:function(_254){dojox.off.sync._load(_254);}});dojox.storage.manager.addOnLoad(dojo.hitch(dojox.off,"_onStorageLoad"));dojo.addOnLoad(dojox.off,"_onPageLoad");}if(!dojo._hasResource["dojox.off"]){dojo._hasResource["dojox.off"]=true;dojo.provide("dojox.off");}if(!dojo._hasResource["dojox.off.ui"]){dojo._hasResource["dojox.off.ui"]=true;dojo.provide("dojox.off.ui");dojo.mixin(dojox.off.ui,{appName:"setme",autoEmbed:true,autoEmbedID:"dot-widget",runLink:window.location.href,runLinkTitle:"Run Application",learnHowPath:dojo.moduleUrl("dojox","off/resources/learnhow.html"),customLearnHowPath:false,htmlTemplatePath:dojo.moduleUrl("dojox","off/resources/offline-widget.html").uri,cssTemplatePath:dojo.moduleUrl("dojox","off/resources/offline-widget.css").uri,onlineImagePath:dojo.moduleUrl("dojox","off/resources/greenball.png").uri,offlineImagePath:dojo.moduleUrl("dojox","off/resources/redball.png").uri,rollerImagePath:dojo.moduleUrl("dojox","off/resources/roller.gif").uri,checkmarkImagePath:dojo.moduleUrl("dojox","off/resources/checkmark.png").uri,learnHowJSPath:dojo.moduleUrl("dojox","off/resources/learnhow.js").uri,_initialized:false,onLoad:function(){},_initialize:function(){if(this._validateAppName(this.appName)==false){alert("You must set dojox.off.ui.appName; it can only contain "+"letters, numbers, and spaces; right now it "+"is incorrectly set to '"+dojox.off.ui.appName+"'");dojox.off.enabled=false;return;}this.runLinkText="Run "+this.appName;dojo.connect(dojox.off,"onNetwork",this,"_onNetwork");dojo.connect(dojox.off.sync,"onSync",this,"_onSync");dojox.off.files.cache([this.htmlTemplatePath,this.cssTemplatePath,this.onlineImagePath,this.offlineImagePath,this.rollerImagePath,this.checkmarkImagePath]);if(this.autoEmbed){this._doAutoEmbed();}},_doAutoEmbed:function(){dojo.xhrGet({url:this.htmlTemplatePath,handleAs:"text",error:function(err){dojox.off.enabled=false;err=err.message||err;alert("Error loading the Dojo Offline Widget from "+this.htmlTemplatePath+": "+err);},load:dojo.hitch(this,this._templateLoaded)});},_templateLoaded:function(data){var _257=dojo.byId(this.autoEmbedID);if(_257){_257.innerHTML=data;}this._initImages();this._updateNetIndicator();this._initLearnHow();this._initialized=true;if(!dojox.off.hasOfflineCache){this._showNeedsOfflineCache();return;}if(dojox.off.hasOfflineCache&&dojox.off.browserRestart){this._needsBrowserRestart();return;}else{var _258=dojo.byId("dot-widget-browser-restart");if(_258){_258.style.display="none";}}this._updateSyncUI();this._initMainEvtHandlers();this._setOfflineEnabled(dojox.off.enabled);this._onNetwork(dojox.off.isOnline?"online":"offline");this._testNet();},_testNet:function(){dojox.off.goOnline(dojo.hitch(this,function(_259){this._onNetwork(_259?"online":"offline");this.onLoad();}));},_updateNetIndicator:function(){var _25a=dojo.byId("dot-widget-network-indicator-online");var _25b=dojo.byId("dot-widget-network-indicator-offline");var _25c=dojo.byId("dot-widget-title-text");if(_25a&&_25b){if(dojox.off.isOnline==true){_25a.style.display="inline";_25b.style.display="none";}else{_25a.style.display="none";_25b.style.display="inline";}}if(_25c){if(dojox.off.isOnline){_25c.innerHTML="Online";}else{_25c.innerHTML="Offline";}}},_initLearnHow:function(){var _25d=dojo.byId("dot-widget-learn-how-link");if(!_25d){return;}if(!this.customLearnHowPath){var _25e=dojo.config.baseRelativePath;this.learnHowPath+="?appName="+encodeURIComponent(this.appName)+"&hasOfflineCache="+dojox.off.hasOfflineCache+"&runLink="+encodeURIComponent(this.runLink)+"&runLinkText="+encodeURIComponent(this.runLinkText)+"&baseRelativePath="+encodeURIComponent(_25e);dojox.off.files.cache(this.learnHowJSPath);dojox.off.files.cache(this.learnHowPath);}_25d.setAttribute("href",this.learnHowPath);var _25f=dojo.byId("dot-widget-learn-how-app-name");if(!_25f){return;}_25f.innerHTML="";_25f.appendChild(document.createTextNode(this.appName));},_validateAppName:function(_260){if(!_260){return false;}return (/^[a-z0-9 ]*$/i.test(_260));},_updateSyncUI:function(){var _261=dojo.byId("dot-roller");var _262=dojo.byId("dot-success-checkmark");var _263=dojo.byId("dot-sync-messages");var _264=dojo.byId("dot-sync-details");var _265=dojo.byId("dot-sync-cancel");if(dojox.off.sync.isSyncing){this._clearSyncMessage();if(_261){_261.style.display="inline";}if(_262){_262.style.display="none";}if(_263){dojo.removeClass(_263,"dot-sync-error");}if(_264){_264.style.display="none";}if(_265){_265.style.display="inline";}}else{if(_261){_261.style.display="none";}if(_265){_265.style.display="none";}if(_263){dojo.removeClass(_263,"dot-sync-error");}}},_setSyncMessage:function(_266){var _267=dojo.byId("dot-sync-messages");if(_267){while(_267.firstChild){_267.removeChild(_267.firstChild);}_267.appendChild(document.createTextNode(_266));}},_clearSyncMessage:function(){this._setSyncMessage("");},_initImages:function(){var _268=dojo.byId("dot-widget-network-indicator-online");if(_268){_268.setAttribute("src",this.onlineImagePath);}var _269=dojo.byId("dot-widget-network-indicator-offline");if(_269){_269.setAttribute("src",this.offlineImagePath);}var _26a=dojo.byId("dot-roller");if(_26a){_26a.setAttribute("src",this.rollerImagePath);}var _26b=dojo.byId("dot-success-checkmark");if(_26b){_26b.setAttribute("src",this.checkmarkImagePath);}},_showDetails:function(evt){evt.preventDefault();evt.stopPropagation();if(!dojox.off.sync.details.length){return;}var html="";html+="<html><head><title>Sync Details</title><head><body>";html+="<h1>Sync Details</h1>\n";html+="<ul>\n";for(var i=0;i<dojox.off.sync.details.length;i++){html+="<li>";html+=dojox.off.sync.details[i];html+="</li>";}html+="</ul>\n";html+="<a href='javascript:window.close()' "+"style='text-align: right; padding-right: 2em;'>"+"Close Window"+"</a>\n";html+="</body></html>";var _26f="height=400,width=600,resizable=true,"+"scrollbars=true,toolbar=no,menubar=no,"+"location=no,directories=no,dependent=yes";var _270=window.open("","SyncDetails",_26f);if(!_270){alert("Please allow popup windows for this domain; can't display sync details window");return;}_270.document.open();_270.document.write(html);_270.document.close();if(_270.focus){_270.focus();}},_cancel:function(evt){evt.preventDefault();evt.stopPropagation();dojox.off.sync.cancel();},_needsBrowserRestart:function(){var _272=dojo.byId("dot-widget-browser-restart");if(_272){dojo.addClass(_272,"dot-needs-browser-restart");}var _273=dojo.byId("dot-widget-browser-restart-app-name");if(_273){_273.innerHTML="";_273.appendChild(document.createTextNode(this.appName));}var _274=dojo.byId("dot-sync-status");if(_274){_274.style.display="none";}},_showNeedsOfflineCache:function(){var _275=dojo.byId("dot-widget-container");if(_275){dojo.addClass(_275,"dot-needs-offline-cache");}},_hideNeedsOfflineCache:function(){var _276=dojo.byId("dot-widget-container");if(_276){dojo.removeClass(_276,"dot-needs-offline-cache");}},_initMainEvtHandlers:function(){var _277=dojo.byId("dot-sync-details-button");if(_277){dojo.connect(_277,"onclick",this,this._showDetails);}var _278=dojo.byId("dot-sync-cancel-button");if(_278){dojo.connect(_278,"onclick",this,this._cancel);}},_setOfflineEnabled:function(_279){var _27a=[];_27a.push(dojo.byId("dot-sync-status"));for(var i=0;i<_27a.length;i++){if(_27a[i]){_27a[i].style.visibility=(_279?"visible":"hidden");}}},_syncFinished:function(){this._updateSyncUI();var _27c=dojo.byId("dot-success-checkmark");var _27d=dojo.byId("dot-sync-details");if(dojox.off.sync.successful==true){this._setSyncMessage("Sync Successful");if(_27c){_27c.style.display="inline";}}else{if(dojox.off.sync.cancelled==true){this._setSyncMessage("Sync Cancelled");if(_27c){_27c.style.display="none";}}else{this._setSyncMessage("Sync Error");var _27e=dojo.byId("dot-sync-messages");if(_27e){dojo.addClass(_27e,"dot-sync-error");}if(_27c){_27c.style.display="none";}}}if(dojox.off.sync.details.length&&_27d){_27d.style.display="inline";}},_onFrameworkEvent:function(type,_280){if(type=="save"){if(_280.status==dojox.storage.FAILED&&!_280.isCoreSave){alert("Please increase the amount of local storage available "+"to this application");if(dojox.storage.hasSettingsUI()){dojox.storage.showSettingsUI();}}}else{if(type=="coreOperationFailed"){console.log("Application does not have permission to use Dojo Offline");if(!this._userInformed){alert("This application will not work if Google Gears is not allowed to run");this._userInformed=true;}}else{if(type=="offlineCacheInstalled"){this._hideNeedsOfflineCache();if(dojox.off.hasOfflineCache==true&&dojox.off.browserRestart==true){this._needsBrowserRestart();return;}else{var _281=dojo.byId("dot-widget-browser-restart");if(_281){_281.style.display="none";}}this._updateSyncUI();this._initMainEvtHandlers();this._setOfflineEnabled(dojox.off.enabled);this._testNet();}}}},_onSync:function(type){switch(type){case "start":this._updateSyncUI();break;case "refreshFiles":this._setSyncMessage("Downloading UI...");break;case "upload":this._setSyncMessage("Uploading new data...");break;case "download":this._setSyncMessage("Downloading new data...");break;case "finished":this._syncFinished();break;case "cancel":this._setSyncMessage("Canceling Sync...");break;default:dojo.warn("Programming error: "+"Unknown sync type in dojox.off.ui: "+type);break;}},_onNetwork:function(type){if(!this._initialized){return;}this._updateNetIndicator();if(type=="offline"){this._setSyncMessage("You are working offline");var _284=dojo.byId("dot-sync-details");if(_284){_284.style.display="none";}this._updateSyncUI();}else{if(dojox.off.sync.autoSync){if(dojo.isAIR){window.setTimeout(function(){dojox.off.sync.synchronize();},1000);}else{window.setTimeout(dojox._scopeName+".off.sync.synchronize()",1000);}}}}});dojo.connect(dojox.off,"onFrameworkEvent",dojox.off.ui,"_onFrameworkEvent");dojo.connect(dojox.off,"onLoad",dojox.off.ui,dojox.off.ui._initialize);}if(!dojo._hasResource["dojox.off.offline"]){dojo._hasResource["dojox.off.offline"]=true;dojo.provide("dojox.off.offline");}
