/*
	Copyright (c) 2004-2008, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["dojox.data.CouchDBRestStore"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.data.CouchDBRestStore"] = true;
dojo.provide("dojox.data.CouchDBRestStore");
dojo.require("dojox.data.JsonRestStore");

// A CouchDBRestStore is an extension of JsonRestStore to handle CouchDB's idiosyncrasies, special features,
// and deviations from standard HTTP Rest.
// NOTE: CouchDB is not designed to be run on a public facing network. There is no access control
// on database documents, and you should NOT rely on client side control to implement security.


dojo.declare("dojox.data.CouchDBRestStore",
	dojox.data.JsonRestStore,
	{
		save: function(kwArgs) {
			var actions = this.inherited(arguments); // do the default save and then update for version numbers
			var prefix = this.service.servicePath;
			for(var i = 0; i < actions.length; i++){
				// need to update the item's version number after it has been committed
				(function(item,dfd){
					dfd.addCallback(function(result){
						if(result){
							item.__id = prefix + result.id; // update the object with the results of the post
							item._rev = result.rev;
						}
						return result;
					});
				})(actions[i].content,actions[i].deferred);
			}
		},
		fetch: function(args){
			// summary:
			// 		This only differs from JsonRestStore in that it, will put the query string the query part of the URL and it handles start and count
			args.query = args.query || '_all_docs?';
			if(args.start){
				args.query = (args.query ? (args.query + '&') : '') + 'skip=' + args.start;
				delete args.start;
			}
			if(args.count){
				args.query = (args.query ? (args.query + '&') : '') + 'count=' + args.count;
				delete args.count;
			}
			return this.inherited(arguments);
		},
		_processResults: function(results){
			var rows = results.rows;
			if(rows){
				var prefix = this.service.servicePath;
				var self = this;
				for(var i = 0; i < rows.length;i++){
					rows[i] = {
						__id: prefix + rows[i].id, 
						_id: rows[i].id,
						_loadObject: function(callback){
							self.fetchItemByIdentity({
								identity: this._id,
								onItem: callback
							});
							delete this._loadObject;
						}
					};
				}
				return {totalCount:results.total_rows, items:results.rows};
			}else{
				return {items:results};
			}
						
		}
	}
);

// create a set of stores
dojox.data.CouchDBRestStore.getStores = function(couchServerUrl){
	var dfd = dojo.xhrGet({
		url: couchServerUrl+"_all_dbs",
		handleAs: "json",
		sync: true
	});
	var stores = {};
	dfd.addBoth(function(dbs){
		for(var i = 0; i < dbs.length; i++){
			stores[dbs[i]] = new dojox.data.CouchDBRestStore({target:couchServerUrl + dbs[i],idAttribute:"_id"});
		}
		return stores;
	});
	return stores;
};

}
