/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(!dojo._hasResource["dojox.gfx.matrix"]){dojo._hasResource["dojox.gfx.matrix"]=true;dojo.provide("dojox.gfx.matrix");(function(){var m=dojox.gfx.matrix;m._degToRad=function(_2){return Math.PI*_2/180;};m._radToDeg=function(_3){return _3/Math.PI*180;};m.Matrix2D=function(_4){if(_4){if(typeof _4=="number"){this.xx=this.yy=_4;}else{if(_4 instanceof Array){if(_4.length>0){var _5=m.normalize(_4[0]);for(var i=1;i<_4.length;++i){var l=_5,r=dojox.gfx.matrix.normalize(_4[i]);_5=new m.Matrix2D();_5.xx=l.xx*r.xx+l.xy*r.yx;_5.xy=l.xx*r.xy+l.xy*r.yy;_5.yx=l.yx*r.xx+l.yy*r.yx;_5.yy=l.yx*r.xy+l.yy*r.yy;_5.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_5.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}dojo.mixin(this,_5);}}else{dojo.mixin(this,_4);}}}};dojo.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});dojo.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_d){var c=Math.cos(_d);var s=Math.sin(_d);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_10){return m.rotate(m._degToRad(_10));},skewX:function(_11){return new m.Matrix2D({xy:Math.tan(_11)});},skewXg:function(_12){return m.skewX(m._degToRad(_12));},skewY:function(_13){return new m.Matrix2D({yx:Math.tan(_13)});},skewYg:function(_14){return m.skewY(m._degToRad(_14));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_21){return (_21 instanceof m.Matrix2D)?_21:new m.Matrix2D(_21);},clone:function(_22){var obj=new m.Matrix2D();for(var i in _22){if(typeof (_22[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_22[i]){obj[i]=_22[i];}}return obj;},invert:function(_25){var M=m.normalize(_25),D=M.xx*M.yy-M.xy*M.yx,M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_28,x,y){return {x:_28.xx*x+_28.xy*y+_28.dx,y:_28.yx*x+_28.yy*y+_28.dy};},multiplyPoint:function(_2b,a,b){var M=m.normalize(_2b);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiply:function(_2f){var M=m.normalize(_2f);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_34,x,y){return m.multiply(m.translate(x,y),_34,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_3b,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_3b),a,b);}return m._sandwich(m.rotate(_3b),a.x,a.y);},rotategAt:function(_3e,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_3e),a,b);}return m._sandwich(m.rotateg(_3e),a.x,a.y);},skewXAt:function(_41,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_41),a,b);}return m._sandwich(m.skewX(_41),a.x,a.y);},skewXgAt:function(_44,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_44),a,b);}return m._sandwich(m.skewXg(_44),a.x,a.y);},skewYAt:function(_47,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_47),a,b);}return m._sandwich(m.skewY(_47),a.x,a.y);},skewYgAt:function(_4a,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_4a),a,b);}return m._sandwich(m.skewYg(_4a),a.x,a.y);}});})();dojox.gfx.Matrix2D=dojox.gfx.matrix.Matrix2D;}if(!dojo._hasResource["dojox.gfx._base"]){dojo._hasResource["dojox.gfx._base"]=true;dojo.provide("dojox.gfx._base");(function(){var g=dojox.gfx,b=g._base;g._hasClass=function(_4f,_50){return ((" "+_4f.getAttribute("className")+" ").indexOf(" "+_50+" ")>=0);};g._addClass=function(_51,_52){var cls=_51.getAttribute("className");if((" "+cls+" ").indexOf(" "+_52+" ")<0){_51.setAttribute("className",cls+(cls?" ":"")+_52);}};g._removeClass=function(_54,_55){_54.setAttribute("className",_54.getAttribute("className").replace(new RegExp("(^|\\s+)"+_55+"(\\s+|$)"),"$1$2"));};b._getFontMeasurements=function(){var _56={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};if(dojo.isIE){dojo.doc.documentElement.style.fontSize="100%";}var div=dojo.doc.createElement("div");div.style.position="absolute";div.style.left="-100px";div.style.top="0";div.style.width="30px";div.style.height="1000em";div.style.border="0";div.style.margin="0";div.style.padding="0";div.style.outline="0";div.style.lineHeight="1";div.style.overflow="hidden";dojo.body().appendChild(div);for(var p in _56){div.style.fontSize=p;_56[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}dojo.body().removeChild(div);div=null;return _56;};var _59=null;b._getCachedFontMeasurements=function(_5a){if(_5a||!_59){_59=b._getFontMeasurements();}return _59;};var _5b=null,_5c={};b._getTextBox=function(_5d,_5e,_5f){var m;if(!_5b){m=_5b=dojo.doc.createElement("div");m.style.position="absolute";m.style.left="-10000px";m.style.top="0";dojo.body().appendChild(m);}else{m=_5b;}m.className="";m.style.border="0";m.style.margin="0";m.style.padding="0";m.style.outline="0";if(arguments.length>1&&_5e){for(var i in _5e){if(i in _5c){continue;}m.style[i]=_5e[i];}}if(arguments.length>2&&_5f){m.className=_5f;}m.innerHTML=_5d;return dojo.marginBox(m);};var _62=0;b._getUniqueId=function(){var id;do{id=dojo._scopeName+"Unique"+(++_62);}while(dojo.byId(id));return id;};})();dojo.mixin(dojox.gfx,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},normalizeColor:function(_64){return (_64 instanceof dojo.Color)?_64:new dojo.Color(_64);},normalizeParameters:function(_65,_66){if(_66){var _67={};for(var x in _65){if(x in _66&&!(x in _67)){_65[x]=_66[x];}}}return _65;},makeParameters:function(_69,_6a){if(!_6a){return dojo.clone(_69);}var _6b={};for(var i in _69){if(!(i in _6b)){_6b[i]=dojo.clone((i in _6a)?_6a[i]:_69[i]);}}return _6b;},formatNumber:function(x,_6e){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _70=val.indexOf(".");if(_70>=0&&val.length-_70>5){val=x.toFixed(4);}}if(x<0){return val;}return _6e?" "+val:val;},makeFontString:function(_71){return _71.style+" "+_71.variant+" "+_71.weight+" "+_71.size+" "+_71.family;},splitFontString:function(str){var _73=dojo.clone(dojox.gfx.defaultFont);var t=str.split(/\s+/);do{if(t.length<5){break;}_73.style=t[0];_73.varian=t[1];_73.weight=t[2];var i=t[3].indexOf("/");_73.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;break;}if(t[4].substr(0,1)=="/"){j=5;break;}}if(j+3>t.length){break;}_73.size=t[j];_73.family=t[j+1];}while(false);return _73;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return dojox.gfx._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*dojox.gfx.px_in_pt();},px2pt:function(len){return len/dojox.gfx.px_in_pt();},normalizedLength:function(len){if(len.length==0){return 0;}if(len.length>2){var _7a=dojox.gfx.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_7a;case "in":return val*72*_7a;case "pc":return val*12*_7a;case "mm":return val*dojox.gfx.mm_in_pt*_7a;case "cm":return val*dojox.gfx.cm_in_pt*_7a;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a==b;}});}if(!dojo._hasResource["dojox.gfx"]){dojo._hasResource["dojox.gfx"]=true;dojo.provide("dojox.gfx");dojo.loadInit(function(){var gfx=dojo.getObject("dojox.gfx",true),sl,_80,_81;if(!gfx.renderer){var _82=(typeof dojo.config.gfxRenderer=="string"?dojo.config.gfxRenderer:"svg,vml,silverlight,canvas").split(",");var ua=navigator.userAgent,_84=0,_85=0;if(dojo.isSafari>=3){if(ua.indexOf("iPhone")>=0||ua.indexOf("iPod")>=0){_81=ua.match(/Version\/(\d(\.\d)?(\.\d)?)\sMobile\/([^\s]*)\s?/);if(_81){_84=parseInt(_81[4].substr(0,3),16);}}if(!_84){_81=ua.match(/Android\s+(\d+\.\d+)/);if(_81){_85=parseFloat(_81[1]);}}}for(var i=0;i<_82.length;++i){switch(_82[i]){case "svg":if(!dojo.isIE&&(!_84||_84>=1521)&&!_85&&!dojo.isAIR){dojox.gfx.renderer="svg";}break;case "vml":if(dojo.isIE){dojox.gfx.renderer="vml";}break;case "silverlight":try{if(dojo.isIE){sl=new ActiveXObject("AgControl.AgControl");if(sl&&sl.IsVersionSupported("1.0")){_80=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_80=true;}}}catch(e){_80=false;}finally{sl=null;}if(_80){dojox.gfx.renderer="silverlight";}break;case "canvas":if(!dojo.isIE){dojox.gfx.renderer="canvas";}break;}if(dojox.gfx.renderer){break;}}if(dojo.config.isDebug){}}});dojo.requireIf(dojox.gfx.renderer=="svg","dojox.gfx.svg");dojo.requireIf(dojox.gfx.renderer=="vml","dojox.gfx.vml");dojo.requireIf(dojox.gfx.renderer=="silverlight","dojox.gfx.silverlight");dojo.requireIf(dojox.gfx.renderer=="canvas","dojox.gfx.canvas");}if(!dojo._hasResource["dojox.lang.functional.lambda"]){dojo._hasResource["dojox.lang.functional.lambda"]=true;dojo.provide("dojox.lang.functional.lambda");(function(){var df=dojox.lang.functional,_88={};var _89="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _8d=function(s){var _8f=[],_90=_89.call(s,/\s*->\s*/m);if(_90.length>1){while(_90.length){s=_90.pop();_8f=_90.pop().split(/\s*,\s*|\s+/m);if(_90.length){_90.push("(function("+_8f+"){return ("+s+")})");}}}else{if(s.match(/\b_\b/)){_8f=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){_8f.push("$1");s="$1"+s;}if(r){_8f.push("$2");s=s+"$2";}}else{var _93=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};dojo.forEach(_93,function(v){if(!(v in t)){_8f.push(v);t[v]=1;}});}}}return {args:_8f,body:s};};var _96=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};dojo.mixin(df,{rawLambda:function(s){return _8d(s);},buildLambda:function(s){s=_8d(s);return "function("+s.args.join(",")+"){return ("+s.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _96(s);}if(s in _88){return _88[s];}s=_8d(s);return _88[s]=new Function(s.args,"return ("+s.body+");");},clearLambdaCache:function(){_88={};}});})();}if(!dojo._hasResource["dojox.lang.functional.array"]){dojo._hasResource["dojox.lang.functional.array"]=true;dojo.provide("dojox.lang.functional.array");(function(){var d=dojo,df=dojox.lang.functional,_a0={};d.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t=[],v,i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _a0)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _a0)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _a0)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _a0)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _a0)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});})();}if(!dojo._hasResource["dojox.lang.functional.object"]){dojo._hasResource["dojox.lang.functional.object"]=true;dojo.provide("dojox.lang.functional.object");(function(){var d=dojo,df=dojox.lang.functional,_bf={};d.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _bf)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _bf)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _bf)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);for(var i in obj){if(!(i in _bf)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _bf)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});})();}if(!dojo._hasResource["dojox.lang.functional"]){dojo._hasResource["dojox.lang.functional"]=true;dojo.provide("dojox.lang.functional");}if(!dojo._hasResource["dojox.lang.functional.fold"]){dojo._hasResource["dojox.lang.functional.fold"]=true;dojo.provide("dojox.lang.functional.fold");(function(){var d=dojo,df=dojox.lang.functional,_d7={};d.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _d7)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var z,i,n;if(d.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _e4=true;for(i in a){if(!(i in _d7)){if(_e4){z=a[i];_e4=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||d.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});})();}if(!dojo._hasResource["dojox.lang.functional.reversed"]){dojo._hasResource["dojox.lang.functional.reversed"]=true;dojo.provide("dojox.lang.functional.reversed");(function(){var d=dojo,df=dojox.lang.functional;d.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});})();}if(!dojo._hasResource["dojo.colors"]){dojo._hasResource["dojo.colors"]=true;dojo.provide("dojo.colors");(function(){var _117=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=function(_11c,obj){var m=_11c.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=dojo.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return dojo.colorFromArray(a,obj);}return dojo.colorFromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_117(m1,m2,H+1/3)*256,_117(m1,m2,H)*256,_117(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return dojo.colorFromArray(a,obj);}}return null;};var _12a=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};dojo.Color.prototype.sanitize=function(){var t=this;t.r=Math.round(_12a(t.r,0,255));t.g=Math.round(_12a(t.g,0,255));t.b=Math.round(_12a(t.b,0,255));t.a=_12a(t.a,0,1);return this;};})();dojo.colors.makeGrey=function(g,a){return dojo.colorFromArray([g,g,g,a]);};dojo.mixin(dojo.Color.named,{aliceblue:[240,248,255],antiquewhite:[250,235,215],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],blanchedalmond:[255,235,205],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],oldlace:[253,245,230],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],thistle:[216,191,216],tomato:[255,99,71],transparent:[0,0,0,0],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],whitesmoke:[245,245,245],yellowgreen:[154,205,50]});}if(!dojo._hasResource["dojox.color._base"]){dojo._hasResource["dojox.color._base"]=true;dojo.provide("dojox.color._base");dojox.color.Color=dojo.Color;dojox.color.blend=dojo.blendColors;dojox.color.fromRgb=dojo.colorFromRgb;dojox.color.fromHex=dojo.colorFromHex;dojox.color.fromArray=dojo.colorFromArray;dojox.color.fromString=dojo.colorFromString;dojox.color.greyscale=dojo.colors.makeGrey;dojo.mixin(dojox.color,{fromCmy:function(cyan,_132,_133){if(dojo.isArray(cyan)){_132=cyan[1],_133=cyan[2],cyan=cyan[0];}else{if(dojo.isObject(cyan)){_132=cyan.m,_133=cyan.y,cyan=cyan.c;}}cyan/=100,_132/=100,_133/=100;var r=1-cyan,g=1-_132,b=1-_133;return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_138,_139,_13a){if(dojo.isArray(cyan)){_138=cyan[1],_139=cyan[2],_13a=cyan[3],cyan=cyan[0];}else{if(dojo.isObject(cyan)){_138=cyan.m,_139=cyan.y,_13a=cyan.b,cyan=cyan.c;}}cyan/=100,_138/=100,_139/=100,_13a/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_13a)+_13a);g=1-Math.min(1,_138*(1-_13a)+_13a);b=1-Math.min(1,_139*(1-_13a)+_13a);return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_13f,_140){if(dojo.isArray(hue)){_13f=hue[1],_140=hue[2],hue=hue[0];}else{if(dojo.isObject(hue)){_13f=hue.s,_140=hue.l,hue=hue.h;}}_13f/=100;_140/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_13f*Math.min(r,1)+(1-_13f);g=2*_13f*Math.min(g,1)+(1-_13f);b=2*_13f*Math.min(b,1)+(1-_13f);if(_140<0.5){r*=_140,g*=_140,b*=_140;}else{r=(1-_140)*r+2*_140-1;g=(1-_140)*g+2*_140-1;b=(1-_140)*b+2*_140-1;}return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsv:function(hue,_145,_146){if(dojo.isArray(hue)){_145=hue[1],_146=hue[2],hue=hue[0];}else{if(dojo.isObject(hue)){_145=hue.s,_146=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_145/=100;_146/=100;var r,g,b;if(_145==0){r=_146,b=_146,g=_146;}else{var _14a=hue/60,i=Math.floor(_14a),f=_14a-i;var p=_146*(1-_145);var q=_146*(1-(_145*f));var t=_146*(1-(_145*(1-f)));switch(i){case 0:r=_146,g=t,b=p;break;case 1:r=q,g=_146,b=p;break;case 2:r=p,g=_146,b=t;break;case 3:r=p,g=q,b=_146;break;case 4:r=t,g=p,b=_146;break;case 5:r=_146,g=p,b=q;break;}}return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});dojo.extend(dojox.color.Color,{toCmy:function(){var cyan=1-(this.r/255),_151=1-(this.g/255),_152=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_151*100),y:Math.round(_152*100)};},toCmyk:function(){var cyan,_154,_155,_156;var r=this.r/255,g=this.g/255,b=this.b/255;_156=Math.min(1-r,1-g,1-b);cyan=(1-r-_156)/(1-_156);_154=(1-g-_156)/(1-_156);_155=(1-b-_156)/(1-_156);return {c:Math.round(cyan*100),m:Math.round(_154*100),y:Math.round(_155*100),b:Math.round(_156*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _15f=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_15f/((l<0.5)?(2*l):(2-2*l));}if(_15f>0){if(max==r&&max!=g){h+=(g-b)/_15f;}if(max==g&&max!=b){h+=(2+(b-r)/_15f);}if(max==b&&max!=r){h+=(4+(r-g)/_15f);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _168=max-min;var h=null,s=(max==0)?0:(_168/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_168;}else{if(g==max){h=120+60*(b-r)/_168;}else{h=240+60*(r-g)/_168;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});}if(!dojo._hasResource["dojox.color"]){dojo._hasResource["dojox.color"]=true;dojo.provide("dojox.color");}if(!dojo._hasResource["dojox.color.Palette"]){dojo._hasResource["dojox.color.Palette"]=true;dojo.provide("dojox.color.Palette");(function(){var dxc=dojox.color;dxc.Palette=function(base){this.colors=[];if(base instanceof dojox.color.Palette){this.colors=base.colors.slice(0);}else{if(base instanceof dojox.color.Color){this.colors=[null,null,base,null,null];}else{if(dojo.isArray(base)){this.colors=dojo.map(base.slice(0),function(item){if(dojo.isString(item)){return new dojox.color.Color(item);}return item;});}else{if(dojo.isString(base)){this.colors=[null,null,new dojox.color.Color(base),null,null];}}}}};function _16e(p,_170,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var r=(_170=="dr")?item.r+val:item.r,g=(_170=="dg")?item.g+val:item.g,b=(_170=="db")?item.b+val:item.b,a=(_170=="da")?item.a+val:item.a;ret.colors.push(new dojox.color.Color({r:Math.min(255,Math.max(0,r)),g:Math.min(255,Math.max(0,g)),b:Math.min(255,Math.max(0,b)),a:Math.min(1,Math.max(0,a))}));});return ret;};function tCMY(p,_17a,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toCmy(),c=(_17a=="dc")?o.c+val:o.c,m=(_17a=="dm")?o.m+val:o.m,y=(_17a=="dy")?o.y+val:o.y;ret.colors.push(dojox.color.fromCmy(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y))));});return ret;};function _182(p,_184,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toCmyk(),c=(_184=="dc")?o.c+val:o.c,m=(_184=="dm")?o.m+val:o.m,y=(_184=="dy")?o.y+val:o.y,k=(_184=="dk")?o.b+val:o.b;ret.colors.push(dojox.color.fromCmyk(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y)),Math.min(100,Math.max(0,k))));});return ret;};function tHSL(p,_18f,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toHsl(),h=(_18f=="dh")?o.h+val:o.h,s=(_18f=="ds")?o.s+val:o.s,l=(_18f=="dl")?o.l+val:o.l;ret.colors.push(dojox.color.fromHsl(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,l))));});return ret;};function tHSV(p,_199,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toHsv(),h=(_199=="dh")?o.h+val:o.h,s=(_199=="ds")?o.s+val:o.s,v=(_199=="dv")?o.v+val:o.v;ret.colors.push(dojox.color.fromHsv(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,v))));});return ret;};function _1a1(val,low,high){return high-((high-val)*((high-low)/high));};dojo.extend(dxc.Palette,{transform:function(_1a5){var fn=_16e;if(_1a5.use){var use=_1a5.use.toLowerCase();if(use.indexOf("hs")==0){if(use.charAt(2)=="l"){fn=tHSL;}else{fn=tHSV;}}else{if(use.indexOf("cmy")==0){if(use.charAt(3)=="k"){fn=_182;}else{fn=tCMY;}}}}else{if("dc" in _1a5||"dm" in _1a5||"dy" in _1a5){if("dk" in _1a5){fn=_182;}else{fn=tCMY;}}else{if("dh" in _1a5||"ds" in _1a5){if("dv" in _1a5){fn=tHSV;}else{fn=tHSL;}}}}var _1a8=this;for(var p in _1a5){if(p=="use"){continue;}_1a8=fn(_1a8,p,_1a5[p]);}return _1a8;},clone:function(){return new dxc.Palette(this);}});dojo.mixin(dxc.Palette,{generators:{analogous:function(args){var high=args.high||60,low=args.low||18,base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h=[(hsv.h+low+360)%360,(hsv.h+Math.round(low/2)+360)%360,hsv.h,(hsv.h-Math.round(high/2)+360)%360,(hsv.h-high+360)%360];var s1=Math.max(10,(hsv.s<=95)?hsv.s+5:(100-(hsv.s-95))),s2=(hsv.s>1)?hsv.s-1:21-hsv.s,v1=(hsv.v>=92)?hsv.v-9:Math.max(hsv.v+9,20),v2=(hsv.v<=90)?Math.max(hsv.v+5,20):(95+Math.ceil((hsv.v-90)/2)),s=[s1,s2,hsv.s,s1,s1],v=[v1,v2,hsv.v,v1,v2];return new dxc.Palette(dojo.map(h,function(hue,i){return dojox.color.fromHsv(hue,s[i],v[i]);}));},monochromatic:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var s1=(hsv.s-30>9)?hsv.s-30:hsv.s+30,s2=hsv.s,v1=_1a1(hsv.v,20,100),v2=(hsv.v-20>20)?hsv.v-20:hsv.v+60,v3=(hsv.v-50>20)?hsv.v-50:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(hsv.h,s1,v1),dojox.color.fromHsv(hsv.h,s2,v3),base,dojox.color.fromHsv(hsv.h,s1,v3),dojox.color.fromHsv(hsv.h,s2,v2)]);},triadic:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h1=(hsv.h+57+360)%360,h2=(hsv.h-157+360)%360,s1=(hsv.s>20)?hsv.s-10:hsv.s+10,s2=(hsv.s>90)?hsv.s-10:hsv.s+10,s3=(hsv.s>95)?hsv.s-5:hsv.s+5,v1=(hsv.v-20>20)?hsv.v-20:hsv.v+20,v2=(hsv.v-30>20)?hsv.v-30:hsv.v+30,v3=(hsv.v-30>70)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(h1,s1,hsv.v),dojox.color.fromHsv(hsv.h,s2,v2),base,dojox.color.fromHsv(h2,s2,v1),dojox.color.fromHsv(h2,s3,v3)]);},complementary:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,s1=Math.max(hsv.s-10,0),s2=_1a1(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(hsv.h,s1,v1),dojox.color.fromHsv(hsv.h,s2,v2),base,dojox.color.fromHsv(h1,s3,v2),dojox.color.fromHsv(h1,hsv.s,hsv.v)]);},splitComplementary:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,_1d6=args.da||30,hsv=base.toHsv();var _1d8=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,h1=(_1d8-_1d6+360)%360,h2=(_1d8+_1d6)%360,s1=Math.max(hsv.s-10,0),s2=_1a1(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(h1,s1,v1),dojox.color.fromHsv(h1,s2,v2),base,dojox.color.fromHsv(h2,s3,v2),dojox.color.fromHsv(h2,hsv.s,hsv.v)]);},compound:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+18<360)?(hsv.h*2)+18:Math.floor(hsv.h/2)-18,h2=((hsv.h*2)+120<360)?(hsv.h*2)+120:Math.floor(hsv.h/2)-120,h3=((hsv.h*2)+99<360)?(hsv.h*2)+99:Math.floor(hsv.h/2)-99,s1=(hsv.s-40>10)?hsv.s-40:hsv.s+40,s2=(hsv.s-10>80)?hsv.s-10:hsv.s+10,s3=(hsv.s-25>10)?hsv.s-25:hsv.s+25,v1=(hsv.v-40>10)?hsv.v-40:hsv.v+40,v2=(hsv.v-20>80)?hsv.v-20:hsv.v+20,v3=Math.max(hsv.v,20);return new dxc.Palette([dojox.color.fromHsv(h1,s1,v1),dojox.color.fromHsv(h1,s2,v2),base,dojox.color.fromHsv(h2,s3,v3),dojox.color.fromHsv(h3,s2,v2)]);},shades:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var s=(hsv.s==100&&hsv.v==0)?0:hsv.s,v1=(hsv.v-50>20)?hsv.v-50:hsv.v+30,v2=(hsv.v-25>=20)?hsv.v-25:hsv.v+55,v3=(hsv.v-75>=20)?hsv.v-75:hsv.v+5,v4=Math.max(hsv.v-10,20);return new dxc.Palette([new dojox.color.fromHsv(hsv.h,s,v1),new dojox.color.fromHsv(hsv.h,s,v2),base,new dojox.color.fromHsv(hsv.h,s,v3),new dojox.color.fromHsv(hsv.h,s,v4)]);}},generate:function(base,type){if(dojo.isFunction(type)){return type({base:base});}else{if(dxc.Palette.generators[type]){return dxc.Palette.generators[type]({base:base});}}throw new Error("dojox.color.Palette.generate: the specified generator ('"+type+"') does not exist.");}});})();}if(!dojo._hasResource["dojox.charting.Theme"]){dojo._hasResource["dojox.charting.Theme"]=true;dojo.provide("dojox.charting.Theme");(function(){var dxc=dojox.charting;dxc.Theme=function(_1f7){_1f7=_1f7||{};var def=dxc.Theme._def;dojo.forEach(["chart","plotarea","axis","series","marker"],function(n){this[n]=dojo.delegate(def[n],_1f7[n]||{});},this);this.markers=dojo.delegate(dxc.Theme.Markers,_1f7.markers||{});this.colors=[];this.antiAlias=("antiAlias" in _1f7)?_1f7.antiAlias:true;this.assignColors=("assignColors" in _1f7)?_1f7.assignColors:true;this.assignMarkers=("assignMarkers" in _1f7)?_1f7.assignMarkers:true;_1f7.colors=_1f7.colors||def.colors;dojo.forEach(_1f7.colors,function(item){this.colors.push(item);},this);this._current={color:0,marker:0};this._markers=[];this._buildMarkerArray();};dxc.Theme.Markers={CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"};dxc.Theme._def={chart:{stroke:null,fill:"white"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},majorTick:{color:"#666",width:1,length:6,position:"center"},minorTick:{color:"#666",width:0.8,length:3,position:"center"},font:"normal normal normal 7pt Tahoma",fontColor:"#333"},series:{outline:{width:0.1,color:"#ccc"},stroke:{width:1.5,color:"#333"},fill:"#ccc",font:"normal normal normal 7pt Tahoma",fontColor:"#000"},marker:{stroke:{width:1},fill:"#333",font:"normal normal normal 7pt Tahoma",fontColor:"#000"},colors:["#54544c","#858e94","#6e767a","#948585","#474747"]};dojo.extend(dxc.Theme,{defineColors:function(obj){var _1fc=obj||{};var c=[],n=_1fc.num||5;if(_1fc.colors){var l=_1fc.colors.length;for(var i=0;i<n;i++){c.push(_1fc.colors[i%l]);}this.colors=c;}else{if(_1fc.hue){var s=_1fc.saturation||100;var st=_1fc.low||30;var end=_1fc.high||90;var l=(end+st)/2;this.colors=dojox.color.Palette.generate(dojox.color.fromHsv(_1fc.hue,s,l),"monochromatic").colors;}else{if(_1fc.generator){this.colors=dojox.color.Palette.generate(_1fc.base,_1fc.generator).colors;}}}},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}this._current.marker=0;},_clone:function(){return new dxc.Theme({chart:this.chart,plotarea:this.plotarea,axis:this.axis,series:this.series,marker:this.marker,antiAlias:this.antiAlias,assignColors:this.assignColors,assignMarkers:this.assigneMarkers,colors:dojo.delegate(this.colors)});},addMarker:function(name,_206){this.markers[name]=_206;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},next:function(type){if(type=="marker"){return this._markers[this._current.marker++%this._markers.length];}else{return this.colors[this._current.color++%this.colors.length];}},clear:function(){this._current={color:0,marker:0};}});})();}if(!dojo._hasResource["dojox.charting.Element"]){dojo._hasResource["dojox.charting.Element"]=true;dojo.provide("dojox.charting.Element");dojo.declare("dojox.charting.Element",null,{constructor:function(_209){this.chart=_209;this.group=null;this.htmlElements=[];this.dirty=true;},createGroup:function(_20a){if(!_20a){_20a=this.chart.surface;}if(!this.group){this.group=_20a.createGroup();}return this;},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.group.clear();this.group.removeShape();this.group=null;}this.dirty=true;return this;},cleanGroup:function(_20b){this.destroyHtmlElements();if(!_20b){_20b=this.chart.surface;}if(this.group){this.group.clear();}else{this.group=_20b.createGroup();}this.dirty=true;return this;},destroyHtmlElements:function(){if(this.htmlElements.length){dojo.forEach(this.htmlElements,dojo.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();}});}if(!dojo._hasResource["dojox.charting.Series"]){dojo._hasResource["dojox.charting.Series"]=true;dojo.provide("dojox.charting.Series");dojo.declare("dojox.charting.Series",dojox.charting.Element,{constructor:function(_20c,data,_20e){dojo.mixin(this,_20e);if(typeof this.plot!="string"){this.plot="default";}this.data=data;this.dirty=true;this.clear();},clear:function(){this.dyn={};}});}if(!dojo._hasResource["dojox.charting.scaler.common"]){dojo._hasResource["dojox.charting.scaler.common"]=true;dojo.provide("dojox.charting.scaler.common");(function(){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};dojo.mixin(dojox.charting.scaler.common,{findString:function(val,text){val=val.toLowerCase();for(var i=0;i<text.length;++i){if(val==text[i]){return true;}}return false;},getNumericLabel:function(_215,_216,_217){var def=_217.fixed?_215.toFixed(_216<0?-_216:0):_215.toString();if(_217.labelFunc){var r=_217.labelFunc(def,_215,_216);if(r){return r;}}if(_217.labels){var l=_217.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_215){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_215)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_215)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_215)){return l[lo].text;}}return def;}});})();}if(!dojo._hasResource["dojox.charting.scaler.linear"]){dojo._hasResource["dojox.charting.scaler.linear"]=true;dojo.provide("dojox.charting.scaler.linear");(function(){var _21f=3,dc=dojox.charting,dcs=dc.scaler,dcsc=dcs.common,_223=dcsc.findString,_224=dcsc.getNumericLabel;var _225=function(min,max,_228,_229,_22a,_22b,span){_228=dojo.delegate(_228);if(!_229){if(_228.fixUpper=="major"){_228.fixUpper="minor";}if(_228.fixLower=="major"){_228.fixLower="minor";}}if(!_22a){if(_228.fixUpper=="minor"){_228.fixUpper="micro";}if(_228.fixLower=="minor"){_228.fixLower="micro";}}if(!_22b){if(_228.fixUpper=="micro"){_228.fixUpper="none";}if(_228.fixLower=="micro"){_228.fixLower="none";}}var _22d=_223(_228.fixLower,["major"])?Math.floor(_228.min/_229)*_229:_223(_228.fixLower,["minor"])?Math.floor(_228.min/_22a)*_22a:_223(_228.fixLower,["micro"])?Math.floor(_228.min/_22b)*_22b:_228.min,_22e=_223(_228.fixUpper,["major"])?Math.ceil(_228.max/_229)*_229:_223(_228.fixUpper,["minor"])?Math.ceil(_228.max/_22a)*_22a:_223(_228.fixUpper,["micro"])?Math.ceil(_228.max/_22b)*_22b:_228.max;if(_228.useMin){min=_22d;}if(_228.useMax){max=_22e;}var _22f=(!_229||_228.useMin&&_223(_228.fixLower,["major"]))?min:Math.ceil(min/_229)*_229,_230=(!_22a||_228.useMin&&_223(_228.fixLower,["major","minor"]))?min:Math.ceil(min/_22a)*_22a,_231=(!_22b||_228.useMin&&_223(_228.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_22b)*_22b,_232=!_229?0:(_228.useMax&&_223(_228.fixUpper,["major"])?Math.round((max-_22f)/_229):Math.floor((max-_22f)/_229))+1,_233=!_22a?0:(_228.useMax&&_223(_228.fixUpper,["major","minor"])?Math.round((max-_230)/_22a):Math.floor((max-_230)/_22a))+1,_234=!_22b?0:(_228.useMax&&_223(_228.fixUpper,["major","minor","micro"])?Math.round((max-_231)/_22b):Math.floor((max-_231)/_22b))+1,_235=_22a?Math.round(_229/_22a):0,_236=_22b?Math.round(_22a/_22b):0,_237=_229?Math.floor(Math.log(_229)/Math.LN10):0,_238=_22a?Math.floor(Math.log(_22a)/Math.LN10):0,_239=span/(max-min);if(!isFinite(_239)){_239=1;}return {bounds:{lower:_22d,upper:_22e,from:min,to:max,scale:_239,span:span},major:{tick:_229,start:_22f,count:_232,prec:_237},minor:{tick:_22a,start:_230,count:_233,prec:_238},micro:{tick:_22b,start:_231,count:_234,prec:0},minorPerMajor:_235,microPerMinor:_236,scaler:dcs.linear};};dojo.mixin(dojox.charting.scaler.linear,{buildScaler:function(min,max,span,_23d){var h={fixUpper:"none",fixLower:"none",natural:false};if(_23d){if("fixUpper" in _23d){h.fixUpper=String(_23d.fixUpper);}if("fixLower" in _23d){h.fixLower=String(_23d.fixLower);}if("natural" in _23d){h.natural=Boolean(_23d.natural);}}if("min" in _23d){min=_23d.min;}if("max" in _23d){max=_23d.max;}if(_23d.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _23d){min=_23d.from;h.useMin=false;}if("to" in _23d){max=_23d.to;h.useMax=false;}if(max<=min){return _225(min,max,h,0,0,0,span);}var mag=Math.floor(Math.log(max-min)/Math.LN10),_240=_23d&&("majorTickStep" in _23d)?_23d.majorTickStep:Math.pow(10,mag),_241=0,_242=0,_243;if(_23d&&("minorTickStep" in _23d)){_241=_23d.minorTickStep;}else{do{_241=_240/10;if(!h.natural||_241>0.9){_243=_225(min,max,h,_240,_241,0,span);if(_243.bounds.scale*_243.minor.tick>_21f){break;}}_241=_240/5;if(!h.natural||_241>0.9){_243=_225(min,max,h,_240,_241,0,span);if(_243.bounds.scale*_243.minor.tick>_21f){break;}}_241=_240/2;if(!h.natural||_241>0.9){_243=_225(min,max,h,_240,_241,0,span);if(_243.bounds.scale*_243.minor.tick>_21f){break;}}return _225(min,max,h,_240,0,0,span);}while(false);}if(_23d&&("microTickStep" in _23d)){_242=_23d.microTickStep;_243=_225(min,max,h,_240,_241,_242,span);}else{do{_242=_241/10;if(!h.natural||_242>0.9){_243=_225(min,max,h,_240,_241,_242,span);if(_243.bounds.scale*_243.micro.tick>_21f){break;}}_242=_241/5;if(!h.natural||_242>0.9){_243=_225(min,max,h,_240,_241,_242,span);if(_243.bounds.scale*_243.micro.tick>_21f){break;}}_242=_241/2;if(!h.natural||_242>0.9){_243=_225(min,max,h,_240,_241,_242,span);if(_243.bounds.scale*_243.micro.tick>_21f){break;}}_242=0;}while(false);}return _242?_243:_225(min,max,h,_240,_241,0,span);},buildTicks:function(_244,_245){var step,next,tick,_249=_244.major.start,_24a=_244.minor.start,_24b=_244.micro.start;if(_245.microTicks&&_244.micro.tick){step=_244.micro.tick,next=_24b;}else{if(_245.minorTicks&&_244.minor.tick){step=_244.minor.tick,next=_24a;}else{if(_244.major.tick){step=_244.major.tick,next=_249;}else{return null;}}}var _24c=1/_244.bounds.scale;if(_244.bounds.to<=_244.bounds.from||isNaN(_24c)||!isFinite(_24c)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _24d=[],_24e=[],_24f=[];while(next<=_244.bounds.to+_24c){if(Math.abs(_249-next)<step/2){tick={value:_249};if(_245.majorLabels){tick.label=_224(_249,_244.major.prec,_245);}_24d.push(tick);_249+=_244.major.tick;_24a+=_244.minor.tick;_24b+=_244.micro.tick;}else{if(Math.abs(_24a-next)<step/2){if(_245.minorTicks){tick={value:_24a};if(_245.minorLabels&&(_244.minMinorStep<=_244.minor.tick*_244.bounds.scale)){tick.label=_224(_24a,_244.minor.prec,_245);}_24e.push(tick);}_24a+=_244.minor.tick;_24b+=_244.micro.tick;}else{if(_245.microTicks){_24f.push({value:_24b});}_24b+=_244.micro.tick;}}next+=step;}return {major:_24d,minor:_24e,micro:_24f};},getTransformerFromModel:function(_250){var _251=_250.bounds.from,_252=_250.bounds.scale;return function(x){return (x-_251)*_252;};},getTransformerFromPlot:function(_254){var _255=_254.bounds.from,_256=_254.bounds.scale;return function(x){return x/_256+_255;};}});})();}if(!dojo._hasResource["dojox.charting.axis2d.common"]){dojo._hasResource["dojox.charting.axis2d.common"]=true;dojo.provide("dojox.charting.axis2d.common");(function(){var g=dojox.gfx;function _259(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};dojo.mixin(dojox.charting.axis2d.common,{createText:{gfx:function(_25b,_25c,x,y,_25f,text,font,_262){return _25c.createText({x:x,y:y,text:text,align:_25f}).setFont(font).setFill(_262);},html:function(_263,_264,x,y,_267,text,font,_26a){var p=dojo.doc.createElement("div"),s=p.style;_259(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_26a;s.position="absolute";s.left="-10000px";dojo.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size),box=dojo.marginBox(p);dojo.body().removeChild(p);s.position="relative";switch(_267){case "middle":s.left=Math.floor(x-box.w/2)+"px";break;case "end":s.left=Math.floor(x-box.w)+"px";break;default:s.left=Math.floor(x)+"px";break;}s.top=Math.floor(y-size)+"px";var wrap=dojo.doc.createElement("div"),w=wrap.style;_259(w);w.width="0px";w.height="0px";wrap.appendChild(p);_263.node.insertBefore(wrap,_263.node.firstChild);return wrap;}}});})();}if(!dojo._hasResource["dojox.charting.axis2d.Base"]){dojo._hasResource["dojox.charting.axis2d.Base"]=true;dojo.provide("dojox.charting.axis2d.Base");dojo.declare("dojox.charting.axis2d.Base",dojox.charting.Element,{constructor:function(_271,_272){this.vertical=_272&&_272.vertical;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_277){return this;}});}if(!dojo._hasResource["dojox.lang.utils"]){dojo._hasResource["dojox.lang.utils"]=true;dojo.provide("dojox.lang.utils");(function(){var _278={},du=dojox.lang.utils;var _27a=function(o){if(dojo.isArray(o)){return dojo._toArray(o);}if(!dojo.isObject(o)||dojo.isFunction(o)){return o;}return dojo.delegate(o);};dojo.mixin(du,{coerceType:function(_27c,_27d){switch(typeof _27c){case "number":return Number(eval("("+_27d+")"));case "string":return String(_27d);case "boolean":return Boolean(eval("("+_27d+")"));}return eval("("+_27d+")");},updateWithObject:function(_27e,_27f,conv){if(!_27f){return _27e;}for(var x in _27e){if(x in _27f&&!(x in _278)){var t=_27e[x];if(t&&typeof t=="object"){du.updateWithObject(t,_27f[x],conv);}else{_27e[x]=conv?du.coerceType(t,_27f[x]):_27a(_27f[x]);}}}return _27e;},updateWithPattern:function(_283,_284,_285,conv){if(!_284||!_285){return _283;}for(var x in _285){if(x in _284&&!(x in _278)){_283[x]=conv?du.coerceType(_285[x],_284[x]):_27a(_284[x]);}}return _283;}});})();}if(!dojo._hasResource["dojox.charting.axis2d.Default"]){dojo._hasResource["dojox.charting.axis2d.Default"]=true;dojo.provide("dojox.charting.axis2d.Default");(function(){var dc=dojox.charting,df=dojox.lang.functional,du=dojox.lang.utils,g=dojox.gfx,lin=dc.scaler.linear,_28d=4;dojo.declare("dojox.charting.axis2d.Default",dojox.charting.axis2d.Base,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,htmlLabels:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,stroke:{},majorTick:{},minorTick:{},microTick:{},font:"",fontColor:""},constructor:function(_28e,_28f){this.opt=dojo.delegate(this.defaultParams,_28f);du.updateWithPattern(this.opt,_28f,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_290,_291){this.scale=_290;this.offset=_291;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},calculate:function(min,max,span,_295){if(this.initialized()){return this;}this.labels="labels" in this.opt?this.opt.labels:_295;this.scaler=lin.buildScaler(min,max,span,this.opt);if("scale" in this){this.opt.from=this.scaler.bounds.lower+this.offset;this.opt.to=(this.scaler.bounds.upper-this.scaler.bounds.lower)/this.scale+this.opt.from;if(!isFinite(this.opt.from)||isNaN(this.opt.from)||!isFinite(this.opt.to)||isNaN(this.opt.to)||this.opt.to-this.opt.from>=this.scaler.bounds.upper-this.scaler.bounds.lower){delete this.opt.from;delete this.opt.to;delete this.scale;delete this.offset;}else{if(this.opt.from<this.scaler.bounds.lower){this.opt.to+=this.scaler.bounds.lower-this.opt.from;this.opt.from=this.scaler.bounds.lower;}else{if(this.opt.to>this.scaler.bounds.upper){this.opt.from+=this.scaler.bounds.upper-this.opt.to;this.opt.to=this.scaler.bounds.upper;}}this.offset=this.opt.from-this.scaler.bounds.lower;}this.scaler=lin.buildScaler(min,max,span,this.opt);if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}var _296=0,ta=this.chart.theme.axis,_298="font" in this.opt?this.opt.font:ta.font,size=_298?g.normalizedLength(g.splitFontString(_298).size):0;if(this.vertical){if(size){_296=size+_28d;}}else{if(size){var _29a,i;if(this.opt.labelFunc&&this.opt.maxLabelSize){_29a=this.opt.maxLabelSize;}else{if(this.labels){_29a=df.foldl(df.map(this.labels,function(_29c){return dojox.gfx._base._getTextBox(_29c.text,{font:_298}).w;}),"Math.max(a, b)",0);}else{var _29d=Math.ceil(Math.log(Math.max(Math.abs(this.scaler.bounds.from),Math.abs(this.scaler.bounds.to)))/Math.LN10),t=[];if(this.scaler.bounds.from<0||this.scaler.bounds.to<0){t.push("-");}t.push(dojo.string.rep("9",_29d));var _29f=Math.floor(Math.log(this.scaler.bounds.to-this.scaler.bounds.from)/Math.LN10);if(_29f>0){t.push(".");for(i=0;i<_29f;++i){t.push("9");}}_29a=dojox.gfx._base._getTextBox(t.join(""),{font:_298}).w;}}_296=_29a+_28d;}}this.scaler.minMinorStep=_296;this.ticks=lin.buildTicks(this.scaler,this.opt);return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;},getOffsets:function(){var _2a0={l:0,r:0,t:0,b:0},_2a1,a,b,c,d,gtb=dojox.gfx._base._getTextBox,gl=dc.scaler.common.getNumericLabel,_2a8=0,ta=this.chart.theme.axis,_2aa="font" in this.opt?this.opt.font:ta.font,_2ab="majorTick" in this.opt?this.opt.majorTick:ta.majorTick,_2ac="minorTick" in this.opt?this.opt.minorTick:ta.minorTick,size=_2aa?g.normalizedLength(g.splitFontString(_2aa).size):0,s=this.scaler;if(!s){return _2a0;}if(this.vertical){if(size){if(this.opt.labelFunc&&this.opt.maxLabelSize){_2a1=this.opt.maxLabelSize;}else{if(this.labels){_2a1=df.foldl(df.map(this.labels,function(_2af){return dojox.gfx._base._getTextBox(_2af.text,{font:_2aa}).w;}),"Math.max(a, b)",0);}else{a=gtb(gl(s.major.start,s.major.prec,this.opt),{font:_2aa}).w;b=gtb(gl(s.major.start+s.major.count*s.major.tick,s.major.prec,this.opt),{font:_2aa}).w;c=gtb(gl(s.minor.start,s.minor.prec,this.opt),{font:_2aa}).w;d=gtb(gl(s.minor.start+s.minor.count*s.minor.tick,s.minor.prec,this.opt),{font:_2aa}).w;_2a1=Math.max(a,b,c,d);}}_2a8=_2a1+_28d;}_2a8+=_28d+Math.max(_2ab.length,_2ac.length);_2a0[this.opt.leftBottom?"l":"r"]=_2a8;_2a0.t=_2a0.b=size/2;}else{if(size){_2a8=size+_28d;}_2a8+=_28d+Math.max(_2ab.length,_2ac.length);_2a0[this.opt.leftBottom?"b":"t"]=_2a8;if(size){if(this.opt.labelFunc&&this.opt.maxLabelSize){_2a1=this.opt.maxLabelSize;}else{if(this.labels){_2a1=df.foldl(df.map(this.labels,function(_2b0){return dojox.gfx._base._getTextBox(_2b0.text,{font:_2aa}).w;}),"Math.max(a, b)",0);}else{a=gtb(gl(s.major.start,s.major.prec,this.opt),{font:_2aa}).w;b=gtb(gl(s.major.start+s.major.count*s.major.tick,s.major.prec,this.opt),{font:_2aa}).w;c=gtb(gl(s.minor.start,s.minor.prec,this.opt),{font:_2aa}).w;d=gtb(gl(s.minor.start+s.minor.count*s.minor.tick,s.minor.prec,this.opt),{font:_2aa}).w;_2a1=Math.max(a,b,c,d);}}_2a0.l=_2a0.r=_2a1/2;}}return _2a0;},render:function(dim,_2b2){if(!this.dirty){return this;}var _2b3,stop,_2b5,_2b6,_2b7,_2b8,ta=this.chart.theme.axis,_2ba="stroke" in this.opt?this.opt.stroke:ta.stroke,_2bb="majorTick" in this.opt?this.opt.majorTick:ta.majorTick,_2bc="minorTick" in this.opt?this.opt.minorTick:ta.minorTick,_2bd="microTick" in this.opt?this.opt.microTick:ta.minorTick,_2be="font" in this.opt?this.opt.font:ta.font,_2bf="fontColor" in this.opt?this.opt.fontColor:ta.fontColor,_2c0=Math.max(_2bb.length,_2bc.length),size=_2be?g.normalizedLength(g.splitFontString(_2be).size):0;if(this.vertical){_2b3={y:dim.height-_2b2.b};stop={y:_2b2.t};_2b5={x:0,y:-1};if(this.opt.leftBottom){_2b3.x=stop.x=_2b2.l;_2b6={x:-1,y:0};_2b8="end";}else{_2b3.x=stop.x=dim.width-_2b2.r;_2b6={x:1,y:0};_2b8="start";}_2b7={x:_2b6.x*(_2c0+_28d),y:size*0.4};}else{_2b3={x:_2b2.l};stop={x:dim.width-_2b2.r};_2b5={x:1,y:0};_2b8="middle";if(this.opt.leftBottom){_2b3.y=stop.y=dim.height-_2b2.b;_2b6={x:0,y:1};_2b7={y:_2c0+_28d+size};}else{_2b3.y=stop.y=_2b2.t;_2b6={x:0,y:-1};_2b7={y:-_2c0-_28d};}_2b7.x=0;}this.cleanGroup();try{var s=this.group,c=this.scaler,t=this.ticks,_2c5,f=lin.getTransformerFromModel(this.scaler),_2c7=dojox.gfx.renderer=="canvas",_2c8=_2c7||this.opt.htmlLabels&&!dojo.isIE&&!dojo.isOpera?"html":"gfx",dx=_2b6.x*_2bb.length,dy=_2b6.y*_2bb.length;s.createLine({x1:_2b3.x,y1:_2b3.y,x2:stop.x,y2:stop.y}).setStroke(_2ba);dojo.forEach(t.major,function(tick){var _2cc=f(tick.value),elem,x=_2b3.x+_2b5.x*_2cc,y=_2b3.y+_2b5.y*_2cc;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_2bb);if(tick.label){elem=dc.axis2d.common.createText[_2c8](this.chart,s,x+_2b7.x,y+_2b7.y,_2b8,tick.label,_2be,_2bf);if(_2c8=="html"){this.htmlElements.push(elem);}}},this);dx=_2b6.x*_2bc.length;dy=_2b6.y*_2bc.length;_2c5=c.minMinorStep<=c.minor.tick*c.bounds.scale;dojo.forEach(t.minor,function(tick){var _2d1=f(tick.value),elem,x=_2b3.x+_2b5.x*_2d1,y=_2b3.y+_2b5.y*_2d1;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_2bc);if(_2c5&&tick.label){elem=dc.axis2d.common.createText[_2c8](this.chart,s,x+_2b7.x,y+_2b7.y,_2b8,tick.label,_2be,_2bf);if(_2c8=="html"){this.htmlElements.push(elem);}}},this);dx=_2b6.x*_2bd.length;dy=_2b6.y*_2bd.length;dojo.forEach(t.micro,function(tick){var _2d6=f(tick.value),elem,x=_2b3.x+_2b5.x*_2d6,y=_2b3.y+_2b5.y*_2d6;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_2bd);},this);}catch(e){}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.common"]){dojo._hasResource["dojox.charting.plot2d.common"]=true;dojo.provide("dojox.charting.plot2d.common");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common;dojo.mixin(dojox.charting.plot2d.common,{makeStroke:function(_2dc){if(!_2dc){return _2dc;}if(typeof _2dc=="string"||_2dc instanceof dojo.Color){_2dc={color:_2dc};}return dojox.gfx.makeParameters(dojox.gfx.defaultStroke,_2dc);},augmentColor:function(_2dd,_2de){var t=new dojo.Color(_2dd),c=new dojo.Color(_2de);c.a=t.a;return c;},augmentStroke:function(_2e1,_2e2){var s=dc.makeStroke(_2e1);if(s){s.color=dc.augmentColor(s.color,_2e2);}return s;},augmentFill:function(fill,_2e5){var fc,c=new dojo.Color(_2e5);if(typeof fill=="string"||fill instanceof dojo.Color){return dc.augmentColor(fill,_2e5);}return fill;},defaultStats:{hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY,vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_2e8){var _2e9=dojo.clone(dc.defaultStats);for(var i=0;i<_2e8.length;++i){var run=_2e8[i];if(!run.data.length){continue;}if(typeof run.data[0]=="number"){var _2ec=_2e9.vmin,_2ed=_2e9.vmax;if(!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,i){var x=i+1,y=val;if(isNaN(y)){y=0;}_2e9.hmin=Math.min(_2e9.hmin,x);_2e9.hmax=Math.max(_2e9.hmax,x);_2e9.vmin=Math.min(_2e9.vmin,y);_2e9.vmax=Math.max(_2e9.vmax,y);});}if("ymin" in run){_2e9.vmin=Math.min(_2ec,run.ymin);}if("ymax" in run){_2e9.vmax=Math.max(_2ed,run.ymax);}}else{var _2f2=_2e9.hmin,_2f3=_2e9.hmax,_2ec=_2e9.vmin,_2ed=_2e9.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,i){var x=val.x,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_2e9.hmin=Math.min(_2e9.hmin,x);_2e9.hmax=Math.max(_2e9.hmax,x);_2e9.vmin=Math.min(_2e9.vmin,y);_2e9.vmax=Math.max(_2e9.vmax,y);});}if("xmin" in run){_2e9.hmin=Math.min(_2f2,run.xmin);}if("xmax" in run){_2e9.hmax=Math.max(_2f3,run.xmax);}if("ymin" in run){_2e9.vmin=Math.min(_2ec,run.ymin);}if("ymax" in run){_2e9.vmax=Math.max(_2ed,run.ymax);}}}return _2e9;},calculateBarSize:function(_2f8,opt,_2fa){if(!_2fa){_2fa=1;}var gap=opt.gap,size=(_2f8-2*gap)/_2fa;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_2f8-size*_2fa)/2;return {size:size,gap:gap};},collectStackedStats:function(_2fd){var _2fe=dojo.clone(dc.defaultStats);if(_2fd.length){_2fe.hmin=Math.min(_2fe.hmin,1);_2fe.hmax=df.foldl(_2fd,"seed, run -> Math.max(seed, run.data.length)",_2fe.hmax);for(var i=0;i<_2fe.hmax;++i){var v=_2fd[0].data[i];if(isNaN(v)){v=0;}_2fe.vmin=Math.min(_2fe.vmin,v);for(var j=1;j<_2fd.length;++j){var t=_2fd[j].data[i];if(isNaN(t)){t=0;}v+=t;}_2fe.vmax=Math.max(_2fe.vmax,v);}}return _2fe;},curve:function(a,_304){var arr=a.slice(0);if(_304=="x"){arr[arr.length]=arr[0];}var p=dojo.map(arr,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_304)){var dx=item.x-arr[i-1].x,dy=arr[i-1].y;return "C"+(item.x-(_304-1)*(dx/_304))+","+dy+" "+(item.x-(dx/_304))+","+item.y+" "+item.x+","+item.y;}else{if(_304=="X"||_304=="x"||_304=="S"){var p0,p1=arr[i-1],p2=arr[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_304=="x"){p0=arr[arr.length-2];}else{p0=p1;}f=1/3;}else{p0=arr[i-2];}if(i==(arr.length-1)){if(_304=="x"){p3=arr[1];}else{p3=p2;}f=1/3;}else{p3=arr[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _317=p0p2*f;var _318=p1p3*f;if(_317>p1p2/2&&_318>p1p2/2){_317=p1p2/2;_318=p1p2/2;}else{if(_317>p1p2/2){_317=p1p2/2;_318=p1p2/2*p1p3/p0p2;}else{if(_318>p1p2/2){_318=p1p2/2;_317=p1p2/2*p0p2/p1p3;}}}if(_304=="S"){if(p0==p1){_317=0;}if(p2==p3){_318=0;}}bz1x=p1.x+_317*(p2.x-p0.x)/p0p2;bz1y=p1.y+_317*(p2.y-p0.y)/p0p2;bz2x=p2.x-_318*(p3.x-p1.x)/p1p3;bz2y=p2.y-_318*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");}});})();}if(!dojo._hasResource["dojox.charting.scaler.primitive"]){dojo._hasResource["dojox.charting.scaler.primitive"]=true;dojo.provide("dojox.charting.scaler.primitive");dojox.charting.scaler.primitive={buildScaler:function(min,max,span,_31c){return {bounds:{lower:min,upper:max,from:min,to:max,scale:span/(max-min),span:span},scaler:dojox.charting.scaler.primitive};},buildTicks:function(_31d,_31e){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_31f){var _320=_31f.bounds.from,_321=_31f.bounds.scale;return function(x){return (x-_320)*_321;};},getTransformerFromPlot:function(_323){var _324=_323.bounds.from,_325=_323.bounds.scale;return function(x){return x/_325+_324;};}};}if(!dojo._hasResource["dojox.charting.plot2d.Base"]){dojo._hasResource["dojox.charting.plot2d.Base"]=true;dojo.provide("dojox.charting.plot2d.Base");dojo.declare("dojox.charting.plot2d.Base",dojox.charting.Element,{destroy:function(){this.resetEvents();this.inherited(arguments);},clear:function(){this.series=[];this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},addSeries:function(run){this.series.push(run);return this;},calculateAxes:function(dim){return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},render:function(dim,_32b){return this;},getRequiredColors:function(){return this.series.length;},plotEvent:function(o){},connect:function(_32d,_32e){this.dirty=true;return dojo.connect(this,"plotEvent",_32d,_32e);},events:function(){var ls=this.plotEvent._listeners;if(!ls||!ls.length){return false;}for(var i in ls){if(!(i in Array.prototype)){return true;}}return false;},resetEvents:function(){this.plotEvent({type:"onplotreset",plot:this});},_calc:function(dim,_332){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_332.hmin,_332.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=dojox.charting.scaler.primitive.buildScaler(_332.hmin,_332.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_332.vmin,_332.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=dojox.charting.scaler.primitive.buildScaler(_332.vmin,_332.vmax,dim.height);}},_connectEvents:function(_333,o){_333.connect("onmouseover",this,function(e){o.type="onmouseover";o.event=e;this.plotEvent(o);});_333.connect("onmouseout",this,function(e){o.type="onmouseout";o.event=e;this.plotEvent(o);});_333.connect("onclick",this,function(e){o.type="onclick";o.event=e;this.plotEvent(o);});}});}if(!dojo._hasResource["dojox.charting.plot2d.Default"]){dojo._hasResource["dojox.charting.plot2d.Default"]=true;dojo.provide("dojox.charting.plot2d.Default");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_33b=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Default",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",lines:true,areas:false,markers:false,shadows:0,tension:0},optionalParams:{},constructor:function(_33c,_33d){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_33d);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},calculateAxes:function(dim){this._calc(dim,dc.collectSimpleStats(this.series));return this;},render:function(dim,_340){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_33b);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_344,_345,_346,_347,_348=this.events();this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;continue;}var s=run.group,_34b,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);if(typeof run.data[0]=="number"){_34b=dojo.map(run.data,function(v,i){return {x:ht(i+1)+_340.l,y:dim.height-_340.b-vt(v)};},this);}else{_34b=dojo.map(run.data,function(v,i){return {x:ht(v.x)+_340.l,y:dim.height-_340.b-vt(v.y)};},this);}if(!run.fill||!run.stroke){_346=run.dyn.color=new dojo.Color(t.next("color"));}var _352=this.opt.tension?dc.curve(_34b,this.opt.tension):"";if(this.opt.areas){var fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_346);var _354=dojo.clone(_34b);if(this.opt.tension){var _355="L"+_354[_354.length-1].x+","+(dim.height-_340.b)+" L"+_354[0].x+","+(dim.height-_340.b)+" L"+_354[0].x+","+_354[0].y;run.dyn.fill=s.createPath(_352+" "+_355).setFill(fill).getFill();}else{_354.push({x:_34b[_34b.length-1].x,y:dim.height-_340.b});_354.push({x:_34b[0].x,y:dim.height-_340.b});_354.push(_34b[0]);run.dyn.fill=s.createPolyline(_354).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_344=run.stroke?dc.makeStroke(run.stroke):dc.augmentStroke(t.series.stroke,_346);if(run.outline||t.series.outline){_345=dc.makeStroke(run.outline?run.outline:t.series.outline);_345.width=2*_345.width+_344.width;}}if(this.opt.markers){_347=run.dyn.marker=run.marker?run.marker:t.next("marker");}var _356=null,_357=null,_358=null;if(this.opt.shadows&&_344){var sh=this.opt.shadows,_35a=new dojo.Color([0,0,0,0.3]),_35b=dojo.map(_34b,function(c){return {x:c.x+sh.dx,y:c.y+sh.dy};}),_35d=dojo.clone(_345?_345:_344);_35d.color=_35a;_35d.width+=sh.dw?sh.dw:0;if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_35b,this.opt.tension)).setStroke(_35d).getStroke();}else{run.dyn.shadow=s.createPolyline(_35b).setStroke(_35d).getStroke();}}if(this.opt.markers){_358=dojo.map(_35b,function(c){return s.createPath("M"+c.x+" "+c.y+" "+_347).setStroke(_35d).setFill(_35a);},this);}}if(this.opt.lines){if(_345){if(this.opt.tension){run.dyn.outline=s.createPath(_352).setStroke(_345).getStroke();}else{run.dyn.outline=s.createPolyline(_34b).setStroke(_345).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_352).setStroke(_344).getStroke();}else{run.dyn.stroke=s.createPolyline(_34b).setStroke(_344).getStroke();}}if(this.opt.markers){_356=new Array(_34b.length);_357=new Array(_34b.length);dojo.forEach(_34b,function(c,i){var path="M"+c.x+" "+c.y+" "+_347;if(_345){_357[i]=s.createPath(path).setStroke(_345);}_356[i]=s.createPath(path).setStroke(_344).setFill(_344.color);},this);if(_348){dojo.forEach(_356,function(s,i){var o={element:"marker",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:s,outline:_357[i]||null,shadow:_358&&_358[i]||null,cx:_34b[i].x,cy:_34b[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(s,o);},this);}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Lines"]){dojo._hasResource["dojox.charting.plot2d.Lines"]=true;dojo.provide("dojox.charting.plot2d.Lines");dojo.declare("dojox.charting.plot2d.Lines",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Areas"]){dojo._hasResource["dojox.charting.plot2d.Areas"]=true;dojo.provide("dojox.charting.plot2d.Areas");dojo.declare("dojox.charting.plot2d.Areas",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Markers"]){dojo._hasResource["dojox.charting.plot2d.Markers"]=true;dojo.provide("dojox.charting.plot2d.Markers");dojo.declare("dojox.charting.plot2d.Markers",dojox.charting.plot2d.Default,{constructor:function(){this.opt.markers=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.MarkersOnly"]){dojo._hasResource["dojox.charting.plot2d.MarkersOnly"]=true;dojo.provide("dojox.charting.plot2d.MarkersOnly");dojo.declare("dojox.charting.plot2d.MarkersOnly",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Scatter"]){dojo._hasResource["dojox.charting.plot2d.Scatter"]=true;dojo.provide("dojox.charting.plot2d.Scatter");dojo.declare("dojox.charting.plot2d.Scatter",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});}if(!dojo._hasResource["dojox.lang.functional.sequence"]){dojo._hasResource["dojox.lang.functional.sequence"]=true;dojo.provide("dojox.lang.functional.sequence");(function(){var d=dojo,df=dojox.lang.functional;d.mixin(df,{repeat:function(n,f,z,o){o=o||d.global;f=df.lambda(f);var t=new Array(n),i=1;t[0]=z;for(;i<n;t[i]=z=f.call(o,z),++i){}return t;},until:function(pr,f,z,o){o=o||d.global;f=df.lambda(f);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(z),z=f.call(o,z)){}return t;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Stacked"]){dojo._hasResource["dojox.charting.plot2d.Stacked"]=true;dojo.provide("dojox.charting.plot2d.Stacked");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_374=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Stacked",dojox.charting.plot2d.Default,{calculateAxes:function(dim){var _376=dc.collectStackedStats(this.series);this._maxRunLength=_376.hmax;this._calc(dim,_376);return this;},render:function(dim,_378){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]+=v;}}this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_374);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_381,_382,_383,_384,_385=this.events(),ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group,_388=dojo.map(acc,function(v,i){return {x:ht(i+1)+_378.l,y:dim.height-_378.b-vt(v)};},this);if(!run.fill||!run.stroke){_383=new dojo.Color(t.next("color"));}var _38b=this.opt.tension?dc.curve(_388,this.opt.tension):"";if(this.opt.areas){var _38c=dojo.clone(_388);var fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_383);if(this.opt.tension){var p=dc.curve(_38c,this.opt.tension);p+=" L"+_388[_388.length-1].x+","+(dim.height-_378.b)+" L"+_388[0].x+","+(dim.height-_378.b)+" L"+_388[0].x+","+_388[0].y;run.dyn.fill=s.createPath(p).setFill(fill).getFill();}else{_38c.push({x:_388[_388.length-1].x,y:dim.height-_378.b});_38c.push({x:_388[0].x,y:dim.height-_378.b});_38c.push(_388[0]);run.dyn.fill=s.createPolyline(_38c).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_381=run.stroke?dc.makeStroke(run.stroke):dc.augmentStroke(t.series.stroke,_383);if(run.outline||t.series.outline){_382=dc.makeStroke(run.outline?run.outline:t.series.outline);_382.width=2*_382.width+_381.width;}}if(this.opt.markers){_384=run.dyn.marker=run.marker?run.marker:t.next("marker");}var _38f,_390,_391;if(this.opt.shadows&&_381){var sh=this.opt.shadows,_393=new dojo.Color([0,0,0,0.3]),_394=dojo.map(_388,function(c){return {x:c.x+sh.dx,y:c.y+sh.dy};}),_396=dojo.clone(_382?_382:_381);_396.color=_393;_396.width+=sh.dw?sh.dw:0;if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_394,this.opt.tension)).setStroke(_396).getStroke();}else{run.dyn.shadow=s.createPolyline(_394).setStroke(_396).getStroke();}}if(this.opt.markers){_391=dojo.map(_394,function(c){return s.createPath("M"+c.x+" "+c.y+" "+_384).setStroke(_396).setFill(_393);},this);}}if(this.opt.lines){if(_382){if(this.opt.tension){run.dyn.outline=s.createPath(_38b).setStroke(_382).getStroke();}else{run.dyn.outline=s.createPolyline(_388).setStroke(_382).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_38b).setStroke(_381).getStroke();}else{run.dyn.stroke=s.createPolyline(_388).setStroke(_381).getStroke();}}if(this.opt.markers){_38f=new Array(_388.length);_390=new Array(_388.length);dojo.forEach(_388,function(c,i){var path="M"+c.x+" "+c.y+" "+_384;if(_382){_390[i]=s.createPath(path).setStroke(_382);}_38f[i]=s.createPath(path).setStroke(_381).setFill(_381.color);},this);if(_385){dojo.forEach(_38f,function(s,i){var o={element:"marker",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:s,outline:_390[i]||null,shadow:_391&&_391[i]||null,cx:_388[i].x,cy:_388[i].y,x:i+1,y:run.data[i]};this._connectEvents(s,o);},this);}}run.dirty=false;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]-=v;}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedLines"]){dojo._hasResource["dojox.charting.plot2d.StackedLines"]=true;dojo.provide("dojox.charting.plot2d.StackedLines");dojo.declare("dojox.charting.plot2d.StackedLines",dojox.charting.plot2d.Stacked,{constructor:function(){this.opt.lines=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.StackedAreas"]){dojo._hasResource["dojox.charting.plot2d.StackedAreas"]=true;dojo.provide("dojox.charting.plot2d.StackedAreas");dojo.declare("dojox.charting.plot2d.StackedAreas",dojox.charting.plot2d.Stacked,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Columns"]){dojo._hasResource["dojox.charting.plot2d.Columns"]=true;dojo.provide("dojox.charting.plot2d.Columns");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_3a1=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Columns",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,shadows:null},optionalParams:{minBarSize:1,maxBarSize:1},constructor:function(_3a2,_3a3){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_3a3);du.updateWithPattern(this.opt,_3a3,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},calculateAxes:function(dim){var _3a5=dc.collectSimpleStats(this.series);_3a5.hmin-=0.5;_3a5.hmax+=0.5;this._calc(dim,_3a5);return this;},render:function(dim,_3a7){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_3a1);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_3ab,_3ac,fill,f,gap,_3b0,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3b3=Math.max(0,this._vScaler.bounds.lower),_3b4=vt(_3b3),_3b5=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_3b0=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_3ab=run.dyn.color=new dojo.Color(t.next("color"));}_3ac=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_3ab);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_3ab);for(var j=0;j<run.data.length;++j){var v=run.data[j],vv=vt(v),_3bb=vv-_3b4,h=Math.abs(_3bb);if(_3b0>=1&&h>=1){var rect={x:_3a7.l+ht(j+0.5)+gap,y:dim.height-_3a7.b-(v>_3b3?vv:_3b4),width:_3b0,height:h},_3be=s.createRect(rect).setFill(fill).setStroke(_3ac);run.dyn.fill=_3be.getFill();run.dyn.stroke=_3be.getStroke();if(_3b5){var o={element:"column",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_3be,x:j+0.5,y:v};this._connectEvents(_3be,o);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedColumns"]){dojo._hasResource["dojox.charting.plot2d.StackedColumns"]=true;dojo.provide("dojox.charting.plot2d.StackedColumns");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_3c2=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.StackedColumns",dojox.charting.plot2d.Columns,{calculateAxes:function(dim){var _3c4=dc.collectStackedStats(this.series);this._maxRunLength=_3c4.hmax;_3c4.hmin-=0.5;_3c4.hmax+=0.5;this._calc(dim,_3c4);return this;},render:function(dim,_3c6){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]+=v;}}this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_3c2);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_3cf,_3d0,fill,f,gap,_3d4,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3d7=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_3d4=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_3cf=run.dyn.color=new dojo.Color(t.next("color"));}_3d0=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_3cf);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_3cf);for(var j=0;j<acc.length;++j){var v=acc[j],_3d8=vt(v);if(_3d4>=1&&_3d8>=1){var _3d9=s.createRect({x:_3c6.l+ht(j+0.5)+gap,y:dim.height-_3c6.b-vt(v),width:_3d4,height:_3d8}).setFill(fill).setStroke(_3d0);run.dyn.fill=_3d9.getFill();run.dyn.stroke=_3d9.getStroke();if(_3d7){var o={element:"column",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_3d9,x:j+0.5,y:v};this._connectEvents(_3d9,o);}}}run.dirty=false;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]-=v;}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"]){dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"]=true;dojo.provide("dojox.charting.plot2d.ClusteredColumns");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_3dd=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.ClusteredColumns",dojox.charting.plot2d.Columns,{render:function(dim,_3df){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_3dd);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_3e3,_3e4,fill,f,gap,_3e8,_3e9,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3ec=Math.max(0,this._vScaler.bounds.lower),_3ed=vt(_3ec),_3ee=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_3e8=_3e9=f.size;this.resetEvents();for(var i=0;i<this.series.length;++i){var run=this.series[i],_3f1=_3e9*i;if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_3e3=run.dyn.color=new dojo.Color(t.next("color"));}_3e4=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_3e3);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_3e3);for(var j=0;j<run.data.length;++j){var v=run.data[j],vv=vt(v),_3f5=vv-_3ed,h=Math.abs(_3f5);if(_3e8>=1&&h>=1){var _3f7=s.createRect({x:_3df.l+ht(j+0.5)+gap+_3f1,y:dim.height-_3df.b-(v>_3ec?vv:_3ed),width:_3e8,height:h}).setFill(fill).setStroke(_3e4);run.dyn.fill=_3f7.getFill();run.dyn.stroke=_3f7.getStroke();if(_3ee){var o={element:"column",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_3f7,x:j+0.5,y:v};this._connectEvents(_3f7,o);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Bars"]){dojo._hasResource["dojox.charting.plot2d.Bars"]=true;dojo.provide("dojox.charting.plot2d.Bars");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_3fc=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Bars",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,shadows:null},optionalParams:{minBarSize:1,maxBarSize:1},constructor:function(_3fd,_3fe){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_3fe);du.updateWithPattern(this.opt,_3fe,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},calculateAxes:function(dim){var _400=dc.collectSimpleStats(this.series),t;_400.hmin-=0.5;_400.hmax+=0.5;t=_400.hmin,_400.hmin=_400.vmin,_400.vmin=t;t=_400.hmax,_400.hmax=_400.vmax,_400.vmax=t;this._calc(dim,_400);return this;},render:function(dim,_403){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_3fc);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_407,_408,fill,f,gap,_40c,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_40f=Math.max(0,this._hScaler.bounds.lower),_410=ht(_40f),_411=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_40c=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_407=run.dyn.color=new dojo.Color(t.next("color"));}_408=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_407);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_407);for(var j=0;j<run.data.length;++j){var v=run.data[j],hv=ht(v),_417=hv-_410,w=Math.abs(_417);if(w>=1&&_40c>=1){var _419=s.createRect({x:_403.l+(v<_40f?hv:_410),y:dim.height-_403.b-vt(j+1.5)+gap,width:w,height:_40c}).setFill(fill).setStroke(_408);run.dyn.fill=_419.getFill();run.dyn.stroke=_419.getStroke();if(_411){var o={element:"bar",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_419,x:v,y:j+1.5};this._connectEvents(_419,o);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedBars"]){dojo._hasResource["dojox.charting.plot2d.StackedBars"]=true;dojo.provide("dojox.charting.plot2d.StackedBars");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_41d=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.StackedBars",dojox.charting.plot2d.Bars,{calculateAxes:function(dim){var _41f=dc.collectStackedStats(this.series),t;this._maxRunLength=_41f.hmax;_41f.hmin-=0.5;_41f.hmax+=0.5;t=_41f.hmin,_41f.hmin=_41f.vmin,_41f.vmin=t;t=_41f.hmax,_41f.hmax=_41f.vmax,_41f.vmax=t;this._calc(dim,_41f);return this;},render:function(dim,_422){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]+=v;}}this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_41d);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_42b,_42c,fill,f,gap,_430,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_433=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_430=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_42b=run.dyn.color=new dojo.Color(t.next("color"));}_42c=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_42b);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_42b);for(var j=0;j<acc.length;++j){var v=acc[j],_434=ht(v);if(_434>=1&&_430>=1){var _435=s.createRect({x:_422.l,y:dim.height-_422.b-vt(j+1.5)+gap,width:_434,height:_430}).setFill(fill).setStroke(_42c);run.dyn.fill=_435.getFill();run.dyn.stroke=_435.getStroke();if(_433){var o={element:"bar",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_435,x:v,y:j+1.5};this._connectEvents(_435,o);}}}run.dirty=false;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]-=v;}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.ClusteredBars"]){dojo._hasResource["dojox.charting.plot2d.ClusteredBars"]=true;dojo.provide("dojox.charting.plot2d.ClusteredBars");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_439=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.ClusteredBars",dojox.charting.plot2d.Bars,{render:function(dim,_43b){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_439);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_43f,_440,fill,f,gap,_444,_445,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_448=Math.max(0,this._hScaler.bounds.lower),_449=ht(_448),_44a=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_444=_445=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i],_44d=_445*(this.series.length-i-1);if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_43f=run.dyn.color=new dojo.Color(t.next("color"));}_440=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_43f);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_43f);for(var j=0;j<run.data.length;++j){var v=run.data[j],hv=ht(v),_451=hv-_449,w=Math.abs(_451);if(w>=1&&_444>=1){var _453=s.createRect({x:_43b.l+(v<_448?hv:_449),y:dim.height-_43b.b-vt(j+1.5)+gap+_44d,width:w,height:_444}).setFill(fill).setStroke(_440);run.dyn.fill=_453.getFill();run.dyn.stroke=_453.getStroke();if(_44a){var o={element:"bar",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_453,x:v,y:j+1.5};this._connectEvents(_453,o);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Grid"]){dojo._hasResource["dojox.charting.plot2d.Grid"]=true;dojo.provide("dojox.charting.plot2d.Grid");(function(){var du=dojox.lang.utils;dojo.declare("dojox.charting.plot2d.Grid",dojox.charting.Element,{defaultParams:{hAxis:"x",vAxis:"y",hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:"none",vStripes:"none"},optionalParams:{},constructor:function(_456,_457){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_457);this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.dirty=true;},clear:function(){this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},addSeries:function(run){return this;},calculateAxes:function(dim){return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},getRequiredColors:function(){return 0;},render:function(dim,_45c){this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.group,ta=this.chart.theme.axis;try{var _45f=this._vAxis.getScaler(),vt=_45f.scaler.getTransformerFromModel(_45f),_461=this._vAxis.getTicks();if(this.opt.hMinorLines){dojo.forEach(_461.minor,function(tick){var y=dim.height-_45c.b-vt(tick.value);s.createLine({x1:_45c.l,y1:y,x2:dim.width-_45c.r,y2:y}).setStroke(ta.minorTick);});}if(this.opt.hMajorLines){dojo.forEach(_461.major,function(tick){var y=dim.height-_45c.b-vt(tick.value);s.createLine({x1:_45c.l,y1:y,x2:dim.width-_45c.r,y2:y}).setStroke(ta.majorTick);});}}catch(e){}try{var _466=this._hAxis.getScaler(),ht=_466.scaler.getTransformerFromModel(_466),_461=this._hAxis.getTicks();if(_461&&this.opt.vMinorLines){dojo.forEach(_461.minor,function(tick){var x=_45c.l+ht(tick.value);s.createLine({x1:x,y1:_45c.t,x2:x,y2:dim.height-_45c.b}).setStroke(ta.minorTick);});}if(_461&&this.opt.vMajorLines){dojo.forEach(_461.major,function(tick){var x=_45c.l+ht(tick.value);s.createLine({x1:x,y1:_45c.t,x2:x,y2:dim.height-_45c.b}).setStroke(ta.majorTick);});}}catch(e){}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Pie"]){dojo._hasResource["dojox.charting.plot2d.Pie"]=true;dojo.provide("dojox.charting.plot2d.Pie");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,da=dojox.charting.axis2d.common,g=dojox.gfx;dojo.declare("dojox.charting.plot2d.Pie",dojox.charting.Element,{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true},optionalParams:{font:"",fontColor:"",radius:0},constructor:function(_471,_472){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_472);du.updateWithPattern(this.opt,_472,this.optionalParams);this.run=null;this.dyn=[];},destroy:function(){this.resetEvents();this.inherited(arguments);},clear:function(){this.dirty=true;this.dyn=[];this.run=null;return this;},setAxis:function(axis){return this;},addSeries:function(run){this.run=run;return this;},calculateAxes:function(dim){return this;},getRequiredColors:function(){return this.run?this.run.data.length:0;},plotEvent:function(o){},connect:function(_477,_478){this.dirty=true;return dojo.connect(this,"plotEvent",_477,_478);},events:function(){var ls=this.plotEvent._listeners;if(!ls||!ls.length){return false;}for(var i in ls){if(!(i in Array.prototype)){return true;}}return false;},resetEvents:function(){this.plotEvent({type:"onplotreset",plot:this});},_connectEvents:function(_47b,o){_47b.connect("onmouseover",this,function(e){o.type="onmouseover";o.event=e;this.plotEvent(o);});_47b.connect("onmouseout",this,function(e){o.type="onmouseout";o.event=e;this.plotEvent(o);});_47b.connect("onclick",this,function(e){o.type="onclick";o.event=e;this.plotEvent(o);});},render:function(dim,_481){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,_483,t=this.chart.theme;this.resetEvents();if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_481.l-_481.r)/2,ry=(dim.height-_481.t-_481.b)/2,r=Math.min(rx,ry),_488="font" in this.opt?this.opt.font:t.axis.font,size=_488?g.normalizedLength(g.splitFontString(_488).size):0,_48a="fontColor" in this.opt?this.opt.fontColor:t.axis.fontColor,_48b=0,step,_48d,_48e,_48f,_490,_491,run=this.run.data,_493=this.events();if(typeof run[0]=="number"){_48d=df.map(run,"Math.max(x, 0)");if(df.every(_48d,"<= 0")){return this;}_48e=df.map(_48d,"/this",df.foldl(_48d,"+",0));if(this.opt.labels){_48f=dojo.map(_48e,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}else{_48d=df.map(run,"Math.max(x.y, 0)");if(df.every(_48d,"<= 0")){return this;}_48e=df.map(_48d,"/this",df.foldl(_48d,"+",0));if(this.opt.labels){_48f=dojo.map(_48e,function(x,i){if(x<=0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}if(this.opt.labels){_490=df.foldl1(df.map(_48f,function(_498){return dojox.gfx._base._getTextBox(_498,{font:_488}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_490,ry-size)+this.opt.labelOffset;}_491=r-this.opt.labelOffset;}if("radius" in this.opt){r=this.opt.radius;_491=r-this.opt.labelOffset;}var _499={cx:_481.l+rx,cy:_481.t+ry,r:r};this.dyn=[];dojo.some(_48e,function(_49a,i){if(_49a<=0){return false;}var v=run[i];if(_49a>=1){var _49d,fill,_49f;if(typeof v=="object"){_49d="color" in v?v.color:new dojo.Color(t.next("color"));fill="fill" in v?v.fill:dc.augmentFill(t.series.fill,_49d);_49f="stroke" in v?v.stroke:dc.augmentStroke(t.series.stroke,_49d);}else{_49d=new dojo.Color(t.next("color"));fill=dc.augmentFill(t.series.fill,_49d);_49f=dc.augmentStroke(t.series.stroke,_49d);}var _4a0=s.createCircle(_499).setFill(fill).setStroke(_49f);this.dyn.push({color:_49d,fill:fill,stroke:_49f});if(_493){var o={element:"slice",index:i,run:this.run,plot:this,shape:_4a0,x:i,y:typeof v=="number"?v:v.y,cx:_499.cx,cy:_499.cy,cr:r};this._connectEvents(_4a0,o);}return true;}var end=_48b+_49a*2*Math.PI;if(i+1==_48e.length){end=2*Math.PI;}var step=end-_48b,x1=_499.cx+r*Math.cos(_48b),y1=_499.cy+r*Math.sin(_48b),x2=_499.cx+r*Math.cos(end),y2=_499.cy+r*Math.sin(end);var _49d,fill,_49f;if(typeof v=="object"){_49d="color" in v?v.color:new dojo.Color(t.next("color"));fill="fill" in v?v.fill:dc.augmentFill(t.series.fill,_49d);_49f="stroke" in v?v.stroke:dc.augmentStroke(t.series.stroke,_49d);}else{_49d=new dojo.Color(t.next("color"));fill=dc.augmentFill(t.series.fill,_49d);_49f=dc.augmentStroke(t.series.stroke,_49d);}var _4a0=s.createPath({}).moveTo(_499.cx,_499.cy).lineTo(x1,y1).arcTo(r,r,0,step>Math.PI,true,x2,y2).lineTo(_499.cx,_499.cy).closePath().setFill(fill).setStroke(_49f);this.dyn.push({color:_49d,fill:fill,stroke:_49f});if(_493){var o={element:"slice",index:i,run:this.run,plot:this,shape:_4a0,x:i,y:typeof v=="number"?v:v.y,cx:_499.cx,cy:_499.cy,cr:r};this._connectEvents(_4a0,o);}_48b=end;return false;},this);if(this.opt.labels){_48b=0;dojo.some(_48e,function(_4a8,i){if(_4a8<=0){return false;}if(_4a8>=1){var v=run[i],elem=da.createText[this.opt.htmlLabels&&dojox.gfx.renderer!="vml"?"html":"gfx"](this.chart,s,_499.cx,_499.cy+size/2,"middle",_48f[i],_488,(typeof v=="object"&&"fontColor" in v)?v.fontColor:_48a);if(this.opt.htmlLabels){this.htmlElements.push(elem);}return true;}var end=_48b+_4a8*2*Math.PI,v=run[i];if(i+1==_48e.length){end=2*Math.PI;}var _4ad=(_48b+end)/2,x=_499.cx+_491*Math.cos(_4ad),y=_499.cy+_491*Math.sin(_4ad)+size/2;var elem=da.createText[this.opt.htmlLabels&&dojox.gfx.renderer!="vml"?"html":"gfx"](this.chart,s,x,y,"middle",_48f[i],_488,(typeof v=="object"&&"fontColor" in v)?v.fontColor:_48a);if(this.opt.htmlLabels){this.htmlElements.push(elem);}_48b=end;return false;},this);}return this;},_getLabel:function(_4b0){return this.opt.fixed?_4b0.toFixed(this.opt.precision):_4b0.toString();}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Bubble"]){dojo._hasResource["dojox.charting.plot2d.Bubble"]=true;dojo.provide("dojox.charting.plot2d.Bubble");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_4b4=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Bubble",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y"},optionalParams:{},constructor:function(_4b5,_4b6){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_4b6);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},calculateAxes:function(dim){this._calc(dim,dc.collectSimpleStats(this.series));return this;},render:function(dim,_4b9){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_4b4);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_4bd,_4be,_4bf,_4c0,_4c1,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_4c4=this.events();this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}var s=run.group,_4c7=dojo.map(run.data,function(v,i){return {x:ht(v.x)+_4b9.l,y:dim.height-_4b9.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)};},this);if(run.fill){_4bf=run.fill;}else{if(run.stroke){_4bf=run.stroke;}else{_4bf=run.dyn.color=new dojo.Color(t.next("color"));}}run.dyn.fill=_4bf;_4bd=run.dyn.stroke=run.stroke?dc.makeStroke(run.stroke):dc.augmentStroke(t.series.stroke,_4bf);var _4ca=null,_4cb=null,_4cc=null;if(this.opt.shadows&&_4bd){var sh=this.opt.shadows,_4c1=new dojo.Color([0,0,0,0.2]),_4c0=dojo.clone(_4be?_4be:_4bd);_4c0.color=_4c1;_4c0.width+=sh.dw?sh.dw:0;run.dyn.shadow=_4c0;var _4ce=dojo.map(_4c7,function(item){var sh=this.opt.shadows;return s.createCircle({cx:item.x+sh.dx,cy:item.y+sh.dy,r:item.radius}).setStroke(_4c0).setFill(_4c1);},this);}if(run.outline||t.series.outline){_4be=dc.makeStroke(run.outline?run.outline:t.series.outline);_4be.width=2*_4be.width+_4bd.width;run.dyn.outline=_4be;_4cb=dojo.map(_4c7,function(item){s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_4be);},this);}_4ca=dojo.map(_4c7,function(item){return s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_4bd).setFill(_4bf);},this);if(_4c4){dojo.forEach(_4ca,function(s,i){var o={element:"circle",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:s,outline:_4cb&&_4cb[i]||null,shadow:_4cc&&_4cc[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_4c7[i].x,cy:_4c7[i].y,cr:_4c7[i].radius};this._connectEvents(s,o);},this);}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.Chart2D"]){dojo._hasResource["dojox.charting.Chart2D"]=true;dojo.provide("dojox.charting.Chart2D");(function(){var df=dojox.lang.functional,dc=dojox.charting,_4d8=df.lambda("item.clear()"),_4d9=df.lambda("item.purgeGroup()"),_4da=df.lambda("item.destroy()"),_4db=df.lambda("item.dirty = false"),_4dc=df.lambda("item.dirty = true");dojo.declare("dojox.charting.Chart2D",null,{constructor:function(node,_4de){if(!_4de){_4de={};}this.margins=_4de.margins?_4de.margins:{l:10,t:10,r:10,b:10};this.stroke=_4de.stroke;this.fill=_4de.fill;this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.coords=null;this.node=dojo.byId(node);var box=dojo.marginBox(node);this.surface=dojox.gfx.createSurface(this.node,box.w,box.h);},destroy:function(){dojo.forEach(this.series,_4da);dojo.forEach(this.stack,_4da);df.forIn(this.axes,_4da);this.surface.destroy();},getCoords:function(){if(!this.coords){this.coords=dojo.coords(this.node,true);}return this.coords;},setTheme:function(_4e0){this.theme=_4e0._clone();this.dirty=true;return this;},addAxis:function(name,_4e2){var axis;if(!_4e2||!("type" in _4e2)){axis=new dc.axis2d.Default(this,_4e2);}else{axis=typeof _4e2.type=="string"?new dc.axis2d[_4e2.type](this,_4e2):new _4e2.type(this,_4e2);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_4e7){var plot;if(!_4e7||!("type" in _4e7)){plot=new dc.plot2d.Default(this,_4e7);}else{plot=typeof _4e7.type=="string"?new dc.plot2d[_4e7.type](this,_4e7):new _4e7.type(this,_4e7);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},removePlot:function(name){if(name in this.plots){var _4ea=this.plots[name];delete this.plots[name];this.stack[_4ea].destroy();this.stack.splice(_4ea,1);df.forIn(this.plots,function(idx,name,_4ed){if(idx>_4ea){_4ed[name]=idx-1;}});this.dirty=true;}return this;},addSeries:function(name,data,_4f0){var run=new dc.Series(this,data,_4f0);if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}run.name=name;this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},removeSeries:function(name){if(name in this.runs){var _4f3=this.runs[name],_4f4=this.series[_4f3].plot;delete this.runs[name];this.series[_4f3].destroy();this.series.splice(_4f3,1);df.forIn(this.runs,function(idx,name,runs){if(idx>_4f3){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data){if(name in this.runs){var run=this.series[this.runs[name]];run.data=data;run.dirty=true;this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}return this;},resize:function(_4fb,_4fc){var box;switch(arguments.length){case 0:box=dojo.marginBox(this.node);break;case 1:box=_4fb;break;default:box={w:_4fb,h:_4fc};break;}dojo.marginBox(this.node,box);this.surface.setDimensions(box.w,box.h);this.dirty=true;this.coords=null;return this.render();},getGeometry:function(){var ret={};df.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_501,_502){var axis=this.axes[name];if(axis){axis.setWindow(_501,_502);}return this;},setWindow:function(sx,sy,dx,dy){if(!("plotArea" in this)){this.calculateGeometry();}df.forIn(this.axes,function(axis){var _509,_50a,_50b=axis.getScaler().bounds,s=_50b.span/(_50b.upper-_50b.lower);if(axis.vertical){_509=sy;_50a=dy/s/_509;}else{_509=sx;_50a=dx/s/_509;}axis.setWindow(_509,_50a);});return this;},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}dojo.forEach(this.stack,function(plot){if(plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty)){plot.calculateAxes(this.plotArea);}},this);return this;},fullGeometry:function(){this._makeDirty();dojo.forEach(this.stack,_4d8);if(!this.theme){this.setTheme(new dojox.charting.Theme(dojox.charting._def));}dojo.forEach(this.series,function(run){if(!(run.plot in this.plots)){var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);dojo.forEach(this.stack,function(plot){if(plot.hAxis){plot.setAxis(this.axes[plot.hAxis]);}if(plot.vAxis){plot.setAxis(this.axes[plot.vAxis]);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=dojox.gfx.normalizedLength(dim.width);dim.height=dojox.gfx.normalizedLength(dim.height);df.forIn(this.axes,_4d8);dojo.forEach(this.stack,function(plot){plot.calculateAxes(dim);});var _513=this.offsets={l:0,r:0,t:0,b:0};df.forIn(this.axes,function(axis){df.forIn(axis.getOffsets(),function(o,i){_513[i]+=o;});});df.forIn(this.margins,function(o,i){_513[i]+=o;});this.plotArea={width:dim.width-_513.l-_513.r,height:dim.height-_513.t-_513.b};df.forIn(this.axes,_4d8);dojo.forEach(this.stack,function(plot){plot.calculateAxes(this.plotArea);},this);return this;},render:function(){if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();df.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);df.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();if(this.surface.render){this.surface.render();}return this;},fullRender:function(){this.fullGeometry();var _51c=this.offsets,dim=this.dim;var _51e=df.foldl(this.stack,"z + plot.getRequiredColors()",0);this.theme.defineColors({num:_51e,cache:false});dojo.forEach(this.series,_4d9);df.forIn(this.axes,_4d9);dojo.forEach(this.stack,_4d9);this.surface.clear();var t=this.theme,fill=t.plotarea&&t.plotarea.fill,_521=t.plotarea&&t.plotarea.stroke;if(fill){this.surface.createRect({x:_51c.l,y:_51c.t,width:dim.width-_51c.l-_51c.r,height:dim.height-_51c.t-_51c.b}).setFill(fill);}if(_521){this.surface.createRect({x:_51c.l,y:_51c.t,width:dim.width-_51c.l-_51c.r-1,height:dim.height-_51c.t-_51c.b-1}).setStroke(_521);}df.foldr(this.stack,function(z,plot){return plot.render(dim,_51c),0;},0);fill=this.fill?this.fill:(t.chart&&t.chart.fill);_521=this.stroke?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node,fill=new dojo.Color(dojo.style(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new dojo.Color(dojo.style(node,"backgroundColor"));node=node.parentNode;}}if(fill){if(_51c.l){this.surface.createRect({width:_51c.l,height:dim.height+1}).setFill(fill);}if(_51c.r){this.surface.createRect({x:dim.width-_51c.r,width:_51c.r+1,height:dim.height+1}).setFill(fill);}if(_51c.t){this.surface.createRect({width:dim.width+1,height:_51c.t}).setFill(fill);}if(_51c.b){this.surface.createRect({y:dim.height-_51c.b,width:dim.width+1,height:_51c.b+2}).setFill(fill);}}if(_521){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_521);}df.forIn(this.axes,function(axis){axis.render(dim,_51c);});this._makeClean();if(this.surface.render){this.surface.render();}return this;},connectToPlot:function(name,_527,_528){return name in this.plots?this.stack[this.plots[name]].connect(_527,_528):null;},_makeClean:function(){dojo.forEach(this.axes,_4db);dojo.forEach(this.stack,_4db);dojo.forEach(this.series,_4db);this.dirty=false;},_makeDirty:function(){dojo.forEach(this.axes,_4dc);dojo.forEach(this.stack,_4dc);dojo.forEach(this.series,_4dc);this.dirty=true;},_invalidateDependentPlots:function(_529,_52a){if(_529 in this.plots){var plot=this.stack[this.plots[_529]],axis,_52d=_52a?"vAxis":"hAxis";if(plot[_52d]){axis=this.axes[plot[_52d]];if(axis.dependOnData()){axis.dirty=true;dojo.forEach(this.stack,function(p){if(p[_52d]&&p[_52d]==plot[_52d]){p.dirty=true;}});}}else{plot.dirty=true;}}}});})();}if(!dojo._hasResource["dojo.fx.easing"]){dojo._hasResource["dojo.fx.easing"]=true;dojo.provide("dojo.fx.easing");dojo.fx.easing={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-dojo.fx.easing.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return dojo.fx.easing.bounceIn(n*2)/2;}return (dojo.fx.easing.bounceOut(n*2-1)/2)+0.5;}};}if(!dojo._hasResource["dojox.gfx.fx"]){dojo._hasResource["dojox.gfx.fx"]=true;dojo.provide("dojox.gfx.fx");(function(){var d=dojo,g=dojox.gfx,m=g.matrix;var _55d=function(_55e,end){this.start=_55e,this.end=end;};d.extend(_55d,{getValue:function(r){return (this.end-this.start)*r+this.start;}});var _561=function(_562,end,unit){this.start=_562,this.end=end;this.unit=unit;};d.extend(_561,{getValue:function(r){return (this.end-this.start)*r+this.start+this.unit;}});var _566=function(_567,end){this.start=_567,this.end=end;this.temp=new dojo.Color();};d.extend(_566,{getValue:function(r){return d.blendColors(this.start,this.end,r,this.temp);}});var _56a=function(_56b){this.values=_56b;this.length=_56b.length;};d.extend(_56a,{getValue:function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];}});var _56d=function(_56e,def){this.values=_56e;this.def=def?def:{};};d.extend(_56d,{getValue:function(r){var ret=dojo.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;}});var _573=function(_574,_575){this.stack=_574;this.original=_575;};d.extend(_573,{getValue:function(r){var ret=[];dojo.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=dojo.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_57d=f.apply(m,val);if(_57d instanceof m.Matrix2D){ret.push(_57d);}},this);return ret;}});var _57e=new d.Color(0,0,0,0);var _57f=function(prop,obj,name,def){if(prop.values){return new _56a(prop.values);}var _584,_585,end;if(prop.start){_585=g.normalizeColor(prop.start);}else{_585=_584=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_584){_584=obj?(name?obj[name]:obj):def;}end=_584;}return new _566(_585,end);};var _587=function(prop,obj,name,def){if(prop.values){return new _56a(prop.values);}var _58c,_58d,end;if(prop.start){_58d=prop.start;}else{_58d=_58c=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _58c!="number"){_58c=obj?obj[name]:def;}end=_58c;}return new _55d(_58d,end);};g.fx.animateStroke=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d._Animation(args),_591=args.shape,_592;d.connect(anim,"beforeBegin",anim,function(){_592=_591.getStroke();var prop=args.color,_594={},_595,_596,end;if(prop){_594.color=_57f(prop,_592,"color",_57e);}prop=args.style;if(prop&&prop.values){_594.style=new _56a(prop.values);}prop=args.width;if(prop){_594.width=_587(prop,_592,"width",1);}prop=args.cap;if(prop&&prop.values){_594.cap=new _56a(prop.values);}prop=args.join;if(prop){if(prop.values){_594.join=new _56a(prop.values);}else{_596=prop.start?prop.start:(_592&&_592.join||0);end=prop.end?prop.end:(_592&&_592.join||0);if(typeof _596=="number"&&typeof end=="number"){_594.join=new _55d(_596,end);}}}this.curve=new _56d(_594,_592);});d.connect(anim,"onAnimate",_591,"setStroke");return anim;};g.fx.animateFill=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d._Animation(args),_59a=args.shape,fill;d.connect(anim,"beforeBegin",anim,function(){fill=_59a.getFill();var prop=args.color,_59d={};if(prop){this.curve=_57f(prop,fill,"",_57e);}});d.connect(anim,"onAnimate",_59a,"setFill");return anim;};g.fx.animateFont=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d._Animation(args),_5a0=args.shape,font;d.connect(anim,"beforeBegin",anim,function(){font=_5a0.getFont();var prop=args.style,_5a3={},_5a4,_5a5,end;if(prop&&prop.values){_5a3.style=new _56a(prop.values);}prop=args.variant;if(prop&&prop.values){_5a3.variant=new _56a(prop.values);}prop=args.weight;if(prop&&prop.values){_5a3.weight=new _56a(prop.values);}prop=args.family;if(prop&&prop.values){_5a3.family=new _56a(prop.values);}prop=args.size;if(prop&&prop.unit){_5a5=parseFloat(prop.start?prop.start:(_5a0.font&&_5a0.font.size||"0"));end=parseFloat(prop.end?prop.end:(_5a0.font&&_5a0.font.size||"0"));_5a3.size=new _561(_5a5,end,prop.unit);}this.curve=new _56d(_5a3,font);});d.connect(anim,"onAnimate",_5a0,"setFont");return anim;};g.fx.animateTransform=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d._Animation(args),_5a9=args.shape,_5aa;d.connect(anim,"beforeBegin",anim,function(){_5aa=_5a9.getTransform();this.curve=new _573(args.transform,_5aa);});d.connect(anim,"onAnimate",_5a9,"setTransform");return anim;};})();}if(!dojo._hasResource["dojox.charting.action2d.Base"]){dojo._hasResource["dojox.charting.action2d.Base"]=true;dojo.provide("dojox.charting.action2d.Base");(function(){var _5ab=400,_5ac=dojo.fx.easing.backOut,df=dojox.lang.functional;dojo.declare("dojox.charting.action2d.Base",null,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_5ae,plot,_5b0){this.chart=_5ae;this.plot=plot?plot:"default";this.anim={};if(!_5b0){_5b0={};}this.duration=_5b0.duration?_5b0.duration:_5ab;this.easing=_5b0.easing?_5b0.easing:_5ac;},connect:function(){this.handle=this.chart.connectToPlot(this.plot,this,"process");},disconnect:function(){if(this.handle){dojo.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){if(this.handle){this.disconnect();}df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});})();}if(!dojo._hasResource["dojox.charting.action2d.Highlight"]){dojo._hasResource["dojox.charting.action2d.Highlight"]=true;dojo.provide("dojox.charting.action2d.Highlight");(function(){var _5b3=100,_5b4=75,_5b5=50,c=dojox.color,cc=function(_5b8){return function(){return _5b8;};},hl=function(_5ba){var a=new c.Color(_5ba),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_5b3;if(x.l<_5b5){x.l=_5b4;}else{if(x.l>_5b4){x.l=_5b5;}else{x.l=x.l-_5b5>_5b4-x.l?_5b5:_5b4;}}}return c.fromHsl(x);};dojo.declare("dojox.charting.action2d.Highlight",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut},optionalParams:{highlight:"red"},constructor:function(_5bd,plot,_5bf){var a=_5bf&&_5bf.highlight;this.colorFun=a?(dojo.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _5c2=o.run.name,_5c3=o.index,anim,_5c5,_5c6;if(_5c2 in this.anim){anim=this.anim[_5c2][_5c3];}else{this.anim[_5c2]={};}if(anim){anim.action.stop(true);}else{var _5c7=o.shape.getFill();if(!_5c7||!(_5c7 instanceof dojo.Color)){return;}this.anim[_5c2][_5c3]=anim={start:_5c7,end:this.colorFun(_5c7)};}var _5c8=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_5c8;_5c8=end;end=t;}anim.action=dojox.gfx.fx.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_5c8,end:end}});if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_5c2]){delete this.anim[_5c2][_5c3];}});}anim.action.play();}});})();}if(!dojo._hasResource["dojox.charting.action2d.Magnify"]){dojo._hasResource["dojox.charting.action2d.Magnify"]=true;dojo.provide("dojox.charting.action2d.Magnify");(function(){var _5cb=2,m=dojox.gfx.matrix,gf=dojox.gfx.fx;dojo.declare("dojox.charting.action2d.Magnify",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,scale:_5cb},optionalParams:{},constructor:function(_5ce,plot,_5d0){this.scale=_5d0&&typeof _5d0.scale=="number"?_5d0.scale:_5cb;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}var _5d2=o.run.name,_5d3=o.index,_5d4=[],anim,init,_5d7;if(_5d2 in this.anim){anim=this.anim[_5d2][_5d3];}else{this.anim[_5d2]={};}if(anim){anim.action.stop(true);}else{this.anim[_5d2][_5d3]=anim={};}if(o.type=="onmouseover"){init=m.identity;_5d7=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_5d7=1/this.scale;}var _5d8={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_5d7,o.cx,o.cy]},init]};if(o.shape){_5d4.push(gf.animateTransform(_5d8));}if(o.oultine){_5d8.shape=o.outline;_5d4.push(gf.animateTransform(_5d8));}if(o.shadow){_5d8.shape=o.shadow;_5d4.push(gf.animateTransform(_5d8));}if(!_5d4.length){delete this.anim[_5d2][_5d3];return;}anim.action=dojo.fx.combine(_5d4);if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_5d2]){delete this.anim[_5d2][_5d3];}});}anim.action.play();}});})();}if(!dojo._hasResource["dojox.lang.functional.scan"]){dojo._hasResource["dojox.lang.functional.scan"]=true;dojo.provide("dojox.lang.functional.scan");(function(){var d=dojo,df=dojox.lang.functional,_5db={};d.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _5db)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,z,_5e9=true;if(d.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(var i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(var i in a){if(!(i in _5db)){if(_5e9){t=[z=a[i]];_5e9=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});})();}if(!dojo._hasResource["dojox.charting.action2d.MoveSlice"]){dojo._hasResource["dojox.charting.action2d.MoveSlice"]=true;dojo.provide("dojox.charting.action2d.MoveSlice");(function(){var _5f9=1.05,_5fa=7,m=dojox.gfx.matrix,gf=dojox.gfx.fx,df=dojox.lang.functional;dojo.declare("dojox.charting.action2d.MoveSlice",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,scale:_5f9,shift:_5fa},optionalParams:{},constructor:function(_5fe,plot,_600){if(!_600){_600={};}this.scale=typeof _600.scale=="number"?_600.scale:_5f9;this.shift=typeof _600.shift=="number"?_600.shift:_5fa;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _602=o.index,anim,_604,_605,_606,_607=(this.angles[_602]+this.angles[_602+1])/2,_608=m.rotateAt(-_607,o.cx,o.cy),_609=m.rotateAt(_607,o.cx,o.cy);anim=this.anim[_602];if(anim){anim.action.stop(true);}else{this.anim[_602]=anim={};}if(o.type=="onmouseover"){_605=0;_606=this.shift;_604=this.scale;}else{_605=this.shift;_606=0;_604=1/this.scale;}anim.action=dojox.gfx.fx.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[_609,{name:"translate",start:[_605,0],end:[_606,0]},{name:"scaleAt",start:[1,o.cx,o.cy],end:[_604,o.cx,o.cy]},_608]});if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){delete this.anim[_602];});}anim.action.play();},reset:function(){delete this.angles;}});})();}if(!dojo._hasResource["dojox.charting.action2d.Shake"]){dojo._hasResource["dojox.charting.action2d.Shake"]=true;dojo.provide("dojox.charting.action2d.Shake");(function(){var _60a=3,m=dojox.gfx.matrix,gf=dojox.gfx.fx;dojo.declare("dojox.charting.action2d.Shake",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,shiftX:_60a,shiftY:_60a},optionalParams:{},constructor:function(_60d,plot,_60f){if(!_60f){_60f={};}this.shiftX=typeof _60f.shiftX=="number"?_60f.shiftX:_60a;this.shiftY=typeof _60f.shiftY=="number"?_60f.shiftY:_60a;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _611=o.run.name,_612=o.index,_613=[],anim,_615=o.type=="onmouseover"?this.shiftX:-this.shiftX,_616=o.type=="onmouseover"?this.shiftY:-this.shiftY;if(_611 in this.anim){anim=this.anim[_611][_612];}else{this.anim[_611]={};}if(anim){anim.action.stop(true);}else{this.anim[_611][_612]=anim={};}var _617={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){_613.push(gf.animateTransform(_617));}if(o.oultine){_617.shape=o.outline;_613.push(gf.animateTransform(_617));}if(o.shadow){_617.shape=o.shadow;_613.push(gf.animateTransform(_617));}if(!_613.length){delete this.anim[_611][_612];return;}anim.action=dojo.fx.combine(_613);if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_611]){delete this.anim[_611][_612];}});}anim.action.play();}});})();}if(!dojo._hasResource["dijit.Tooltip"]){dojo._hasResource["dijit.Tooltip"]=true;dojo.provide("dijit.Tooltip");dojo.declare("dijit._MasterTooltip",[dijit._Widget,dijit._Templated],{duration:dijit.defaultDuration,templateString:"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\">\n\t<div class=\"dijitTooltipContainer dijitTooltipContents\" dojoAttachPoint=\"containerNode\" waiRole='alert'></div>\n\t<div class=\"dijitTooltipConnector\"></div>\n</div>\n",postCreate:function(){dojo.body().appendChild(this.domNode);this.bgIframe=new dijit.BackgroundIframe(this.domNode);this.fadeIn=dojo.fadeIn({node:this.domNode,duration:this.duration,onEnd:dojo.hitch(this,"_onShow")});this.fadeOut=dojo.fadeOut({node:this.domNode,duration:this.duration,onEnd:dojo.hitch(this,"_onHide")});},show:function(_618,_619,_61a){if(this.aroundNode&&this.aroundNode===_619){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_618;this.domNode.style.top=(this.domNode.offsetTop+1)+"px";var _61b={};var ltr=this.isLeftToRight();dojo.forEach((_61a&&_61a.length)?_61a:dijit.Tooltip.defaultPosition,function(pos){switch(pos){case "after":_61b[ltr?"BR":"BL"]=ltr?"BL":"BR";break;case "before":_61b[ltr?"BL":"BR"]=ltr?"BR":"BL";break;case "below":_61b[ltr?"BL":"BR"]=ltr?"TL":"TR";_61b[ltr?"BR":"BL"]=ltr?"TR":"TL";break;case "above":default:_61b[ltr?"TL":"TR"]=ltr?"BL":"BR";_61b[ltr?"TR":"TL"]=ltr?"BR":"BL";break;}});var pos=dijit.placeOnScreenAroundElement(this.domNode,_619,_61b,dojo.hitch(this,"orient"));dojo.style(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_619;},orient:function(node,_620,_621){node.className="dijitTooltip "+{"BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_620+"-"+_621];},_onShow:function(){if(dojo.isIE){this.domNode.style.filter="";}},hide:function(_622){if(this._onDeck&&this._onDeck[1]==_622){this._onDeck=null;}else{if(this.aroundNode===_622){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});dijit.showTooltip=function(_623,_624,_625){if(!dijit._masterTT){dijit._masterTT=new dijit._MasterTooltip();}return dijit._masterTT.show(_623,_624,_625);};dijit.hideTooltip=function(_626){if(!dijit._masterTT){dijit._masterTT=new dijit._MasterTooltip();}return dijit._masterTT.hide(_626);};dojo.declare("dijit.Tooltip",dijit._Widget,{label:"",showDelay:400,connectId:[],position:[],postCreate:function(){dojo.addClass(this.domNode,"dijitTooltipData");this._connectNodes=[];dojo.forEach(this.connectId,function(id){var node=dojo.byId(id);if(node){this._connectNodes.push(node);dojo.forEach(["onMouseEnter","onMouseLeave","onFocus","onBlur"],function(_629){this.connect(node,_629.toLowerCase(),"_"+_629);},this);if(dojo.isIE){node.style.zoom=1;}}},this);},_onMouseEnter:function(e){this._onHover(e);},_onMouseLeave:function(e){this._onUnHover(e);},_onFocus:function(e){this._focus=true;this._onHover(e);this.inherited(arguments);},_onBlur:function(e){this._focus=false;this._onUnHover(e);this.inherited(arguments);},_onHover:function(e){if(!this._showTimer){var _62f=e.target;this._showTimer=setTimeout(dojo.hitch(this,function(){this.open(_62f);}),this.showDelay);}},_onUnHover:function(e){if(this._focus){return;}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}this.close();},open:function(_631){_631=_631||this._connectNodes[0];if(!_631){return;}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}dijit.showTooltip(this.label||this.domNode.innerHTML,_631,this.position);this._connectNode=_631;},close:function(){if(this._connectNode){dijit.hideTooltip(this._connectNode);delete this._connectNode;}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}},uninitialize:function(){this.close();}});dijit.Tooltip.defaultPosition=["after","before"];}if(!dojo._hasResource["dojox.charting.action2d.Tooltip"]){dojo._hasResource["dojox.charting.action2d.Tooltip"]=true;dojo.provide("dojox.charting.action2d.Tooltip");(function(){var _632=function(o){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t=="object"&&t.tooltip){return t.tooltip;}return o.element=="bar"?o.x:o.y;};var df=dojox.lang.functional,pi4=Math.PI/4,pi2=Math.PI/2;dojo.declare("dojox.charting.action2d.Tooltip",dojox.charting.action2d.Base,{defaultParams:{text:_632},optionalParams:{},constructor:function(_638,plot,_63a){this.text=_63a&&_63a.text?_63a.text:_632;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){dijit.hideTooltip(this.aroundRect);this.aroundRect=null;return;}if(!o.shape||o.type!=="onmouseover"){return;}var _63c={type:"rect"},_63d=["after","before"];switch(o.element){case "marker":_63c.x=o.cx;_63c.y=o.cy;_63c.width=_63c.height=1;break;case "circle":_63c.x=o.cx-o.cr;_63c.y=o.cy-o.cr;_63c.width=_63c.height=2*o.cr;break;case "column":_63d=["above","below"];case "bar":_63c=dojo.clone(o.shape.getShape());break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _63e=(this.angles[o.index]+this.angles[o.index+1])/2;_63c.x=o.cx+o.cr*Math.cos(_63e);_63c.y=o.cy+o.cr*Math.sin(_63e);_63c.width=_63c.height=1;if(_63e<pi4){}else{if(_63e<pi2+pi4){_63d=["below","above"];}else{if(_63e<Math.PI+pi4){_63d=["before","after"];}else{if(_63e<2*Math.PI-pi4){_63d=["above","below"];}}}}break;}var lt=dojo.coords(this.chart.node,true);_63c.x+=lt.x;_63c.y+=lt.y;_63c.x=Math.round(_63c.x);_63c.y=Math.round(_63c.y);_63c.width=Math.ceil(_63c.width);_63c.height=Math.ceil(_63c.height);this.aroundRect=_63c;dijit.showTooltip(this.text(o),this.aroundRect,_63d);}});})();}if(!dojo._hasResource["dojox.charting.widget.Chart2D"]){dojo._hasResource["dojox.charting.widget.Chart2D"]=true;dojo.provide("dojox.charting.widget.Chart2D");(function(){var _640,_641,_642,_643,_644,_645=function(o){return o;},df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting,d=dojo;dojo.declare("dojox.charting.widget.Chart2D",dijit._Widget,{theme:null,margins:null,stroke:null,fill:null,buildRendering:function(){var n=this.domNode=this.srcNodeRef;var axes=d.query("> .axis",n).map(_641).filter(_645),_64d=d.query("> .plot",n).map(_642).filter(_645),_64e=d.query("> .action",n).map(_643).filter(_645),_64f=d.query("> .series",n).map(_644).filter(_645);n.innerHTML="";var c=this.chart=new dc.Chart2D(n,{margins:this.margins,stroke:this.stroke,fill:this.fill});if(this.theme){c.setTheme(this.theme);}axes.forEach(function(axis){c.addAxis(axis.name,axis.kwArgs);});_64d.forEach(function(plot){c.addPlot(plot.name,plot.kwArgs);});this.actions=_64e.map(function(_653){return new _653.action(c,_653.plot,_653.kwArgs);});var _654=df.foldl(_64f,function(_655,_656){if(_656.type=="data"){c.addSeries(_656.name,_656.data,_656.kwArgs);_655=true;}else{c.addSeries(_656.name,[0],_656.kwArgs);var kw={};du.updateWithPattern(kw,_656.kwArgs,{"query":"","queryOptions":null,"start":0,"count":1},true);if(_656.kwArgs.sort){kw.sort=dojo.clone(_656.kwArgs.sort);}d.mixin(kw,{onComplete:function(data){var _659;if("valueFn" in _656.kwArgs){var fn=_656.kwArgs.valueFn;_659=d.map(data,function(x){return fn(_656.data.getValue(x,_656.field,0));});}else{_659=d.map(data,function(x){return _656.data.getValue(x,_656.field,0);});}c.addSeries(_656.name,_659,_656.kwArgs).render();}});_656.data.fetch(kw);}return _655;},false);if(_654){c.render();}},destroy:function(){this.chart.destroy();this.inherited(arguments);},resize:function(box){if(box.w>0&&box.h>0){dojo.marginBox(this.domNode,box);this.chart.resize();}}});_640=function(node,type,kw){var dp=eval("("+type+".prototype.defaultParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}var op=eval("("+type+".prototype.optionalParams)");for(x in op){if(x in kw){continue;}attr=node.getAttribute(x);if(attr!=null){kw[x]=du.coerceType(op[x],attr);}}};_641=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.axis2d[type]){type=dojox._scopeName+".charting.axis2d."+type;}var axis=eval("("+type+")");if(axis){kw.type=axis;}}else{type=dojox._scopeName+".charting.axis2d.Default";}_640(node,type,kw);return o;};_642=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.plot2d[type]){type=dojox._scopeName+".charting.plot2d."+type;}var plot=eval("("+type+")");if(plot){kw.type=plot;}}else{type=dojox._scopeName+".charting.plot2d.Default";}_640(node,type,kw);return o;};_643=function(node){var plot=node.getAttribute("plot"),type=node.getAttribute("type");if(!plot){plot="default";}var o={plot:plot,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.action2d[type]){type=dojox._scopeName+".charting.action2d."+type;}var _676=eval("("+type+")");if(!_676){return null;}o.action=_676;}else{return null;}_640(node,type,kw);return o;};_644=function(node){var ga=d.partial(d.attr,node);var name=ga("name");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs,t;t=ga("plot");if(t!=null){kw.plot=t;}t=ga("marker");if(t!=null){kw.marker=t;}t=ga("stroke");if(t!=null){kw.stroke=eval("("+t+")");}t=ga("fill");if(t!=null){kw.fill=eval("("+t+")");}t=ga("legend");if(t!=null){kw.legend=t;}t=ga("data");if(t!=null){o.type="data";o.data=dojo.map(String(t).split(","),Number);return o;}t=ga("array");if(t!=null){o.type="data";o.data=eval("("+t+")");return o;}t=ga("store");if(t!=null){o.type="store";o.data=eval("("+t+")");t=ga("field");o.field=t!=null?t:"value";t=ga("query");if(!!t){kw.query=t;}t=ga("queryOptions");if(!!t){kw.queryOptions=eval("("+t+")");}t=ga("start");if(!!t){kw.start=Number(t);}t=ga("count");if(!!t){kw.count=Number(t);}t=ga("sort");if(!!t){kw.sort=eval("("+t+")");}t=ga("valueFn");if(!!t){kw.valueFn=df.lambda(t);}return o;}return null;};})();}if(!dojo._hasResource["dojox.charting.themes.ET.greys"]){dojo._hasResource["dojox.charting.themes.ET.greys"]=true;dojo.provide("dojox.charting.themes.ET.greys");dojo.deprecated("dojox.charting.themes.ET.greys","1.3");(function(){var dxc=dojox.charting;dxc.themes.ET.greys=new dxc.Theme({antiAlias:false,chart:{stroke:null,fill:"inherit"},plotarea:{stroke:null,fill:"transparent"},axis:{stroke:{width:0},line:{width:0},majorTick:{color:"#666666",width:1,length:5},minorTick:{color:"black",width:0.5,length:2},font:"normal normal normal 8pt Tahoma",fontColor:"#999999"},series:{outline:{width:0,color:"black"},stroke:{width:1,color:"black"},fill:dojo.colorFromHex("#3b444b"),font:"normal normal normal 7pt Tahoma",fontColor:"#717171"},marker:{stroke:{width:1},fill:"#333",font:"normal normal normal 7pt Tahoma",fontColor:"#000"},colors:[dojo.colorFromHex("#8a8c8f"),dojo.colorFromHex("#4b4b4b"),dojo.colorFromHex("#3b444b"),dojo.colorFromHex("#2e2d30"),dojo.colorFromHex("#000000")]});})();}if(!dojo._hasResource["dojox.charting.widget.Sparkline"]){dojo._hasResource["dojox.charting.widget.Sparkline"]=true;dojo.provide("dojox.charting.widget.Sparkline");(function(){var d=dojo;dojo.declare("dojox.charting.widget.Sparkline",dojox.charting.widget.Chart2D,{theme:dojox.charting.themes.ET.greys,margins:{l:0,r:0,t:0,b:0},type:"Lines",valueFn:"Number(x)",store:"",field:"",query:"",queryOptions:"",start:"0",count:"Infinity",sort:"",data:"",name:"default",buildRendering:function(){var n=this.srcNodeRef;if(!n.childNodes.length||!d.query("> .axis, > .plot, > .action, > .series",n).length){var plot=document.createElement("div");d.attr(plot,{"class":"plot","name":"default","type":this.type});n.appendChild(plot);var _681=document.createElement("div");d.attr(_681,{"class":"series",plot:"default",name:this.name,start:this.start,count:this.count,valueFn:this.valueFn});d.forEach(["store","field","query","queryOptions","sort","data"],function(i){if(this[i].length){d.attr(_681,i,this[i]);}},this);n.appendChild(_681);}this.inherited(arguments);}});})();}if(!dojo._hasResource["dojox.charting.widget.Legend"]){dojo._hasResource["dojox.charting.widget.Legend"]=true;dojo.provide("dojox.charting.widget.Legend");dojo.declare("dojox.charting.widget.Legend",[dijit._Widget,dijit._Templated],{chartRef:"",horizontal:true,templateString:"<table dojoAttachPoint='legendNode' class='dojoxLegendNode'><tbody dojoAttachPoint='legendBody'></tbody></table>",legendNode:null,legendBody:null,postCreate:function(){if(!this.chart){if(!this.chartRef){return;}this.chart=dijit.byId(this.chartRef);if(!this.chart){var node=dojo.byId(this.chartRef);if(node){this.chart=dijit.byNode(node);}else{return;}}this.series=this.chart.chart.series;}else{this.series=this.chart.series;}this.refresh();},refresh:function(){var df=dojox.lang.functional;if(this._surfaces){dojo.forEach(this._surfaces,function(_685){_685.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){dojo.destroy(this.legendBody.lastChild);}if(this.horizontal){dojo.addClass(this.legendNode,"dojoxLegendHorizontal");this._tr=dojo.doc.createElement("tr");this.legendBody.appendChild(this._tr);}var s=this.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _688=df.map(t.run.data,"Math.max(x, 0)");if(df.every(_688,"<= 0")){return;}var _689=df.map(_688,"/this",df.foldl(_688,"+",0));dojo.forEach(_689,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{dojo.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{dojo.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_690){var icon=dojo.doc.createElement("td"),text=dojo.doc.createElement("td"),div=dojo.doc.createElement("div");dojo.addClass(icon,"dojoxLegendIcon");dojo.addClass(text,"dojoxLegendText");div.style.width="20px";div.style.height="20px";icon.appendChild(div);if(this._tr){this._tr.appendChild(icon);this._tr.appendChild(text);}else{var tr=dojo.doc.createElement("tr");this.legendBody.appendChild(tr);tr.appendChild(icon);tr.appendChild(text);}this._makeIcon(div,dyn);text.innerHTML=String(_690);},_makeIcon:function(div,dyn){var mb={h:14,w:14};var _698=dojox.gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_698);if(dyn.fill){_698.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_698.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};if(dyn.stroke){_698.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.stroke.color).setStroke(dyn.stroke);}else{_698.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.color).setStroke(dyn.color);}}}else{_698.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_698.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_698.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}}});}
