/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(!dojo._hasResource["dojox.storage.Provider"]){dojo._hasResource["dojox.storage.Provider"]=true;dojo.provide("dojox.storage.Provider");dojo.declare("dojox.storage.Provider",null,{constructor:function(){},SUCCESS:"success",FAILED:"failed",PENDING:"pending",SIZE_NOT_AVAILABLE:"Size not available",SIZE_NO_LIMIT:"No size limit",DEFAULT_NAMESPACE:"default",onHideSettingsUI:null,initialize:function(){console.warn("dojox.storage.initialize not implemented");},isAvailable:function(){console.warn("dojox.storage.isAvailable not implemented");},put:function(_1,_2,_3,_4){console.warn("dojox.storage.put not implemented");},get:function(_5,_6){console.warn("dojox.storage.get not implemented");},hasKey:function(_7,_8){return !!this.get(_7,_8);},getKeys:function(_9){console.warn("dojox.storage.getKeys not implemented");},clear:function(_a){console.warn("dojox.storage.clear not implemented");},remove:function(_b,_c){console.warn("dojox.storage.remove not implemented");},getNamespaces:function(){console.warn("dojox.storage.getNamespaces not implemented");},isPermanent:function(){console.warn("dojox.storage.isPermanent not implemented");},getMaximumSize:function(){console.warn("dojox.storage.getMaximumSize not implemented");},putMultiple:function(_d,_e,_f,_10){for(var i=0;i<_d.length;i++){dojox.storage.put(_d[i],_e[i],_f,_10);}},getMultiple:function(_12,_13){var _14=[];for(var i=0;i<_12.length;i++){_14.push(dojox.storage.get(_12[i],_13));}return _14;},removeMultiple:function(_16,_17){for(var i=0;i<_16.length;i++){dojox.storage.remove(_16[i],_17);}},isValidKeyArray:function(_19){if(_19===null||_19===undefined||!dojo.isArray(_19)){return false;}return !dojo.some(_19,function(key){return !this.isValidKey(key);},this);},hasSettingsUI:function(){return false;},showSettingsUI:function(){console.warn("dojox.storage.showSettingsUI not implemented");},hideSettingsUI:function(){console.warn("dojox.storage.hideSettingsUI not implemented");},isValidKey:function(_1b){if(_1b===null||_1b===undefined){return false;}return /^[0-9A-Za-z_]*$/.test(_1b);},getResourceList:function(){return [];}});}if(!dojo._hasResource["dojox.storage.manager"]){dojo._hasResource["dojox.storage.manager"]=true;dojo.provide("dojox.storage.manager");dojox.storage.manager=new function(){this.currentProvider=null;this.available=false;this.providers=[];this._initialized=false;this._onLoadListeners=[];this.initialize=function(){this.autodetect();};this.register=function(_1c,_1d){this.providers.push(_1d);this.providers[_1c]=_1d;};this.setProvider=function(_1e){};this.autodetect=function(){if(this._initialized){return;}var _1f=dojo.config["forceStorageProvider"]||false;var _20;for(var i=0;i<this.providers.length;i++){_20=this.providers[i];if(_1f&&_1f==_20.declaredClass){_20.isAvailable();break;}else{if(!_1f&&_20.isAvailable()){break;}}}if(!_20){this._initialized=true;this.available=false;this.currentProvider=null;console.warn("No storage provider found for this platform");this.loaded();return;}this.currentProvider=_20;dojo.mixin(dojox.storage,this.currentProvider);dojox.storage.initialize();this._initialized=true;this.available=true;};this.isAvailable=function(){return this.available;};this.addOnLoad=function(_22){this._onLoadListeners.push(_22);if(this.isInitialized()){this._fireLoaded();}};this.removeOnLoad=function(_23){for(var i=0;i<this._onLoadListeners.length;i++){if(_23==this._onLoadListeners[i]){this._onLoadListeners=this._onLoadListeners.splice(i,1);break;}}};this.isInitialized=function(){if(this.currentProvider!=null&&this.currentProvider.declaredClass=="dojox.storage.FlashStorageProvider"&&dojox.flash.ready==false){return false;}else{return this._initialized;}};this.supportsProvider=function(_25){try{var _26=eval("new "+_25+"()");var _27=_26.isAvailable();if(!_27){return false;}return _27;}catch(e){return false;}};this.getProvider=function(){return this.currentProvider;};this.loaded=function(){this._fireLoaded();};this._fireLoaded=function(){dojo.forEach(this._onLoadListeners,function(i){try{i();}catch(e){}});};this.getResourceList=function(){var _29=[];dojo.forEach(dojox.storage.manager.providers,function(_2a){_29=_29.concat(_2a.getResourceList());});return _29;};};}if(!dojo._hasResource["dojo.gears"]){dojo._hasResource["dojo.gears"]=true;dojo.provide("dojo.gears");dojo.gears._gearsObject=function(){var _2b;var _2c;var _2d=dojo.getObject("google.gears");if(_2d){return _2d;}if(typeof GearsFactory!="undefined"){_2b=new GearsFactory();}else{if(dojo.isIE){try{_2b=new ActiveXObject("Gears.Factory");}catch(e){}}else{if(navigator.mimeTypes["application/x-googlegears"]){_2b=document.createElement("object");_2b.setAttribute("type","application/x-googlegears");_2b.setAttribute("width",0);_2b.setAttribute("height",0);_2b.style.display="none";document.documentElement.appendChild(_2b);}}}if(!_2b){return null;}dojo.setObject("google.gears.factory",_2b);return dojo.getObject("google.gears");};dojo.gears.available=(!!dojo.gears._gearsObject())||0;}if(!dojo._hasResource["dojox.sql._crypto"]){dojo._hasResource["dojox.sql._crypto"]=true;dojo.provide("dojox.sql._crypto");dojo.mixin(dojox.sql._crypto,{_POOL_SIZE:100,encrypt:function(_2e,_2f,_30){this._initWorkerPool();var msg={plaintext:_2e,password:_2f};msg=dojo.toJson(msg);msg="encr:"+String(msg);this._assignWork(msg,_30);},decrypt:function(_32,_33,_34){this._initWorkerPool();var msg={ciphertext:_32,password:_33};msg=dojo.toJson(msg);msg="decr:"+String(msg);this._assignWork(msg,_34);},_initWorkerPool:function(){if(!this._manager){try{this._manager=google.gears.factory.create("beta.workerpool","1.0");this._unemployed=[];this._employed={};this._handleMessage=[];var _36=this;this._manager.onmessage=function(msg,_38){var _39=_36._employed["_"+_38];_36._employed["_"+_38]=undefined;_36._unemployed.push("_"+_38);if(_36._handleMessage.length){var _3a=_36._handleMessage.shift();_36._assignWork(_3a.msg,_3a.callback);}_39(msg);};var _3b="function _workerInit(){"+"gearsWorkerPool.onmessage = "+String(this._workerHandler)+";"+"}";var _3c=_3b+" _workerInit();";for(var i=0;i<this._POOL_SIZE;i++){this._unemployed.push("_"+this._manager.createWorker(_3c));}}catch(exp){throw exp.message||exp;}}},_assignWork:function(msg,_3f){if(!this._handleMessage.length&&this._unemployed.length){var _40=this._unemployed.shift().substring(1);this._employed["_"+_40]=_3f;this._manager.sendMessage(msg,parseInt(_40,10));}else{this._handleMessage={msg:msg,callback:_3f};}},_workerHandler:function(msg,_42){var _43=[99,124,119,123,242,107,111,197,48,1,103,43,254,215,171,118,202,130,201,125,250,89,71,240,173,212,162,175,156,164,114,192,183,253,147,38,54,63,247,204,52,165,229,241,113,216,49,21,4,199,35,195,24,150,5,154,7,18,128,226,235,39,178,117,9,131,44,26,27,110,90,160,82,59,214,179,41,227,47,132,83,209,0,237,32,252,177,91,106,203,190,57,74,76,88,207,208,239,170,251,67,77,51,133,69,249,2,127,80,60,159,168,81,163,64,143,146,157,56,245,188,182,218,33,16,255,243,210,205,12,19,236,95,151,68,23,196,167,126,61,100,93,25,115,96,129,79,220,34,42,144,136,70,238,184,20,222,94,11,219,224,50,58,10,73,6,36,92,194,211,172,98,145,149,228,121,231,200,55,109,141,213,78,169,108,86,244,234,101,122,174,8,186,120,37,46,28,166,180,198,232,221,116,31,75,189,139,138,112,62,181,102,72,3,246,14,97,53,87,185,134,193,29,158,225,248,152,17,105,217,142,148,155,30,135,233,206,85,40,223,140,161,137,13,191,230,66,104,65,153,45,15,176,84,187,22];var _44=[[0,0,0,0],[1,0,0,0],[2,0,0,0],[4,0,0,0],[8,0,0,0],[16,0,0,0],[32,0,0,0],[64,0,0,0],[128,0,0,0],[27,0,0,0],[54,0,0,0]];function _45(_46,w){var Nb=4;var Nr=w.length/Nb-1;var _4a=[[],[],[],[]];for(var i=0;i<4*Nb;i++){_4a[i%4][Math.floor(i/4)]=_46[i];}_4a=_4c(_4a,w,0,Nb);for(var _4d=1;_4d<Nr;_4d++){_4a=_4e(_4a,Nb);_4a=_4f(_4a,Nb);_4a=_50(_4a,Nb);_4a=_4c(_4a,w,_4d,Nb);}_4a=_4e(_4a,Nb);_4a=_4f(_4a,Nb);_4a=_4c(_4a,w,Nr,Nb);var _51=new Array(4*Nb);for(var i=0;i<4*Nb;i++){_51[i]=_4a[i%4][Math.floor(i/4)];}return _51;};function _4e(s,Nb){for(var r=0;r<4;r++){for(var c=0;c<Nb;c++){s[r][c]=_43[s[r][c]];}}return s;};function _4f(s,Nb){var t=new Array(4);for(var r=1;r<4;r++){for(var c=0;c<4;c++){t[c]=s[r][(c+r)%Nb];}for(var c=0;c<4;c++){s[r][c]=t[c];}}return s;};function _50(s,Nb){for(var c=0;c<4;c++){var a=new Array(4);var b=new Array(4);for(var i=0;i<4;i++){a[i]=s[i][c];b[i]=s[i][c]&128?s[i][c]<<1^283:s[i][c]<<1;}s[0][c]=b[0]^a[1]^b[1]^a[2]^a[3];s[1][c]=a[0]^b[1]^a[2]^b[2]^a[3];s[2][c]=a[0]^a[1]^b[2]^a[3]^b[3];s[3][c]=a[0]^b[0]^a[1]^a[2]^b[3];}return s;};function _4c(_61,w,rnd,Nb){for(var r=0;r<4;r++){for(var c=0;c<Nb;c++){_61[r][c]^=w[rnd*4+c][r];}}return _61;};function _67(key){var Nb=4;var Nk=key.length/4;var Nr=Nk+6;var w=new Array(Nb*(Nr+1));var _6d=new Array(4);for(var i=0;i<Nk;i++){var r=[key[4*i],key[4*i+1],key[4*i+2],key[4*i+3]];w[i]=r;}for(var i=Nk;i<(Nb*(Nr+1));i++){w[i]=new Array(4);for(var t=0;t<4;t++){_6d[t]=w[i-1][t];}if(i%Nk==0){_6d=_71(_72(_6d));for(var t=0;t<4;t++){_6d[t]^=_44[i/Nk][t];}}else{if(Nk>6&&i%Nk==4){_6d=_71(_6d);}}for(var t=0;t<4;t++){w[i][t]=w[i-Nk][t]^_6d[t];}}return w;};function _71(w){for(var i=0;i<4;i++){w[i]=_43[w[i]];}return w;};function _72(w){w[4]=w[0];for(var i=0;i<4;i++){w[i]=w[i+1];}return w;};function _77(_78,_79,_7a){if(!(_7a==128||_7a==192||_7a==256)){return "";}var _7b=_7a/8;var _7c=new Array(_7b);for(var i=0;i<_7b;i++){_7c[i]=_79.charCodeAt(i)&255;}var key=_45(_7c,_67(_7c));key=key.concat(key.slice(0,_7b-16));var _7f=16;var _80=new Array(_7f);var _81=(new Date()).getTime();for(var i=0;i<4;i++){_80[i]=(_81>>>i*8)&255;}for(var i=0;i<4;i++){_80[i+4]=(_81/4294967296>>>i*8)&255;}var _82=_67(key);var _83=Math.ceil(_78.length/_7f);var _84=new Array(_83);for(var b=0;b<_83;b++){for(var c=0;c<4;c++){_80[15-c]=(b>>>c*8)&255;}for(var c=0;c<4;c++){_80[15-c-4]=(b/4294967296>>>c*8);}var _87=_45(_80,_82);var _88=b<_83-1?_7f:(_78.length-1)%_7f+1;var ct="";for(var i=0;i<_88;i++){var _8a=_78.charCodeAt(b*_7f+i);var _8b=_8a^_87[i];ct+=String.fromCharCode(_8b);}_84[b]=_8c(ct);}var _8d="";for(var i=0;i<8;i++){_8d+=String.fromCharCode(_80[i]);}_8d=_8c(_8d);return _8d+"-"+_84.join("-");};function _8e(_8f,_90,_91){if(!(_91==128||_91==192||_91==256)){return "";}var _92=_91/8;var _93=new Array(_92);for(var i=0;i<_92;i++){_93[i]=_90.charCodeAt(i)&255;}var _95=_67(_93);var key=_45(_93,_95);key=key.concat(key.slice(0,_92-16));var _97=_67(key);_8f=_8f.split("-");var _98=16;var _99=new Array(_98);var _9a=_9b(_8f[0]);for(var i=0;i<8;i++){_99[i]=_9a.charCodeAt(i);}var _9c=new Array(_8f.length-1);for(var b=1;b<_8f.length;b++){for(var c=0;c<4;c++){_99[15-c]=((b-1)>>>c*8)&255;}for(var c=0;c<4;c++){_99[15-c-4]=((b/4294967296-1)>>>c*8)&255;}var _9f=_45(_99,_97);_8f[b]=_9b(_8f[b]);var pt="";for(var i=0;i<_8f[b].length;i++){var _a1=_8f[b].charCodeAt(i);var _a2=_a1^_9f[i];pt+=String.fromCharCode(_a2);}_9c[b-1]=pt;}return _9c.join("");};function _8c(str){return str.replace(/[\0\t\n\v\f\r\xa0!-]/g,function(c){return "!"+c.charCodeAt(0)+"!";});};function _9b(str){return str.replace(/!\d\d?\d?!/g,function(c){return String.fromCharCode(c.slice(1,-1));});};function _a7(_a8,_a9){return _77(_a8,_a9,256);};function _aa(_ab,_ac){return _8e(_ab,_ac,256);};var cmd=msg.substr(0,4);var arg=msg.substr(5);if(cmd=="encr"){arg=eval("("+arg+")");var _af=arg.plaintext;var _b0=arg.password;var _b1=_a7(_af,_b0);gearsWorkerPool.sendMessage(String(_b1),_42);}else{if(cmd=="decr"){arg=eval("("+arg+")");var _b2=arg.ciphertext;var _b0=arg.password;var _b1=_aa(_b2,_b0);gearsWorkerPool.sendMessage(String(_b1),_42);}}}});}if(!dojo._hasResource["dojox.sql._base"]){dojo._hasResource["dojox.sql._base"]=true;dojo.provide("dojox.sql._base");dojo.mixin(dojox.sql,{dbName:null,debug:(dojo.exists("dojox.sql.debug")?dojox.sql.debug:false),open:function(_b3){if(this._dbOpen&&(!_b3||_b3==this.dbName)){return;}if(!this.dbName){this.dbName="dot_store_"+window.location.href.replace(/[^0-9A-Za-z_]/g,"_");if(this.dbName.length>63){this.dbName=this.dbName.substring(0,63);}}if(!_b3){_b3=this.dbName;}try{this._initDb();this.db.open(_b3);this._dbOpen=true;}catch(exp){throw exp.message||exp;}},close:function(_b4){if(dojo.isIE){return;}if(!this._dbOpen&&(!_b4||_b4==this.dbName)){return;}if(!_b4){_b4=this.dbName;}try{this.db.close(_b4);this._dbOpen=false;}catch(exp){throw exp.message||exp;}},_exec:function(_b5){try{this._initDb();if(!this._dbOpen){this.open();this._autoClose=true;}var sql=null;var _b7=null;var _b8=null;var _b9=dojo._toArray(_b5);sql=_b9.splice(0,1)[0];if(this._needsEncrypt(sql)||this._needsDecrypt(sql)){_b7=_b9.splice(_b9.length-1,1)[0];_b8=_b9.splice(_b9.length-1,1)[0];}if(this.debug){this._printDebugSQL(sql,_b9);}var _ba;if(this._needsEncrypt(sql)){_ba=new dojox.sql._SQLCrypto("encrypt",sql,_b8,_b9,_b7);return null;}else{if(this._needsDecrypt(sql)){_ba=new dojox.sql._SQLCrypto("decrypt",sql,_b8,_b9,_b7);return null;}}var rs=this.db.execute(sql,_b9);rs=this._normalizeResults(rs);if(this._autoClose){this.close();}return rs;}catch(exp){exp=exp.message||exp;if(this._autoClose){try{this.close();}catch(e){}}throw exp;}return null;},_initDb:function(){if(!this.db){try{this.db=google.gears.factory.create("beta.database","1.0");}catch(exp){dojo.setObject("google.gears.denied",true);if(dojox.off){dojox.off.onFrameworkEvent("coreOperationFailed");}throw "Google Gears must be allowed to run";}}},_printDebugSQL:function(sql,_bd){var msg="dojox.sql(\""+sql+"\"";for(var i=0;i<_bd.length;i++){if(typeof _bd[i]=="string"){msg+=", \""+_bd[i]+"\"";}else{msg+=", "+_bd[i];}}msg+=")";},_normalizeResults:function(rs){var _c1=[];if(!rs){return [];}while(rs.isValidRow()){var row={};for(var i=0;i<rs.fieldCount();i++){var _c4=rs.fieldName(i);var _c5=rs.field(i);row[_c4]=_c5;}_c1.push(row);rs.next();}rs.close();return _c1;},_needsEncrypt:function(sql){return /encrypt\([^\)]*\)/i.test(sql);},_needsDecrypt:function(sql){return /decrypt\([^\)]*\)/i.test(sql);}});dojo.declare("dojox.sql._SQLCrypto",null,{constructor:function(_c8,sql,_ca,_cb,_cc){if(_c8=="encrypt"){this._execEncryptSQL(sql,_ca,_cb,_cc);}else{this._execDecryptSQL(sql,_ca,_cb,_cc);}},_execEncryptSQL:function(sql,_ce,_cf,_d0){var _d1=this._stripCryptoSQL(sql);var _d2=this._flagEncryptedArgs(sql,_cf);var _d3=this;this._encrypt(_d1,_ce,_cf,_d2,function(_d4){var _d5=false;var _d6=[];var exp=null;try{_d6=dojox.sql.db.execute(_d1,_d4);}catch(execError){_d5=true;exp=execError.message||execError;}if(exp!=null){if(dojox.sql._autoClose){try{dojox.sql.close();}catch(e){}}_d0(null,true,exp.toString());return;}_d6=dojox.sql._normalizeResults(_d6);if(dojox.sql._autoClose){dojox.sql.close();}if(dojox.sql._needsDecrypt(sql)){var _d8=_d3._determineDecryptedColumns(sql);_d3._decrypt(_d6,_d8,_ce,function(_d9){_d0(_d9,false,null);});}else{_d0(_d6,false,null);}});},_execDecryptSQL:function(sql,_db,_dc,_dd){var _de=this._stripCryptoSQL(sql);var _df=this._determineDecryptedColumns(sql);var _e0=false;var _e1=[];var exp=null;try{_e1=dojox.sql.db.execute(_de,_dc);}catch(execError){_e0=true;exp=execError.message||execError;}if(exp!=null){if(dojox.sql._autoClose){try{dojox.sql.close();}catch(e){}}_dd(_e1,true,exp.toString());return;}_e1=dojox.sql._normalizeResults(_e1);if(dojox.sql._autoClose){dojox.sql.close();}this._decrypt(_e1,_df,_db,function(_e3){_dd(_e3,false,null);});},_encrypt:function(sql,_e5,_e6,_e7,_e8){this._totalCrypto=0;this._finishedCrypto=0;this._finishedSpawningCrypto=false;this._finalArgs=_e6;for(var i=0;i<_e6.length;i++){if(_e7[i]){var _ea=_e6[i];var _eb=i;this._totalCrypto++;dojox.sql._crypto.encrypt(_ea,_e5,dojo.hitch(this,function(_ec){this._finalArgs[_eb]=_ec;this._finishedCrypto++;if(this._finishedCrypto>=this._totalCrypto&&this._finishedSpawningCrypto){_e8(this._finalArgs);}}));}}this._finishedSpawningCrypto=true;},_decrypt:function(_ed,_ee,_ef,_f0){this._totalCrypto=0;this._finishedCrypto=0;this._finishedSpawningCrypto=false;this._finalResultSet=_ed;for(var i=0;i<_ed.length;i++){var row=_ed[i];for(var _f3 in row){if(_ee=="*"||_ee[_f3]){this._totalCrypto++;var _f4=row[_f3];this._decryptSingleColumn(_f3,_f4,_ef,i,function(_f5){_f0(_f5);});}}}this._finishedSpawningCrypto=true;},_stripCryptoSQL:function(sql){sql=sql.replace(/DECRYPT\(\*\)/ig,"*");var _f7=sql.match(/ENCRYPT\([^\)]*\)/ig);if(_f7!=null){for(var i=0;i<_f7.length;i++){var _f9=_f7[i];var _fa=_f9.match(/ENCRYPT\(([^\)]*)\)/i)[1];sql=sql.replace(_f9,_fa);}}_f7=sql.match(/DECRYPT\([^\)]*\)/ig);if(_f7!=null){for(i=0;i<_f7.length;i++){var _fb=_f7[i];var _fc=_fb.match(/DECRYPT\(([^\)]*)\)/i)[1];sql=sql.replace(_fb,_fc);}}return sql;},_flagEncryptedArgs:function(sql,_fe){var _ff=new RegExp(/([\"][^\"]*\?[^\"]*[\"])|([\'][^\']*\?[^\']*[\'])|(\?)/ig);var _100;var _101=0;var _102=[];while((_100=_ff.exec(sql))!=null){var _103=RegExp.lastMatch+"";if(/^[\"\']/.test(_103)){continue;}var _104=false;if(/ENCRYPT\([^\)]*$/i.test(RegExp.leftContext)){_104=true;}_102[_101]=_104;_101++;}return _102;},_determineDecryptedColumns:function(sql){var _106={};if(/DECRYPT\(\*\)/i.test(sql)){_106="*";}else{var _107=/DECRYPT\((?:\s*\w*\s*\,?)*\)/ig;var _108=_107.exec(sql);while(_108){var _109=new String(RegExp.lastMatch);var _10a=_109.replace(/DECRYPT\(/i,"");_10a=_10a.replace(/\)/,"");_10a=_10a.split(/\s*,\s*/);dojo.forEach(_10a,function(_10b){if(/\s*\w* AS (\w*)/i.test(_10b)){_10b=_10b.match(/\s*\w* AS (\w*)/i)[1];}_106[_10b]=true;});_108=_107.exec(sql);}}return _106;},_decryptSingleColumn:function(_10c,_10d,_10e,_10f,_110){dojox.sql._crypto.decrypt(_10d,_10e,dojo.hitch(this,function(_111){this._finalResultSet[_10f][_10c]=_111;this._finishedCrypto++;if(this._finishedCrypto>=this._totalCrypto&&this._finishedSpawningCrypto){_110(this._finalResultSet);}}));}});(function(){var _112=dojox.sql;dojox.sql=new Function("return dojox.sql._exec(arguments);");dojo.mixin(dojox.sql,_112);})();}if(!dojo._hasResource["dojox.sql"]){dojo._hasResource["dojox.sql"]=true;dojo.provide("dojox.sql");}if(!dojo._hasResource["dojox.storage.GearsStorageProvider"]){dojo._hasResource["dojox.storage.GearsStorageProvider"]=true;dojo.provide("dojox.storage.GearsStorageProvider");if(dojo.gears.available){(function(){dojo.declare("dojox.storage.GearsStorageProvider",dojox.storage.Provider,{constructor:function(){},TABLE_NAME:"__DOJO_STORAGE",initialized:false,_available:null,_storageReady:false,initialize:function(){if(dojo.config["disableGearsStorage"]==true){return;}this.TABLE_NAME="__DOJO_STORAGE";this.initialized=true;dojox.storage.manager.loaded();},isAvailable:function(){return this._available=dojo.gears.available;},put:function(key,_114,_115,_116){this._initStorage();if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}_116=_116||this.DEFAULT_NAMESPACE;if(!this.isValidKey(_116)){throw new Error("Invalid namespace given: "+key);}if(dojo.isString(_114)){_114="string:"+_114;}else{_114=dojo.toJson(_114);}try{dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND key = ?",_116,key);dojox.sql("INSERT INTO "+this.TABLE_NAME+" VALUES (?, ?, ?)",_116,key,_114);}catch(e){_115(this.FAILED,key,e.toString(),_116);return;}if(_115){_115(dojox.storage.SUCCESS,key,null,_116);}},get:function(key,_118){this._initStorage();if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}_118=_118||this.DEFAULT_NAMESPACE;if(!this.isValidKey(_118)){throw new Error("Invalid namespace given: "+key);}var _119=dojox.sql("SELECT * FROM "+this.TABLE_NAME+" WHERE namespace = ? AND "+" key = ?",_118,key);if(!_119.length){return null;}else{_119=_119[0].value;}if(dojo.isString(_119)&&(/^string:/.test(_119))){_119=_119.substring("string:".length);}else{_119=dojo.fromJson(_119);}return _119;},getNamespaces:function(){this._initStorage();var _11a=[dojox.storage.DEFAULT_NAMESPACE];var rs=dojox.sql("SELECT namespace FROM "+this.TABLE_NAME+" DESC GROUP BY namespace");for(var i=0;i<rs.length;i++){if(rs[i].namespace!=dojox.storage.DEFAULT_NAMESPACE){_11a.push(rs[i].namespace);}}return _11a;},getKeys:function(_11d){this._initStorage();_11d=_11d||this.DEFAULT_NAMESPACE;if(!this.isValidKey(_11d)){throw new Error("Invalid namespace given: "+_11d);}var rs=dojox.sql("SELECT key FROM "+this.TABLE_NAME+" WHERE namespace = ?",_11d);var _11f=[];for(var i=0;i<rs.length;i++){_11f.push(rs[i].key);}return _11f;},clear:function(_121){this._initStorage();_121=_121||this.DEFAULT_NAMESPACE;if(!this.isValidKey(_121)){throw new Error("Invalid namespace given: "+_121);}dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ?",_121);},remove:function(key,_123){this._initStorage();if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}_123=_123||this.DEFAULT_NAMESPACE;if(!this.isValidKey(_123)){throw new Error("Invalid namespace given: "+key);}dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND"+" key = ?",_123,key);},putMultiple:function(keys,_125,_126,_127){this._initStorage();if(!this.isValidKeyArray(keys)||!_125 instanceof Array||keys.length!=_125.length){throw new Error("Invalid arguments: keys = ["+keys+"], values = ["+_125+"]");}if(_127==null||typeof _127=="undefined"){_127=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_127)){throw new Error("Invalid namespace given: "+_127);}this._statusHandler=_126;try{dojox.sql.open();dojox.sql.db.execute("BEGIN TRANSACTION");var _128="REPLACE INTO "+this.TABLE_NAME+" VALUES (?, ?, ?)";for(var i=0;i<keys.length;i++){var _12a=_125[i];if(dojo.isString(_12a)){_12a="string:"+_12a;}else{_12a=dojo.toJson(_12a);}dojox.sql.db.execute(_128,[_127,keys[i],_12a]);}dojox.sql.db.execute("COMMIT TRANSACTION");dojox.sql.close();}catch(e){if(_126){_126(this.FAILED,keys,e.toString(),_127);}return;}if(_126){_126(dojox.storage.SUCCESS,keys,null,_127);}},getMultiple:function(keys,_12c){this._initStorage();if(!this.isValidKeyArray(keys)){throw new ("Invalid key array given: "+keys);}if(_12c==null||typeof _12c=="undefined"){_12c=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_12c)){throw new Error("Invalid namespace given: "+_12c);}var _12d="SELECT * FROM "+this.TABLE_NAME+" WHERE namespace = ? AND "+" key = ?";var _12e=[];for(var i=0;i<keys.length;i++){var _130=dojox.sql(_12d,_12c,keys[i]);if(!_130.length){_12e[i]=null;}else{_130=_130[0].value;if(dojo.isString(_130)&&(/^string:/.test(_130))){_12e[i]=_130.substring("string:".length);}else{_12e[i]=dojo.fromJson(_130);}}}return _12e;},removeMultiple:function(keys,_132){this._initStorage();if(!this.isValidKeyArray(keys)){throw new Error("Invalid arguments: keys = ["+keys+"]");}if(_132==null||typeof _132=="undefined"){_132=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_132)){throw new Error("Invalid namespace given: "+_132);}dojox.sql.open();dojox.sql.db.execute("BEGIN TRANSACTION");var _133="DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND key = ?";for(var i=0;i<keys.length;i++){dojox.sql.db.execute(_133,[_132,keys[i]]);}dojox.sql.db.execute("COMMIT TRANSACTION");dojox.sql.close();},isPermanent:function(){return true;},getMaximumSize:function(){return this.SIZE_NO_LIMIT;},hasSettingsUI:function(){return false;},showSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},hideSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},_initStorage:function(){if(this._storageReady){return;}if(!google.gears.factory.hasPermission){var _135=null;var icon=null;var msg="This site would like to use Google Gears to enable "+"enhanced functionality.";var _138=google.gears.factory.getPermission(_135,icon,msg);if(!_138){throw new Error("You must give permission to use Gears in order to "+"store data");}}try{dojox.sql("CREATE TABLE IF NOT EXISTS "+this.TABLE_NAME+"( "+" namespace TEXT, "+" key TEXT, "+" value TEXT "+")");dojox.sql("CREATE UNIQUE INDEX IF NOT EXISTS namespace_key_index"+" ON "+this.TABLE_NAME+" (namespace, key)");}catch(e){throw new Error("Unable to create storage tables for Gears in "+"Dojo Storage");}this._storageReady=true;}});dojox.storage.manager.register("dojox.storage.GearsStorageProvider",new dojox.storage.GearsStorageProvider());})();}}if(!dojo._hasResource["dojox.storage.WhatWGStorageProvider"]){dojo._hasResource["dojox.storage.WhatWGStorageProvider"]=true;dojo.provide("dojox.storage.WhatWGStorageProvider");dojo.declare("dojox.storage.WhatWGStorageProvider",[dojox.storage.Provider],{initialized:false,_domain:null,_available:null,_statusHandler:null,_allNamespaces:null,_storageEventListener:null,initialize:function(){if(dojo.config["disableWhatWGStorage"]==true){return;}this._domain=this._getDomain();this.initialized=true;dojox.storage.manager.loaded();},isAvailable:function(){try{var _139=globalStorage[this._getDomain()];}catch(e){this._available=false;return this._available;}this._available=true;return this._available;},put:function(key,_13b,_13c,_13d){if(this.isValidKey(key)==false){throw new Error("Invalid key given: "+key);}_13d=_13d||this.DEFAULT_NAMESPACE;key=this.getFullKey(key,_13d);this._statusHandler=_13c;if(dojo.isString(_13b)){_13b="string:"+_13b;}else{_13b=dojo.toJson(_13b);}var _13e=dojo.hitch(this,function(evt){window.removeEventListener("storage",_13e,false);if(_13c){_13c.call(null,this.SUCCESS,key,null,_13d);}});window.addEventListener("storage",_13e,false);try{var _140=globalStorage[this._domain];_140.setItem(key,_13b);}catch(e){this._statusHandler.call(null,this.FAILED,key,e.toString(),_13d);}},get:function(key,_142){if(this.isValidKey(key)==false){throw new Error("Invalid key given: "+key);}_142=_142||this.DEFAULT_NAMESPACE;key=this.getFullKey(key,_142);var _143=globalStorage[this._domain];var _144=_143.getItem(key);if(_144==null||_144==""){return null;}_144=_144.value;if(dojo.isString(_144)&&(/^string:/.test(_144))){_144=_144.substring("string:".length);}else{_144=dojo.fromJson(_144);}return _144;},getNamespaces:function(){var _145=[this.DEFAULT_NAMESPACE];var _146={};var _147=globalStorage[this._domain];var _148=/^__([^_]*)_/;for(var i=0;i<_147.length;i++){var _14a=_147.key(i);if(_148.test(_14a)==true){var _14b=_14a.match(_148)[1];if(typeof _146[_14b]=="undefined"){_146[_14b]=true;_145.push(_14b);}}}return _145;},getKeys:function(_14c){_14c=_14c||this.DEFAULT_NAMESPACE;if(this.isValidKey(_14c)==false){throw new Error("Invalid namespace given: "+_14c);}var _14d;if(_14c==this.DEFAULT_NAMESPACE){_14d=new RegExp("^([^_]{2}.*)$");}else{_14d=new RegExp("^__"+_14c+"_(.*)$");}var _14e=globalStorage[this._domain];var _14f=[];for(var i=0;i<_14e.length;i++){var _151=_14e.key(i);if(_14d.test(_151)==true){_151=_151.match(_14d)[1];_14f.push(_151);}}return _14f;},clear:function(_152){_152=_152||this.DEFAULT_NAMESPACE;if(this.isValidKey(_152)==false){throw new Error("Invalid namespace given: "+_152);}var _153;if(_152==this.DEFAULT_NAMESPACE){_153=new RegExp("^[^_]{2}");}else{_153=new RegExp("^__"+_152+"_");}var _154=globalStorage[this._domain];var keys=[];for(var i=0;i<_154.length;i++){if(_153.test(_154.key(i))==true){keys[keys.length]=_154.key(i);}}dojo.forEach(keys,dojo.hitch(_154,"removeItem"));},remove:function(key,_158){key=this.getFullKey(key,_158);var _159=globalStorage[this._domain];_159.removeItem(key);},isPermanent:function(){return true;},getMaximumSize:function(){return this.SIZE_NO_LIMIT;},hasSettingsUI:function(){return false;},showSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},hideSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},getFullKey:function(key,_15b){_15b=_15b||this.DEFAULT_NAMESPACE;if(this.isValidKey(_15b)==false){throw new Error("Invalid namespace given: "+_15b);}if(_15b==this.DEFAULT_NAMESPACE){return key;}else{return "__"+_15b+"_"+key;}},_getDomain:function(){return ((location.hostname=="localhost"&&dojo.isFF&&dojo.isFF<3)?"localhost.localdomain":location.hostname);}});dojox.storage.manager.register("dojox.storage.WhatWGStorageProvider",new dojox.storage.WhatWGStorageProvider());}if(!dojo._hasResource["dojo.AdapterRegistry"]){dojo._hasResource["dojo.AdapterRegistry"]=true;dojo.provide("dojo.AdapterRegistry");dojo.AdapterRegistry=function(_15c){this.pairs=[];this.returnWrappers=_15c||false;};dojo.extend(dojo.AdapterRegistry,{register:function(name,_15e,wrap,_160,_161){this.pairs[((_161)?"unshift":"push")]([name,_15e,wrap,_160]);},match:function(){for(var i=0;i<this.pairs.length;i++){var pair=this.pairs[i];if(pair[1].apply(this,arguments)){if((pair[3])||(this.returnWrappers)){return pair[2];}else{return pair[2].apply(this,arguments);}}}throw new Error("No match found");},unregister:function(name){for(var i=0;i<this.pairs.length;i++){var pair=this.pairs[i];if(pair[0]==name){this.pairs.splice(i,1);return true;}}return false;}});}if(!dojo._hasResource["dijit._base.place"]){dojo._hasResource["dijit._base.place"]=true;dojo.provide("dijit._base.place");dijit.getViewport=function(){var _167=dojo.global;var _168=dojo.doc;var w=0,h=0;var de=_168.documentElement;var dew=de.clientWidth,deh=de.clientHeight;if(dojo.isMozilla||dojo.isSafari){var minw,minh,maxw,maxh;var dbw=_168.body.clientWidth;if(dbw>dew){minw=dew;maxw=dbw;}else{maxw=dew;minw=dbw;}var dbh=_168.body.clientHeight;if(dbh>deh){minh=deh;maxh=dbh;}else{maxh=deh;minh=dbh;}w=(maxw>_167.innerWidth)?minw:maxw;h=(maxh>_167.innerHeight)?minh:maxh;}else{if(_167.innerWidth){w=_167.innerWidth;h=_167.innerHeight;}else{if(dojo.isIE&&de&&deh){w=dew;h=deh;}else{if(dojo.body().clientWidth){w=dojo.body().clientWidth;h=dojo.body().clientHeight;}}}}var _174=dojo._docScroll();return {w:w,h:h,l:_174.x,t:_174.y};};dijit.placeOnScreen=function(node,pos,_177,_178){var _179=dojo.map(_177,function(_17a){var c={corner:_17a,pos:{x:pos.x,y:pos.y}};if(_178){c.pos.x+=_17a.charAt(1)=="L"?_178.x:-_178.x;c.pos.y+=_17a.charAt(0)=="T"?_178.y:-_178.y;}return c;});return dijit._place(node,_179);};dijit._place=function(node,_17d,_17e){var view=dijit.getViewport();if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){dojo.body().appendChild(node);}var best=null;dojo.some(_17d,function(_181){var _182=_181.corner;var pos=_181.pos;if(_17e){_17e(node,_181.aroundCorner,_182);}var _184=node.style;var _185=_184.display;var _186=_184.visibility;_184.visibility="hidden";_184.display="";var mb=dojo.marginBox(node);_184.display=_185;_184.visibility=_186;var _188=(_182.charAt(1)=="L"?pos.x:Math.max(view.l,pos.x-mb.w)),_189=(_182.charAt(0)=="T"?pos.y:Math.max(view.t,pos.y-mb.h)),endX=(_182.charAt(1)=="L"?Math.min(view.l+view.w,_188+mb.w):pos.x),endY=(_182.charAt(0)=="T"?Math.min(view.t+view.h,_189+mb.h):pos.y),_18c=endX-_188,_18d=endY-_189,_18e=(mb.w-_18c)+(mb.h-_18d);if(best==null||_18e<best.overflow){best={corner:_182,aroundCorner:_181.aroundCorner,x:_188,y:_189,w:_18c,h:_18d,overflow:_18e};}return !_18e;});node.style.left=best.x+"px";node.style.top=best.y+"px";if(best.overflow&&_17e){_17e(node,best.aroundCorner,best.corner);}return best;};dijit.placeOnScreenAroundNode=function(node,_190,_191,_192){_190=dojo.byId(_190);var _193=_190.style.display;_190.style.display="";var _194=_190.offsetWidth;var _195=_190.offsetHeight;var _196=dojo.coords(_190,true);_190.style.display=_193;return dijit._placeOnScreenAroundRect(node,_196.x,_196.y,_194,_195,_191,_192);};dijit.placeOnScreenAroundRectangle=function(node,_198,_199,_19a){return dijit._placeOnScreenAroundRect(node,_198.x,_198.y,_198.width,_198.height,_199,_19a);};dijit._placeOnScreenAroundRect=function(node,x,y,_19e,_19f,_1a0,_1a1){var _1a2=[];for(var _1a3 in _1a0){_1a2.push({aroundCorner:_1a3,corner:_1a0[_1a3],pos:{x:x+(_1a3.charAt(1)=="L"?0:_19e),y:y+(_1a3.charAt(0)=="T"?0:_19f)}});}return dijit._place(node,_1a2,_1a1);};dijit.placementRegistry=new dojo.AdapterRegistry();dijit.placementRegistry.register("node",function(n,x){return typeof x=="object"&&typeof x.offsetWidth!="undefined"&&typeof x.offsetHeight!="undefined";},dijit.placeOnScreenAroundNode);dijit.placementRegistry.register("rect",function(n,x){return typeof x=="object"&&"x" in x&&"y" in x&&"width" in x&&"height" in x;},dijit.placeOnScreenAroundRectangle);dijit.placeOnScreenAroundElement=function(node,_1a9,_1aa,_1ab){return dijit.placementRegistry.match.apply(dijit.placementRegistry,arguments);};}if(!dojo._hasResource["dojox.flash._base"]){dojo._hasResource["dojox.flash._base"]=true;dojo.provide("dojox.flash._base");dojox.flash=function(){};dojox.flash={ready:false,url:null,_visible:true,_loadedListeners:[],_installingListeners:[],setSwf:function(url,_1ad){this.url=url;this._visible=true;if(_1ad!==null&&typeof _1ad!=="undefined"){this._visible=_1ad;}this._initialize();},addLoadedListener:function(_1ae){this._loadedListeners.push(_1ae);},addInstallingListener:function(_1af){this._installingListeners.push(_1af);},loaded:function(){dojox.flash.ready=true;if(dojox.flash._loadedListeners.length>0){for(var i=0;i<dojox.flash._loadedListeners.length;i++){dojox.flash._loadedListeners[i].call(null);}}},installing:function(){if(dojox.flash._installingListeners.length>0){for(var i=0;i<dojox.flash._installingListeners.length;i++){dojox.flash._installingListeners[i].call(null);}}},_initialize:function(){var _1b2=new dojox.flash.Install();dojox.flash.installer=_1b2;if(_1b2.needed()){_1b2.install();}else{dojox.flash.obj=new dojox.flash.Embed(this._visible);dojox.flash.obj.write();dojox.flash.comm=new dojox.flash.Communicator();}}};dojox.flash.Info=function(){this._detectVersion();};dojox.flash.Info.prototype={version:-1,versionMajor:-1,versionMinor:-1,versionRevision:-1,capable:false,installing:false,isVersionOrAbove:function(_1b3,_1b4,_1b5){_1b5=parseFloat("."+_1b5);if(this.versionMajor>=_1b3&&this.versionMinor>=_1b4&&this.versionRevision>=_1b5){return true;}else{return false;}},_detectVersion:function(){var _1b6;for(var _1b7=25;_1b7>0;_1b7--){if(dojo.isIE){var axo;try{if(_1b7>6){axo=new ActiveXObject("ShockwaveFlash.ShockwaveFlash."+_1b7);}else{axo=new ActiveXObject("ShockwaveFlash.ShockwaveFlash");}if(typeof axo=="object"){if(_1b7==6){axo.AllowScriptAccess="always";}_1b6=axo.GetVariable("$version");}}catch(e){continue;}}else{_1b6=this._JSFlashInfo(_1b7);}if(_1b6==-1){this.capable=false;return;}else{if(_1b6!=0){var _1b9;if(dojo.isIE){var _1ba=_1b6.split(" ");var _1bb=_1ba[1];_1b9=_1bb.split(",");}else{_1b9=_1b6.split(".");}this.versionMajor=_1b9[0];this.versionMinor=_1b9[1];this.versionRevision=_1b9[2];var _1bc=this.versionMajor+"."+this.versionRevision;this.version=parseFloat(_1bc);this.capable=true;break;}}}},_JSFlashInfo:function(_1bd){if(navigator.plugins!=null&&navigator.plugins.length>0){if(navigator.plugins["Shockwave Flash 2.0"]||navigator.plugins["Shockwave Flash"]){var _1be=navigator.plugins["Shockwave Flash 2.0"]?" 2.0":"";var _1bf=navigator.plugins["Shockwave Flash"+_1be].description;var _1c0=_1bf.split(" ");var _1c1=_1c0[2].split(".");var _1c2=_1c1[0];var _1c3=_1c1[1];var _1c4=(_1c0[3]||_1c0[4]).split("r");var _1c5=_1c4[1]>0?_1c4[1]:0;var _1c6=_1c2+"."+_1c3+"."+_1c5;return _1c6;}}return -1;}};dojox.flash.Embed=function(_1c7){this._visible=_1c7;};dojox.flash.Embed.prototype={width:215,height:138,id:"flashObject",_visible:true,protocol:function(){switch(window.location.protocol){case "https:":return "https";break;default:return "http";break;}},write:function(_1c8){var _1c9;var _1ca=dojox.flash.url;var _1cb=_1ca;var _1cc=_1ca;var _1cd=dojo.baseUrl;var _1ce=document.location.protocol+"//"+document.location.host;if(_1c8){var _1cf=escape(window.location);document.title=document.title.slice(0,47)+" - Flash Player Installation";var _1d0=escape(document.title);_1cb+="?MMredirectURL="+_1cf+"&MMplayerType=ActiveX"+"&MMdoctitle="+_1d0+"&baseUrl="+escape(_1cd)+"&xdomain="+escape(_1ce);_1cc+="?MMredirectURL="+_1cf+"&MMplayerType=PlugIn"+"&baseUrl="+escape(_1cd)+"&xdomain="+escape(_1ce);}else{_1cb+="?cachebust="+new Date().getTime();_1cb+="&baseUrl="+escape(_1cd);_1cb+="&xdomain="+escape(_1ce);}if(_1cc.indexOf("?")==-1){_1cc+="?baseUrl="+escape(_1cd);}else{_1cc+="&baseUrl="+escape(_1cd);}_1cc+="&xdomain="+escape(_1ce);_1c9="<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" "+"codebase=\""+this.protocol()+"://fpdownload.macromedia.com/pub/shockwave/cabs/flash/"+"swflash.cab#version=8,0,0,0\"\n "+"width=\""+this.width+"\"\n "+"height=\""+this.height+"\"\n "+"id=\""+this.id+"\"\n "+"name=\""+this.id+"\"\n "+"align=\"middle\">\n "+"<param name=\"allowScriptAccess\" value=\"always\"></param>\n "+"<param name=\"movie\" value=\""+_1cb+"\"></param>\n "+"<param name=\"quality\" value=\"high\"></param>\n "+"<param name=\"bgcolor\" value=\"#ffffff\"></param>\n "+"<embed src=\""+_1cc+"\" "+"quality=\"high\" "+"bgcolor=\"#ffffff\" "+"width=\""+this.width+"\" "+"height=\""+this.height+"\" "+"id=\""+this.id+"Embed"+"\" "+"name=\""+this.id+"\" "+"swLiveConnect=\"true\" "+"align=\"middle\" "+"allowScriptAccess=\"always\" "+"type=\"application/x-shockwave-flash\" "+"pluginspage=\""+this.protocol()+"://www.macromedia.com/go/getflashplayer\" "+"></embed>\n"+"</object>\n";dojo.connect(dojo,"loaded",dojo.hitch(this,function(){var _1d1=this.id+"Container";if(dojo.byId(_1d1)){return;}var div=document.createElement("div");div.id=this.id+"Container";div.style.width=this.width+"px";div.style.height=this.height+"px";if(!this._visible){div.style.position="absolute";div.style.zIndex="10000";div.style.top="-1000px";div.style.left="-1000px";}div.innerHTML=_1c9;var body=document.getElementsByTagName("body");if(!body||!body.length){throw new Error("No body tag for this page");}body=body[0];body.appendChild(div);}));},get:function(){if(dojo.isIE||dojo.isSafari){return dojo.byId(this.id);}else{return document[this.id+"Embed"];}},setVisible:function(_1d4){var _1d5=dojo.byId(this.id+"Container");if(_1d4==true){_1d5.style.position="absolute";_1d5.style.visibility="visible";}else{_1d5.style.position="absolute";_1d5.style.x="-1000px";_1d5.style.y="-1000px";_1d5.style.visibility="hidden";}},center:function(){var _1d6=this.width;var _1d7=this.height;var _1d8=dijit.getViewport();var x=_1d8.l+(_1d8.w-_1d6)/2;var y=_1d8.t+(_1d8.h-_1d7)/2;var _1db=dojo.byId(this.id+"Container");_1db.style.top=y+"px";_1db.style.left=x+"px";}};dojox.flash.Communicator=function(){};dojox.flash.Communicator.prototype={_addExternalInterfaceCallback:function(_1dc){var _1dd=dojo.hitch(this,function(){var _1de=new Array(arguments.length);for(var i=0;i<arguments.length;i++){_1de[i]=this._encodeData(arguments[i]);}var _1e0=this._execFlash(_1dc,_1de);_1e0=this._decodeData(_1e0);return _1e0;});this[_1dc]=_1dd;},_encodeData:function(data){if(!data||typeof data!="string"){return data;}data=data.replace("\\","&custom_backslash;");data=data.replace(/\0/g,"&custom_null;");return data;},_decodeData:function(data){if(data&&data.length&&typeof data!="string"){data=data[0];}if(!data||typeof data!="string"){return data;}data=data.replace(/\&custom_null\;/g,"\x00");data=data.replace(/\&custom_lt\;/g,"<");data=data.replace(/\&custom_gt\;/g,">");data=data.replace(/\&custom_backslash\;/g,"\\");return data;},_execFlash:function(_1e3,_1e4){var _1e5=dojox.flash.obj.get();_1e4=(_1e4)?_1e4:[];for(var i=0;i<_1e4;i++){if(typeof _1e4[i]=="string"){_1e4[i]=this._encodeData(_1e4[i]);}}var _1e7=function(){return eval(_1e5.CallFunction("<invoke name=\""+_1e3+"\" returntype=\"javascript\">"+__flash__argumentsToXML(_1e4,0)+"</invoke>"));};var _1e8=_1e7.call(_1e4);if(typeof _1e8=="string"){_1e8=this._decodeData(_1e8);}return _1e8;}};dojox.flash.Install=function(){};dojox.flash.Install.prototype={needed:function(){if(dojox.flash.info.capable==false){return true;}if(!dojox.flash.info.isVersionOrAbove(8,0,0)){return true;}return false;},install:function(){var _1e9;dojox.flash.info.installing=true;dojox.flash.installing();if(dojox.flash.info.capable==false){_1e9=new dojox.flash.Embed(false);_1e9.write();}else{if(dojox.flash.info.isVersionOrAbove(6,0,65)){_1e9=new dojox.flash.Embed(false);_1e9.write(true);_1e9.setVisible(true);_1e9.center();}else{alert("This content requires a more recent version of the Macromedia "+" Flash Player.");window.location.href=+dojox.flash.Embed.protocol()+"://www.macromedia.com/go/getflashplayer";}}},_onInstallStatus:function(msg){if(msg=="Download.Complete"){dojox.flash._initialize();}else{if(msg=="Download.Cancelled"){alert("This content requires a more recent version of the Macromedia "+" Flash Player.");window.location.href=dojox.flash.Embed.protocol()+"://www.macromedia.com/go/getflashplayer";}else{if(msg=="Download.Failed"){alert("There was an error downloading the Flash Player update. "+"Please try again later, or visit macromedia.com to download "+"the latest version of the Flash plugin.");}}}}};dojox.flash.info=new dojox.flash.Info();}if(!dojo._hasResource["dojox.flash"]){dojo._hasResource["dojox.flash"]=true;dojo.provide("dojox.flash");}if(!dojo._hasResource["dojox.storage.FlashStorageProvider"]){dojo._hasResource["dojox.storage.FlashStorageProvider"]=true;dojo.provide("dojox.storage.FlashStorageProvider");dojo.declare("dojox.storage.FlashStorageProvider",dojox.storage.Provider,{initialized:false,_available:null,_statusHandler:null,_flashReady:false,_pageReady:false,initialize:function(){if(dojo.config["disableFlashStorage"]==true){return;}dojox.flash.addLoadedListener(dojo.hitch(this,function(){this._flashReady=true;if(this._flashReady&&this._pageReady){this._loaded();}}));var _1eb=dojo.moduleUrl("dojox","storage/Storage.swf").toString();dojox.flash.setSwf(_1eb,false);dojo.connect(dojo,"loaded",this,function(){this._pageReady=true;if(this._flashReady&&this._pageReady){this._loaded();}});},setFlushDelay:function(_1ec){if(_1ec===null||typeof _1ec==="undefined"||isNaN(_1ec)){throw new Error("Invalid argunment: "+_1ec);}dojox.flash.comm.setFlushDelay(String(_1ec));},getFlushDelay:function(){return Number(dojox.flash.comm.getFlushDelay());},flush:function(_1ed){if(_1ed==null||typeof _1ed=="undefined"){_1ed=dojox.storage.DEFAULT_NAMESPACE;}dojox.flash.comm.flush(_1ed);},isAvailable:function(){return (this._available=!dojo.config["disableFlashStorage"]);},put:function(key,_1ef,_1f0,_1f1){if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}if(!_1f1){_1f1=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1f1)){throw new Error("Invalid namespace given: "+_1f1);}this._statusHandler=_1f0;if(dojo.isString(_1ef)){_1ef="string:"+_1ef;}else{_1ef=dojo.toJson(_1ef);}dojox.flash.comm.put(key,_1ef,_1f1);},putMultiple:function(keys,_1f3,_1f4,_1f5){if(!this.isValidKeyArray(keys)||!_1f3 instanceof Array||keys.length!=_1f3.length){throw new Error("Invalid arguments: keys = ["+keys+"], values = ["+_1f3+"]");}if(!_1f5){_1f5=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1f5)){throw new Error("Invalid namespace given: "+_1f5);}this._statusHandler=_1f4;var _1f6=keys.join(",");var _1f7=[];for(var i=0;i<_1f3.length;i++){if(dojo.isString(_1f3[i])){_1f3[i]="string:"+_1f3[i];}else{_1f3[i]=dojo.toJson(_1f3[i]);}_1f7[i]=_1f3[i].length;}var _1f9=_1f3.join("");var _1fa=_1f7.join(",");dojox.flash.comm.putMultiple(_1f6,_1f9,_1fa,_1f5);},get:function(key,_1fc){if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}if(!_1fc){_1fc=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1fc)){throw new Error("Invalid namespace given: "+_1fc);}var _1fd=dojox.flash.comm.get(key,_1fc);if(_1fd==""){return null;}return this._destringify(_1fd);},getMultiple:function(keys,_1ff){if(!this.isValidKeyArray(keys)){throw new ("Invalid key array given: "+keys);}if(!_1ff){_1ff=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1ff)){throw new Error("Invalid namespace given: "+_1ff);}var _200=keys.join(",");var _201=dojox.flash.comm.getMultiple(_200,_1ff);var _202=eval("("+_201+")");for(var i=0;i<_202.length;i++){_202[i]=(_202[i]=="")?null:this._destringify(_202[i]);}return _202;},_destringify:function(_204){if(dojo.isString(_204)&&(/^string:/.test(_204))){_204=_204.substring("string:".length);}else{_204=dojo.fromJson(_204);}return _204;},getKeys:function(_205){if(!_205){_205=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_205)){throw new Error("Invalid namespace given: "+_205);}var _206=dojox.flash.comm.getKeys(_205);if(_206==null||_206=="null"){_206="";}_206=_206.split(",");_206.sort();return _206;},getNamespaces:function(){var _207=dojox.flash.comm.getNamespaces();if(_207==null||_207=="null"){_207=dojox.storage.DEFAULT_NAMESPACE;}_207=_207.split(",");_207.sort();return _207;},clear:function(_208){if(!_208){_208=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_208)){throw new Error("Invalid namespace given: "+_208);}dojox.flash.comm.clear(_208);},remove:function(key,_20a){if(!_20a){_20a=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_20a)){throw new Error("Invalid namespace given: "+_20a);}dojox.flash.comm.remove(key,_20a);},removeMultiple:function(keys,_20c){if(!this.isValidKeyArray(keys)){dojo.raise("Invalid key array given: "+keys);}if(!_20c){_20c=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_20c)){throw new Error("Invalid namespace given: "+_20c);}var _20d=keys.join(",");dojox.flash.comm.removeMultiple(_20d,_20c);},isPermanent:function(){return true;},getMaximumSize:function(){return dojox.storage.SIZE_NO_LIMIT;},hasSettingsUI:function(){return true;},showSettingsUI:function(){dojox.flash.comm.showSettings();dojox.flash.obj.setVisible(true);dojox.flash.obj.center();},hideSettingsUI:function(){dojox.flash.obj.setVisible(false);if(dojo.isFunction(dojox.storage.onHideSettingsUI)){dojox.storage.onHideSettingsUI.call(null);}},getResourceList:function(){return [];},_loaded:function(){this._allNamespaces=this.getNamespaces();this.initialized=true;dojox.storage.manager.loaded();},_onStatus:function(_20e,key,_210){var ds=dojox.storage;var dfo=dojox.flash.obj;if(_20e==ds.PENDING){dfo.center();dfo.setVisible(true);}else{dfo.setVisible(false);}if(ds._statusHandler){ds._statusHandler.call(null,_20e,key,null,_210);}}});dojox.storage.manager.register("dojox.storage.FlashStorageProvider",new dojox.storage.FlashStorageProvider());}if(!dojo._hasResource["dojox.storage._common"]){dojo._hasResource["dojox.storage._common"]=true;dojo.provide("dojox.storage._common");dojox.storage.manager.initialize();}if(!dojo._hasResource["dojox.storage"]){dojo._hasResource["dojox.storage"]=true;dojo.provide("dojox.storage");}if(!dojo._hasResource["dojox.off.files"]){dojo._hasResource["dojox.off.files"]=true;dojo.provide("dojox.off.files");dojox.off.files={versionURL:"version.js",listOfURLs:[],refreshing:false,_cancelID:null,_error:false,_errorMessages:[],_currentFileIndex:0,_store:null,_doSlurp:false,slurp:function(){this._doSlurp=true;},cache:function(_213){if(dojo.isString(_213)){var url=this._trimAnchor(_213+"");if(!this.isAvailable(url)){this.listOfURLs.push(url);}}else{if(_213 instanceof dojo._Url){var url=this._trimAnchor(_213.uri);if(!this.isAvailable(url)){this.listOfURLs.push(url);}}else{dojo.forEach(_213,function(url){url=this._trimAnchor(url);if(!this.isAvailable(url)){this.listOfURLs.push(url);}},this);}}},printURLs:function(){dojo.forEach(this.listOfURLs,function(i){});},remove:function(url){for(var i=0;i<this.listOfURLs.length;i++){if(this.listOfURLs[i]==url){this.listOfURLs=this.listOfURLs.splice(i,1);break;}}},isAvailable:function(url){for(var i=0;i<this.listOfURLs.length;i++){if(this.listOfURLs[i]==url){return true;}}return false;},refresh:function(_21b){try{if(dojo.config.isDebug){this.printURLs();}this.refreshing=true;if(this.versionURL){this._getVersionInfo(function(_21c,_21d,_21e){if(dojo.config.isDebug||!_21d||_21e||!_21c||_21c!=_21d){console.warn("Refreshing offline file list");this._doRefresh(_21b,_21d);}else{console.warn("No need to refresh offline file list");_21b(false,[]);}});}else{console.warn("Refreshing offline file list");this._doRefresh(_21b);}}catch(e){this.refreshing=false;dojox.off.coreOpFailed=true;dojox.off.enabled=false;dojox.off.onFrameworkEvent("coreOperationFailed");}},abortRefresh:function(){if(!this.refreshing){return;}this._store.abortCapture(this._cancelID);this.refreshing=false;},_slurp:function(){if(!this._doSlurp){return;}var _21f=dojo.hitch(this,function(url){if(this._sameLocation(url)){this.cache(url);}});_21f(window.location.href);dojo.query("script").forEach(function(i){try{_21f(i.getAttribute("src"));}catch(exp){}});dojo.query("link").forEach(function(i){try{if(!i.getAttribute("rel")||i.getAttribute("rel").toLowerCase()!="stylesheet"){return;}_21f(i.getAttribute("href"));}catch(exp){}});dojo.query("img").forEach(function(i){try{_21f(i.getAttribute("src"));}catch(exp){}});dojo.query("a").forEach(function(i){try{_21f(i.getAttribute("href"));}catch(exp){}});dojo.forEach(document.styleSheets,function(_225){try{if(_225.cssRules){dojo.forEach(_225.cssRules,function(rule){var text=rule.cssText;if(text){var _228=text.match(/url\(\s*([^\) ]*)\s*\)/i);if(!_228){return;}for(var i=1;i<_228.length;i++){_21f(_228[i]);}}});}else{if(_225.cssText){var _22a;var text=_225.cssText.toString();var _22c=text.split(/\f|\r|\n/);for(var i=0;i<_22c.length;i++){_22a=_22c[i].match(/url\(\s*([^\) ]*)\s*\)/i);if(_22a&&_22a.length){_21f(_22a[1]);}}}}}catch(exp){}});},_sameLocation:function(url){if(!url){return false;}if(url.length&&url.charAt(0)=="#"){return false;}url=new dojo._Url(url);if(!url.scheme&&!url.port&&!url.host){return true;}if(!url.scheme&&url.host&&url.port&&window.location.hostname==url.host&&window.location.port==url.port){return true;}if(!url.scheme&&url.host&&!url.port&&window.location.hostname==url.host&&window.location.port==80){return true;}return window.location.protocol==(url.scheme+":")&&window.location.hostname==url.host&&(window.location.port==url.port||!window.location.port&&!url.port);},_trimAnchor:function(url){return url.replace(/\#.*$/,"");},_doRefresh:function(_230,_231){var _232;try{_232=google.gears.factory.create("beta.localserver","1.0");}catch(exp){dojo.setObject("google.gears.denied",true);dojox.off.onFrameworkEvent("coreOperationFailed");throw "Google Gears must be allowed to run";}var _233="dot_store_"+window.location.href.replace(/[^0-9A-Za-z_]/g,"_");if(_233.length>=64){_233=_233.substring(0,63);}_232.removeStore(_233);_232.openStore(_233);var _234=_232.createStore(_233);this._store=_234;var self=this;this._currentFileIndex=0;this._cancelID=_234.capture(this.listOfURLs,function(url,_237,_238){if(!_237&&self.refreshing){self._cancelID=null;self.refreshing=false;var _239=[];_239.push("Unable to capture: "+url);_230(true,_239);return;}else{if(_237){self._currentFileIndex++;}}if(_237&&self._currentFileIndex>=self.listOfURLs.length){self._cancelID=null;self.refreshing=false;if(_231){dojox.storage.put("oldVersion",_231,null,dojox.off.STORAGE_NAMESPACE);}dojox.storage.put("justDebugged",dojo.config.isDebug,null,dojox.off.STORAGE_NAMESPACE);_230(false,[]);}});},_getVersionInfo:function(_23a){var _23b=dojox.storage.get("justDebugged",dojox.off.STORAGE_NAMESPACE);var _23c=dojox.storage.get("oldVersion",dojox.off.STORAGE_NAMESPACE);var _23d=null;_23a=dojo.hitch(this,_23a);dojo.xhrGet({url:this.versionURL+"?browserbust="+new Date().getTime(),timeout:5*1000,handleAs:"javascript",error:function(err){dojox.storage.remove("oldVersion",dojox.off.STORAGE_NAMESPACE);dojox.storage.remove("justDebugged",dojox.off.STORAGE_NAMESPACE);_23a(_23c,_23d,_23b);},load:function(data){if(data){_23d=data;}_23a(_23c,_23d,_23b);}});}};}if(!dojo._hasResource["dojox.off.sync"]){dojo._hasResource["dojox.off.sync"]=true;dojo.provide("dojox.off.sync");dojo.mixin(dojox.off.sync,{isSyncing:false,cancelled:false,successful:true,details:[],error:false,actions:null,autoSync:true,onSync:function(type){},synchronize:function(){if(this.isSyncing||dojox.off.goingOnline||(!dojox.off.isOnline)){return;}this.isSyncing=true;this.successful=false;this.details=[];this.cancelled=false;this.start();},cancel:function(){if(!this.isSyncing){return;}this.cancelled=true;if(dojox.off.files.refreshing){dojox.off.files.abortRefresh();}this.onSync("cancel");},finishedDownloading:function(_241,_242){if(typeof _241=="undefined"){_241=true;}if(!_241){this.successful=false;this.details.push(_242);this.error=true;}this.finished();},start:function(){if(this.cancelled){this.finished();return;}this.onSync("start");this.refreshFiles();},refreshFiles:function(){if(this.cancelled){this.finished();return;}this.onSync("refreshFiles");dojox.off.files.refresh(dojo.hitch(this,function(_243,_244){if(_243){this.error=true;this.successful=false;for(var i=0;i<_244.length;i++){this.details.push(_244[i]);}}this.upload();}));},upload:function(){if(this.cancelled){this.finished();return;}this.onSync("upload");dojo.connect(this.actions,"onReplayFinished",this,this.download);this.actions.replay();},download:function(){if(this.cancelled){this.finished();return;}this.onSync("download");},finished:function(){this.isSyncing=false;this.successful=(!this.cancelled&&!this.error);this.onSync("finished");},_save:function(_246){this.actions._save(function(){_246();});},_load:function(_247){this.actions._load(function(){_247();});}});dojo.declare("dojox.off.sync.ActionLog",null,{entries:[],reasonHalted:null,isReplaying:false,autoSave:true,add:function(_248){if(this.isReplaying){throw "Programming error: you can not call "+"dojox.off.sync.actions.add() while "+"we are replaying an action log";}this.entries.push(_248);if(this.autoSave){this._save();}},onReplay:function(_249,_24a){},length:function(){return this.entries.length;},haltReplay:function(_24b){if(!this.isReplaying){return;}if(_24b){this.reasonHalted=_24b.toString();}if(this.autoSave){var self=this;this._save(function(){self.isReplaying=false;self.onReplayFinished();});}else{this.isReplaying=false;this.onReplayFinished();}},continueReplay:function(){if(!this.isReplaying){return;}this.entries.shift();if(!this.entries.length){if(this.autoSave){var self=this;this._save(function(){self.isReplaying=false;self.onReplayFinished();});return;}else{this.isReplaying=false;this.onReplayFinished();return;}}var _24e=this.entries[0];this.onReplay(_24e,this);},clear:function(){if(this.isReplaying){return;}this.entries=[];if(this.autoSave){this._save();}},replay:function(){if(this.isReplaying){return;}this.reasonHalted=null;if(!this.entries.length){this.onReplayFinished();return;}this.isReplaying=true;var _24f=this.entries[0];this.onReplay(_24f,this);},onReplayFinished:function(){},toString:function(){var _250="";_250+="[";for(var i=0;i<this.entries.length;i++){_250+="{";for(var j in this.entries[i]){_250+=j+": \""+this.entries[i][j]+"\"";_250+=", ";}_250+="}, ";}_250+="]";return _250;},_save:function(_253){if(!_253){_253=function(){};}try{var self=this;var _255=function(_256,key,_258){if(_256==dojox.storage.FAILED){dojox.off.onFrameworkEvent("save",{status:dojox.storage.FAILED,isCoreSave:true,key:key,value:_258,namespace:dojox.off.STORAGE_NAMESPACE});_253();}else{if(_256==dojox.storage.SUCCESS){_253();}}};dojox.storage.put("actionlog",this.entries,_255,dojox.off.STORAGE_NAMESPACE);}catch(exp){dojox.off.onFrameworkEvent("save",{status:dojox.storage.FAILED,isCoreSave:true,key:"actionlog",value:this.entries,namespace:dojox.off.STORAGE_NAMESPACE});_253();}},_load:function(_259){var _25a=dojox.storage.get("actionlog",dojox.off.STORAGE_NAMESPACE);if(!_25a){_25a=[];}this.entries=_25a;_259();}});dojox.off.sync.actions=new dojox.off.sync.ActionLog();}if(!dojo._hasResource["dojox.off._common"]){dojo._hasResource["dojox.off._common"]=true;dojo.provide("dojox.off._common");dojo.mixin(dojox.off,{isOnline:false,NET_CHECK:5,STORAGE_NAMESPACE:"_dot",enabled:true,availabilityURL:dojo.moduleUrl("dojox","off/network_check.txt"),goingOnline:false,coreOpFailed:false,doNetChecking:true,hasOfflineCache:null,browserRestart:false,_STORAGE_APP_NAME:window.location.href.replace(/[^0-9A-Za-z_]/g,"_"),_initializeCalled:false,_storageLoaded:false,_pageLoaded:false,onLoad:function(){},onNetwork:function(type){},initialize:function(){this._initializeCalled=true;if(this._storageLoaded&&this._pageLoaded){this._onLoad();}},goOffline:function(){if((dojox.off.sync.isSyncing)||(this.goingOnline)){return;}this.goingOnline=false;this.isOnline=false;},goOnline:function(_25c){if(dojox.off.sync.isSyncing||dojox.off.goingOnline){return;}this.goingOnline=true;this.isOnline=false;this._isSiteAvailable(_25c);},onFrameworkEvent:function(type,_25e){if(type=="save"){if(_25e.isCoreSave&&(_25e.status==dojox.storage.FAILED)){dojox.off.coreOpFailed=true;dojox.off.enabled=false;dojox.off.onFrameworkEvent("coreOperationFailed");}}else{if(type=="coreOperationFailed"){dojox.off.coreOpFailed=true;dojox.off.enabled=false;}}},_checkOfflineCacheAvailable:function(_25f){this.hasOfflineCache=dojo.gears.available;_25f();},_onLoad:function(){dojox.off.files.cache(dojo.moduleUrl("dojo","dojo.js"));this._cacheDojoResources();dojox.off.files.cache(dojox.storage.manager.getResourceList());dojox.off.files._slurp();this._checkOfflineCacheAvailable(dojo.hitch(this,"_onOfflineCacheChecked"));},_onOfflineCacheChecked:function(){if(this.hasOfflineCache&&this.enabled){this._load(dojo.hitch(this,"_finishStartingUp"));}else{if(this.hasOfflineCache&&!this.enabled){this._finishStartingUp();}else{this._keepCheckingUntilInstalled();}}},_keepCheckingUntilInstalled:function(){this._finishStartingUp();},_finishStartingUp:function(){if(!this.hasOfflineCache){this.onLoad();}else{if(this.enabled){this._startNetworkThread();this.goOnline(dojo.hitch(this,function(){dojox.off.onLoad();}));}else{if(this.coreOpFailed){this.onFrameworkEvent("coreOperationFailed");}else{this.onLoad();}}}},_onPageLoad:function(){this._pageLoaded=true;if(this._storageLoaded&&this._initializeCalled){this._onLoad();}},_onStorageLoad:function(){this._storageLoaded=true;if(!dojox.storage.manager.isAvailable()&&dojox.storage.manager.isInitialized()){this.coreOpFailed=true;this.enabled=false;}if(this._pageLoaded&&this._initializeCalled){this._onLoad();}},_isSiteAvailable:function(_260){dojo.xhrGet({url:this._getAvailabilityURL(),handleAs:"text",timeout:this.NET_CHECK*1000,error:dojo.hitch(this,function(err){this.goingOnline=false;this.isOnline=false;if(_260){_260(false);}}),load:dojo.hitch(this,function(data){this.goingOnline=false;this.isOnline=true;if(_260){_260(true);}else{this.onNetwork("online");}})});},_startNetworkThread:function(){if(!this.doNetChecking){return;}window.setInterval(dojo.hitch(this,function(){var d=dojo.xhrGet({url:this._getAvailabilityURL(),handleAs:"text",timeout:this.NET_CHECK*1000,error:dojo.hitch(this,function(err){if(this.isOnline){this.isOnline=false;try{if(typeof d.ioArgs.xhr.abort=="function"){d.ioArgs.xhr.abort();}}catch(e){}dojox.off.sync.isSyncing=false;this.onNetwork("offline");}}),load:dojo.hitch(this,function(data){if(!this.isOnline){this.isOnline=true;this.onNetwork("online");}})});}),this.NET_CHECK*1000);},_getAvailabilityURL:function(){var url=this.availabilityURL.toString();if(url.indexOf("?")==-1){url+="?";}else{url+="&";}url+="browserbust="+new Date().getTime();return url;},_onOfflineCacheInstalled:function(){this.onFrameworkEvent("offlineCacheInstalled");},_cacheDojoResources:function(){var _267=true;dojo.forEach(dojo.query("script"),function(i){var src=i.getAttribute("src");if(!src){return;}if(src.indexOf("_base/_loader/bootstrap.js")!=-1){_267=false;}});if(!_267){dojox.off.files.cache(dojo.moduleUrl("dojo","_base.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/loader.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/bootstrap.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/hostenv_browser.js").uri);}for(var i=0;i<dojo._loadedUrls.length;i++){dojox.off.files.cache(dojo._loadedUrls[i]);}},_save:function(){},_load:function(_26b){dojox.off.sync._load(_26b);}});dojox.storage.manager.addOnLoad(dojo.hitch(dojox.off,"_onStorageLoad"));dojo.addOnLoad(dojox.off,"_onPageLoad");}if(!dojo._hasResource["dojox.off"]){dojo._hasResource["dojox.off"]=true;dojo.provide("dojox.off");}if(!dojo._hasResource["dojox.off.ui"]){dojo._hasResource["dojox.off.ui"]=true;dojo.provide("dojox.off.ui");dojo.mixin(dojox.off.ui,{appName:"setme",autoEmbed:true,autoEmbedID:"dot-widget",runLink:window.location.href,runLinkTitle:"Run Application",learnHowPath:dojo.moduleUrl("dojox","off/resources/learnhow.html"),customLearnHowPath:false,htmlTemplatePath:dojo.moduleUrl("dojox","off/resources/offline-widget.html").uri,cssTemplatePath:dojo.moduleUrl("dojox","off/resources/offline-widget.css").uri,onlineImagePath:dojo.moduleUrl("dojox","off/resources/greenball.png").uri,offlineImagePath:dojo.moduleUrl("dojox","off/resources/redball.png").uri,rollerImagePath:dojo.moduleUrl("dojox","off/resources/roller.gif").uri,checkmarkImagePath:dojo.moduleUrl("dojox","off/resources/checkmark.png").uri,learnHowJSPath:dojo.moduleUrl("dojox","off/resources/learnhow.js").uri,_initialized:false,onLoad:function(){},_initialize:function(){if(this._validateAppName(this.appName)==false){alert("You must set dojox.off.ui.appName; it can only contain "+"letters, numbers, and spaces; right now it "+"is incorrectly set to '"+dojox.off.ui.appName+"'");dojox.off.enabled=false;return;}this.runLinkText="Run "+this.appName;dojo.connect(dojox.off,"onNetwork",this,"_onNetwork");dojo.connect(dojox.off.sync,"onSync",this,"_onSync");dojox.off.files.cache([this.htmlTemplatePath,this.cssTemplatePath,this.onlineImagePath,this.offlineImagePath,this.rollerImagePath,this.checkmarkImagePath]);if(this.autoEmbed){this._doAutoEmbed();}},_doAutoEmbed:function(){dojo.xhrGet({url:this.htmlTemplatePath,handleAs:"text",error:function(err){dojox.off.enabled=false;err=err.message||err;alert("Error loading the Dojo Offline Widget from "+this.htmlTemplatePath+": "+err);},load:dojo.hitch(this,this._templateLoaded)});},_templateLoaded:function(data){var _26e=dojo.byId(this.autoEmbedID);if(_26e){_26e.innerHTML=data;}this._initImages();this._updateNetIndicator();this._initLearnHow();this._initialized=true;if(!dojox.off.hasOfflineCache){this._showNeedsOfflineCache();return;}if(dojox.off.hasOfflineCache&&dojox.off.browserRestart){this._needsBrowserRestart();return;}else{var _26f=dojo.byId("dot-widget-browser-restart");if(_26f){_26f.style.display="none";}}this._updateSyncUI();this._initMainEvtHandlers();this._setOfflineEnabled(dojox.off.enabled);this._onNetwork(dojox.off.isOnline?"online":"offline");this._testNet();},_testNet:function(){dojox.off.goOnline(dojo.hitch(this,function(_270){this._onNetwork(_270?"online":"offline");this.onLoad();}));},_updateNetIndicator:function(){var _271=dojo.byId("dot-widget-network-indicator-online");var _272=dojo.byId("dot-widget-network-indicator-offline");var _273=dojo.byId("dot-widget-title-text");if(_271&&_272){if(dojox.off.isOnline==true){_271.style.display="inline";_272.style.display="none";}else{_271.style.display="none";_272.style.display="inline";}}if(_273){if(dojox.off.isOnline){_273.innerHTML="Online";}else{_273.innerHTML="Offline";}}},_initLearnHow:function(){var _274=dojo.byId("dot-widget-learn-how-link");if(!_274){return;}if(!this.customLearnHowPath){var _275=dojo.config.baseRelativePath;this.learnHowPath+="?appName="+encodeURIComponent(this.appName)+"&hasOfflineCache="+dojox.off.hasOfflineCache+"&runLink="+encodeURIComponent(this.runLink)+"&runLinkText="+encodeURIComponent(this.runLinkText)+"&baseRelativePath="+encodeURIComponent(_275);dojox.off.files.cache(this.learnHowJSPath);dojox.off.files.cache(this.learnHowPath);}_274.setAttribute("href",this.learnHowPath);var _276=dojo.byId("dot-widget-learn-how-app-name");if(!_276){return;}_276.innerHTML="";_276.appendChild(document.createTextNode(this.appName));},_validateAppName:function(_277){if(!_277){return false;}return (/^[a-z0-9 ]*$/i.test(_277));},_updateSyncUI:function(){var _278=dojo.byId("dot-roller");var _279=dojo.byId("dot-success-checkmark");var _27a=dojo.byId("dot-sync-messages");var _27b=dojo.byId("dot-sync-details");var _27c=dojo.byId("dot-sync-cancel");if(dojox.off.sync.isSyncing){this._clearSyncMessage();if(_278){_278.style.display="inline";}if(_279){_279.style.display="none";}if(_27a){dojo.removeClass(_27a,"dot-sync-error");}if(_27b){_27b.style.display="none";}if(_27c){_27c.style.display="inline";}}else{if(_278){_278.style.display="none";}if(_27c){_27c.style.display="none";}if(_27a){dojo.removeClass(_27a,"dot-sync-error");}}},_setSyncMessage:function(_27d){var _27e=dojo.byId("dot-sync-messages");if(_27e){while(_27e.firstChild){_27e.removeChild(_27e.firstChild);}_27e.appendChild(document.createTextNode(_27d));}},_clearSyncMessage:function(){this._setSyncMessage("");},_initImages:function(){var _27f=dojo.byId("dot-widget-network-indicator-online");if(_27f){_27f.setAttribute("src",this.onlineImagePath);}var _280=dojo.byId("dot-widget-network-indicator-offline");if(_280){_280.setAttribute("src",this.offlineImagePath);}var _281=dojo.byId("dot-roller");if(_281){_281.setAttribute("src",this.rollerImagePath);}var _282=dojo.byId("dot-success-checkmark");if(_282){_282.setAttribute("src",this.checkmarkImagePath);}},_showDetails:function(evt){evt.preventDefault();evt.stopPropagation();if(!dojox.off.sync.details.length){return;}var html="";html+="<html><head><title>Sync Details</title><head><body>";html+="<h1>Sync Details</h1>\n";html+="<ul>\n";for(var i=0;i<dojox.off.sync.details.length;i++){html+="<li>";html+=dojox.off.sync.details[i];html+="</li>";}html+="</ul>\n";html+="<a href='javascript:window.close()' "+"style='text-align: right; padding-right: 2em;'>"+"Close Window"+"</a>\n";html+="</body></html>";var _286="height=400,width=600,resizable=true,"+"scrollbars=true,toolbar=no,menubar=no,"+"location=no,directories=no,dependent=yes";var _287=window.open("","SyncDetails",_286);if(!_287){alert("Please allow popup windows for this domain; can't display sync details window");return;}_287.document.open();_287.document.write(html);_287.document.close();if(_287.focus){_287.focus();}},_cancel:function(evt){evt.preventDefault();evt.stopPropagation();dojox.off.sync.cancel();},_needsBrowserRestart:function(){var _289=dojo.byId("dot-widget-browser-restart");if(_289){dojo.addClass(_289,"dot-needs-browser-restart");}var _28a=dojo.byId("dot-widget-browser-restart-app-name");if(_28a){_28a.innerHTML="";_28a.appendChild(document.createTextNode(this.appName));}var _28b=dojo.byId("dot-sync-status");if(_28b){_28b.style.display="none";}},_showNeedsOfflineCache:function(){var _28c=dojo.byId("dot-widget-container");if(_28c){dojo.addClass(_28c,"dot-needs-offline-cache");}},_hideNeedsOfflineCache:function(){var _28d=dojo.byId("dot-widget-container");if(_28d){dojo.removeClass(_28d,"dot-needs-offline-cache");}},_initMainEvtHandlers:function(){var _28e=dojo.byId("dot-sync-details-button");if(_28e){dojo.connect(_28e,"onclick",this,this._showDetails);}var _28f=dojo.byId("dot-sync-cancel-button");if(_28f){dojo.connect(_28f,"onclick",this,this._cancel);}},_setOfflineEnabled:function(_290){var _291=[];_291.push(dojo.byId("dot-sync-status"));for(var i=0;i<_291.length;i++){if(_291[i]){_291[i].style.visibility=(_290?"visible":"hidden");}}},_syncFinished:function(){this._updateSyncUI();var _293=dojo.byId("dot-success-checkmark");var _294=dojo.byId("dot-sync-details");if(dojox.off.sync.successful==true){this._setSyncMessage("Sync Successful");if(_293){_293.style.display="inline";}}else{if(dojox.off.sync.cancelled==true){this._setSyncMessage("Sync Cancelled");if(_293){_293.style.display="none";}}else{this._setSyncMessage("Sync Error");var _295=dojo.byId("dot-sync-messages");if(_295){dojo.addClass(_295,"dot-sync-error");}if(_293){_293.style.display="none";}}}if(dojox.off.sync.details.length&&_294){_294.style.display="inline";}},_onFrameworkEvent:function(type,_297){if(type=="save"){if(_297.status==dojox.storage.FAILED&&!_297.isCoreSave){alert("Please increase the amount of local storage available "+"to this application");if(dojox.storage.hasSettingsUI()){dojox.storage.showSettingsUI();}}}else{if(type=="coreOperationFailed"){if(!this._userInformed){alert("This application will not work if Google Gears is not allowed to run");this._userInformed=true;}}else{if(type=="offlineCacheInstalled"){this._hideNeedsOfflineCache();if(dojox.off.hasOfflineCache==true&&dojox.off.browserRestart==true){this._needsBrowserRestart();return;}else{var _298=dojo.byId("dot-widget-browser-restart");if(_298){_298.style.display="none";}}this._updateSyncUI();this._initMainEvtHandlers();this._setOfflineEnabled(dojox.off.enabled);this._testNet();}}}},_onSync:function(type){switch(type){case "start":this._updateSyncUI();break;case "refreshFiles":this._setSyncMessage("Downloading UI...");break;case "upload":this._setSyncMessage("Uploading new data...");break;case "download":this._setSyncMessage("Downloading new data...");break;case "finished":this._syncFinished();break;case "cancel":this._setSyncMessage("Canceling Sync...");break;default:dojo.warn("Programming error: "+"Unknown sync type in dojox.off.ui: "+type);break;}},_onNetwork:function(type){if(!this._initialized){return;}this._updateNetIndicator();if(type=="offline"){this._setSyncMessage("You are working offline");var _29b=dojo.byId("dot-sync-details");if(_29b){_29b.style.display="none";}this._updateSyncUI();}else{if(dojox.off.sync.autoSync){if(dojo.isAIR){window.setTimeout(function(){dojox.off.sync.synchronize();},1000);}else{window.setTimeout(dojox._scopeName+".off.sync.synchronize()",1000);}}}}});dojo.connect(dojox.off,"onFrameworkEvent",dojox.off.ui,"_onFrameworkEvent");dojo.connect(dojox.off,"onLoad",dojox.off.ui,dojox.off.ui._initialize);}if(!dojo._hasResource["dojox.off.offline"]){dojo._hasResource["dojox.off.offline"]=true;dojo.provide("dojox.off.offline");}
