/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


/*=====
// this file is in place as a quick way to give summaries to all available dojox projects.

dojox = {
	// summary:
	//	DojoX: the home for Dojo eXtensions
	//
	// description:
	//	DojoX is a collection of subprojects provided by Dojo committers and subject to
	//	the generous licensing and policies of the [Dojo CLA](http://dojotoolkit.org/cla)
	//	Each subproject in DojoX has its own top-level directory and a README file with
	//	status information and project status and a stability rating (experimental, beta, stable)
	//
	//	Projects may or may not depend on other top-level Dojo projects, like Dojo or Dijit.
	//	Unlike Dojo and Dijit, code is not subject to i18n and a11y restrictions and may vary
	//	in quality (experimental code is encouraged in DojoX, but currently prohibited in Dojo
	//	and Dijit)
	//
	//	DojoX projects may mature to a stable state and stay in DojoX, or on occasion
	//	after proving themselves may migrate to Dojo Core or Dijit.  Dojo and Dijit projects
	//	are constrained both by development resources as well as design goals, so DojoX is
	//	a natural place to provide enhanced behavior or extend Dojo Core or Dijit primitives.
	//	DojoX can also be an incubator for entirely new projects.
}

dojox._sql = { 
	// summary: objects to support Dojo Offline (dojox.off)
};

dojox.charting = { 
	// summary: Vector graphic, data-driven graphs and charts 
};

dojox.collections = { 
	// summary: A set of lists and hashes for easy use within your applications.
};

dojox.color = { 
	// summary: Advanced color methods, including HSV, HSL, and CMYK conversion, a color generator and advanced colorspace calculations.
};

dojox.cometd = { 
	// summary: A cometd client written in Dojo
};

dojox.crypto = { 
	// summary: Cryptography in JS.  DEPRECATED: use dojox.encoding instead.
};	

dojox.data = { 
	// summary: Additional dojo.data data stores and demos
};

dojox.date = { 	
	// summary: Additional date manipulation functions
};

dojox.dtl = { 
	// summary: Django Templating Language implementation	
};

dojox.encoding = { 
	// summary: Various encoding algorithms, including crypto and digests.
};

dojox.flash = { 
	// summary: Utilities to embed and communicate with Flash-based objects
};

dojox.fx = {
	// summary: Extension animations to the core dojo FX project
	//
	// description:
	//	A package of animations, and FX-related code, extending Dojo Core fx.
	//	Including this package includes all the Base and Core fx packages.
	//
	
	style: { // summary: Module to provide CSS animations
	},

	scroll: { // summary: Module to provide scroll-related FX 
	}
};
dojox.fx["ext-dojo"] = {
	// summary: Direct extensions to dojo.fx namespace
	NodeList: {
		// summary: module to include to support dojox.fx animations in dojo.query()
	}
};

dojox.gfx = { 
	// summary: Cross-browser vector graphics API
	// description: 
	//
	//	dojox.gfx is an advanced API providing normalized vector drawing
	//	in a variety of browsers. It has individual renderers for SVG, VML,
	//	Canvas, and Silverlight.
};

dojox.gfx3d = { 
	// summary: A 3d API for dojox.gfx
};

dojox.grid = { 
	// summary: An advanced Grid widget with virtual scrolling, cell editing, and much more 
};	

dojox.highlight = { 
	// summary: A client-side syntax highlighting engine.
	// description:
	//	This project parses pre > code nodes, and applies syntax highlighting for
	//	a wide variety of languages. Simply dojo.require() in all the 
	//	dojox.highlight.languages you wish to include in your highlighingting,
	//	and customize colors in the highlight.css.
	//
	//	It is provided as a dojo package, contributed under CLA 
	//	by Ivan Sagalaev and is available originally from:
	// 	http://softwaremaniacs.org/soft/highlight/en/	
	//	
};

dojox.image = { 
	// summary: A collection of image related widgets
};

dojox.io = { 
	// summary: Extensions to the Core dojo.io transports
};

dojox.jsonPath = { 
	// summary: A query system for JavaScript objects
};

dojox.layout = { 
	// summary: A collection of layout related Widgets
};

dojox.lang = { 
	// summary: Language specific extensions
	functional: {
		// summary: Functional language constructs, including currying and lambda.
	}
};

dojox.math = { 
	// summary: A collection of various advanced math functions.
};

dojox.off = { 
	// summary: the Dojo Offline project
};

dojox.presentation = {
	// summary: A simple, experimental PowerPoint-like presentation project
};

dojox.regexp = { 
	// summary: Additional pre-made regular expressions for use
};

dojox.storage = { 
	// summary: Objects for mass storage within the browser.  For when cookies just aren't enough.
};

dojox.string = {
	// summary: A collection of various objects for advanced string manipulation, including a Builder and a tokenizer.
};

dojox.timing = {
	// summary: A set of objects to perform advanced time-based tasks, including a basic Timer.
};

dojox.uuid = { 
	// summary: Universally Unique Identifier (UUID) implementations, including an implementation of UUID 2
};

dojox.validate = { 
	// summary: Additional input validation methods
	ca : {
		// summary: Methods specific to the Canadian provinces
	},
	creditCard : {
		// summary: Validate various credit card types  
	}
};

dojox.widget = { 
	// summary: A collection of un-categorized widgets, or code not requiring it's own package.
	// 
	// description: 
	// 	These are standalone widgets with varying levels of stability. Some are useful, 
	//	some were created for demonstration purposes, and learning tools. The each maintain
	//	their own .css file (typically dojox/widget/WidgetName/WidgetName.css)
};

dojox.wire = {
	// summary:
	//	Declarative data binding and action tags for simplified MVC
};

dojox.xml = {
	// summary: XML utilities.  Currently only includes a DomParser, which returns a psuedo-XML document in JSON-like form.
};
=====*/
