/*
 * Decompiled with CFR 0.152.
 */
package org.complate.nashorn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.complate.core.ComplateException;
import org.complate.core.ComplateRenderer;
import org.complate.core.ComplateSource;
import org.complate.core.ComplateStream;
import org.openjdk.nashorn.api.scripting.NashornException;
import org.openjdk.nashorn.api.scripting.NashornScriptEngine;
import org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory;

public final class NashornComplateRenderer
implements ComplateRenderer {
    private static final String POLYFILLS = "if(typeof global === \"undefined\") { var global = this; }\nif(typeof console === \"undefined\") { var console = { log: print, error: print }; }\n\n";
    private final NashornScriptEngine engine;

    public NashornComplateRenderer(ComplateSource source) {
        this(source, Collections.emptyMap());
    }

    public NashornComplateRenderer(ComplateSource source, Map<String, ?> bindings) {
        this.engine = NashornComplateRenderer.createEngine(bindings);
        try {
            this.engine.eval(POLYFILLS);
        }
        catch (ScriptException e) {
            throw new ComplateException((Throwable)e, "Could not evaluate nashorn polyfills", new Object[0]);
        }
        this.engine.put("javax.script.filename", (Object)source.getDescription());
        try (Reader reader = NashornComplateRenderer.readerFor(source);){
            this.engine.eval(reader);
        }
        catch (IOException e) {
            throw new ComplateException("failed to read script from source '%s'", new Object[]{source.getDescription()});
        }
        catch (ScriptException e) {
            throw NashornComplateRenderer.extractJavaScriptError(e).map(jsError -> new ComplateException((Throwable)e, "failed to evaluate script: %s", new Object[]{jsError})).orElseGet(() -> new ComplateException((Throwable)e, "failed to evaluate script from resource '%s'", new Object[]{source.getDescription()}));
        }
    }

    public void render(String view, Map<String, ?> parameters, ComplateStream stream) throws ComplateException {
        try {
            Object[] args = NashornComplateRenderer.toVarArgs(view, parameters, stream);
            this.engine.invokeFunction("render", args);
        }
        catch (NoSuchMethodException e) {
            throw new ComplateException((Throwable)e, "could not find 'render' method in script", new Object[0]);
        }
        catch (ScriptException e) {
            throw NashornComplateRenderer.extractJavaScriptError(e).map(jsError -> new ComplateException((Throwable)e, "failed to render: %s", new Object[]{jsError})).orElseGet(() -> new ComplateException((Throwable)e, "failed to render", new Object[0]));
        }
    }

    private static NashornScriptEngine createEngine(Map<String, ?> bindings) {
        NashornScriptEngine engine = NashornComplateRenderer.createEngine();
        Bindings engineBindings = engine.getBindings(100);
        bindings.forEach(engineBindings::put);
        return engine;
    }

    private static NashornScriptEngine createEngine() {
        ScriptEngine engine = new NashornScriptEngineFactory().getScriptEngine();
        if (engine == null) {
            throw new ComplateException("Cannot instantiate Nashorn Script Engine", new Object[0]);
        }
        return (NashornScriptEngine)engine;
    }

    private static Reader readerFor(ComplateSource source) {
        InputStream is;
        try {
            is = source.getInputStream();
        }
        catch (IOException e) {
            throw new ComplateException((Throwable)e, "failed to initialize input stream for source '%s'", new Object[]{source.getDescription()});
        }
        InputStreamReader isr = new InputStreamReader(is);
        return new BufferedReader(isr);
    }

    private static Optional<String> extractJavaScriptError(Exception e) {
        Throwable cause = e.getCause();
        if (cause instanceof NashornException) {
            return Optional.of(cause.getMessage() + "\n" + NashornException.getScriptStackString((Throwable)cause));
        }
        return Optional.empty();
    }

    private static Object[] toVarArgs(String view, Map<String, ?> parameters, ComplateStream stream) {
        Object[] args = new Object[]{view, parameters == null ? Collections.emptyMap() : parameters, stream};
        return args;
    }
}

