/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.uniform;

import java.util.function.Supplier;
import org.comroid.api.Invocable;
import org.comroid.uniform.SerializationAdapter;

public class DataStructureType<SERI extends SerializationAdapter<BAS, ?, ?>, BAS, TAR extends BAS>
implements Supplier<TAR> {
    public final Primitive typ;
    protected final Class<TAR> tarClass;
    private final Invocable<TAR> constructor;

    protected DataStructureType(Class<TAR> tarClass, Primitive typ) {
        this.tarClass = tarClass;
        this.constructor = Invocable.ofConstructor(tarClass, (Class[])new Class[0]);
        this.typ = typ;
    }

    public int hashCode() {
        return 31 * this.tarClass.hashCode() + this.typ.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStructureType that = (DataStructureType)o;
        if (!this.tarClass.equals(that.tarClass)) {
            return false;
        }
        return this.typ == that.typ;
    }

    public String toString() {
        return String.format("DataStructureType{typ=%s, tarClass=%s}", new Object[]{this.typ, this.tarClass});
    }

    public Class<TAR> typeClass() {
        return this.tarClass;
    }

    public TAR cast(Object node) throws ClassCastException {
        if (this.tarClass.isInstance(node)) {
            return this.tarClass.cast(node);
        }
        throw new ClassCastException(String.format("Cannot cast %s to targeted %s type %s", node.getClass().getName(), this.typ.name(), this.tarClass.getName()));
    }

    @Override
    public TAR get() {
        return (TAR)this.constructor.invokeRethrow(new Object[0]);
    }

    public static class Arr<SERI extends SerializationAdapter<BAS, OBJ, ARR>, BAS, OBJ extends BAS, ARR extends BAS>
    extends DataStructureType<SERI, BAS, ARR> {
        public Arr(Class<ARR> arrClass) {
            super(arrClass, Primitive.ARRAY);
        }
    }

    public static class Obj<SERI extends SerializationAdapter<BAS, OBJ, ARR>, BAS, OBJ extends BAS, ARR extends BAS>
    extends DataStructureType<SERI, BAS, OBJ> {
        public Obj(Class<OBJ> objClass) {
            super(objClass, Primitive.OBJECT);
        }
    }

    public static enum Primitive {
        OBJECT,
        ARRAY;

    }
}

