/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.uniform;

import java.util.Objects;
import org.comroid.common.io.FileHandle;
import org.comroid.uniform.DataStructureType;
import org.comroid.uniform.node.UniArrayNode;
import org.comroid.uniform.node.UniNode;
import org.comroid.uniform.node.UniObjectNode;
import org.comroid.uniform.node.UniValueNode;
import org.jetbrains.annotations.Nullable;

public abstract class SerializationAdapter<BAS, OBJ extends BAS, ARR extends BAS> {
    public final DataStructureType.Arr<SerializationAdapter<BAS, OBJ, ARR>, BAS, OBJ, ARR> arrayType;
    public final DataStructureType.Obj<SerializationAdapter<BAS, OBJ, ARR>, BAS, OBJ, ARR> objectType;
    private final String mimeType;

    public final String getMimeType() {
        return this.mimeType;
    }

    protected SerializationAdapter(String mimeType, Class<OBJ> objClass, Class<ARR> arrClass) {
        this(mimeType, new DataStructureType.Obj(objClass), new DataStructureType.Arr(arrClass));
        Objects.requireNonNull(objClass, "Object class cannot be null");
    }

    protected SerializationAdapter(String mimeType, DataStructureType.Obj<SerializationAdapter<BAS, OBJ, ARR>, BAS, OBJ, ARR> objectType, DataStructureType.Arr<SerializationAdapter<BAS, OBJ, ARR>, BAS, OBJ, ARR> arrayType) {
        this.mimeType = mimeType;
        this.objectType = objectType;
        this.arrayType = arrayType;
    }

    public static SerializationAdapter<?, ?, ?> autodetect() {
        throw new UnsupportedOperationException();
    }

    public final UniNode readFile(FileHandle file) {
        return this.createUniNode(file.getContent());
    }

    public String toString() {
        return String.format("%s{object=%s;array=%s}", this.getClass().getSimpleName(), this.objectType.tarClass.getName(), this.arrayType.tarClass.getName());
    }

    public <TAR extends BAS> DataStructureType<SerializationAdapter<BAS, OBJ, ARR>, BAS, TAR> typeOf(TAR node) {
        if (this.objectType.typeClass().isInstance(node)) {
            return this.objectType;
        }
        if (this.arrayType.typeClass().isInstance(node)) {
            return this.arrayType;
        }
        throw new IllegalArgumentException("Unknown type: " + node.getClass().getName());
    }

    public final UniNode createUniNode(Object node) {
        if (node == null) {
            UniValueNode.nullNode();
        }
        if (node instanceof CharSequence) {
            return this.parse(node == null ? null : node.toString());
        }
        if (this.objectType.typeClass().isInstance(node)) {
            return this.createUniObjectNode(node);
        }
        if (this.arrayType.typeClass().isInstance(node)) {
            return this.createUniArrayNode(node);
        }
        throw new IllegalArgumentException(String.format("Unknown node type: %s", node.getClass().getName()));
    }

    public abstract UniNode parse(@Nullable String var1);

    public UniObjectNode createUniObjectNode() {
        return this.createUniObjectNode(this.objectType.get());
    }

    public abstract UniObjectNode createUniObjectNode(OBJ var1);

    public UniArrayNode createUniArrayNode() {
        return this.createUniArrayNode(this.arrayType.get());
    }

    public abstract UniArrayNode createUniArrayNode(ARR var1);
}

