/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.uniform;

import java.util.function.Function;

public final class ValueType<R> {
    public static final ValueType<Boolean> BOOLEAN = new ValueType<Boolean>(Boolean::parseBoolean);
    public static final ValueType<Character> CHARACTER = new ValueType<Character>(str -> Character.valueOf(str.toCharArray()[0]));
    public static final ValueType<Double> DOUBLE = new ValueType<Double>(Double::parseDouble);
    public static final ValueType<Float> FLOAT = new ValueType<Float>(Float::parseFloat);
    public static final ValueType<Integer> INTEGER = new ValueType<Integer>(Integer::parseInt);
    public static final ValueType<Long> LONG = new ValueType<Long>(Long::parseLong);
    public static final ValueType<Short> SHORT = new ValueType<Short>(Short::parseShort);
    public static final ValueType<String> STRING = new ValueType(Function.identity());
    public static final ValueType<Void> VOID = new ValueType<Void>(it -> null);
    private final Function<String, R> mapper;

    public Function<String, R> getMapper() {
        return this.mapper;
    }

    public ValueType(Function<String, R> mapper) {
        this.mapper = mapper;
    }

    public <T> T convert(R value, ValueType<T> toType) {
        return toType.apply(value.toString());
    }

    public R apply(String from) {
        return this.mapper.apply(from);
    }
}

