/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.uniform.adapter.json.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.comroid.annotations.Instance;
import org.comroid.uniform.SerializationAdapter;
import org.comroid.uniform.node.UniArrayNode;
import org.comroid.uniform.node.UniNode;
import org.comroid.uniform.node.UniObjectNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FastJSONLib
extends SerializationAdapter<JSON, JSONObject, JSONArray> {
    @Instance
    public static final FastJSONLib fastJsonLib = new FastJSONLib();

    private FastJSONLib() {
        super("application/json", JSONObject.class, JSONArray.class);
    }

    @Override
    public UniNode parse(@Nullable String data) {
        JSONValidator validator = JSONValidator.from((String)data);
        UniNode node = null;
        if (validator.validate()) {
            JSONValidator.Type type = validator.getType();
            try {
                validator.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close validator", e);
            }
            switch (type) {
                case Object: {
                    node = this.createUniObjectNode(JSONObject.parseObject((String)data));
                    break;
                }
                case Array: {
                    node = this.createUniArrayNode(JSONArray.parseArray((String)data));
                    break;
                }
                case Value: {
                    throw new IllegalArgumentException("Cannot parse JSON Value");
                }
            }
        } else {
            throw new IllegalArgumentException("String is not valid JSON");
        }
        return Objects.requireNonNull(node, "Node is null");
    }

    @Override
    public UniObjectNode createUniObjectNode(JSONObject node) {
        return new UniObjectNode(this, this.objectAdapter(node));
    }

    @Override
    public UniArrayNode createUniArrayNode(JSONArray node) {
        return new UniArrayNode(this, this.arrayAdapter(node));
    }

    private UniObjectNode.Adapter objectAdapter(JSONObject node) {
        class Local
        extends UniObjectNode.Adapter<JSONObject> {
            protected Local(JSONObject baseNode) {
                super(baseNode);
            }

            @Override
            public Object put(String key, Object value) {
                return ((JSONObject)this.baseNode).put(key, value);
            }

            @Override
            @NotNull
            public Set<Map.Entry<String, Object>> entrySet() {
                return ((JSONObject)this.baseNode).entrySet();
            }
        }
        return new Local(node == null ? new JSONObject() : node);
    }

    private UniArrayNode.Adapter arrayAdapter(JSONArray node) {
        class Local
        extends UniArrayNode.Adapter<JSONArray> {
            Local(JSONArray node) {
                super(node);
            }

            @Override
            public Object get(int index) {
                return ((JSONArray)this.baseNode).get(index);
            }

            @Override
            public Object set(int index, Object element) {
                return ((JSONArray)this.baseNode).set(index, element);
            }

            @Override
            public void add(int index, Object element) {
                ((JSONArray)this.baseNode).add(index, element);
            }

            @Override
            public Object remove(int index) {
                return ((JSONArray)this.baseNode).remove(index);
            }

            @Override
            public int size() {
                return ((JSONArray)this.baseNode).size();
            }
        }
        return new Local(node == null ? new JSONArray() : node);
    }
}

