/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.uniform.cache;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.comroid.api.Provider;
import org.comroid.mutatio.pipe.Pipe;
import org.comroid.mutatio.span.Span;
import org.comroid.uniform.cache.Cache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicCache<K, V>
implements Cache<K, V> {
    public static final int DEFAULT_LARGE_THRESHOLD = 250;
    @Nullable
    private final Provider.Now<V> emptyValueProvider;
    private final Map<K, Cache.Reference<K, V>> cache;
    private final int largeThreshold;

    public BasicCache() {
        this(250);
    }

    public BasicCache(int largeThreshold) {
        this(largeThreshold, new ConcurrentHashMap());
    }

    protected BasicCache(Map<K, Cache.Reference<K, V>> map) {
        this(250, map);
    }

    protected BasicCache(int largeThreshold, Map<K, Cache.Reference<K, V>> map) {
        this(largeThreshold, map, null);
    }

    protected BasicCache(int largeThreshold, Map<K, Cache.Reference<K, V>> map, @Nullable Provider.Now<V> emptyValueProvider) {
        this.largeThreshold = largeThreshold;
        this.cache = map;
        this.emptyValueProvider = emptyValueProvider;
    }

    public String toString() {
        return super.toString();
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> iterator() {
        return ((Span)this.stream().map(ref -> new AbstractMap.SimpleEntry<K, V>(ref.getKey(), ref.get()){

            @Override
            public V setValue(V value) {
                return BasicCache.this.getReference(this.getKey(), false).set(value);
            }
        }).map(it -> it).collect(Span.collector())).iterator();
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        return this.stream().anyMatch(ref -> ref.process().test(value::equals));
    }

    @Override
    public boolean large() {
        return this.size() < this.largeThreshold;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public final Stream<Cache.Reference<K, V>> stream(Predicate<K> filter) {
        return (this.large() ? this.cache.entrySet().parallelStream() : this.cache.entrySet().stream()).filter(entry -> filter.test(entry.getKey())).map(Map.Entry::getValue);
    }

    @Override
    public Pipe<?, Cache.Reference<K, V>> pipe(Predicate<K> filter) {
        return Pipe.of(this.cache.entrySet()).filter(entry -> filter.test(entry.getKey())).map(Map.Entry::getValue);
    }

    @Override
    @NotNull
    public Cache.Reference<K, V> getReference(K key, boolean createIfAbsent) {
        return createIfAbsent ? this.cache.computeIfAbsent(key, Cache.Reference::new) : this.cache.getOrDefault(key, this.emptyValueProvider == null ? Cache.Reference.create() : Cache.Reference.constant(key, this.emptyValueProvider.now()));
    }
}

