/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.uniform.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.comroid.api.Polyfill;
import org.comroid.api.Provider;
import org.comroid.mutatio.pipe.Pipe;
import org.comroid.mutatio.ref.OutdateableReference;
import org.comroid.mutatio.ref.Reference;
import org.comroid.mutatio.ref.ReferenceMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Cache<K, V>
extends Iterable<Map.Entry<K, V>>,
ReferenceMap.Settable<K, V, Reference<K, V>> {
    public boolean large();

    public int size();

    public boolean containsKey(K var1);

    public boolean containsValue(V var1);

    default public Stream<Reference<K, V>> stream() {
        return this.stream(any -> true);
    }

    public Stream<Reference<K, V>> stream(Predicate<K> var1);

    default public Pipe<?, Reference<K, V>> pipe() {
        return this.pipe(any -> true);
    }

    public Pipe<?, Reference<K, V>> pipe(Predicate<K> var1);

    @NotNull
    public Reference<K, V> getReference(K var1, boolean var2);

    default public boolean canProvide() {
        return false;
    }

    default public CompletableFuture<V> provide(K key) {
        return Polyfill.failedFuture((Throwable)new UnsupportedOperationException("Cache can't provide!"));
    }

    default public void forEach(BiConsumer<K, V> action) {
        this.forEach((? super T entry) -> action.accept(entry.getKey(), entry.getValue()));
    }

    public static class Reference<K, V>
    implements Reference.Settable<V> {
        public final AtomicReference<V> reference = new AtomicReference<Object>(null);
        private final OutdateableReference<CompletableFuture<V>> firstValueFuture = new OutdateableReference();
        private final Object lock = Polyfill.selfawareLock();
        private final K key;

        @NotNull
        public K getKey() {
            return this.key;
        }

        public Reference(K key) {
            this.key = key;
            this.firstValueFuture.update(new CompletableFuture());
        }

        public Reference(K key, V initValue) {
            this.key = key;
            this.firstValueFuture.outdate();
        }

        public static <K, V> Reference<K, V> create() {
            return new Reference<Object, V>(null);
        }

        public static <K, V> Reference<K, V> constant(K key, V value) {
            return new Reference<K, V>((Object)key, (Object)value){

                @Override
                @Nullable
                public V set(V value) {
                    throw new UnsupportedOperationException("Reference is constant");
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public V set(V value) {
            Object object = this.lock;
            synchronized (object) {
                if (!(this.firstValueFuture.isOutdated() || this.firstValueFuture.isNull() || Objects.requireNonNull((CompletableFuture)this.firstValueFuture.get(), "AssertionFailure").isDone())) {
                    ((CompletableFuture)this.firstValueFuture.get()).complete(value);
                }
                return this.reference.getAndSet(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public V get() {
            Object object = this.lock;
            synchronized (object) {
                return this.reference.get();
            }
        }

        public Provider<V> provider() {
            if (this.firstValueFuture.isOutdated()) {
                this.firstValueFuture.outdate();
                return Provider.of((CompletableFuture)((CompletableFuture)this.firstValueFuture.get()));
            }
            return Provider.of((Supplier)((Object)this));
        }
    }
}

