/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.uniform.cache;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import org.comroid.uniform.cache.BasicCache;

public class ProvidedCache<K, V>
extends BasicCache<K, V> {
    public static final Executor DEFAULT_EXECUTOR = ForkJoinPool.commonPool();
    private final Executor providerWriteExecutor;
    private final Function<K, CompletableFuture<V>> valueProvider;

    public ProvidedCache(int largeThreshold, Executor providerWriteExecutor, Function<K, CompletableFuture<V>> valueProvider) {
        super(largeThreshold);
        this.providerWriteExecutor = providerWriteExecutor;
        this.valueProvider = valueProvider;
    }

    @Override
    public boolean canProvide() {
        return true;
    }

    @Override
    public CompletableFuture<V> provide(K key) {
        if (!this.containsKey(key)) {
            CompletableFuture<V> future = this.valueProvider.apply(key);
            future.thenAcceptAsync(it -> this.getReference(key, true).set(it), this.providerWriteExecutor);
        }
        return this.getReference(key, false).provider().get();
    }
}

