/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.uniform.node;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.comroid.mutatio.ref.OutdateableReference;
import org.comroid.mutatio.ref.Reference;
import org.comroid.uniform.DataStructureType;
import org.comroid.uniform.SerializationAdapter;
import org.comroid.uniform.ValueType;
import org.comroid.uniform.node.UniNode;
import org.comroid.uniform.node.UniObjectNode;
import org.comroid.uniform.node.UniValueNode;
import org.jetbrains.annotations.NotNull;

public final class UniArrayNode
extends UniNode {
    private final Map<Integer, UniValueNode<String>> valueAdapters = new ConcurrentHashMap<Integer, UniValueNode<String>>();
    private final Adapter adapter;

    @Override
    public final Object getBaseNode() {
        return this.adapter.getBaseNode();
    }

    public UniArrayNode(SerializationAdapter<?, ?, ?> serializationAdapter, Adapter adapter) {
        super(serializationAdapter, UniNode.Type.ARRAY);
        this.adapter = adapter;
    }

    @Override
    @NotNull
    public UniNode get(int index) {
        Object value = this.adapter.get(index);
        if (value == null) {
            return UniValueNode.nullNode();
        }
        if (value instanceof UniNode) {
            return (UniNode)value;
        }
        if (Stream.of(this.serializationAdapter.objectType, this.serializationAdapter.arrayType).map(DataStructureType::typeClass).noneMatch(type -> type.isInstance(value))) {
            return this.valueAdapters.computeIfAbsent(index, k -> this.generateValueNode((Reference.Settable<String>)new OutdateableReference.SettableOfSupplier(() -> value).process().map(String::valueOf).snapshot()));
        }
        return this.serializationAdapter.createUniNode(value);
    }

    @Override
    public UniArrayNode copyFrom(@NotNull UniNode it) {
        if (it instanceof UniArrayNode) {
            this.adapter.addAll(((UniArrayNode)it).adapter);
            return this;
        }
        return (UniArrayNode)this.unsupported("COPY_FROM", UniNode.Type.ARRAY);
    }

    @Override
    public int size() {
        return this.adapter.size();
    }

    @Override
    public boolean has(String fieldName) {
        return (Boolean)this.unsupported("HAS_FIELD", UniNode.Type.OBJECT);
    }

    @Override
    @NotNull
    public UniNode get(String fieldName) {
        return (UniNode)this.unsupported("GET_FIELD", UniNode.Type.OBJECT);
    }

    @Override
    @NotNull
    public <T> UniValueNode<String> put(int index, ValueType<T> type, T value) {
        Object at;
        if (this.adapter.size() > index && (at = this.adapter.get(index)) instanceof UniValueNode) {
            this.adapter.set(index, value);
            return (UniValueNode)at;
        }
        this.adapter.set(index, value);
        return this.valueAdapters.computeIfAbsent(index, k -> this.generateValueNode((Reference.Settable<String>)new OutdateableReference.SettableOfSupplier(() -> value).process().map(String::valueOf).snapshot()));
    }

    @Override
    @NotNull
    public UniObjectNode putObject(int index) {
        UniObjectNode objectNode = this.serializationAdapter.createUniObjectNode();
        this.adapter.add(index, objectNode.getBaseNode());
        return objectNode;
    }

    @Override
    @NotNull
    public UniArrayNode putArray(int index) {
        UniArrayNode arrayNode = this.serializationAdapter.createUniArrayNode();
        this.adapter.add(index, arrayNode.getBaseNode());
        return arrayNode;
    }

    @Override
    public synchronized List<Object> asList() {
        ArrayList<Object> yields = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            yields.add(this.get(i).asRaw(null));
        }
        return yields;
    }

    @Override
    public synchronized List<? extends UniNode> asNodeList() {
        ArrayList<UniNode> yields = new ArrayList<UniNode>();
        for (int i = 0; i < this.size(); ++i) {
            yields.add(this.get(i));
        }
        return yields;
    }

    public static abstract class Adapter<B>
    extends AbstractList<Object>
    implements UniNode.Adapter<B> {
        protected final B baseNode;

        @Override
        public B getBaseNode() {
            return this.baseNode;
        }

        protected Adapter(B baseNode) {
            this.baseNode = baseNode;
        }

        @Override
        public abstract Object get(int var1);

        @Override
        public abstract Object set(int var1, Object var2);

        @Override
        public abstract void add(int var1, Object var2);

        @Override
        public abstract Object remove(int var1);
    }
}

