/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.uniform.node;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.comroid.api.Specifiable;
import org.comroid.common.info.MessageSupplier;
import org.comroid.mutatio.proc.Processor;
import org.comroid.mutatio.ref.Reference;
import org.comroid.uniform.SerializationAdapter;
import org.comroid.uniform.ValueType;
import org.comroid.uniform.node.UniArrayNode;
import org.comroid.uniform.node.UniObjectNode;
import org.comroid.uniform.node.UniValueNode;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UniNode
implements Specifiable<UniNode> {
    protected final SerializationAdapter<?, ?, ?> serializationAdapter;
    private final Type type;

    public String getSerializedString() {
        return this.toString();
    }

    public abstract Object getBaseNode();

    public final SerializationAdapter<?, ?, ?> getSerializationAdapter() {
        return this.serializationAdapter;
    }

    public final boolean isObjectNode() {
        return this.getType() == Type.OBJECT;
    }

    public final Type getType() {
        return this.type;
    }

    public final boolean isArrayNode() {
        return this.getType() == Type.ARRAY;
    }

    public final boolean isValueNode() {
        return this.getType() == Type.VALUE;
    }

    public boolean isNull() {
        return this instanceof UniValueNode.Null;
    }

    protected UniNode(SerializationAdapter<?, ?, ?> serializationAdapter, Type type) {
        this.serializationAdapter = serializationAdapter;
        this.type = type;
    }

    public abstract int size();

    public boolean isNull(String fieldName) {
        return this.wrap(fieldName).map(UniNode::isNull).orElse(true);
    }

    @NotNull
    public abstract UniNode get(int var1);

    @NotNull
    public abstract UniNode get(String var1);

    @NotNull
    public Optional<UniNode> wrap(int index) {
        return this.has(index) ? Optional.of(this.get(index)) : Optional.empty();
    }

    @NotNull
    public Optional<UniNode> wrap(String fieldName) {
        return this.has(fieldName) ? Optional.of(this.get(fieldName)) : Optional.empty();
    }

    @NotNull
    public Processor<UniNode> process(int index) {
        return Processor.ofConstant((Object)this.get(index));
    }

    @NotNull
    public Processor<UniNode> process(String fieldName) {
        return Processor.ofConstant((Object)this.get(fieldName));
    }

    public boolean has(int index) {
        return this.size() < index;
    }

    public abstract boolean has(String var1);

    @NotNull
    public <T> UniValueNode<String> add(ValueType<T> type, T value) throws UnsupportedOperationException {
        return this.put(this.size(), type, value);
    }

    @NotNull
    public <T> UniValueNode<String> put(int index, ValueType<T> type, T value) throws UnsupportedOperationException {
        return (UniValueNode)this.unsupported("PUT_INDEX", Type.ARRAY);
    }

    @NotNull
    public <T> UniValueNode<String> put(String key, ValueType<T> type, T value) throws UnsupportedOperationException {
        return (UniValueNode)this.unsupported("PUT_KEY", Type.OBJECT);
    }

    @NotNull
    public UniNode addNull() throws UnsupportedOperationException {
        return this.putNull(this.size());
    }

    @NotNull
    public UniNode putNull(int index) throws UnsupportedOperationException {
        return (UniNode)this.unsupported("PUT_NULL_INDEX", Type.ARRAY);
    }

    @NotNull
    public UniNode putNull(String key) throws UnsupportedOperationException {
        return (UniNode)this.unsupported("PUT_NULL_KEY", Type.OBJECT);
    }

    @NotNull
    public UniObjectNode addObject() throws UnsupportedOperationException {
        return this.putObject(this.size());
    }

    @NotNull
    public UniObjectNode putObject(int index) throws UnsupportedOperationException {
        return (UniObjectNode)this.unsupported("PUT_OBJECT_INDEX", Type.ARRAY);
    }

    @NotNull
    public UniObjectNode putObject(String key) throws UnsupportedOperationException {
        return (UniObjectNode)this.unsupported("PUT_OBJECT_KEY", Type.OBJECT);
    }

    @NotNull
    public UniArrayNode addArray() throws UnsupportedOperationException {
        return this.putArray(this.size());
    }

    @NotNull
    public UniArrayNode putArray(int index) throws UnsupportedOperationException {
        return (UniArrayNode)this.unsupported("PUT_ARRAY_INDEX", Type.ARRAY);
    }

    @NotNull
    public UniArrayNode putArray(String key) throws UnsupportedOperationException {
        return (UniArrayNode)this.unsupported("PUT_ARRAY_KEY", Type.ARRAY);
    }

    @Contract(value="_ -> this", mutates="this")
    public abstract UniNode copyFrom(@NotNull UniNode var1);

    public Object asRaw(@Nullable Object fallback) {
        if (this.isNull() && fallback != null) {
            return fallback;
        }
        return this.unsupported("GET_RAW", Type.VALUE);
    }

    protected final <T> T unsupported(String actionName, Type expected) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(String.format("Cannot invoke %s on node type %s; %s expected", new Object[]{actionName, this.getType(), expected}));
    }

    public <R> R as(ValueType<R> type) {
        return (R)this.unsupported("GET_AS", Type.VALUE);
    }

    public String asString() {
        return this.asString(null);
    }

    public String asString(@Nullable String fallback) {
        if (this.isNull() && fallback != null) {
            return fallback;
        }
        return (String)this.unsupported("GET_AS_STRING", Type.VALUE);
    }

    public boolean asBoolean() {
        return this.asBoolean(false);
    }

    public boolean asBoolean(boolean fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return (Boolean)this.unsupported("GET_AS_BOOLEAN", Type.VALUE);
    }

    public int asInt() {
        return this.asInt(0);
    }

    public int asInt(int fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return (Integer)this.unsupported("GET_AS_INT", Type.VALUE);
    }

    public long asLong() {
        return this.asLong(0L);
    }

    public long asLong(long fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return (Long)this.unsupported("GET_AS_LONG", Type.VALUE);
    }

    public double asDouble() {
        return this.asDouble(0.0);
    }

    public double asDouble(double fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return (Double)this.unsupported("GET_AS_DOUBLE", Type.VALUE);
    }

    public float asFloat() {
        return this.asFloat(0.0f);
    }

    public float asFloat(float fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return ((Float)this.unsupported("GET_AS_FLOAT", Type.VALUE)).floatValue();
    }

    public short asShort() {
        return this.asShort((short)0);
    }

    public short asShort(short fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return (Short)this.unsupported("GET_AS_SHORT", Type.VALUE);
    }

    public char asChar() {
        return this.asChar('\u0000');
    }

    public char asChar(char fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return ((Character)this.unsupported("GET_AS_CHAR", Type.VALUE)).charValue();
    }

    public List<Object> asList() {
        return (List)this.unsupported("GET_AS_LIST", Type.ARRAY);
    }

    public List<? extends UniNode> asNodeList() {
        return (List)this.unsupported("GET_AS_NODELIST", Type.ARRAY);
    }

    public final UniObjectNode asObjectNode() {
        return (UniObjectNode)this.as(UniObjectNode.class, (Supplier)MessageSupplier.format((String)"Node is of %s type; expected %s", (Object[])new Object[]{this.getType(), Type.OBJECT}));
    }

    public final UniArrayNode asArrayNode() {
        return (UniArrayNode)this.as(UniArrayNode.class, (Supplier)MessageSupplier.format((String)"Node is of %s type; expected %s", (Object[])new Object[]{this.getType(), Type.ARRAY}));
    }

    public final <T> UniValueNode<T> asValueNode() {
        return (UniValueNode)this.as(UniValueNode.class, (Supplier)MessageSupplier.format((String)"Node is of %s type; expected %s", (Object[])new Object[]{this.getType(), Type.VALUE}));
    }

    public final String toString() {
        return this.getBaseNode().toString();
    }

    @NotNull
    protected UniValueNode<String> generateValueNode(Reference.Settable<String> stringReference) {
        UniValueNode.Adapter.ViaString valueAdapter = new UniValueNode.Adapter.ViaString(stringReference);
        return new UniValueNode<String>(this.serializationAdapter, valueAdapter);
    }

    public static interface Adapter<B> {
        public B getBaseNode();
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        VALUE;

    }
}

