/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.uniform.node;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.comroid.mutatio.ref.OutdateableReference;
import org.comroid.mutatio.ref.Reference;
import org.comroid.trie.TrieMap;
import org.comroid.uniform.DataStructureType;
import org.comroid.uniform.SerializationAdapter;
import org.comroid.uniform.ValueType;
import org.comroid.uniform.node.UniArrayNode;
import org.comroid.uniform.node.UniNode;
import org.comroid.uniform.node.UniValueNode;
import org.jetbrains.annotations.NotNull;

public final class UniObjectNode
extends UniNode {
    private final Map<String, UniValueNode<String>> valueAdapters = TrieMap.ofString();
    private final Adapter adapter;

    @Override
    public final Object getBaseNode() {
        return this.adapter.getBaseNode();
    }

    public UniObjectNode(SerializationAdapter<?, ?, ?> serializationAdapter, Adapter adapter) {
        super(serializationAdapter, UniNode.Type.OBJECT);
        this.adapter = adapter;
    }

    public static UniObjectNode ofMap(SerializationAdapter<?, ?, ?> adapter, Map<String, Object> map) {
        class MergedAdapter
        extends Adapter<Map<String, Object>> {
            protected MergedAdapter(Map<String, Object> underlying) {
                super(underlying);
            }

            @Override
            public Object put(String key, Object value) {
                return ((Map)this.getBaseNode()).put(key, value);
            }

            @Override
            @NotNull
            public Set<Map.Entry<String, Object>> entrySet() {
                return ((Map)this.getBaseNode()).entrySet();
            }
        }
        return new UniObjectNode(adapter, new MergedAdapter(map));
    }

    @Override
    @NotNull
    public UniNode get(int index) {
        return (UniNode)this.unsupported("GET_INDEX", UniNode.Type.ARRAY);
    }

    @Override
    public int size() {
        return (Integer)this.unsupported("SIZE", UniNode.Type.ARRAY);
    }

    @Override
    public boolean has(String fieldName) {
        return this.adapter.containsKey(fieldName);
    }

    @Override
    @NotNull
    public UniNode get(String fieldName) {
        Object value = this.adapter.get(fieldName);
        if (value == null) {
            return UniValueNode.nullNode();
        }
        if (Stream.of(this.serializationAdapter.objectType, this.serializationAdapter.arrayType).map(DataStructureType::typeClass).noneMatch(type -> type.isInstance(value))) {
            return this.valueAdapters.computeIfAbsent(fieldName, k -> this.generateValueNode((Reference.Settable<String>)new OutdateableReference.SettableOfSupplier(() -> value).process().map(String::valueOf).snapshot()));
        }
        return this.serializationAdapter.createUniNode(value);
    }

    @Override
    @NotNull
    public <T> UniValueNode<String> put(String key, ValueType<T> type, T value) {
        Object at;
        if (this.adapter.containsKey(key) && (at = this.adapter.get(key)) instanceof UniValueNode) {
            this.adapter.put(key, value);
            return (UniValueNode)at;
        }
        this.adapter.put(key, value);
        return this.valueAdapters.computeIfAbsent(key, k -> this.generateValueNode((Reference.Settable<String>)new OutdateableReference.SettableOfSupplier(() -> value).process().map(String::valueOf).snapshot()));
    }

    @Override
    public UniNode putNull(String key) throws UnsupportedOperationException {
        UniNode nullNode = this.serializationAdapter.createUniNode(null);
        this.adapter.put(key, (Object)nullNode);
        return nullNode;
    }

    @Override
    @NotNull
    public UniObjectNode putObject(String key) {
        UniObjectNode objectNode = this.serializationAdapter.createUniObjectNode();
        this.adapter.put(key, objectNode.getBaseNode());
        return objectNode;
    }

    @Override
    @NotNull
    public UniArrayNode putArray(String key) {
        UniArrayNode arrayNode = this.serializationAdapter.createUniArrayNode();
        this.adapter.put(key, arrayNode.getBaseNode());
        return arrayNode;
    }

    @Override
    public UniObjectNode copyFrom(@NotNull UniNode it) {
        if (it instanceof UniObjectNode) {
            this.adapter.putAll(((UniObjectNode)it).adapter);
            return this;
        }
        return (UniObjectNode)this.unsupported("COPY_FROM", UniNode.Type.OBJECT);
    }

    public static abstract class Adapter<B>
    extends AbstractMap<String, Object>
    implements UniNode.Adapter<B> {
        protected final B baseNode;

        @Override
        public B getBaseNode() {
            return this.baseNode;
        }

        protected Adapter(B baseNode) {
            this.baseNode = baseNode;
        }

        @Override
        public abstract Object put(String var1, Object var2);

        @Override
        @NotNull
        public abstract Set<Map.Entry<String, Object>> entrySet();
    }
}

