/*
 * Decompiled with CFR 0.152.
 */
package org.comroid.uniform.node;

import org.comroid.mutatio.ref.Reference;
import org.comroid.uniform.SerializationAdapter;
import org.comroid.uniform.ValueType;
import org.comroid.uniform.node.UniNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniValueNode<T>
extends UniNode {
    private final Adapter<T> adapter;

    @Override
    public final Object getBaseNode() {
        return this.asRaw(null);
    }

    public UniValueNode(SerializationAdapter<?, ?, ?> serializationAdapter, Adapter<T> adapter) {
        super(serializationAdapter, UniNode.Type.VALUE);
        this.adapter = adapter;
    }

    public static <T> UniValueNode<T> nullNode() {
        return Null.instance;
    }

    @Override
    @NotNull
    public UniNode get(int index) {
        return (UniNode)this.unsupported("GET_INDEX", UniNode.Type.ARRAY);
    }

    @Override
    public int size() {
        return (Integer)this.unsupported("SIZE", UniNode.Type.ARRAY);
    }

    @Override
    public boolean has(String fieldName) {
        return (Boolean)this.unsupported("HAS_FIELD", UniNode.Type.OBJECT);
    }

    @Override
    @NotNull
    public UniNode get(String fieldName) {
        return (UniNode)this.unsupported("GET_FIELD", UniNode.Type.OBJECT);
    }

    @Override
    public UniValueNode copyFrom(@NotNull UniNode it) {
        if (it instanceof UniValueNode) {
            this.adapter.set(it.asString(null));
            return this;
        }
        return (UniValueNode)this.unsupported("COPY_FROM", UniNode.Type.VALUE);
    }

    @Override
    public Object asRaw(@Nullable Object fallback) {
        String str = this.asString(null);
        if (str.length() == 1) {
            return Character.valueOf(this.asChar('\u0000'));
        }
        if (str.matches("true|false")) {
            return this.asBoolean(false);
        }
        if (str.matches("[0-9]+")) {
            long asLong = this.asLong(0L);
            if (asLong > Integer.MAX_VALUE) {
                return asLong;
            }
            return this.asInt(0);
        }
        if (str.matches("[0-9.]+")) {
            double asDouble = this.asDouble(0.0);
            if (asDouble > 3.4028234663852886E38) {
                return asDouble;
            }
            return Float.valueOf(this.asFloat(0.0f));
        }
        return this.asString(null);
    }

    @Override
    public <R> R as(ValueType<R> type) {
        return this.adapter.get(type);
    }

    @Override
    public String asString(@Nullable String fallback) {
        if (this.isNull() && fallback != null) {
            return fallback;
        }
        return this.adapter.get(ValueType.STRING);
    }

    @Override
    public boolean asBoolean(boolean fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return this.adapter.get(ValueType.BOOLEAN);
    }

    @Override
    public int asInt(int fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return this.adapter.get(ValueType.INTEGER);
    }

    @Override
    public long asLong(long fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return this.adapter.get(ValueType.LONG);
    }

    @Override
    public double asDouble(double fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return this.adapter.get(ValueType.DOUBLE);
    }

    @Override
    public float asFloat(float fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return this.adapter.get(ValueType.FLOAT).floatValue();
    }

    @Override
    public short asShort(short fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return this.adapter.get(ValueType.SHORT);
    }

    @Override
    public char asChar(char fallback) {
        if (this.isNull()) {
            return fallback;
        }
        return this.adapter.get(ValueType.CHARACTER).charValue();
    }

    static final class Null
    extends UniValueNode<Void> {
        private static final UniValueNode<?> instance = new Null();

        private Null() {
            super(null, new Adapter<Void>(){

                public Object getBaseNode() {
                    return instance;
                }

                @Override
                @Nullable
                public <R> R get(ValueType<R> as) {
                    return null;
                }

                @Override
                @Nullable
                public String set(String value) {
                    throw new UnsupportedOperationException();
                }

                public String toString() {
                    return null;
                }
            });
        }
    }

    public static interface Adapter<T>
    extends UniNode.Adapter {
        @Nullable
        public <R> R get(ValueType<R> var1);

        @Nullable
        public String set(String var1);

        public static final class ViaString
        implements Adapter<String> {
            private final Reference.Settable<String> sub;

            public Object getBaseNode() {
                return null;
            }

            public ViaString(Reference.Settable<String> sub) {
                this.sub = sub;
            }

            @Override
            @Nullable
            public <R> R get(ValueType<R> as) {
                String from = (String)this.sub.get();
                if (from != null) {
                    return as.apply(from);
                }
                return null;
            }

            @Override
            @Nullable
            public String set(String value) {
                return (String)this.sub.set((Object)value);
            }

            public String toString() {
                return String.format("\"%s\"", this.sub.get());
            }
        }
    }
}

