/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.contribs.queue.amqp.config;

import com.netflix.conductor.contribs.queue.amqp.util.RetryType;

public class AMQPRetryPattern {
    private int limit = 50;
    private int duration = 1000;
    private RetryType type = RetryType.REGULARINTERVALS;

    public AMQPRetryPattern() {
    }

    public AMQPRetryPattern(int limit, int duration, RetryType type) {
        this.limit = limit;
        this.duration = duration;
        this.type = type;
    }

    public void continueOrPropogate(Exception ex, int retryIndex) throws Exception {
        if (retryIndex > this.limit) {
            throw ex;
        }
        long waitDuration = this.duration;
        if (this.type == RetryType.INCREMENTALINTERVALS) {
            waitDuration = this.duration * retryIndex;
        } else if (this.type == RetryType.EXPONENTIALBACKOFF) {
            waitDuration = (long)Math.pow(2.0, retryIndex) * (long)this.duration;
        }
        try {
            Thread.sleep(waitDuration);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }
}

