/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.contribs.queue.amqp.config;

import com.netflix.conductor.contribs.queue.amqp.AMQPObservableQueue;
import com.netflix.conductor.contribs.queue.amqp.config.AMQPEventQueueProperties;
import com.netflix.conductor.core.events.EventQueueProvider;
import com.netflix.conductor.core.events.queue.ObservableQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class AMQPEventQueueProvider
implements EventQueueProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQPEventQueueProvider.class);
    protected Map<String, AMQPObservableQueue> queues = new ConcurrentHashMap<String, AMQPObservableQueue>();
    private final boolean useExchange;
    private final AMQPEventQueueProperties properties;
    private final String queueType;

    public AMQPEventQueueProvider(AMQPEventQueueProperties properties, String queueType, boolean useExchange) {
        this.properties = properties;
        this.queueType = queueType;
        this.useExchange = useExchange;
    }

    public String getQueueType() {
        return this.queueType;
    }

    @NonNull
    public ObservableQueue getQueue(String queueURI) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Retrieve queue with URI {}", (Object)queueURI);
        }
        return this.queues.computeIfAbsent(queueURI, q -> new AMQPObservableQueue.Builder(this.properties).build(this.useExchange, (String)q));
    }
}

